<?php

namespace  Copygenaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Extra_items_btn_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-extra-items-v1';
    }

    public function get_title()
    {
        return __('Header Extra Items V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('header_extra_settings',
        [ 
            'label' => __('Header Extra Settings', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'types',
            [
            'label' => __('Types', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'search' => __( 'Search / Option Panel', 'copygen-addons' ),
                'search_two' => __( 'Search Type Two', 'copygen-addons' ),
                'language' => __( 'Language', 'copygen-addons' ), 
            ],
            'default' => 'search' , 
            ]
        );
        $this->add_control(
            'search_enable',
            [
                'label' => __('Search show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'types' => 'search'
                ],
            ]
        );
        
        $this->add_control(
            'option_panel_enable',
            [
                'label' => __('Option Panel Show / Hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'types' => 'search'
                ],
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items  ' => 'justify-content: {{VALUE}}!important;',
                ],
                'condition' => [
                    'types' => 'search'
                ],
            ]
        );
      

        $this->add_control(
            'language_type',
            [
                'label' => __('Language Type', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'custom_language'   => esc_html__( 'Custom Language', 'copygen-addons' ),
                    'using_short_code'   => esc_html__( 'Using Shortcode', 'copygen-addons' ), 
                ],
                'default' => 'custom_language',
                'condition' => [ 
                    'types' => 'language'
                ],
            ]
        );

        $this->add_control(
            'defaut_language_texts',
            [
                'label' => __( 'Default Language Text', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'English', 'copygen-addons' ),
                'condition' => [
                    'language_type' => 'custom_language' ,
                    'types' => 'language'
                ],
            ]
        );
        $repeater_three = new \Elementor\Repeater();
        $repeater_three->add_control(
            'language_icon_image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ] 
        );
            $repeater_three->add_control(
                'language_text',
                [
                    'label' => __( 'Language Text', 'copygen-addons' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'English', 'copygen-addons' ),
                ]
            );
    
            $repeater_three->add_control(
                'language_link',
                [
                    'label' => __( 'Link', 'copygen-addons' ),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __( 'https://your-link.com', 'copygen-addons' ),
                    'show_external' => true,
                    'default' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                    ],
                ]
            );
            $this->add_control(
                'language_repeater',
                [
                    'label' => __('Language Content', 'copygen-addons'),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater_three->get_controls(),
                    'default' => [
                        [
                        'language_text' =>  __('Français', 'copygen-addons'),
                        'language_link' =>  __('#', 'copygen-addons'),
                        ],
                        [
                            'language_text' =>  __('Deutsch', 'copygen-addons'),
                            'language_link' =>  __('#', 'copygen-addons'),
                        ],
                        [
                            'language_text' =>  __('Pусский ', 'copygen-addons'),
                            'language_link' =>  __('#', 'copygen-addons'),
                        ], 
                    ],
                    'title_field' => '{{{ language_text }}}',
                    'condition' => [
                        'language_type' => 'custom_language' ,
                        'types' => 'language'
                    ],
                ]
            );

            
        $this->add_control(
            'language_shortcode',
            [
                'label' => __( 'Language Shortcode', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( '[trp_language language="en_US"]', 'copygen-addons' ),
                'condition' => [
                    'language_type' => 'using_short_code' ,
                    'types' => 'language'
                ],
            ]
        );
 
        $this->end_controls_section(); 
        $this->start_controls_section('header_extra_css',
        [ 
            'label' => __('Option Panel / Search Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'types' => 'search'
            ],
        ]);

        $this->add_control(
            'icon_color',
            [
                'label' => __('Search Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search i ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'search_enable' => 'yes'
                ],
            ]
        ); 

        $this->add_control(
            'icon_color_two',
            [
                'label' => __('Option Panel Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items  .contact-toggler svg path' => 'stroke: {{VALUE}}!important;',
                ],
                'condition' => [
                    'option_panel_enable' => 'yes'
                ],
            ]
        ); 

        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Icon Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Icon Padding', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search  , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search  , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

    $this->end_controls_section(); 

    $this->start_controls_section('language_css',
    [ 
        'label' => __('Language Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
            'types' => 'language'
        ],
    ]);

    $this->add_control(
        'lbtnolor',
        [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn ' => 'color: {{VALUE}}!important;', 
            ], 
        ]
    );  
    $this->add_control(
        'lbtncolorbg',
        [
            'label' => __('Button Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn' => 'background: {{VALUE}}!important;',
            ], 
        ]
    );  
    $this->add_control(
        'lbtnbordercolor',
        [
            'label' => __('Button Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_control(
        'hollbtnolor',
        [
            'label' => __('Button Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn:hover ' => 'color: {{VALUE}}!important;', 
            ], 
        ]
    );  
    $this->add_control(
        'holbtncolorbg',
        [
            'label' => __('Button Hover Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn:hover ' => 'background: {{VALUE}}!important;',
            ], 
        ]
    );  
    $this->add_control(
        'holbtnbordercolor',
        [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .btn:hover ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Button Typography', 'copygen-addons' ),
            'name' => 'holdt_typo',
            'selector' => '{{WRAPPER}} .language .btn ',
        ]
    ); 
    $this->add_control(
        'lbuttonpadding', 
        [
            'label' => esc_html__( 'Icon Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}}  .language .btn  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'lbuttonradius',
        [
            'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .language .btn   ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' DropDown Item Typography', 'copygen-addons' ),
            'name' => 'ldt_typo',
            'selector' => '{{WRAPPER}}  .language .language-dropdown li a ',
        ]
    ); 
    $this->add_control(
        'ldropbg_color',
        [
            'label' => __('DropDown Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .language-dropdown ' => 'background: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'ldropbr_color',
        [
            'label' => __('DropDown Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .language-dropdown ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_control(
        'ldrop_color',
        [
            'label' => __('DropDown  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .language .language-dropdown li a ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'lla_align',
        [
            'label' => esc_html__( 'Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .language ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );  
    $this->end_controls_section(); 


    $this->start_controls_section('search_css',
    [ 
        'label' => __('Search Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
            'types' => 'search_two'
        ],
    ]);
    $this->add_control(
        'inicon_color',
        [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search i ' => 'color: {{VALUE}}!important;', 
            ], 
        ]
    ); 
    $this->add_control(
        'sehr1',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Input Typography', 'copygen-addons' ),
            'name' => 'desc_typo',
            'selector' => '{{WRAPPER}} .simple_search input::placeholder , {{WRAPPER}} .simple_search input ',
        ]
    );
    $this->add_control(
        'sehr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inc_color',
        [
            'label' => __('Input Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search input::placeholder , {{WRAPPER}} .simple_search input ' => 'color: {{VALUE}}!important;', 
            ], 
        ]
    ); 
    $this->add_control(
        'sehr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inborder_color',
        [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search input ' => 'border-color: {{VALUE}}!important;', 
            ], 
        ]
    );   
    $this->add_control(
        'sehr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inbg_color',
        [
            'label' => __('Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search input ' => 'background: {{VALUE}}!important;', 
            ], 
        ]
    );  
    $this->add_control(
        'sehr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Button Typography', 'copygen-addons' ),
            'name' => 'btn_typo',
            'selector' => '{{WRAPPER}} .simple_search  .sch_btn',
        ]
    );
    $this->add_control(
        'sehr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inbtn_color',
        [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search  .sch_btn ' => 'color: {{VALUE}}!important;', 
            ], 
        ]
    );  
    $this->add_control(
        'sehr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inbtnbg_color',
        [
            'label' => __('Button Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search  .sch_btn ' => 'background: {{VALUE}}!important;', 
            ], 
        ]
    );  
    $this->add_control(
        'sehr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'inbtnbr_color',
        [
            'label' => __('Button Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .simple_search  .sch_btn ' => 'border-color: {{VALUE}}!important;', 
            ], 
        ]
    );  
     
    
    $this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
?>
<?php if($settings['types'] == 'language'): ?>
<?php if($settings['language_type'] == 'custom_language'): ?>
<div class="language dropdown"> 
    
 
  <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
  <?php echo esc_html($settings['defaut_language_texts']); ?>  
  </button>
    <ul class="dropdown-menu language-dropdown" aria-labelledby="dropdownMenuButton1"> 
        <?php foreach($settings['language_repeater'] as  $language_repeater): 
        $target_three = $language_repeater['language_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow_three= $language_repeater['language_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
        <li>
            <a href="<?php echo esc_url($language_repeater['language_link']['url']); ?>"
                <?php echo esc_attr($target_three); ?> <?php echo esc_attr($nofollow_three); ?>>
                <?php if(!empty($language_repeater['language_icon_image']['url'])): ?>
                <img src="<?php echo esc_url($language_repeater['language_icon_image']['url']); ?>" alt="img" />
                <?php endif; ?>
                <?php echo esc_attr($language_repeater['language_text']); ?>
            </a>
        </li>
        <?php endforeach ;?>
    </ul>
</div>
<?php elseif($settings['language_type'] == 'using_short_code'): ?>
<div class="language_shortcode">
    <?php do_shortcode($settings['language_shortcode']); ?>
</div>
<?php endif; ?>
<?php elseif($settings['types'] == 'search_two'): ?>
    <?php do_action('copygen_custom_search_setup'); ?> 
<?php else: ?>



<div class="d-flex flex-wrap align-items-center header_extra_items">
    <?php if($settings['search_enable'] == 'yes'): ?>
    <div class="search search-toggler">
        <i class="copy-search1"></i>
    </div>
    <?php endif;?>
    <?php if($settings['option_panel_enable'] == 'yes'): ?>
    <div class="contact-toggler">
        <i class="copy-menu-circled"></i>
    </div>
    <?php endif;?>
</div>
<?php endif;?>
<?php
    }
}