<?php

namespace  Copygenaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_header_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-contact-header-v1';
    }

    public function get_title()
    {
        return __('Header Contact V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('header_contact_settings',
        [ 
            'label' => __('Header Contact Settings', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'contact_types',
        [
          'label' => __('Contact Types', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
            'mail' => __( 'Mail', 'copygen-addons' ),
            'phone' => __( 'Phone', 'copygen-addons' ),
            'custom_content' => __( 'Custom Content', 'copygen-addons' ), 
        ],
          'default' => 'mail' , 
        ]
     );
     $this->add_control(
        'hr1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
     $this->add_control(
        'icon_type',
        [
            'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
                'none'  => esc_html__( 'None', 'copygen-addons' ), 
            ], 
            'default' => 'elicon' , 
        ]
    );
    $this->add_control(
        'hr2',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'icon',
        [
            'label' => __('Icon', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => copygen_get_icons(),
            'default' => 'fi-rs-user' , 
            'condition' => [
                'icon_type' => 'icon' ,
            ]
        ]
    );
    $this->add_control(
        'icon_lib',
        [
            'label' => __('Icon', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fab fa-facebook-f',
                'library' => 'fa-brands',
            ],
            'label_block' => true,
            'condition' => [
                'icon_type' => 'elicon',
            ]
        ]
    );
    $this->add_control(
        'hr3',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'icon_type' => ['icon' , 'elicon'] ,
            ]
        ]
    );
    $this->add_control(
        'title',
        [
            'label' => __( 'Title', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( 'Our Locations', 'copygen-addons' ),
        ]
    );
    $this->add_control(
        'hr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'mail',
        [
            'label' => __( 'Mail', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( 'example@gmail.com', 'copygen-addons' ),
            'condition' => [
                'contact_types' => 'mail'
            ],
        ]
    );
    $this->add_control(
        'hr5',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'contact_types' => 'mail'
            ],
        ]
    );
    $this->add_control(
        'phone',
        [
            'label' => __( 'Phone', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( '+000(123)456 88', 'copygen-addons' ),
            'condition' => [
                'contact_types' => 'phone'
            ],
        ]
    );
    $this->add_control(
        'hr6',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'contact_types' => 'phone'
            ],
        ]
    );
    $this->add_control(
        'content',
        [
            'label' => __( 'Content', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( '55 Main Street, USA', 'copygen-addons' ),
            'condition' => [
                'contact_types' => 'custom_content'
            ],
        ]
    );
    
    $this->end_controls_section();
 
        $this->start_controls_section('header_contact_css',
        [ 
            'label' => __('Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s i ' => 'color: {{VALUE}}!important;',
                ],
            
            ]
        );  
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Icon Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'icon_font_size',
            [
                'label' => __('Icon Font Size', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s i' => 'font-size: {{VALUE}}px!important;',
                ],
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => __('Icon Width', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 50,
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s ' => 'width: {{VALUE}}px!important; min-width: {{VALUE}}px!important;',
                ],
            ]
        );

        $this->add_control(
            'icon_height',
            [
                'label' => __('Icon Height', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 50,
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'height: {{VALUE}}px!important;',
                    '{{WRAPPER}} .contact_header_one .icon_s i  ' => 'line-height: {{VALUE}}px!important;',
                ],
            ]
        );

        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
				'name' => 'title_typos',
				'selector' => '{{WRAPPER}} .contact_header_one .content .tite',
			]
		);
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .content .tite ' => 'color: {{VALUE}}!important;',
                ],
            
            ]
        ); 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Content Typography', 'copygen-addons' ),
				'name' => 'content_typos',
				'selector' => '{{WRAPPER}} .contact_header_one .content .title_20 a , {{WRAPPER}} .contact_header_one .content .title_no_a_20',
			]
		);
        $this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .content .title_20 a , {{WRAPPER}} .contact_header_one .content .title_no_a_20 ' => 'color: {{VALUE}}!important;',
                ],
            
            ]
        ); 

        $this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<div class="d-flex align-items-center contact_header_one">
        <?php if($settings['icon_type'] == 'icon'): ?>
            <?php if(!empty($settings['icon'])): ?>
                <div class="icon_s">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                </div>
            <?php endif; ?>	
            <?php elseif($settings['icon_type'] == 'none'): ?>   
                <?php //  none ?>
            <?php else: ?>
            <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon_s">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                </div>
            <?php endif; ?>	
        <?php endif; ?>	
        <div class="content">
            <?php if(!empty($settings['title'])): ?>
            <h6 class="tite"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
             <?php if($settings['contact_types'] == 'mail'): ?>
                <div class="title_20"><a href="mailto:<?php echo esc_attr($settings['mail']); ?>"><?php echo esc_attr($settings['mail']); ?></a></div>
            <?php elseif($settings['contact_types'] == 'custom_content'): ?>
                <div class="title_no_a_20"><?php echo wp_kses($settings['content'] , $allowed_tags); ?></div>
            <?php else: ?>
                <div class="title_20"><a href="tel:<?php echo esc_attr($settings['phone']); ?>"><?php echo esc_attr($settings['phone']); ?></a></div>
            <?php endif; ?>
        </div>
</div>

 


<?php
    }
}