<?php
namespace  Copygenaddons\Core\Widgets\Content;
if(!defined('ABSPATH')){
  exit;
} // If this file is called directly, abort.
 class Video_btn extends \Elementor\Widget_Base{
      public function get_name(){
        return 'copygen-videobtns-v1';
      }
      public function get_title(){
        return __('Video Button' , 'copygen-addons');
      }
      public function get_icon(){
        return 'icon-steel';
      }
      public function get_categories(){
        return ['101'];
      }
      protected function register_controls(){
        $this->start_controls_section(
          'video_btn_content',
          [
            'label' => __('Video Button Content', 'copygen-addons')
          ]
        );

        $this->add_control(
          'video_style',
          [
          'label' => __('Video Styles', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
              'style_one' => __( 'Style One', 'copygen-addons' ),
              'style_two' => __( 'Style Two', 'copygen-addons' ), 
              'style_three' => __( 'Style Three', 'copygen-addons' ), 
          ],
          'default' => 'style_one' , 
          ]
        );


        $this->add_control(
        'video_button_link',
          [
             'label' => __('Video Link', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::URL,
             'placeholder' => __('https://www.youtube.com/71EZb94AS1k', 'copygen-addons'),
             'show_external' => true,
             'default' => [
                 'url' => 'https://www.youtube.com/71EZb94AS1k',
                 'is_external' => true,
                 'nofollow' => true,
             ],
          ]
        );  
         $this->add_responsive_control(
          'video_alignments',
           [
               'label' => __('Video alignments', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::CHOOSE,
               'options' => [
                 'left' => [
                   'title' => __( 'Text Left', 'copygen-addons' ),
                   'icon' => 'eicon-text-align-left',
                 ],
                 'center' => [
                   'title' => __( 'Text Center', 'copygen-addons' ),
                   'icon' => 'eicon-text-align-center',
                 ],
                 'right' => [
                   'title' => __( 'Text Right', 'copygen-addons' ),
                   'icon' => 'eicon-text-align-right',
                 ],
               ],
               'default' => 'center',
               'toggle' => true,
               'selectors' => [
                 '{{WRAPPER}} .video_btn_all ' => 'text-align: {{VALUE}}!important;',
               ],
           ]
       );

       $this->add_control(
        'hr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
     $this->add_responsive_control(
        'icon_font_size',
        [
            'label' => __('Icon  Size', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .video_btn_all .video_box  a  ' => 'font-size: {{VALUE}}px!important;', 
            ], 
        ]
    );
    $this->add_responsive_control(
        'icon_width',
        [
            'label' => __('Icon Width', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .video_btn_all .video_box  a  ' => 'width: {{VALUE}}px!important;', 
            ], 
        ]
    );
    $this->add_responsive_control(
        'icon_height',
        [
            'label' => __('Icon Height', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .video_btn_all .video_box  a  ' => 'height: {{VALUE}}px!important; line-height: {{VALUE}}px!important;',  
            ], 
        ]
    );

    $this->add_responsive_control(
        'icon_border_radius',
        [
            'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .video_btn_all .video_box  a  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    );

    $this->add_control(
        'hr5',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
      'video_btn_icon',
       [
          'label' => __('Icon Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
              '{{WRAPPER}} .video_btn_all .video_box  a  ' => 'color: {{VALUE}}!important;',
          ],
       ]
    );
    $this->add_control(
      'video_btn_br',
       [
          'label' => __('Border Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
              '{{WRAPPER}} .video_box a ' => 'border-color: {{VALUE}}!important;', 
            ],
            
       ]
    ); 
    $this->add_control(
      'video_btn_bg',
       [
          'label' => __('Background Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
              '{{WRAPPER}} .video_box a ' => 'background: {{VALUE}}!important;', 
            ],
            
       ]
    );  
      
    $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'icon_boxshadows',
				'selector' => '{{WRAPPER}} .video_box a ', 
			]
		);
    $this->add_control(
      'hr6',
          [
          'type' => \Elementor\Controls_Manager::DIVIDER, 
      ]
    );   
    $this->add_control(
      'hvideo_btn_icon',
       [
          'label' => __('Hover Icon Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
              '{{WRAPPER}} .video_btn_all .video_box  a:hover  ' => 'color: {{VALUE}}!important;',
          ],
       ]
    );
    $this->add_control(
      'hvideo_btn_br',
       [
          'label' => __('Hover Border Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
              '{{WRAPPER}} .video_box ahover  ' => 'border-color: {{VALUE}}!important;', 
            ],
            
       ]
    ); 
    $this->add_control(
      'hvideo_btn_bg',
       [
          'label' => __('Hover Background Color', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
              '{{WRAPPER}} .video_box ahover  ' => 'background: {{VALUE}}!important;', 
            ],
            
       ]
    );         
  $this->end_controls_section();
}
protected function render(){
  $settings = $this->get_settings_for_display();
  $allowed_tags = wp_kses_allowed_html('post');
?>
<div class="video_btn_all">
 <?php if($settings['video_style'] == 'style_two'): ?>
  <a href="<?php echo esc_attr($settings['video_button_link']['url']); ?>"
    class="lightbox-image style_two media-group align-items-center justify-content-center justify-content-md-start">
    <div class="nk-video-btn">
      <div  class="icn animate animate-infinite animate-pulse animate-duration-1">
        <em class="icon ni ni-play-fill"></em>
      </div>
    </div>
    <div class="media-text">
      <h4 class="title_no_a_24 m-0">Watch Demo</h4>
    </div>
  </a>
  <?php else: ?>
    <div class="video_box">
      <a href="<?php echo esc_attr($settings['video_button_link']['url']); ?>"
        class="lightbox-image  animate animate-infinite animate-pulse animate-duration-1">
        <i class="ni-play-fill"></i>
      </a>
    </div>
  <?php endif; ?>
</div>
<?php
}
}
 