<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Team_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-team-v1';
    }

    public function get_title()
    {
        return __('Team Box V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }
    public function get_categories()
    {
        return ['101'];
    }
    protected function register_controls(){
        // style one start
        $this->start_controls_section('team_settings',
        [ 
            'label' => __('Team Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ], 
            ] 
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'name',
            [
               'label' => __('Name', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Jacob T. Campbell', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
          'designation',
          [
             'label' => __('Designation', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Junior Manager', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $this->add_control(
            'hr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'description',
            [
               'label' => __('Description', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('AI Copywriting is revolutionizing the way content is created.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'hr4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'link',
            [
                'label' => __('Link', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'copygen-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
        $this->add_control(
            'hr5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'media_enable',
            [
                'label' => __('Media Enable / Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
             
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'media_icon',
        [
            'label' => esc_html__('Media Icon', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('fa fa-facebook' , 'copygen-addons'),
        ]);
        
        $repeater->add_responsive_control(
            'media_link',
            [
                'label' => __('Link', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'copygen-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
      $this->add_control(
        'media_repeater',
        [
            'label' => __('Media Repeater', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'media_icon' =>  __('fa fa-facebook','copygen-addons'),
                ],
                [
                    'media_icon' =>  __('fa fa-twitter','copygen-addons'),
                ],
                [
                    'media_icon' =>  __('fa fa-skype','copygen-addons'),
                ],
                [
                    'media_icon' =>  __('fa fa-instagram','copygen-addons'),
                ]
                
            ],
            'title_field' => '{{{ media_icon }}}',
            'condition' => [
                'media_enable' => 'yes'
            ],
        ]);
       
        $this->end_controls_section();
        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Image Border Radius', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .team_box.type_one .image_box img ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				], 
			]
		);
        $this->add_responsive_control(
            'image_width',
            [
                'label' => __('Image Width', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 100,
                'step'    => 1,
                'default' => 30,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .image_box img  ' => 'width: {{VALUE}}%!important;',
               ], 
            ]
        );
        $this->add_control(
            'hr7',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Name Typography', 'copygen-addons' ),
				'name' => 'name_typo',
				'selector' => '{{WRAPPER}} .team_box.type_one .contnet .title_16 a',
			]
		);
        $this->add_control(
            'name_bg_color',
             [
                'label' => __('Name Bg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .title_16 a ' => 'background: {{VALUE}}!important;',
                ],
             ]
        );   
        $this->add_control(
            'name_color',
             [
                'label' => __('Name Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .title_16 a ' => 'color: {{VALUE}}!important;',
                ],
             ]
        ); 
        $this->add_control(
            'hr9',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Designation Typography', 'copygen-addons' ),
				'name' => 'd_typo',
				'selector' => '{{WRAPPER}} .team_box.type_one .contnet .designation ',
			]
		);
        $this->add_control(
            'designation_color',
             [
                'label' => __('Designation Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .designation ' => 'color: {{VALUE}}!important;',
                ],
             ]
        ); 
        $this->add_control(
            'hr10',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Description Typography', 'copygen-addons' ),
				'name' => 'des_typo',
				'selector' => '{{WRAPPER}} .team_box.type_one .contnet .desc ',
			]
		);
        $this->add_control(
            'description_color',
             [
                'label' => __('Description Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .desc ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'hr11',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'media_color',
             [
                'label' => __('Media Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .socialicons li a ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
          
    $this->end_controls_section();


    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : '';
    ?>
 
<div class="team_box type_one">
    <?php if(!empty($settings['image']['url'])): ?>
    <div class="image_box">
        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
    </div>
    <?php endif; ?>
    <div class="contnet">
        <?php if(!empty($settings['name'])): ?>
        <h6 class="title_16" data-splitting>
            <a href="<?php echo esc_url($settings['link']['url']); ?>" <?php echo esc_attr($target); ?>
                <?php echo esc_attr($nofollow); ?>>
                <?php echo wp_kses($settings['name'] , $allowed_tags); ?>
            </a>
        </h6>
        <?php endif; ?>
        <?php if(!empty($settings['designation'])): ?>
            <p class="designation"> <?php echo wp_kses($settings['designation'] , $allowed_tags); ?></p>
        <?php endif; ?>
        <?php if(!empty($settings['description'])): ?>
            <p class="desc"> <?php echo wp_kses($settings['description'] , $allowed_tags);  ?></p>
        <?php endif; ?>
        <?php if($settings['media_enable'] == 'yes'): ?>
            <div class="socialicons">
                <ul>
                    <?php foreach($settings['media_repeater'] as $media):
                    $mtarget = $media['media_link']['is_external'] ? ' target="_blank"' : '';
                    $mnofollow = $media['media_link']['nofollow'] ? ' rel="nofollow"' : '';
                    ?>
                    <li>
                        <a href="<?php echo esc_url($media['media_link']['url']); ?>" class="m_icon"
                            <?php echo esc_attr($mtarget); ?> <?php echo esc_attr($mnofollow); ?>>
                            <i class="<?php echo esc_attr($media['media_icon']); ?>"></i>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
       
    </div>
</div>
 


<?php
    }
}

 