<?php
   
namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

   class Faqs_v1 extends \Elementor\Widget_Base
   {
   
       public function get_name()
       {
           return 'copygen-faqs-v1';
       }
   
       public function get_title()
       {
           return __('Faqs V1', 'copygen-addons');
       }
   
       public function get_icon()
       {
        return 'icon-steel';
       }
   
       public function get_categories()
       {
           return ['101'];
       }
   
       protected function register_controls(){
   
            $this->start_controls_section('faq_settings',
            [ 
               'label' => __('Faq Settings', 'copygen-addons')
            ]
            );

            $this->add_control(
                'faqstyle',
                [
                'label' => __('Faq Styles', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one' => __( 'Style One', 'copygen-addons' ),
                    'style_two' => __( 'Style Two', 'copygen-addons' ),  
                ],
                'default' => 'style_one' , 
                ]
            );
           
            $repeater = new \Elementor\Repeater();
   
            $repeater->add_control(
               'faq_icon',
               [
                   'label' => __('Faqs Icon', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::ICON,
                   'options' => copygen_get_icons(),
                   'default' => 'ni-arrow-down-circle',
                  
               ]
            );
            $repeater->add_control(
               'faqsheading_text',
               [
                   'label' => __('Faqs Heading', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('How do I make a yearly payment? ', 'copygen-addons'),
                   'placeholder' => __('How do I make a yearly payment?', 'copygen-addons'),
               ]
            );
            $repeater->add_control(
               'faqsdescription',
               [
                   'label' => __('Faqs Description', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                   'placeholder' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
               ]
            );
   
            $repeater->add_control(
             'hrfourre',
             [
                 'type' => \Elementor\Controls_Manager::DIVIDER, 
                
             ]
            );
   
           $repeater->add_control(
             'faqs_active_tb',
            [
               'label' => __('Faq Active / Deactive', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
         );
     
           $this->add_control(
               'faqs_v1_repeater',
               [
                   'label' => __('Faqs Box Content', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::REPEATER,
                   'fields' => $repeater->get_controls(),
                   'default' => [
                       [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('How do I make a yearly payment?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.'),
                        'faqs_active_tb' => 'yes',
                        ],
                       [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('How this technology works?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                   ],
                   'title_field' => '{{{ faqsheading_text }}}',
   	
               ]
           );
    
    $this->end_controls_section();

    
    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header .question_box .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    
    
   
$this->end_controls_section();

}
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>


<section class="block_faq <?php echo esc_attr($settings['faqstyle']); ?>"> 
 
</section>


<?php
}
}
 