<?php
   
namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Login extends \Elementor\Widget_Base{
   
    public function get_name()
    {
        return 'copygen-login-v1';
     }
   
    public function get_title()
    {
        return __('Login / Register Form', 'copygen-addons');
    }
       
    public function get_icon()
    {
        return 'icon-steel';
    }
   
    public function get_categories()
    {
        return ['101'];
    }
   
    protected function register_controls(){
   
    $this->start_controls_section('login_settings',
    [ 
        'label' => __('Login Settings', 'copygen-addons')
    ]
    );
    $this->add_control(
        'form_type',
        [
            'label' => __('Form Type', 'creote-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'login'  => __('Login', 'creote-addons'),
                'register'  => __('Register', 'creote-addons'),
                'forget'  => __('Forget', 'creote-addons'), 
            ],
            'default' => 'login',
        ]
    );
    $this->start_controls_tabs(
        'tab_start'
    );
    $this->start_controls_tab(
        'tab_one',
        [
            'label' => esc_html__( 'Before Login', 'copygen-addons' ),
        ]
    ); 
    $this->add_control(
        'name_label',
        [
            'label' => __('Name label', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Username', 'copygen-addons'),
            'placeholder' => __('Username', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );  
    $this->add_control(
        'name_placeholder',
        [
            'label' => __('Name Placeholder', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Enter the Name', 'copygen-addons'),
            'placeholder' => __('Enter the Name', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );  
    $this->add_control(
        'hr1',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );
    $this->add_control(
        'mail_label',
        [
            'label' => __('Mail label', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Mail Id', 'copygen-addons'),
            'placeholder' => __('Mail Id', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['login' , 'register' , 'forget']
            ]
        ]
    );  
    $this->add_control(
        'mail_placeholder',
        [
            'label' => __('Mail Placeholder', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Enter the Mail Id', 'copygen-addons'),
            'placeholder' => __('Enter the Mail Id', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['login' , 'register' , 'forget']
            ]
        ]
    );  
    $this->add_control(
        'hr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'form_type' => ['login' , 'register' , 'forget']
            ]
        ]
    );
    $this->add_control(
        'pass_label',
        [
            'label' => __('Password label', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Password', 'copygen-addons'),
            'placeholder' => __('Password', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['register' , 'login']
            ]
        ]
    );   
    $this->add_control(
        'pass_placeholder',
        [
            'label' => __('Password Placeholder', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Enter the Mail Password', 'copygen-addons'),
            'placeholder' => __('Enter the Mail Password', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['register' , 'login']
            ]
        ]
    );   
    $this->add_control(
        'hrn',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );
    $this->add_control(
        'rnotice',
        [
            'label' => __('Notice', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Registration confirmation will be emailed to you.', 'copygen-addons'), 
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );  
    $this->add_control(
        'hrrm',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'form_type' => ['login']
            ]
        ]
    );
    $this->add_control(
        'remember_text',
        [
            'label' => __('Remember Text', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Remember Me', 'copygen-addons'),
            'placeholder' => __('Remember Me', 'copygen-addons'),
            'condition' => [ 
                'form_type' => ['login']
            ]
        ]
    );   
    $this->add_control(
        'hr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'form_type' => ['register']
            ]
        ]
    );
    $this->add_control(
        'button_text',
        [
            'label' => __('Submit Button', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Button Text', 'copygen-addons'),
            'placeholder' => __('Enter the text here', 'copygen-addons'),
        ]
    ); 
    $this->add_control(
        'google_login_disables',
        [
            'label' => __('Social Login Shortdode Disable / Enable', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'no',
        ]
    );
    $this->add_control(
        'or_signs',
        [
            'label' => __('Extra Text', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('OR JOIN WITH', 'copygen-addons'),
            'placeholder' => __('OR JOIN WITH', 'copygen-addons'),
            'condition' => [ 
                'google_login_disables' => ['yes']
            ]
        ]
    ); 
    $this->add_control(
        'socical_shortcode',
        [
            'label' => __('Social Shortcode', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __('', 'copygen-addons'),
            'placeholder' => __('[nextend_social_login]  or [miniorange_social_login]', 'copygen-addons'),
            'condition' => [ 
                'google_login_disables' => ['yes']
            ]
        ]
    );   
    $this->end_controls_tab();
    $this->start_controls_tab(
        'tab_two',
        [
            'label' => esc_html__( 'After Login', 'copygen-addons' ),
        ]
    ); 
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section(); 
    $this->start_controls_section('form_css',
     [ 
         'label' => __('Form Css', 'copygen-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     );  
     $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Label Typography', 'copygen-addons' ),
            'name' => 'label_typo',
            'selector' => '{{WRAPPER}} .login_form_box label  ',
        ]
    );
     $this->add_control(
         'label_color',
          [
             'label' => __('Label Color', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::COLOR,
             'selectors' => [
                 '{{WRAPPER}} .login_form_box label  ' => 'color: {{VALUE}}!important;',
             ],
          ]
     );
     $this->add_responsive_control(
         'label_padding',
         [
             'label' => esc_html__( 'Label Padding', 'copygen-addons' ),
             'type' => \Elementor\Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', '%', 'em' ],
             'selectors' => [
                 '{{WRAPPER}} .login_form_box label   ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
             ],
         ]
     ); 
     $this->add_control(
        'shr1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
   
    $this->add_control(
        'input_check_colors',
         [
            'label' => __('Input Check / Radio Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=checkbox] , {{WRAPPER}} .login_form_box  input[type=radio]  ' => 'box-shadow: 0 0 0 1px {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'input_checked_colors',
         [
            'label' => __('Input Check / Radio Active Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=checkbox]:checked , {{WRAPPER}} .login_form_box  input[type=radio]:checked  ' => 'background:{{VALUE}}!important; box-shadow: 0 0 0 1px {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'shr3',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Input Typo', 'copygen-addons' ),
            'name' => 'in_typo',
            'selector' => '{{WRAPPER}} .login_form_box input:not([type=submit]) , {{WRAPPER}} .login_form_box input:not([type=submit])::placeholder  ',
        ]
    );
     $this->add_control(
        'input_color',
         [
            'label' => __('Input Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit]) ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'input_place_holder_color',
         [
            'label' => __('Input Placeholder Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit])::placeholder  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr5',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'input_bg_color',
         [
            'label' => __('Input Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit])  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr6',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'input_border_width',
        [
            'label' => esc_html__( 'Input Border Width', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit]) ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'shr7',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'input_border_color',
         [
            'label' => __('Input', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit])  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr8',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'input_border_radius',
        [
            'label' => esc_html__( 'Input Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit]) ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'shr9',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'input_padding',
        [
            'label' => esc_html__( 'Input Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input:not([type=submit])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'shr10',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'input_margin',
        [
            'label' => esc_html__( 'Input Margin', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box input:not([type=submit]) ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    ); 
    $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Button Normal', 'copygen-addons' ),
        ]
    );  
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Button Typo', 'copygen-addons' ),
            'name' => 'btn_typo',
            'selector' => '{{WRAPPER}} .login_form_box   input[type=submit]  ',
        ]
    );
    $this->add_control(
        'button_color',
         [
            'label' => __('Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit] ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr14',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'button_border_color',
         [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit] ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr15',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'button_bg_color',
         [
            'label' => __('Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box   input[type=submit]  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr13',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'button_padding',
        [
            'label' => esc_html__( 'Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important; min-height:auto!important;',
            ],
        ]
    );
    $this->add_control(
        'shr12',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'button_borderradiuse',
        [
            'label' => esc_html__( 'Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit]  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
        'style_hover_tab',
        [
            'label' => esc_html__( 'Button  Hover', 'copygen-addons' ),
        ]
    );
    $this->add_control(
        'button_hover_color',
         [
            'label' => __('Button Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit]:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr17',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'button_hover_bor_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit]:hover  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr18',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'button_hover_bg_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box  input[type=submit]:hover  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
        'two_s',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );

    $this->start_controls_tabs(
        'two_style_tabs'
    );
    $this->start_controls_tab(
        'two_style_normal_tab',
        [
            'label' => esc_html__( 'Google Button Normal', 'copygen-addons' ),
        ]
    );  
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Google Button Typography', 'copygen-addons' ),
            'name' => 'g_typo',
            'selector' => '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper ',
        ]
    );
    $this->add_control(
        'two_button_color',
         [
            'label' => __('Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'two_shr14',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'two_button_border_color',
         [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'two_shr15',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'two_button_bg_color',
         [
            'label' => __('Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'two_shr13',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
     
    $this->add_responsive_control(
        'two_button_borderradiuse',
        [
            'label' => esc_html__( 'Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButtonBlue  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
        'two_style_hover_tab',
        [
            'label' => esc_html__( 'Button  Hover', 'copygen-addons' ),
        ]
    );
    $this->add_control(
        'two_button_hover_color',
         [
            'label' => __('Button Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'two_shr17',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'two_button_hover_bor_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper:hover  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'two_shr18',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'two_button_hover_bg_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper:hover  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
        'two_shr12',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Extra Text Typography', 'copygen-addons' ),
            'name' => 'e_typo',
            'selector' => '{{WRAPPER}} .login_form_box .abcRioButton .abcRioButtonContentWrapper ',
        ]
    );
    $this->add_control(
        'extra_text_color',
         [
            'label' => __('Extra Text Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .other_text span  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'extra_textbr_color',
         [
            'label' => __('Extra Text Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .login_form_box .other_text::before  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_section();

}
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<?php if($settings['form_type'] == 'register'):
        $registration_enabled = get_option('users_can_register'); 
    ?>
<section class="login_form_box">
    <div class="login_form_box_inner">

       <?php if(!is_user_logged_in()):  if($registration_enabled):
            $name_label = $settings['name_label'];
            $name_placeholder = $settings['name_placeholder'];
            $mail_label = $settings['mail_label'];
            $mail_placeholder = $settings['mail_placeholder'];
            $pass_label = $settings['pass_label'];
            $pass_placeholder = $settings['pass_placeholder'];
            
            if (isset($_POST['register'])) {
            $username = sanitize_user($_POST['user_login']);
            $email = sanitize_email($_POST['user_email']);
            $password = esc_attr($_POST['user_password']);
            $userdata = array(
            'user_login' => $username,
            'user_email' => $email,
            'user_pass' => $password,
            ); 
            $user_id = wp_insert_user($userdata);
            if (!is_wp_error($user_id)) {
                wp_new_user_notification($user_id, null, 'admin');
                echo 'Registration complete. Now you Can login by using username or mailid with password';
                } else {
                echo $user_id->get_error_message();
                }
            }
        ?>
      <form method="post" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
    <p>
        <label for="user_login"><?php echo esc_html($name_label); ?><br />
            <input type="text" name="user_login" placeholder="<?php echo esc_attr($name_placeholder); ?>"
                value="<?php if (isset($_POST['user_login'])) echo esc_attr($_POST['user_login']); ?>" /></label>
    </p>
    <p>
        <label for="user_email"><?php echo esc_html($mail_label); ?><br />
            <input type="email" name="user_email" placeholder="<?php echo esc_attr($mail_placeholder); ?>"
                value="<?php if (isset($_POST['user_email'])) echo esc_attr($_POST['user_email']); ?>" /></label>
    </p>
    <p>
        <label for="user_password"><?php echo esc_html($pass_label); ?><br />
            <input type="password" name="user_password"
                placeholder="<?php echo esc_attr($pass_placeholder); ?>" /></label>
    </p>
    <?php if ($settings['rnotice']) : ?>
    <p class="text_notice">
        <?php echo esc_html($settings['rnotice']); ?>
    </p>
    <?php endif; ?>
    <p>
        <input type="submit" name="register" value="<?php echo esc_attr($settings['button_text']); ?>" />
    </p>
</form>  
 
<?php else: ?>
    <?php  echo '<p>User registration is disabled So this form is only for demo Purpose Only.</p>
    <p>Top enable user registration go to Settings --> General --> check Membership Check Box</p>'; ?>
<?php endif; ?>
        <?php if($settings['google_login_disables'] == 'yes'): ?>
        <?php if(!empty($settings['or_signs'])): ?>
        <div class="other_text">
            <span><?php echo wp_kses($settings['or_signs'] , $allowed_tags);  ?></span>
        </div>
        <?php endif; ?>
        <?php if(!empty($settings['socical_shortcode'])): ?>
            <div class="shortcode_social">
            <?php echo do_shortcode($settings['socical_shortcode']); ?> 
            </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php endif; ?>
        <?php
        $current_user = wp_get_current_user(); 
        if(is_user_logged_in()): ?>
            <div class="after_logged_in text-center">
                <h6> <?php echo esc_html('Welcome' , 'copygen-addons'); ?> <?php echo esc_attr($current_user->display_name); ?> <h6>
                <ul>
                    <li>
                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="theme_btn"><?php echo esc_html('Log Out' , 'copygen-addons'); ?></a>
                    
                    </li>
                    <li> 
                    <a href="<?php echo admin_url(); ?>" class="theme_btn"><?php echo esc_html('Go to Admin Dashboard' , 'copygen-addons'); ?></a>
                    </li>
                </ul>
         </div>
        <?php endif; ?>
    </div>
 
</section>
<?php elseif($settings['form_type'] == 'forget'): ?>
<section class="login_form_box">
    <div class="login_form_box_inner">
        <?php  if(!is_user_logged_in()):
        $mail_label = $settings['mail_label'];
        $mail_placeholder  = $settings['mail_placeholder'];
        if(isset($_POST['user_login'])){
            $user_login = $_POST['user_login'];
            $errors = retrieve_password();
            if(is_wp_error($errors)){
                echo "<div class='alert alert-danger'>";
                foreach($errors->get_error_messages() as $error){
                    echo " $error<br/>";
                }
                echo "</div>";
            }else{
                echo "<div class='alert alert-success'>".esc_html__('Check your email for the confirmation link.')."</div>";
            }
        }
        ?>
        <form method="post" action="">
            <p>
                <label for="user_login"><?php echo esc_attr($mail_label); ?></label>
                <input type="text" name="user_login" id="user_login" class="input" value="" placeholder="<?php echo esc_attr($mail_placeholder); ?>" size="20" />
            </p>
            <p>
                <input type="submit" name="submit" value="<?php echo esc_attr($settings['button_text']); ?>" class="button-primary" />
            </p>
        </form>
        <?php endif; ?>
        <?php
        $current_user = wp_get_current_user(); 
        if(is_user_logged_in()): ?>
            <div class="after_logged_in text-center">
                <h6> <?php echo esc_html('Welcome' , 'copygen-addons'); ?> <?php echo esc_attr($current_user->display_name); ?> <h6>
                <ul>
                    <li>
                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="theme_btn"><?php echo esc_html('Log Out' , 'copygen-addons'); ?></a>
                    
                    </li>
                    <li> 
                    <a href="<?php echo admin_url(); ?>" class="theme_btn"><?php echo esc_html('Go to Admin Dashboard' , 'copygen-addons'); ?></a>
                    </li>
                </ul>
         </div>
        <?php endif; ?>
    </div>
</section>
<?php else: ?>
<section class="login_form_box">
    <div class="login_form_box_inner">
        <?php if(!is_user_logged_in()): 
        $mail_label = $settings['mail_label'];
        $mail_placeholder = $settings['mail_placeholder'];
           $pass_label = $settings['pass_label'];
           $pass_placeholder = $settings['pass_placeholder'];
        if(isset( $_GET['login']) && preg_match('/failed/', $_GET['login'])): ?>
        <div class="wp_login_error">
            <p style="color:red;">
                <?php echo esc_html__('The login is incorrect. Please try again.' , 'vankine-addons'); ?></p>
        </div>
        <?php elseif ( isset( $_GET['login'] ) && $_GET['login'] == 'empty' ): ?>
        <div class="wp_login_error">
            <p style="color:red;">
                <?php echo esc_html__('Please enter both username and password.' , 'vankine-addons'); ?></p>
        </div>
        <?php endif; ?>
        <div id="loginform">
            <form method="post" action="<?php echo home_url('wp-login.php'); ?>" class="wp-user-form">
                <div class="from_box">
                    <label class="form-label"><?php echo esc_attr($mail_label); ?></label>
                    <input type="text" placeholder="<?php echo esc_attr($mail_placeholder); ?>" required id="user_login"
                        name="log" />
                </div>
                <div class="from_box">
                    <label class="form-label"><?php echo esc_attr($pass_label); ?></label>
                    <input type="password" placeholder="<?php echo esc_attr($pass_placeholder); ?>" required id="user_pass" name="pwd" />
                </div>
                <?php if(!empty($settings['remember_text'])): ?>
                    <p class="forgetmenot">
                        <input type="checkbox" name="rememberme" id="rememberme" value="forever" />
                        <label for="rememberme"><?php echo esc_attr($settings['remember_text']); ?></label>
                    </p>
                <?php endif; ?>
                <div>
                    <input id="wp-submit" type="submit" value="<?php echo esc_attr($settings['button_text']); ?>" name="submit" />
                </div>
                <input type="hidden" name="redirect_to" value="<?php echo esc_attr( $_SERVER['REQUEST_URI'] ); ?>" />
            </form>
        </div> 
        <?php if($settings['google_login_disables'] == 'yes'): ?>
        <?php if(!empty($settings['or_signs'])): ?>
        <div class="other_text">
            <span><?php echo wp_kses($settings['or_signs'] , $allowed_tags);  ?></span>
        </div>
        <?php endif; ?>
        <?php if(!empty($settings['socical_shortcode'])): ?>
            <div class="shortcode_social">
            <?php echo do_shortcode($settings['socical_shortcode']); ?> 
            </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php endif; ?>
        <?php
        $current_user = wp_get_current_user(); 
        if(is_user_logged_in()): ?>
            <div class="after_logged_in text-center">
                <h6> <?php echo esc_html('Welcome' , 'copygen-addons'); ?> <?php echo esc_attr($current_user->display_name); ?> <h6>
                <ul>
                    <li>
                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="theme_btn"><?php echo esc_html('Log Out' , 'copygen-addons'); ?></a>
                    
                    </li>
                    <li> 
                    <a href="<?php echo admin_url(); ?>" class="theme_btn"><?php echo esc_html('Go to Admin Dashboard' , 'copygen-addons'); ?></a>
                    </li>
                </ul>
         </div>
        <?php endif; ?>

    </div> 
</section>
<?php endif; ?>
<?php
}
}
 