<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class List_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-list-items-v1';
    }

    public function get_title()
    {
        return __('List Items V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('list_v1_settings',
        [ 
            'label' => __('List Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
          'list_type',
          [
          'label' => __('List Type', 'copygen-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
              'linline' => __( 'Inline View', 'copygen-addons' ),
              'list' => __( 'List View', 'copygen-addons' ),
          ],
          'default' => 'list' , 
          ]
        );
        $repeater = new \Elementor\Repeater(); 
        $repeater->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icons'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
                    'dot'  => esc_html__( 'Simple Dots', 'copygen-addons' ), 
                    'none'  => esc_html__( 'None', 'copygen-addons' ), 
				], 
                'default' => 'dot' , 
			]
		);
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'fi-rs-user' , 
                'condition' => [ 
                    'icon_type' => 'icons'
                ]
            ]
        );
        $repeater->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon'
                ]
            ]
        );
        $repeater->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
          'list_item',
          [
             'label' => __('List item', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Cake & Milk', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $repeater->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
          'list_link',
          [
              'label' => __('Link', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __('https://your-link.com', 'copygen-addons'),
              'show_external' => true,
              'default' => [
                  'url' => '#',
                  'is_external' => false,
                  'nofollow' => false,
              ],
          ]
        );
        $this->add_control(
        'list_repeater',
        [
            'label' => __('List Repeater', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('House Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                 [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __(' Medical Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                 [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('Car Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                 [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('Business Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                 [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('Travel Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('Fire Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ],
                [
                'icon_type' => __('icon', 'copygen-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'copygen-addons'),
                'list_item' =>  __('Marrige Insurance', 'copygen-addons'),
                'list_link' =>  __('#', 'copygen-addons'),
                ]
            ],
            'title_field' => '{{{ list_item }}}',
        ]
        );
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .list_box ' => 'text-align: {{VALUE}}!important;',
                ],
                'condition' => [
                    'list_type' => 'linline' , 
                ], 
            ]
        );

        $this->add_responsive_control(
            'text_aligntwo',
            [
                'label' => esc_html__( 'Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .list_box .d-flex ' => 'justify-content: {{VALUE}}!important;',
                ],
                'condition' => [
                    'list_type' => 'list' , 
                ], 
            ]
        );

    $this->end_controls_section();

    $this->start_controls_section('title_css',
    [ 
        'label' => __('Title Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' List Typography', 'copygen-addons' ),
            'name' => 'desc_typo',
            'selector' =>   '{{WRAPPER}} .list_box li a.links ', 
        ]
    );
    $this->add_control(
        'hr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'list_icon_color',
         [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i ' => 'color: {{VALUE}}!important;',
            ],
            
         ]
    );
    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li  .dot ' => 'background: {{VALUE}}!important;',
            ],
            
         ]
    );
    $this->add_control(
        'dotbox_color',
         [
            'label' => __('Dot Box Shadow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li  .dot ' => 'box-shadow: 0 0 0 .25rem {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'icon_size_widths',
        [
            'label' => __('Icon / Image Size', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 20,
            'min'     => 1,
            'max'     => 100,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'min-width: {{VALUE}}px!important; width: {{VALUE}}px!important; height:auto!important; font-size: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_control(
        'hr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'icon_top',
        [
            'label' => __('Icon Move Top', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  '',
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'top: {{VALUE}}px!important; position:relative;', 
            ],
        ]
    );
    $this->add_control(
        'hr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'icon_right',
        [
            'label' => __('Icon Margin Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  '',
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'margin-right: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_control(
        'hr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'rtlicon_rights',
        [
            'label' => __('Icon Margin Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  '',
            'min'     => -150,
            'max'     => 150, 
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'margin-left: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_control(
        'hr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'list_color',
         [
            'label' => __('List Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'list_hover_color',
         [
            'label' => __('List Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li:hover a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hr10',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'list_margin',
        [
            'label' => esc_html__( 'List Margin', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .list_box li ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'hr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'list_padding',
        [
            'label' => esc_html__( 'List Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .list_box li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
   
$this->end_controls_section();

}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');  
?>
<div class="position-relative">
    <ul class="list_box <?php echo esc_attr($settings['list_type']); ?>">
    <?php if(!empty($settings['list_repeater'])):
    foreach($settings['list_repeater'] as  $key => $list_repeater):   
        $target = $list_repeater['list_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $list_repeater['list_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
        <li>
            <div class="d-flex">
                <?php if($list_repeater['icon_type'] == 'image'): ?>
                    <?php if(!empty($list_repeater['image']['url'])): ?>
                        <div class="icon">
                            <img src="<?php echo esc_url($list_repeater['image']['url']); ?>" alt="img" />
                        </div>
                    <?php endif; ?>
                <?php elseif($list_repeater['icon_type'] == 'elicon'): ?>
                    <?php if(!empty($list_repeater['icon_lib'])): ?>
                        <div class="icon">
                            <?php \Elementor\Icons_Manager::render_icon($list_repeater['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                        </div>
                    <?php endif; ?>		
                <?php elseif($list_repeater['icon_type'] == 'icons'): ?>
                    <?php if(!empty($list_repeater['icon'])): ?>
                        <div class="icon">
                            <i class="<?php echo esc_attr($list_repeater['icon']); ?>"></i>
                        </div> 
                    <?php endif; ?>	
                <?php elseif($list_repeater['icon_type'] == 'none'): ?>	
                    <?php // none ?>
                <?php else: ?>
                    <div class="dot"></div>
                <?php endif; ?>
                <a class="links" href="<?php echo esc_url($list_repeater['list_link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo wp_kses($list_repeater['list_item'] , $allowed_tags); ?>
                </a>
            </div>
        </li>
        <?php endforeach; endif; ?>
    </ul>
    </div>
    <?php
    }
}

 