<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Image_move_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-image-move-v1';
    }

    public function get_title()
    {
        return __('Move Image  V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('image_box_settings',
        [ 
            'label' => __('Image Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
      
        $this->add_control(
            'image',
            [
            'label' => __('Image', 'creote-addons'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
            ]
         );
    
         $this->add_control(
            'width',
            [
            'label' => esc_html__( 'Image Width', 'creote-addons' ),
            'type'  => \Elementor\Controls_Manager::TEXT, 
            'placeholder' => '1000px , 100% , 10rem and 10em', 
            'selectors' => [
                '{{WRAPPER}} .move_image_absolute img  , {{WRAPPER}} .move_image_absolute' => 'width: {{VALUE}}!important;',
            ],
        ]);
        $this->add_control(
            'height',
            [
            'label' => esc_html__( 'Image Height', 'creote-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => '1000px , 100% , 10rem and 10em', 
            'selectors' => [
                '{{WRAPPER}} .move_image_absolute img , {{WRAPPER}} .move_image_absolute' => 'height: {{VALUE}}!important;',
            ],
        ]);

        $this->add_control(
            'move_css',
            [
            'label' => __('Moving Position', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'top_right' => __( 'Top Right', 'copygen-addons' ),
                'top_left' => __( 'Top Left', 'copygen-addons' ),
                'bottom_left' => __( 'Bottom Left', 'copygen-addons' ),
                'bottom_right' => __( 'Bottom Right', 'copygen-addons' ),
            ],
            'default' => 'top_right' , 
            ]
        ); 
         $this->add_control(
            'top',
            [
            'label'       => esc_html__( 'Move Top', 'creote-addons' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'min' => -10000,
            'max' => 10000,
            'step' => 1,
            'default' => '', 
            'condition' => [
                'move_css' => ['top_right' , 'top_left'],
            ],
            'selectors' => [
                '{{WRAPPER}} .move_image_absolute ' => 'top: {{VALUE}}px!important;',
            ],
        ]); 
        $this->add_control(
            'bottom',
             [
             'label'       => esc_html__( 'Move Bottom', 'creote-addons' ),
             'type'        => \Elementor\Controls_Manager::NUMBER,
             'min' => -10000,
            'max' => 10000,
            'step' => 1,
            'default' => '', 
             'condition' => [
                'move_css' => ['bottom_right' , 'bottom_left'],
             ],
             'selectors' => [
                 '{{WRAPPER}} .move_image_absolute ' => 'bottom: {{VALUE}}px!important;',
             ],
        ]);
        $this->add_control(
            'lefts',
            [
            'label'       => esc_html__( 'Move Left', 'creote-addons' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'min' => -10000,
            'max' => 10000,
            'step' => 1,
            'default' => '', 
            'condition' => [
                'move_css' => ['top_left' , 'bottom_left'],
            ],
            'selectors' => [
                '{{WRAPPER}} .move_image_absolute ' => 'left: {{VALUE}}%!important;',
            ],
        ]); 
        $this->add_control(
            'rights',
            [
            'label'       => esc_html__( 'Move Right', 'creote-addons' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'min' => -10000,
            'max' => 10000,
            'step' => 1,
            'default' => '', 
            'condition' => [  
                'move_css' => ['top_right' , 'bottom_right'],
            ],
            'selectors' => [
                '{{WRAPPER}} .move_image_absolute ' => 'right: {{VALUE}}%!important;',
            ],
        ]);
        
        $this->end_controls_section();
    }
    protected function render(){
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');  
     ?>
   <div class="move_image_absolute">    
        <?php if(!empty($settings['image']['url'])):
             $alt_text = 'alt';
             $image = isset($settings['image']['alt']) ? $settings['image']['alt'] : '';
             if(!empty($image)) {
               $alt_text = $image;
             }
            ?>
        <img src="<?php echo esc_url($settings['image']['url']); ?>" class="class-fluid" alt="<?php echo esc_attr($alt_text); ?>" />
        <?php endif; ?>
    </div>
    <?php
    }
}

 

