<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Image_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-image-box-v1';
    }

    public function get_title()
    {
        return __('Image Box V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('image_box_settings',
        [ 
            'label' => __('Image Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'image_style',
            [
            'label' => __('Image Box Styles', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'copygen-addons' ),
                'style_two' => __( 'Style Two', 'copygen-addons' ),
                'style_three' => __( 'Style Three', 'copygen-addons' ),
                'style_four' => __( 'Style Four', 'copygen-addons' ),
                'style_five' => __( 'Style Five', 'copygen-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );
        $this->add_control(
            'hr0',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ] 
        );
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'svg_style',
            [
            'label' => __('Svg Styles', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'copygen-addons' ),
                'style_two' => __( 'Style Two', 'copygen-addons' ),
                'style_three' => __( 'Style Three', 'copygen-addons' ), 
            ],
            'default' => 'style_one' , 
            ]
        );
        $this->add_control(
            'shr0',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'svg_move',
            [
            'label' => __('Move Svg Position', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'top_right' => __( 'Position Top Right', 'copygen-addons' ),
                'top_left' => __( 'Position Top Left', 'copygen-addons' ),
                'bottom_right' => __( 'Position Bottom Right', 'copygen-addons' ), 
                'bottom_left' => __( 'Position Top Left', 'copygen-addons' ), 
            ],
            'default' => 'top_right' , 
            ]
        );
        $this->add_control(
            'shr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'move_svg_top',
            [
                'label' => __('Move Svg Top', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .image_box.style_one svg ' => 'height: {{VALUE}}%!important;', 
                ],
                'condition' => [
                    'svg_move' => ['top_right' , 'top_left'] ,
                ],
            ]
        );
        $this->add_responsive_control(
            'move_svg_bottom',
            [
                'label' => __('Move Bottom', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .image_box.style_one svg ' => 'height: {{VALUE}}%!important;', 
                ],
                'condition' => [
                    'svg_move' => ['bottom_right' , 'bottom_left'] ,
                ],
            ]
        );
        $this->add_control(
            'shr3',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'move_svg_left',
            [
                'label' => __('Move Left', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .image_box.style_one svg ' => 'height: {{VALUE}}%!important;', 
                ],
                'condition' => [
                    'svg_move' => ['top_left' ,  'bottom_left'] ,
                ],
            ]
        );
        
        $this->add_responsive_control(
            'move_svg_right',
            [
                'label' => __('Move Right', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .image_box.style_one svg ' => 'right: {{VALUE}}%!important;', 
                ],
                'condition' => [
                    'svg_move' => ['top_right' , 'bottom_right' ] ,
                ],
            ]
        );
       
        $this->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
			'image_alignment',
			[
				'label' => esc_html__( 'Image Alignment', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'copygen-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'copygen-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'copygen-addons' ),
						'icon' => 'eicon-text-align-right',
					], 
				],
				'default' => 'center',
				'toggle' => true, 
			]
		); 
        $this->add_control(
            'hr33',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'animation_enable',
            [
                'label' => __('Animation Enable / Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label' => __('Image Height', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge .cc_height ' => 'height: {{VALUE}}px!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                ],
            ]
        );
        $this->add_control(
            'image_move_type',
            [
            'label' => __('Image Moving Type', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'top_left' => __( 'Top Left', 'copygen-addons' ),
                'bottom_right' => __( 'Bottom Right', 'copygen-addons' ), 
            ],
            'default' => 'bottom_right' , 
            'condition' => [
                'image_style' => ['style_two'] , 
            ],
            ]
        );
        $this->add_responsive_control(
            'imagebottom',
            [
                'label' => __('Image Bottom', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => -5000,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge .cc_height ' => 'bottom: {{VALUE}}%!important; top:unset!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                    'image_move_type' => ['bottom_right'] ,
                ],
            ]
        );
        $this->add_responsive_control(
            'imageright',
            [
                'label' => __('Image Right', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => -5000,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge .cc_height ' => 'right: {{VALUE}}%!important; left:unset!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                    'image_move_type' => ['bottom_right'] ,
                ],
            ]
        );
        $this->add_responsive_control(
            'imagetop',
            [
                'label' => __('Image Bottom', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => -5000,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge .cc_height ' => 'top: {{VALUE}}%!important; bottom:unset!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                    'image_move_type' => ['top_left'] ,
                ],
            ]
        );
        $this->add_responsive_control(
            'imageleft',
            [
                'label' => __('Image Left', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => -5000,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge .cc_height ' => 'left: {{VALUE}}%!important; right:unset!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                    'image_move_type' => ['top_left'] ,
                ],
            ]
        );
        $this->add_control(
            'dotbox_color',
             [
                'label' => __('Svg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge.style_four svg path ' => 'fill:{{VALUE}}!important;',
                ],
             ]
        );
        $this->add_responsive_control(
            'foursvg_wi',
            [
                'label' => __('Svg Width', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '500',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge.style_four svg ' => 'width: {{VALUE}}px!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_four'] ,
                ],
            ]
        );
      
        $this->add_responsive_control(
            'fourimage_wi',
            [
                'label' => __('Image Width', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 5000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .cm_imge.style_four img ' => 'width: {{VALUE}}px!important;', 
                ],
                'condition' => [
                    'image_style' => ['style_four'] ,
                ],
            ]
        );
        
        $this->end_controls_section();
    }
    protected function render(){
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');  
     ?>
    <?php // style ?>
    <?php if($settings['image_style'] == 'style_two'):  ?>
    <?php // style ?>
     
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_three'):  ?>
    <?php // style ?>
   
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_four'):  ?>
    <?php // style ?>
     
    <?php // style ?>
    <?php else: ?>
    <?php // style ?>
    <div class="image_box style_one<?php if($settings['animation_enable'] == 'yes'): ?> animate animate-shakeY animate-duration-12<?php endif; ?>">
        <?php if(!empty($settings['image']['url'])): ?>
         <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="cover-bg" class="base">
        <?php endif; ?> 
        <?php if($settings['svg_style'] == 'style_two'): ?> 
            <svg width="414" height="367" viewBox="0 0 414 367" fill="none" xmlns="http://www.w3.org/2000/svg">
                 <path d="M298.553 365.385C241.683 379.987 171.916 291.086 139.67 279.276C76.3519 256.299 -32.1102 263.6 10.3952 210.775C30.0356 186.295 71.0754 153.011 86.3187 133.9C117.392 95.0327 56.4183 25.4583 111.529 5.05841C166.346 -15.1267 212.956 30.612 266.894 45.6435C302.364 55.736 340.472 50.7971 376.821 55.9508C401.738 59.6013 423.724 80.0012 409.067 99.9716C319.073 222.8 394.996 340.476 298.553 365.385Z" fill="#B4EBFC"/>
            </svg>
        <?php elseif($settings['svg_style'] == 'style_three'): ?> 
            <svg width="410" height="408" viewBox="0 0 410 408" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M260.99 3.04619L55.1725 57.9405C15.7331 68.4595 -7.67192 108.811 2.89582 148.069L58.0446 352.937C68.6123 392.195 109.151 415.492 148.59 404.973L354.408 350.078C393.848 339.559 417.253 299.208 406.685 259.95L351.536 55.0817C340.968 15.8243 300.43 -7.4728 260.99 3.04619Z" fill="#B9B3FF"/>
            </svg>
        <?php else: ?>
            <svg width="452" height="373" viewBox="0 0 452 373" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M448.494 259.068C420.999 316.242 367.226 292.754 321.726 287.81C232.429 277.92 171.844 428.427 78.1669 350.546C-25.4856 264.322 -26.2156 107.634 76.9503 47.6789C365.766 -120.753 473.555 207.148 448.494 259.068Z" fill="#B9F7F5"/>
            </svg>
        <?php endif; ?>
    </div>
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>
    <?php
    }
}

 

