<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Feature_card_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-feature-v1';
    }

    public function get_title()
    {
        return __('Feature Card V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('feature_settins',
        [ 
            'label' => __('Feature Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ] 
        );
       
        $this->add_control(
          'title',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Standard Plan', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );

        $this->add_control(
            'description',
            [
               'label' => __('Description', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Standard Plan', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
   
        $this->add_control(
          'link',
          [
              'label' => __('Link', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __('https://your-link.com', 'copygen-addons'),
              'show_external' => true,
              'default' => [
                  'url' => '#',
                  'is_external' => false,
                  'nofollow' => false,
              ],
          ]
      );
  

    $this->end_controls_section();

    $this->start_controls_section('cource_css',
    [ 
        'label' => __('Course Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .feture_box.type_one .image_box  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 'titletypo',
            'selector' => '{{WRAPPER}} .feture_box .title_24 a ',
        ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Price Box Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .feture_box .title_24 a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Description Typography', 'copygen-addons' ),
            'name' => 'desctypo',
            'selector' => '{{WRAPPER}} .feture_box p ',
        ]
    );
    $this->add_control(
        'desc_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .feture_box p  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    
    
    $this->end_controls_section();

}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');  
    $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : ''; 
?>
    <div class="feture_box type_one trans">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image_box">
                <a  href="<?php echo esc_url($settings['link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>> 
                    <img class="img-fluid" src="<?php echo esc_url($settings['image']['url']); ?>" alt="img">
                </a>
            </div>
        <?php endif; ?> 
        <h4 class="title_24">
            <a class="links" href="<?php echo esc_url($settings['link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>> 
                <?php echo wp_kses($settings['title'] , $allowed_tags); ?>
            </a>
        </h4> 
        <?php if(!empty($settings['description'])): ?>
            <p>
                <?php echo wp_kses($settings['description'] , $allowed_tags); ?>
            </p>
        <?php endif; ?> 
    </div>
    <?php
    }
}

 