<?php
   
namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

   class Faqs_v1 extends \Elementor\Widget_Base
   {
   
       public function get_name()
       {
           return 'copygen-faqs-v1';
       }
   
       public function get_title()
       {
           return __('Faqs V1', 'copygen-addons');
       }
   
       public function get_icon()
       {
        return 'icon-steel';
       }
   
       public function get_categories()
       {
           return ['101'];
       }
   
       protected function register_controls(){
   
            $this->start_controls_section('faq_settings',
            [ 
               'label' => __('Faq Settings', 'copygen-addons')
            ]
            );

            $this->add_control(
                'faqstyle',
                [
                'label' => __('Faq Styles', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one' => __( 'Style One', 'copygen-addons' ),
                    'style_two' => __( 'Style Two', 'copygen-addons' ),  
                ],
                'default' => 'style_one' , 
                ]
            ); 
            $repeater = new \Elementor\Repeater(); 
            $repeater->add_control(
               'faqsheading_text',
               [
                   'label' => __('Faqs Heading', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('How do I make a yearly payment? ', 'copygen-addons'),
                   'placeholder' => __('How do I make a yearly payment?', 'copygen-addons'),
               ]
            );
            $repeater->add_control(
               'faqsdescription',
               [
                   'label' => __('Faqs Description', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                   'placeholder' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
               ]
            );
   
            $repeater->add_control(
             'hrfourre',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );
   
           $repeater->add_control(
             'faqs_active_tb',
            [
               'label' => __('Faq Active / Deactive', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
         );
     
           $this->add_control(
               'faqs_v1_repeater',
               [
                   'label' => __('Faqs Box Content', 'copygen-addons'),
                   'type' => \Elementor\Controls_Manager::REPEATER,
                   'fields' => $repeater->get_controls(),
                   'default' => [
                       [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('How do I make a yearly payment?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.'),
                        'faqs_active_tb' => 'yes',
                        ],
                       [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('How this technology works?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icon' =>  ' ni-arrow-down-circle',
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'copygen-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'copygen-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                   ],
                   'title_field' => '{{{ faqsheading_text }}}',
   	
               ]
           );
    
    $this->end_controls_section();

    
    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Normal', 'copygen-addons' ),
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 't_typos',
            'selector' => '{{WRAPPER}} .block_faq .accordion .question .question_box .title_no_a_18 ',
        ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion .question .question_box .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr_1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Content Typography', 'copygen-addons' ),
            'name' => 'c_typos',
            'selector' => '{{WRAPPER}} .block_faq .accordion .answer ',
        ]
    );
    $this->add_control(
        'content_color',
         [
            'label' => __('Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion .answer ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr_2',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_control(
        'arrow_color',
         [
            'label' => __('Symbol Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion .question .question_box .plus_mins i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr_3',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [  
                'faqstyle' => ['style_one'],
            ], 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .block_faq .accordion  ',
            'condition' => [  
                'faqstyle' => ['style_one'],
            ],
        ]
    );
    $this->add_control(
        'shr_4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion' => 'border-color: {{VALUE}}',
            ],
         ]
    ); 
    $this->end_controls_tab();
    $this->start_controls_tab(
        'style_hover_tab',
        [
            'label' => esc_html__( 'Hover / Active', 'copygen-addons' ),
        ]
    );
    $this->add_control(
        'htitle_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion.active-block .question .question_box .title_no_a_18 , {{WRAPPER}} .block_faq .accordion:hover .question .question_box .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr_1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_control(
        'hcontent_color',
         [
            'label' => __('Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion.active-block .answer ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr_2',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_control(
        'hrrow_color',
         [
            'label' => __('Symbol Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion.active-block .question .question_box .plus_mins i , {{WRAPPER}} .block_faq.style_one .accordion:hover .question .question_box .plus_mins i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr_3',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
            'condition' => [  
                'faqstyle' => ['style_one'],
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'hbg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .block_faq .accordion.active-block , {{WRAPPER}} .block_faq .accordion:hover  ',
            'condition' => [  
                'faqstyle' => ['style_one'],
            ],
        ]
    );
    $this->add_control(
        'hshr_4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_control(
        'hborder_color',
         [
            'label' => __('Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .accordion.active-block , {{WRAPPER}} .block_faq .accordion:hover' => 'border-color: {{VALUE}}',
            ],
         ]
    ); 


    $this->end_controls_tab();
    $this->end_controls_tabs();

$this->end_controls_section();
}
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<section class="block_faq <?php echo esc_attr($settings['faqstyle']); ?>"> 
    <div class="accordion-box">
        <?php foreach($settings['faqs_v1_repeater'] as  $key => $faqs_block):?>
        <div class="accordion trans<?php if($faqs_block['faqs_active_tb'] == 'yes'): echo esc_attr(' active-block'); endif;?>">
            <div
                class="question faq_header<?php if($faqs_block['faqs_active_tb'] == 'yes'): echo  esc_attr(' active'); endif;?>">
                <div class="question_box ">
                    <div class="title_no_a_18 trans">
                        <?php echo wp_kses($faqs_block['faqsheading_text'] , $allowed_tags);?>
                    </div>
                    <div class="plus_mins trans">
                        <i class="copy-plus3 trans"></i>
                        <i class="copy-minus trans"></i>
                    </div>
                </div>
            </div>
            <div
                class="answer accordion-content<?php if($faqs_block['faqs_active_tb'] == 'yes'): echo  esc_attr(' current'); endif;?>">
                <?php echo wp_kses($faqs_block['faqsdescription'] , $allowed_tags);?>
            </div>
        </div>
        <?php endforeach;?>
    </div>
</section>
<?php
}
}
 