<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_form_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-contact-form-v1';
    }

    public function get_title()
    {
        return __('Contact Form V1' , 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
		$this->start_controls_section(
			'contact_form',
			[
				'label' => esc_html__( 'Contact Form', 'copygen-addons' ),
			]
        );
        
        $this->add_control(
            'forms_plu',
            [
            'label' => __('Contact Form Plugin type', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'wpforms' => __( 'Wp Forms', 'copygen-addons' ),
                'contactformseven' => __( 'Contact Form 7', 'copygen-addons' ),
            ],
            'default' => 'contactformseven' ,  
            ]
        );

       
        $this->add_control(
            'contact_form_url',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'copygen-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  copygen_contact_form_7_query('wpforms'),
               'condition' => [
                 
                'forms_plu' => 'wpforms',
                ],
            ]
        );

        
        $this->add_control(
            'contact_form_url_seven',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'copygen-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  copygen_contact_form_7_query('wpcf7_contact_form'),
               'condition' => [ 
                'forms_plu' => 'contactformseven',
                ],
            ]
        );

        
     $this->end_controls_section(); 

     $this->start_controls_section('form_css',
     [ 
         'label' => __('Form Css', 'copygen-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     ); 
     
     $this->add_control(
         'label_color',
          [
             'label' => __('Label Color', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::COLOR,
             'selectors' => [
                 '{{WRAPPER}} .contact_form_shortcode label , {{WRAPPER}} .wpforms-field-number-slider-hint ' => 'color: {{VALUE}}!important;',
             ],
          ]
     );
     $this->add_responsive_control(
         'label_padding',
         [
             'label' => esc_html__( 'Label Padding', 'copygen-addons' ),
             'type' => \Elementor\Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', '%', 'em' ],
             'selectors' => [
                 '{{WRAPPER}} .contact_form_shortcode label , {{WRAPPER}} .wpforms-field-number-slider-hint  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
             ],
         ]
     ); 
     $this->add_control(
        'input_check_color',
         [
            'label' => __('Input Check / Radio Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=checkbox]:after, .contact_form_shortcode  input[type=radio]:after ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'input_check_ac_color',
         [
            'label' => __('Input Check / Radio Active Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=checkbox]:checked:after, {{WRAPPER}} .contact_form_shortcode input[type=radio]:checked:after ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

     $this->add_control(
        'input_color',
         [
            'label' => __('Input / Textarea Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'input_place_holder_color',
         [
            'label' => __('Input / Textarea Placeholder Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input::placeholder , {{WRAPPER}} .contact_form_shortcode textarea::placeholder  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'input_bg_color',
         [
            'label' => __('Input / Textarea Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'input_border_width',
        [
            'label' => esc_html__( 'Input Border Width', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'input_border_color',
         [
            'label' => __('Input / Textarea Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'input_border_radius',
        [
            'label' => esc_html__( 'Input Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'input_padding',
        [
            'label' => esc_html__( 'Input / Textarea Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'input_margin',
        [
            'label' => esc_html__( 'Input / Textarea Margin', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
 
    $this->add_responsive_control(
        'textarea_height',
        [
            'label' => __('Textarea Height', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 1000,
            'step'    => 1,
            'default' => '240', 
            'selectors' => [
                '{{WRAPPER}}  .contact_form_shortcode textarea ' => 'min-height: {{VALUE}}px!important; height: {{VALUE}}px!important;',
           ], 
        ]
    );

    $this->add_control(
        'select_color',
         [
            'label' => __('Select  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single .select2-selection__rendered , {{WRAPPER}} .contact_form_shortcode  .wpforms-field .select2-selection--single .select2-selection__rendered 
                , {{WRAPPER}} .wpforms-field-select select  , {{WRAPPER}} div.wpforms-container .wpforms-form .choices__list--single .choices__item ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}}  .wpforms-form .choices::after , {{WRAPPER}} .contact_form_shortcode .select2-selection__arrow::before , {{WRAPPER}}  select ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
   
    $this->add_control(
        'select_bg_color',
         [
            'label' => __('Select Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select 
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'select_border_width',
        [
            'label' => esc_html__( 'Select Border Width', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'select_border_color',
         [
            'label' => __('Select Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'select_border_radius',
        [
            'label' => esc_html__( 'Select Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'select_padding',
        [
            'label' => esc_html__( 'Select Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'select_margin',
        [
            'label' => esc_html__( 'Select Margin', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_responsive_control(
        'button_position',
        [
        'label' => __('Button Position', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'absolute' => __( 'Absolute', 'copygen-addons' ),
            'relative' => __( 'Relative', 'copygen-addons' ),
        ],
        'default' => 'relative' ,
        'selectors' => [
             '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'position: {{VALUE}}!important;',
        ],
        ]
    );
    $this->add_responsive_control(
        'button_pos',
        [
        'label' => __('Button Position', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'button_bottom_right' => __( 'Bottom Right', 'copygen-addons' ),
            'button_bottom_left' => __( 'Bottom Left', 'copygen-addons' ),
        ],
        'default' => 'button_bottom_right' , 
       
        ]
    );
    $this->add_responsive_control(
        'button_bottom',
        [
            'label' => __('Button Bottom', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'bottom: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => ['button_bottom_right' , 'button_bottom_left'],
            ],
        ]
    );
    $this->add_responsive_control(
        'button_right',
        [
            'label' => __('Button Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'right: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => 'button_bottom_right'
            ],
        ]
    );
    $this->add_responsive_control(
        'button_left',
        [
            'label' => __('Button Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'left: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => 'button_bottom_left'
            ],
        ]
    );
    $this->add_responsive_control(
        'button_padding',
        [
            'label' => esc_html__( 'Button Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important; min-height:auto!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'button_borderradiuse',
        [
            'label' => esc_html__( 'Button Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_control(
        'button_color',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_border_color',
         [
            'label' => __('Button Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_bg_color',
         [
            'label' => __('Button Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'button_hover_color',
         [
            'label' => __('Button Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_hover_bor_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_hover_bg_color',
         [
            'label' => __('Button Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->end_controls_section();

}
protected function render() {
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post'); 
?>
    <section class="contact_form_box_all">
        <div class="contact_form_shortcode">
            <?php if($settings['forms_plu'] == 'wpforms'): ?>
                <?php if(!empty($settings['contact_form_url'])): ?>
                    <?php echo do_shortcode('[wpforms id="' . $settings['contact_form_url'] . '"]'); ?>
                <?php else: ?>
                    <p><?php echo esc_html('There is no contact form please create it' , 'copygen-addons'); ?></p>
                <?php endif; ?>
            <?php elseif($settings['forms_plu'] == 'contactformseven'): ?>
                <?php if(!empty($settings['contact_form_url_seven'])): ?>
                    <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_form_url_seven'] . '"]'); ?>
                <?php else: ?>
                    <p><?php echo esc_html('There is no contact form please create it' , 'copygen-addons'); ?></p>
                <?php endif; ?>
            <?php endif; ?>    
        </div>
    </section>
		<?php 
	}
}

 


