<?php
/**
 * Plugin Name: Copygen Addons
 * Plugin URI: http://demo2.steelthemes.com/
 * Description: Extra Addons For Copygen theme. 
 * Version: 1.0.2
 * Author:  Steelthemes
 * Author URI: http://steelthemes.com
 * License: GPL2+
 * Text Domain: copygen-addons
 * Domain Path: /lang/
 */
if (! defined('ABSPATH' )){
	die('-1');
}
if (!defined('COPYGEN_ADDONS_DIR')){
  define('COPYGEN_ADDONS_DIR', plugin_dir_path( __FILE__ ));
}

if (!defined('COPYGEN_ADDONS_URL')){
  define('COPYGEN_ADDONS_URL', plugin_dir_url( __FILE__ ));
}

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

require_once __DIR__ . '/vendor/autoload.php';

/**
* Main copygen Addons Class
*
* The main class that initiates and runs the plugin.
*
* @since 1.0.0
*/
final class  copygen_elementor_extension {

  /**
   * Plugin Version
   *
   * @since 1.0.0
   *
   * @var string The plugin version.
   */
  const VERSION = '1.0.0';

  /**
   * Minimum Elementor Version
   *
   * @since 1.0.0
   *
   * @var string Minimum Elementor version required to run the plugin.
   */
  const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

  /**
   * Minimum PHP Version
   *
   * @since 1.0.0
   *
   * @var string Minimum PHP version required to run the plugin.
   */
  const MINIMUM_PHP_VERSION = '7.0';

  /**
   * Instance
   *
   * @since 1.0.0
   *
   * @access private
   * @static
   *
   * @var  copygen_elementor_extension The single instance of the class.
   */
  private static $_instance = null;

  /**
   * Instance
   *
   * Ensures only one instance of the class is loaded or can be loaded.
   *
   * @since 1.0.0
   *
   * @access public
   * @static
   *
   * @return  copygen_elementor_extension An instance of the class.
   */
  public static function instance() {

      if ( is_null( self::$_instance ) ) {
    self::$_instance = new self();
      }
      return self::$_instance;

  }

  /**
   * Constructor
   *
   * @since 1.0.0
   *
   * @access public
   */
    public function __construct() {
        add_action( 'init', [ $this, 'i18n' ] );
        add_action( 'plugins_loaded', [ $this, 'on_plugins_loaded' ] );
        remove_filter( 'render_block', 'wp_render_layout_support_flag', 10, 2 );
        $this->add_copygen_extra();
        $this->update_theme_plugin();
        $this->copygen_get_shortcodes();
        add_filter( 'init', array( $this, 'enable_elementor_posttype_supports' ));
    }
  /**
    * Theme Update
    **/
    public function update_theme_plugin() {
        require_once COPYGEN_ADDONS_DIR . '/update/plugin-update-checker.php';
        $themeJsonURL = get_template_directory_uri() . '/includes/admin/plugin.json';
        $myUpdateCheckers = PucFactory::buildUpdateChecker(
        $themeJsonURL,
        __FILE__, //Full path to the main plugin file or functions.php.
        'vankine-plugin-addons'
        );
    }

    public function enable_elementor_posttype_supports() {
        $elementor_enable = get_option( 'elementor_cpt_support' );
        if ( ! $elementor_enable ) {
            $elementor_enable = array( 'page', 'post', 'product', 'header' , 'service' , 'portfolio' , 'footer' , 'mega_menu' );
            update_option( 'elementor_cpt_support', $elementor_enable );
        }  
    } 
   /**
    * Get All the wanted files
    *
    * @return void
    */
    public function add_copygen_extra(){ 
        require_once COPYGEN_ADDONS_DIR . '/includes/Plugins/Widgets/recent-post.php';
        require_once COPYGEN_ADDONS_DIR . '/includes/Plugins/Widgets/about-us.php';
        require_once COPYGEN_ADDONS_DIR . '/includes/blog-options.php'; 
        require_once COPYGEN_ADDONS_DIR . '/includes/logins.php'; 
        if (!class_exists('Redux' )){
            require_once COPYGEN_ADDONS_DIR . 'redux-framework/redux-framework.php';
            require_once COPYGEN_ADDONS_DIR . 'metabox/metaboxes.php';
        }
        add_action('elementor/editor/before_enqueue_scripts', function() {
            wp_enqueue_style('copygen-widgets-css', COPYGEN_ADDONS_URL . 'assets/css/elementor-steel.css', array() , '1.0.0', 'all'); 
        });
    }
    public function on_plugins_loaded(){
        new Copygenaddons\Startcopygen();
        new Copygenaddons\Admin();
        if ($this->is_compatible()) {
            add_action('elementor/init', [$this, 'init']);
        }
    }
/*
** ============================== 
**   get_shortcodes
** ==============================
*/ 
public function copygen_get_shortcodes() {
    /*
    ** ============================== 
    **  copygen_navmenu
    ** ==============================
    */ 
    if (!function_exists('copygen_navmenu')) {
        function copygen_navmenu() {
            $options = array();
            $nvmenus = wp_get_nav_menus();
                if (!empty($nvmenus)) {
                    foreach ($nvmenus as $navigationmenu) {
                        if (isset($navigationmenu)) {
                            $options[''] = 'Select';
                            if (isset($navigationmenu->slug) && isset($navigationmenu->name)) {
                                $options[$navigationmenu->slug] = $navigationmenu->name;
                            }
                        }
                    }
                }
            
            return $options;
        }
    }
    
    /*
    ** ============================== 
    **   copygen_get_icons
    ** ==============================
    */ 
    if(!function_exists('copygen_get_icons')) {
       
        function copygen_get_icons() {
            // scrape list of icons from fontawesome css
            $pattern_one = '/\.((?:\w+(?:-)?)+):before\s*{\s*content/';
            $file_get = file_get_contents(get_template_directory() . '/assets/css/plugins/font-awesome.min.css');
            preg_match_all($pattern_one, $file_get, $matche_one, PREG_SET_ORDER);
            $icon_one = array(); 
            //fontawesome
            foreach ($matche_one as $match_get_one) {
                $icon_one[] = array('value' => ' '.$match_get_one[1], 'label' => $match_get_one[1]);
            }
            $pattern_two = '/\.((?:\w+(?:-)?)+):before\s*{\s*content/';
            $file_get_two = file_get_contents(get_template_directory() . '/assets/fonts/copygen/style.css');
            preg_match_all($pattern_two, $file_get_two, $matches_two, PREG_SET_ORDER);
            foreach ($matches_two as $match_get_two) {
                $icon_one[] = array('value' => ' '.$match_get_two[1], 'label' => $match_get_two[1]);
            }
            $icons_get = array_column($icon_one, 'label', 'value');
            //print_r($icons); exit('hellow');
            return $icons_get;
        }
    
    }
 
    /*
    ** ============================== 
    **   copygen_contact_form_7_query
    ** ==============================
    */ 
    if (!function_exists('copygen_contact_form_7_query')):
        function copygen_contact_form_7_query($post_type){
        $post_list = get_posts(array(
            'post_type' => $post_type,
            'showposts' => -1,
        ));
        $posts = array();
            if (!empty($post_list) && !is_wp_error($post_list)) {
                foreach ($post_list as $post) {
                    $options[$post->ID] = $post->post_title;
            }
            return $options;
        }
    }
    endif;
    /*
    ** ============================== 
    **   copygen_contact_form_7_query
    ** ==============================
    */ 
    if (!function_exists('copygen_product_query')):
        function copygen_product_query(){
        $post_list = get_posts(array(
            'post_type' => 'product',
            'showposts' => -1,
        ));
        $posts = array();
            if (!empty($post_list) && !is_wp_error($post_list)) {
                foreach ($post_list as $post) {
                    $options[$post->ID] = $post->post_title;
            }
            return $options;
        }
    }
    endif;
    
    /*
    ** ============================== 
    ** copygen_get_product_categories
    ** ============================== 
    */
    
    
    function copygen_get_product_categories() {
        $options = array();
        $taxonomy = 'product_cat';
        if (!empty($taxonomy)) {
            $terms = get_terms(
                array(
                    'parent' => 0,
                    'taxonomy' => $taxonomy,
                    'hide_empty' => false,
                    )
                );
                if (!empty($terms)) {
                    foreach ($terms as $term) {
                        if (isset($term)) {
                            $options[''] = 'Select';
                            if (isset($term->slug) && isset($term->name)) {
                                $options[$term->slug] = $term->name;
                            }
                        }
                    }
                }
            }
        return $options;
    }
    /*
    ** ============================== 
    ** copygen_get_blog_categories
    ** ============================== 
    */
    function copygen_get_blog_categories() {
        $options = array();
        $taxonomy = 'category_name';
        if (!empty($taxonomy)) {
            $terms = get_terms(
                array(
                    'parent' => 0,
                    'taxonomy' => $taxonomy,
                    'hide_empty' => false,
                    )
                );
                if (!empty($terms)) {
                    foreach ($terms as $term) {
                        if (isset($term)) {
                            $options[''] = 'Select';
                            if (isset($term->slug) && isset($term->name)) {
                                $options[$term->slug] = $term->name;
                            }
                        }
                    }
                }
            }
        return $options;
    }

    /*
    ** ============================== 
    ** copygen_get_service_categories
    ** ============================== 
    */
    function copygen_get_service_categories() {
        $options = array();
        $taxonomy = 'service_category';
        if (!empty($taxonomy)) {
            $terms = get_terms(
                array(
                    'parent' => 0,
                    'taxonomy' => $taxonomy,
                    'hide_empty' => false,
                    )
                );
                if (!empty($terms)) {
                    foreach ($terms as $term) {
                        if (isset($term)) {
                            $options[''] = 'Select';
                            if (isset($term->slug) && isset($term->name)) {
                                $options[$term->slug] = $term->name;
                            }
                        }
                    }
                }
            }
        return $options;
    }
}


  /**
   * Load Textdomain
   *
   * Load plugin localization files.
   *
   * Fired by `init` action hook.
   *
   * @since 1.0.0
   *
   * @access public
   */
  public function i18n() {
   load_theme_textdomain( 'copygen-addons', get_template_directory() . '/lang' );
  }

  /**
     * Compatibility Checks
     *
     * Checks if the installed version of Elementor meets the plugin's minimum requirement.
     * Checks if the installed PHP version meets the plugin's minimum requirement.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function is_compatible()
    {

         // Check if Elementor installed and activated
      if ( ! did_action( 'elementor/loaded' ) ) {
          add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
          return;
      }

      // Check for required Elementor version
      if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
          add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
          return;
      }

      // Check for required PHP version
      if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
          add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
          return;
      }

        return true;
    }

  /**
   * Initialize the plugin
   *
   * Load the plugin only after Elementor (and other plugins) are loaded.
   * Checks for basic plugin requirements, if one check fail don't continue,
   * if all check have passed load the files required to run the plugin.
   *
   * Fired by `plugins_loaded` action hook.
   *
   * @since 1.0.0
   *
   * @access public
   */
  public function init() {

        $this->i18n();

  // Register widgets

  add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
 
   
  }

  /**
   * Admin notice
   *
   * Warning when the site doesn't have Elementor installed or activated.
   *
   * @since 1.0.0
   *
   * @access public
   */
  public function admin_notice_missing_main_plugin() {

      if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

      $message = sprintf(
          /* translators: 1: Plugin name 2: Elementor */
          esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'copygen-addons' ),
          '<strong>' . esc_html__( 'copygen Addons', 'copygen-addons' ) . '</strong>',
          '<strong>' . esc_html__( 'Elementor', 'copygen-addons' ) . '</strong>'
      );

      printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

  }

  /**
   * Admin notice
   *
   * Warning when the site doesn't have a minimum required Elementor version.
   *
   * @since 1.0.0
   *
   * @access public
   */
  public function admin_notice_minimum_elementor_version() {

      if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

      $message = sprintf(
          /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
          esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'copygen-addons' ),
          '<strong>' . esc_html__( 'copygen-addons', 'copygen-addons' ) . '</strong>',
          '<strong>' . esc_html__( 'Elementor', 'copygen-addons' ) . '</strong>',
           self::MINIMUM_ELEMENTOR_VERSION
      );

      printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

  }

  /**
   * Admin notice
   *
   * Warning when the site doesn't have a minimum required PHP version.
   *
   * @since 1.0.0
   *
   * @access public
   */
  public function admin_notice_minimum_php_version() {

      if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

      $message = sprintf(
          /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
          esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'copygen-addons' ),
          '<strong>' . esc_html__( 'copygen Addons', 'copygen-addons' ) . '</strong>',
          '<strong>' . esc_html__( 'PHP', 'copygen-addons' ) . '</strong>',
           self::MINIMUM_PHP_VERSION
      );

      printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    /**
     * Include Files
     *
     * Load required plugin core files.
     *
     * @since 1.0.0
     * 
     * @access public
    */
    public function register_widgets() {
        $widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
        //header
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Header\Logo()); 
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Header\Menu_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Header\Extra_items_btn_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Header\Contact_header_v1()); 
        //Content
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Title_v1()); 
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Text_editor());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\List_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Theme_btn_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Icon_box());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Fun_facts_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Tab_with_content_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Image_box_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Image_move_v1()); 
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Feature_card_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Faqs_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Process_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Price_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Price_tab_v1());  
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Testimonial_v1());
        //$widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Progress_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Team_box_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Contact_box_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Contact_form_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Video_btn());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Mcforwp_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Login());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Content\Sidebar_v1());
        //post
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Post\Blog_v1());
        //Footer
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Footer\Foo_gallery_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Footer\Foo_post_v1());
        $widgets_manager->register(new  Copygenaddons\Core\Widgets\Footer\Foo_contact_v1());   
    }
}

copygen_elementor_extension::instance();

