<?php
/*
** ============================== 
**   copygen Header File
** ==============================
*/
global $copygen_theme_mod;
$fnotf_styles = isset( $copygen_theme_mod['fnotf_styles'] ) ? $copygen_theme_mod['fnotf_styles'] : '';
$header_sticky = isset( $copygen_theme_mod['header_sticky'] ) ? $copygen_theme_mod['header_sticky'] : '';

if(is_page_template( 'template-empty.php' ) || is_singular('header')  || is_singular('footer')  || is_singular('mega_menu') || $fnotf_styles == 'style_two' || copygen_get_fnotf_url() == 'style_two'):
    return false;
endif;

$header_id = '';
if(!empty($copygen_theme_mod['header_custom_style'])):
    $header_id = $copygen_theme_mod['header_custom_style'];
endif;
if(get_post_meta(get_the_ID() , 'custom_header', true)):
    $header_id = get_post_meta(get_the_ID() , 'header_settings_meta', true);
endif;

$header_custom_enables = '';
if(!empty($copygen_theme_mod['header_custom_enables'])):
$header_custom_enables = $copygen_theme_mod['header_custom_enables'];
endif;

function  copygen_default_header(){
    $blog_title = get_bloginfo('name');
    ?>
<header class="default_header">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-3 col-lg-3 col-md-8 col-sm-8 col-xs-8 logo_col">
                <div class="logo_box">
                    <a href="<?php  echo esc_url(home_url()); ?>" class="logo text">
                    <?php echo esc_attr($blog_title); ?>
                        <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
                    </a>
                </div>
            </div>
            <div class="col-xl-9 col-lg-9 col-md-4 col-sm-4 col-xs-4 men_col">
                    <div class="navbar_togglers hamburger_menu">
                        <span class="line"></span>
                        <span class="line"></span>
                        <span class="line"></span>
                    </div>
                <div class="navbar_content">
                    <?php wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'container' => false,
                        'menu_class' => 'navbar_nav',
                        'fallback_cb'    => 'copygen_navwalker::fallback',
                        'walker' => new \copygen_navwalker()
                    ));?>
                </div>
            </div>
        </div>
    </div>
</header>
<?php  } ?>
<?php if($header_custom_enables == false): ?>
       <?php copygen_default_header(); ?>
<?php else: ?>
<div class="header_area" id="header_contents">
<?php do_action('copygen_header'); ?>
</div>
<?php if($header_sticky == true): ?>
<div class="sticky_header_area sticky_header_content">
<?php do_action('copygen_sticky_header'); ?> 
</div>
<?php endif; ?>
<?php endif; ?>
 
 