<?php
/*
**============================== 
**  Copygen Single Page Content
**==============================
*/
global $copygen_theme_mod;
$breadcrumb_enable = isset( $copygen_theme_mod['breadcrumb_enable'] ) ? $copygen_theme_mod['breadcrumb_enable'] : '';
$extra_class = 'blog_single_content style_two row';
$post_sub_title = get_post_meta(get_the_ID() , 'page_header_title', true);
$allowed_tags = wp_kses_allowed_html('post');
$share_disable = isset( $copygen_theme_mod['share_disable'] ) ? $copygen_theme_mod['share_disable'] : '';
$column = 'col-lg-12';
if($share_disable == true):
   $column = 'col-lg-11 col-sm-11 col-xs-11';
endif;
?>
<section id="post-<?php esc_attr(the_ID()); ?>" <?php esc_attr(post_class($extra_class)); ?>>
    <div class="single_content_upper col-lg-9 m-auto">
        <div class="up_box">
            <div class="m_box">
                <?php do_action('copygen_theme_blog_category'); ?>
                <?php the_title( '<div class="title_28"  data-splitting><a href="' .  esc_url(get_permalink()) . '" rel="bookmark">', '</a></div>' ); ?>
            </div>
            <?php if(!empty($post_sub_title)): ?>
            <h1 class="sub_title_meta"><?php echo wp_kses($post_sub_title , $allowed_tags); ?></h1>
            <?php endif; ?>
            <ul class="nk-list-meta smaller">
                <li><?php do_action('copygen_theme_blog_time'); ?></li>
                <li><?php do_action('copygen_theme_blog_comments'); ?></li>
            </ul>
            <?php if($breadcrumb_enable == true): ?>
            <?php do_action('copygen_custom_breadcrumb'); ?>
            <?php endif; ?>
        </div>
        <?php if(has_post_thumbnail()): ?>
        <div class="single-thumbnail">
            <?php the_post_thumbnail(array(770,400)); ?>
        </div>
        <?php endif;?>
        <div class="post_single_content">
            <div class="row">
                <div class="<?php echo esc_attr($column); ?>">
                <?php the_content(); ?>
                    <div class="clearfix"></div>
                    <?php wp_link_pages(); ?>
                </div>
                <?php if($share_disable == true): ?>
                <div class="col-lg-1 col-sm-1 col-xs-1">
                    <?php do_action('copygen_theme_blog_share'); ?>
                </div>
                <?php endif;?>
                </div>
                </div>
                <div class="single_content_lower">
                    <?php do_action('copygen_theme_blog_tags_and_cat');?>
                    <?php if(!class_exists('copygen_elementor_extension')): do_action('copygen_theme_blog_tags_and_catbefore'); endif;?>
                    <?php if(!empty($copygen_theme_mod['authour_detail_disable']) == true): ?>
                    <?php do_action('copygen_theme_authour_details'); ?>
                    <?php endif;?>
                    <?php if(!empty($copygen_theme_mod['next_prev_enable']) == true):
       do_action('copygen_custom_pagination_width_img'); 
    endif;?>
                    <?php // If comments are open or we have at least one comment, load up the comment template
	    if(comments_open() || get_comments_number()):
		    comments_template();
	    endif;
	  ?>
                </div>
            </div>
            <div class="col-gl-12">
    <?php do_action('get_copygen_related_post'); ?>
</div>
</section>
