<?php
/*
**==============================   
** copygen Blog
**==============================
*/
add_action('copygen_theme_blog_comments', 'copygen_comments');
add_action('copygen_theme_blog_time', 'copygen_blog_time');
add_action('copygen_theme_blog_category', 'copygen_blog_category');
add_action('copygen_theme_blog_tags_and_cat', 'copygen_tags_and_cat');
add_action('copygen_theme_blog_tags_and_catbefore', 'copygen_tags_and_cat_before_intsll_pg');
add_action('copygen_after_blogsetup_comment_timing', 'copygen_comment_timing');
/*
**=========================================
**copygen get-comments
**=========================================
*/
function copygen_comments(){
    global $post;
?>
<small class="comments">
    <?php echo comments_popup_link( 
        esc_html__( 'Post a Comment', 'copygen' ), 
        esc_html__( '1 Comment', 'copygen' ), 
        esc_html__( '% Comments', 'copygen' ),
        esc_html__( 'Comments are Closed', 'copygen' )
    ); 
?>
</small>
<?php   
}   
/*
**==============================   
** copygen copygen_blog_time
**==============================
*/
function copygen_blog_time(){
    $time_string = '<time class="date published updated" datetime="%1$s">%2$s</time>';
    if(get_the_time('U') !== get_the_modified_time('U')):
        $time_string = '<time class="date published" datetime="%1$s">%2$s</time>';
    endif;    
    $time_string = sprintf($time_string, esc_attr(get_the_date('c')) , esc_html(get_the_date(get_option('date_format'))));
    $posted_on = '<span class="date_tm">' . $time_string . '</span>';
    echo '' . $posted_on . '';
}   
/*
**===================================
**copygen copygen_blog_category
**===================================
*/
function copygen_blog_category(){
$categories = get_the_category();
    if(!empty($categories)) {
        echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '" class="cat_gry">' . esc_html( $categories[0]->name ) . '</a>';
    }
}   

/*
**==================================
**copygen tag category
** =================================
*/
function copygen_tags_and_cat(){
    global $copygen_theme_mod;
    $get_the_categorys = get_the_category();
    $tag_outputs = get_the_tags();
if((!empty($copygen_theme_mod['tag_disable']) == true) || (!empty($copygen_theme_mod['category_enable']) == true)): ?>
<div
    class="tags_and_cat<?php if((!empty($tag_outputs)) && (!empty($copygen_theme_mod['tag_disable']) == true)):?> yes_tags<?php endif; ?> <?php  if((!empty($get_the_categorys)) && (!empty($copygen_theme_mod['category_enable']) == true)):?>yes_share<?php endif; ?>">
    <div class="d-flex">
        <?php  if(!empty($copygen_theme_mod['tag_disable']) == true): ?>
            <?php if(!empty($tag_outputs)): ?>
        <div class="left_one d-flex">
            <div class="title"><?php echo esc_html__('Tags' , 'copygen'); ?></div>
            <?php foreach ($tag_outputs as $tag_output):?>
            <a class="tags" href="<?php echo get_term_link($tag_output); ?>"><?php echo esc_html('#' , 'copygen');?>
                <?php echo esc_attr($tag_output->name); ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php if(!empty($copygen_theme_mod['category_enable']) == true): ?>
        <?php if(!empty($get_the_categorys)): ?>
        <div class="right_one d-flex">
            <div class="title"><?php echo esc_html__('Posted in' , 'copygen'); ?></div>
            <?php foreach ($get_the_categorys as $get_the_category):?>
            <a class="cats"
                href="<?php echo get_term_link($get_the_category); ?>">
                <?php echo esc_attr($get_the_category->name); ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
<?php 
}   

/*
**==================================
**copygen tag cat before
** =================================
*/
function copygen_tags_and_cat_before_intsll_pg(){
$get_the_categorys = get_the_category();
$tag_outputs = get_the_tags(); ?>
<div
    class="tags_and_cat<?php if(!empty($tag_outputs)):?> yes_tags<?php endif; ?> <?php  if(!empty($get_the_categorys)):?>yes_share<?php endif; ?>">
    <div class="d-flex">
    <?php if(!empty($tag_outputs)): ?>
        <div class="left_one d-flex">
            <div class="title"><?php echo esc_html__('Tags' , 'copygen'); ?></div>
            <?php foreach ($tag_outputs as $tag_output):?>
            <a class="tags" href="<?php echo get_term_link($tag_output); ?>"><?php echo esc_html('#' , 'copygen');?>
                <?php echo esc_attr($tag_output->name); ?></a>
            <?php endforeach; ?>
        </div>
    
        <?php endif; ?>
 
        <?php if(!empty($get_the_categorys)): ?>
        <div class="right_one d-flex">
            <div class="title"><?php echo esc_html__('Posted in' , 'copygen'); ?></div>
            <?php foreach ($get_the_categorys as $get_the_category):?>
            <a class="cats"
                href="<?php echo get_term_link($get_the_category); ?>">
                <?php echo esc_attr($get_the_category->name); ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php 
}  
/*
**================================   
**copygen Comment Timing
**================================
*/
function copygen_comment_timing() { 
    ?>
    <?php
    $comment_date = get_comment_time('U');
    $dayscommnet = round((date('U') - get_comment_time('U')) / (60*60*24));
    $deltacomment = time() - $comment_date;
    if($deltacomment < 60):
        echo esc_html('Less than a minute ago' , 'creote');
    elseif($deltacomment > 60 && $deltacomment < 120):
        echo esc_html('About a minute ago' , 'creote');
    elseif($deltacomment > 120 && $deltacomment < (60*60)):
        echo strval(round(($deltacomment/60),0)), ' minutes ago';
    elseif($deltacomment > (60*60) && $deltacomment < (120*60)):
        echo esc_html('About an hour ago' , 'creote');
    elseif($deltacomment > (120*60) && $deltacomment < (24*60*60)):
        echo strval(round(($deltacomment/3600),0)), ' hours ago';
    else:
        echo  get_comment_date();
    endif;
}  
 
/*
**================================   
**copygen Single get by url
**================================
*/
add_action('get_copygen_single_pgb' , 'copygen_backgroun_pg_for_single_style_two');
function copygen_backgroun_pg_for_single_style_two() { 
    global $copygen_theme_mod;
    $pg_headerimage_for_style_two = isset( $copygen_theme_mod['pg_headerimage_for_style_two']['url'] ) ? $copygen_theme_mod['pg_headerimage_for_style_two']['url'] : '';
    if(!empty($pg_headerimage_for_style_two)):
        $pg_headerimage_for_style_two = $pg_headerimage_for_style_two;
    else:
        $pg_headerimage_for_style_two = get_template_directory_uri() . '/assets/images/dot-a.png';
    endif; 
    ?>
    <div class="pageheader_bg_for_single_style_two">
    <?php if(!empty($pg_headerimage_for_style_two)): ?><div class="pgsinner"style="background-image:url(<?php echo esc_attr($pg_headerimage_for_style_two); ?>);"></div><?php endif; ?>
    </div>
    <?php 
}