<?php
/*
** ============================== 
**  copygen Theme main file
** ==============================
*/
add_action('wp_enqueue_scripts', 'copygen_enqueue_scripts_before_install_plugin');
add_action('admin_enqueue_scripts', 'copygen_cat_meta_postbox_css');
add_action('after_setup_theme',  'copygen_setup');
add_action('widgets_init',   'copygen_register_sidebar');
/*
========================
includeslude  file
========================
*/
//WP Bootstrap Navwalke
require_once get_template_directory() . '/includes/lib/Copygen_navwalker.php';

//plugin activation
require_once get_template_directory() . '/includes/admin/admin.php';
require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';
require_once get_template_directory() . '/includes/lib/pluginarrays.php';
require_once get_template_directory() . '/includes/functions/functions.php';
//Redux
if(class_exists('Redux')){
    require_once get_template_directory() . '/includes/admin/options/config.php';
    require_once get_template_directory() . '/includes/admin/options/inline-functions.php';
    require_once get_template_directory() . '/includes/admin/options/typography-css.php';
}
//Theme Custom Extension
require_once get_template_directory() . '/includes/functions/header-source.php';
require_once get_template_directory() . '/includes/functions/layout.php';
require_once get_template_directory() . '/includes/functions/classes.php';
require_once get_template_directory() . '/includes/functions/extra/breadcrumbs.php';
require_once get_template_directory() . '/includes/functions/extra/comments.php';
require_once get_template_directory() . '/includes/functions/extra/nav.php';
require_once get_template_directory() . '/template-parts/page-header/default-page-header.php';
require_once get_template_directory() . '/template-parts/page-header/page-header.php';
require_once get_template_directory() . '/template-parts/blog-functions.php';
// Header
require_once get_template_directory() . '/template-parts/headers/mobile-menu.php';
require_once get_template_directory() . '/template-parts/headers/option-panel.php';
//OCDI_Plugin
if(class_exists('OCDI_Plugin')){
    require get_template_directory() . '/includes/demo-content/demo-content.php';  
}
/*
==========================================
Metabox admin styles
==========================================
*/
function copygen_cat_meta_postbox_css(){
    wp_enqueue_style('meta-box-css', get_template_directory_uri().'/assets/css/metabox.css' );
} 
/*
==========================================
Font Loading
==========================================
*/
function copygen_fonts_url() {
    $font_url = '';
    
    /* Translators: If there are characters in your language that are not
    * supported by Open Sans, translate this to 'off'. Do not translate
    * into your own language.
    *
    *$Roboto = _x( 'on', 'Roboto font: on or off', 'copygen' );
    */
    $SplineSans = _x( 'on', 'Spline font: on or off', 'copygen' );
    if ('off' !== $SplineSans) {
        $font_families = array();
      
        $font_families = array();
        if ( 'off' !== $SplineSans ) {
            $font_families[] = 'Spline Sans:300,400,500,700'; 
        }
        
    $query_args = array(
        'family' => urlencode( implode( '|', $font_families ) ),
        'subset' => urlencode( 'latin,latin-ext' ),
    );
    $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
    return esc_url_raw( $fonts_url );
}
/*
** ============================== 
** Register and enqueue styles
** ============================== 
*/
function copygen_enqueue_scripts_before_install_plugin(){
    global $copygen_theme_mod;
    $dark_color_enable = isset( $copygen_theme_mod['dark_color_enable'] ) ? $copygen_theme_mod['dark_color_enable'] : ''; 
    if($dark_color_enable == true): 
        wp_enqueue_style('copygen-variable-dark', get_template_directory_uri() . '/assets/css/theme-css/variables-dark.css' , array() , time() , 'all');   
    else:
        wp_enqueue_style('copygen-variable', get_template_directory_uri() . '/assets/css/theme-css/variables.css' , array() , time() , 'all');  
    endif;
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.min.css', array() , '5.0.0', 'all');
    wp_enqueue_style('copygen-style', get_template_directory_uri() .'/style.css' , array() , time() , 'all');  
    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/plugins/font-awesome.min.css', array() , '1.0.0', 'all');
    wp_enqueue_style('copygenicons', get_template_directory_uri() . '/assets/fonts/copygen/style.css', array() , '1.0.0', 'all');
    wp_enqueue_style('copygen-fonts', copygen_fonts_url(), array(), null );
    wp_enqueue_style('copygen-meta-box', get_template_directory_uri() . '/assets/css/metabox.css' , array() , '1.0.0' , 'all');
    wp_enqueue_style('copygen-main-style', get_template_directory_uri() . '/assets/css/theme.css' , array() , time() , 'all');  
    wp_enqueue_script('bootstrap-bundle', get_template_directory_uri() . '/assets/js/plugins/bootstrap.bundle.min.js', array('jquery') , '5.0.0', true);
    wp_enqueue_script('copygen-theme', get_template_directory_uri() . '/assets/js/theme.js', array('jquery') , '1.0.0', true);
    if(is_singular() && comments_open() && get_option('thread_comments')):
        wp_enqueue_script('comment-reply');
    endif;
}  
/*
==========================================
add_theme_support
==========================================
*/
function copygen_setup(){
if(!isset($content_width))
    $content_width = 840;
/*---------- Make theme available for translation-----------*/
    load_theme_textdomain('copygen', get_template_directory() . '/lang');
/*----------Add Theme Support-----------*/
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array(
        'search-form'
    ));
    add_theme_support('title-tag');
    add_theme_support('post_format', ['aside', 'gallery', 'link', 'image', 'quote', 'status', 'video', 'audio', 'chat']);
    add_theme_support('automatic-feed-links');
/*----------woocommerce Theme Support-----------*/ 
    add_theme_support( 'woocommerce');
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
/*----------editor-style-----------*/
    add_editor_style('assets/css/editor-style.css');
/*----------register_nav_menus-----------*/
    register_nav_menus(array(
        'primary' => esc_html__('Primary Menu', 'copygen') , 
    ));
}
add_action('init', 'copygen_disable_elementor_onboarding_redirect');

function copygen_disable_elementor_onboarding_redirect() {
    delete_transient( 'elementor_activation_redirect' );
}


/*
==========================================
Register widgetized area and update sidebar with default widgets.
==========================================
*/
function copygen_register_sidebar(){
$sidebars = array(
'sidebar-blog' => esc_html__('Blog Sidebar', 'copygen') ,
'page-sidebar' => esc_html__('Page Sidebar', 'copygen') , 
);
// Register sidebars
foreach ($sidebars as $id => $name){
register_sidebar(
    array(
        'name' => $name,
        'id' => $id,
        'description' => esc_html__('Add widgets here in order to display on pages', 'copygen') ,
        'before_widget' => '<div class="sidebar-widget mb-50"><div id="%1$s" class="widget widget_box  %2$s">',
        'after_widget' => '</div> </div>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));
}
} 
 