<?php
/*
** ============================== 
** copygen Layout
** ==============================
*/
/*
======================================
Display page header
======================================
*/
if(!function_exists('copygen_has_page_header')):
/*
** Check ifcurrent page has page header
** @return bool && get_post_meta(get_the_ID() , 'page_header_enable_disable', true))
*/
function copygen_has_page_header(){
     global $copygen_theme_mod;
     $page_header_options = '';
     if(!empty($copygen_theme_mod['page_header_enable'])):
        $page_header_options =  $copygen_theme_mod['page_header_enable'];
     endif;
        if((is_page()  || is_singular(array('project' , 'service' , 'post' , 'product'))) && get_post_meta(get_the_ID() , 'page_header_enable_disable', true)):
            return false;
        elseif(is_singular('mega_menu')):
            return false;
        elseif(is_singular('header')):
            return false;
        elseif(is_singular('sticky_header')):
            return false;
        elseif(is_singular('footer')):
            return false;
        elseif(is_page_template('template-homepage.php')):
            return false;
        elseif(is_page_template('template-blog.php')):
            return false;
        elseif(is_attachment()):
            return false;
        endif;
        return $page_header_options;
    }
endif;
/*
======================================
Display page header Image
======================================
*/
if(!function_exists('copygen_get_page_header_image')):
    /**
    * Get page header image URL
    * @return string
    */
    function copygen_get_page_header_image(){   
         global $copygen_theme_mod;
            if(!copygen_has_page_header()){
                return '';
            }
            if((is_page()  || is_singular(array('post' , 'service' , 'portfolio' , 'product')) || is_post_type_archive('product') || is_tax() || is_tag() || is_day() || is_year() || is_month()  || is_tax( 'product_cat') || is_category())){
                $page_header_bgimages = '';
                if(!empty($copygen_theme_mod['page_header_bg_image']['url'])):
                    $page_header_bgimages = $copygen_theme_mod['page_header_bg_image']['url'];
                endif;
                if(get_post_meta(get_the_ID() , 'page_header_bg_image_showss', true) == true){
                    $page_pg_image = get_post_meta(get_the_ID() , 'page_header_bgimage', true);
                    $page_header_bgimages =  $page_pg_image['url'];
                }
            if(!empty($page_header_bgimages)):
            ?>
            <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_bgimages); ?>)"> 
          
            </div>
            <?php else: ?>
                <?php $page_header_bgimages = get_template_directory_uri() . '/assets/images/dot-a.png'; ?>
  <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_bgimages); ?>)"> </div>
            <?php
        endif;  
    } 
    else{
        $page_header_blog = '';
        if(!empty($copygen_theme_mod['blog_page_header_bg_image']['url'])):
            $page_header_blog = $copygen_theme_mod['blog_page_header_bg_image']['url'];
        endif;
        if(!empty($page_header_blog)):
        ?>
        <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_blog); ?>)"> 
        </div>
        <?php else: ?>
                <?php $page_header_bgimages = get_template_directory_uri() . '/assets/images/dot-a.png'; ?>
  <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_bgimages); ?>)"> </div>
    <?php endif;   
    }  
}
endif;
/*
======================================
Display Columns
======================================
*/
if(!function_exists('copygen_get_layout')):
/*
**Get Column base on current page
** @return string
*/
function copygen_get_layout(){
    global $copygen_theme_mod;
    global $post;
    $copygen_layout = 'right-sidebar';
    $page_layouts = 'right-sidebar';
    $service_layouts = 'right-sidebar';
    if(!empty($copygen_theme_mod['default_layouts'])):
        $copygen_layout = $copygen_theme_mod['default_layouts'];
    endif;
    if(!empty($copygen_theme_mod['page_layouts'])):
        $page_layouts =  $copygen_theme_mod['page_layouts'];
    endif;
    if(!empty($copygen_theme_mod['service_layouts'])):
        $service_layouts =  $copygen_theme_mod['service_layouts'];
    endif;

    if(is_singular() && get_post_meta(get_the_ID() , 'custom_layout', true)):
        $copygen_layout = get_post_meta(get_the_ID() , 'layout', true);
    elseif(is_page()):
        $copygen_layout =   $page_layouts;
    elseif(is_404()):
        $copygen_layout = 'no-sidebar';
    elseif(is_tax('service_category')  || is_singular('service')):
        $copygen_layout =  $service_layouts;
 
    elseif(is_tax('portfolio_category')  || is_singular('portfolio')):
        $copygen_layout = 'no-sidebar';
    elseif(is_singular('mega_menu')):
        $copygen_layout = 'no-sidebar';
    elseif(is_singular('header')):
        $copygen_layout = 'no-sidebar';
    elseif(is_singular('sticky_header')):
        $copygen_layout = 'no-sidebar';
    elseif(is_singular('footer')):
        $copygen_layout = 'no-sidebar';
    endif;
return $copygen_layout;
}
endif;
/*
======================================
Display Columns
======================================
*/
if(!function_exists('copygen_get_content_columns')):
/*
**Get CSS classes for content columns output
**@param string $layout
**@return array
*/
function copygen_get_content_columns($copygen_layout = null){
    $copygen_layout = $copygen_layout ? $copygen_layout : copygen_get_layout();
    if('no-sidebar' == $copygen_layout):
        echo 'no_column';
    else:
        echo 'col-lg-9 col-md-12 col-sm-12 col-xs-12';
    endif;  
   }
endif;

if(!function_exists('copygen_column_for_page')):
    function copygen_column_for_page(){
        if(is_active_sidebar('page-sidebar')):
            copygen_get_content_columns();
        elseif(!is_active_sidebar('page-sidebar')):
            echo esc_html('no_column no_sidebar', 'copygen');
        endif;
    }
endif;

if(!function_exists('copygen_column_for_service')):
    function copygen_column_for_service(){
        if(is_active_sidebar('service-sidebar')):
            copygen_get_content_columns();
        elseif(!is_active_sidebar('service-sidebar')):
            echo esc_html('no_column no_sidebar', 'copygen');
        endif;
    }
endif;



if(!function_exists('copygen_column_for_blog')):
    function copygen_column_for_blog(){
        if(is_active_sidebar('sidebar-blog')):
            copygen_get_content_columns();
        elseif(!is_active_sidebar('sidebar-blog')):
            echo esc_html('no_column', 'copygen');
        endif;
    }
endif;
   
if (!function_exists('copygen_column_for_shop')):
    function copygen_column_for_shop(){
        if(is_active_sidebar('shop-sidebar')):
            copygen_get_content_columns();
        elseif(!is_active_sidebar('shop-sidebar')):
            echo esc_html('no_column no_sidebar', 'copygen');
        endif;
    }
endif;