<?php
/*
** ============================== 
** copygen Header Source File
** ==============================
*/
add_action('copygen_custom_search_setup',  'copygen_simple_search'); 
add_filter('get_the_archive_title', 'copygen_the_archive_title'); 
/*
** ==============================  
**  copygen_the_archive_title
** ============================== 
*/
function copygen_the_archive_title($title){
if(is_search()):
    $title = sprintf(esc_html__('Search Results', 'copygen'));
    elseif(is_404()):
        $title = sprintf(esc_html__('Page Not Found', 'copygen'));
    elseif(is_page()):
        $title = get_the_title();
    elseif(is_single()):
        $title = get_the_title();
    elseif (is_home() && is_front_page()):
        $title = esc_html__('The Latest Posts', 'copygen');
    elseif (is_home() && !is_front_page()):
        $title = get_the_title(get_option('page_for_posts'));
    elseif(is_singular('product')):
        $title = get_the_title(get_the_ID());
    elseif(is_tax() || is_category()  || is_tag()):
        $title = single_term_title('', false);
    elseif(is_singular('post')):
        $title = get_the_title(get_the_ID());
    elseif(function_exists( 'dokan_is_store_page' ) && dokan_is_store_page()):
        $store_user = wcfmmp_get_store( get_query_var( 'author' ) );
        $store_info = $store_user->get_shop_info();
        $title = $store_info['store_name'];
    elseif(function_exists( 'wcfm_is_store_page' ) && wcfm_is_store_page()):
        $store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
        $title = $store_user->get_shop_name();
    elseif(is_post_type_archive('service')):
        $services_page_id = get_option('st_services_page_id');
        if($services_page_id && get_post($services_page_id)):
            $title = get_the_title($services_page_id);
        else:
            $title = esc_html__('Service',  'copygen');
        endif;
    elseif(is_post_type_archive('product')):
        $product_page_id = get_option('st_product_page_id');
        if($product_page_id && get_post($product_page_id)):
            $title = get_the_title($product_page_id);
        else:
            $title = esc_html__('Product',  'copygen');
    endif;
endif;
return $title;
}
/*
** ============================== 
**  Simple Serch
** ============================== 
*/
function copygen_simple_search() { ?>
<form role="search" method="get" class="simple_search" action="<?php echo esc_url(home_url( '/' )); ?>">
<i class="copy-search"></i>
    <input type="search" class="search" placeholder="<?php echo esc_attr__( 'Search...', 'copygen' ); ?>"
        value="<?php echo get_search_query() ?>" name="s" title="Search" />
    <button type="submit" class="sch_btn"><?php echo esc_attr__('Search' , 'copygen'); ?></button>
</form> 
<?php 
} 

/*
**================================   
**copygen Single get by url
**================================
*/
function copygen_get_single_url() { 
    $copygen_single  = isset( $_GET['singles'] ) ? $_GET['singles'] : '';
	if($copygen_single){
		return $copygen_single;
	}
}

/*
**================================   
**copygen Single get by url
**================================
*/
function copygen_get_fnotf_url() { 
    $copygen_fournotfour  = isset( $_GET['fournotfour'] ) ? $_GET['fournotfour'] : '';
	if($copygen_fournotfour){
		return $copygen_fournotfour;
	}
}
/**
 * Get Elementor builder content for display.
 *
 * @param int $post_id Post ID of the Elementor builder content.
 * @return string|null The builder content HTML.
 */
function copygen_elementor_builder_content_for_display($post_id) {
    if( empty( $post_id)){
        return;
    }
    $content = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($post_id);
    return  $content;
}