<?php
/*
** ============================== 
** copygen Breadcrumb File
** ==============================
*/
add_action('copygen_custom_breadcrumb',  'copygen_breadcrumb'); 
function copygen_breadcrumb() {
global $copygen_theme_mod;
global $post;
$showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
$delimiter = ''; // delimiter between crumbs
$showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
$before = '<li class="active">'; // tag before the current crumb
$after = '</li>'; // tag after the current crumb
$wp_the_query   = $GLOBALS['wp_the_query'];
$queried_object = $wp_the_query->get_queried_object();
$allowed_tags = wp_kses_allowed_html('post');
$homeLink = esc_url( home_url());
$bdhome= 'Home';
if(!empty($copygen_theme_mod['bdhomes'])):
   $bdhome = $copygen_theme_mod['bdhomes'];
endif;
// service
 
  if (is_home() || is_front_page()) {
    if ($showOnHome == 1) echo '<ul class="bread-crumb"><li><a href="' . $homeLink . '">' . esc_attr($bdhome) . '</a></li></ul>';
  } 
  if (!is_front_page()) {
    echo '<ul class="breadcrumb m-auto"><li><a href="' . $homeLink . '">' . esc_attr($bdhome)  . '</a> </li>';
    if(is_category()){
        global $wp_query;
        $cat_obj = $wp_query->get_queried_object();
        $thisCat = $cat_obj->term_id;
        $thisCat = get_category($thisCat);
        $parentCat = get_category($thisCat->parent);
        if ($thisCat->parent != 0) echo html_entity_decode( esc_html($before . get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '). $after));
        echo html_entity_decode( esc_html( $before . ' ' . single_cat_title('', false) . '' . $after) );
    }
    elseif ( is_search() ) {
        echo html_entity_decode( $before . esc_html__('Search results for "' , 'copygen') . get_search_query() . '"' . $after);
    } 
    elseif ( is_day() ) {
      echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
      echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
      echo html_entity_decode( esc_html( $before . get_the_time('d') . $after));
    } 
    elseif ( is_month() ) {
      echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
      echo html_entity_decode( esc_html( $before . get_the_time('F') . $after));
    } 
    elseif ( is_year() ) {
        echo html_entity_decode( esc_html( $before . get_the_time('Y') . $after));
    }
    elseif(is_singular('post')) {
      $cat = get_the_category(); $cat = $cat[0];
      $cats = get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      if($showCurrent == 0) $cats = preg_replace("/^(.+)\s$delimiter\s$/", "$1", $cats);
      echo '<li>'.$cats.'</li> ';
      if($showCurrent == 1) echo html_entity_decode( esc_html( $before . get_the_title() . $after));
  }
 
elseif(is_attachment()){
      $parent = get_post($post->post_parent);
      $cat = get_the_category($parent->ID); $cat = $cat;
      echo '<li><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
      if ($showCurrent == 1) echo html_entity_decode( esc_html( $before . get_the_title() . $after));
    } 
    elseif ( is_page() && !$post->post_parent ) {
      if ($showCurrent == 1) echo html_entity_decode( esc_html( $before . get_the_title() . $after));
 
    } 
    elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<li><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb)  echo html_entity_decode( esc_html( $crumb . ' ' . $delimiter . ' '));
      if ($showCurrent == 1) echo html_entity_decode( esc_html( $before . get_the_title() . $after));
 
    } 
    elseif ( is_tag() ) {
        echo html_entity_decode( esc_html( $before . '"' . single_tag_title('', false) . '"' . $after));
 
    } 
    elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo html_entity_decode( esc_html( $before . '"' . $userdata->display_name . '"' . $after));
 
    } 
    elseif ( is_404() ) {
        echo html_entity_decode($before . esc_html__( 'Error 404' , 'copygen') . $after);
    }
    if (is_home()){
      global $post;
      $page_for_posts_id = get_option('page_for_posts');
      echo '<li>';
      if ( $page_for_posts_id ) { 

          $post = get_page($page_for_posts_id);

          setup_postdata($post);
          the_title();
          rewind_posts();

      }
      echo '</li>';
  }
  if(get_query_var('paged')){
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ){
      echo '<li>'.esc_html__('Page', 'copygen') . ''.get_query_var('paged').'</li> ';
    }
  }
    
    echo '</ul>';
 
  }
} 