<?php
/*
======================
 Page Header Settings
======================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Page Header Settings', 'copygen' ),
            'id'     => 'page_header_settings_option',
            'desc'   => esc_html__( '', 'copygen' ),
            'icon'   => 'el el el-website',
            'fields' => array(
              
            array(
                'id'       => 'page_header_enable',
                'type'     => 'switch', 
                'title'    => __('Page Header Enable / Disable', 'copygen'),
                'default'  => true,
            ),
            array(
                'id'    => 'page_header_alignment',
                'type'  => 'select',
                'title' => esc_html__( 'Page Header Alignment', 'copygen' ),
                'options'  => array(
                    'left' => esc_html__( 'Left', 'copygen' ),
                    'center' => esc_html__( 'Center', 'copygen' ),
                    'text_right' => esc_html__( 'Right', 'copygen' ),
                ),
                'default'  => 'center',
            ),
            array(
                'id'       => 'breadcrumb_enable',
                'type'     => 'switch', 
                'title'    => __('Breadcrumb Enable / Disable', 'copygen'),
                'default'  => true,
                'required' => array( 'page_header_enable', '=', true ),
            ),

            array(
                'id'       => 'bdhomes',
                'type'     => 'text', 
                'default'  =>  __('Home', 'copygen'),
                'title'    => __('Breadcrumb Home Text', 'copygen'),
                'required' => array( 'page_header_enable', '=', true ),
            ), 
 
            array(
                'id'       => 'page_header_bg_image',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Page Header Background Image for Pages', 'copygen'),  
            ),
            
            array(         
                'id'       => 'page_header_bg_image_other',
                'type'     => 'background',
                'title'    => __('Page Header Background Option for Pages', 'copygen'),
                'background-image' => false ,
                'background-color' => false ,
                'desc'     => __('This is the description field, again good for additional info.', 'copygen'),
                'output'    => array('body:not(.blog , .single-post) .page_header_default .bakground_cover'),
            ),
            array(
                'id'       => 'blog_page_header_bg_image',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Blog Page header Background Image for Blog', 'copygen'), 
            ),  
            array(         
                'id'       => 'blog_page_header_bg_image_other',
                'type'     => 'background',
                'title'    => __('Page Header Background Option for Blog', 'copygen'), 
                'background-image' => false ,
                'background-color' => false ,
                'output'    => '.blog .page_header_default .bakground_cover , .single-post .page_header_default .bakground_cover',
            ),
              
            array(
                'id'        => 'pageheader_bg_color',
                'type'      => 'color_rgba',
                'title'     =>  __('Page header Background Colors', 'copygen'), 
                 
                // See Notes below about these lines.
                'output'    => array('background-color' => '.page_header_default:before'),
                //'compiler'  => array('color' => '.site-header, .site-footer', 'background-color' => '.nav-bar'),
                
                // These options display a fully functional color palette.  Omit this argument
                // for the minimal color picker, and change as desired.
                'options'       => array(
                    'show_input'                => true,
                    'show_initial'              => true,
                    'show_alpha'                => true,
                    'show_palette'              => true,
                    'show_palette_only'         => false,
                    'show_selection_palette'    => true,
                    'max_palette_size'          => 10,
                    'allow_empty'               => true,
                    'clickout_fires_change'     => false,
                    'choose_text'               => 'Choose',
                    'cancel_text'               => 'Cancel',
                    'show_buttons'              => true,
                    'use_extended_classes'      => true,
                    'palette'                   => null,  // show default
                    'input_text'                => 'Select Color'
                ),                        
            ),
            

            array(
                'id'       => 'page_header_paddings',
                'type'     => 'text',
                'title'    => __('Page Header Padding', 'copygen'),
                'placeholder'    => __('5rem 0px 5rem 0px', 'copygen'),
                'default'  => '',
          
            ),

            array(
                'id'       => 'pageheader_title_color',
                'type'     => 'color',
                'title'    => __('Page Header Title Color', 'copygen'), 
                'validate' => 'color',
              
            ),
            array(
                'id'       => 'pageheader_breadcrumb_color',
                'type'     => 'color',
                'title'    => __('Page Header Breadcrumb Color', 'copygen'), 
                'validate' => 'color',
               
            ),
            
            array(
                'id'       => 'pageheader_breadcrumb_arrow_color',
                'type'     => 'color',
                'title'    => __('Page Header Breadcrumb Arrow Color', 'copygen'), 
                'validate' => 'color',
          
            ),
 

        )
));

