<?php
/*
=================================
Mobile Header Settings
==================================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Option Panel Settings', 'copygen' ),
            'id'     => 'option_panel_settings',
            'desc'   => esc_html__( '', 'copygen' ),
            'icon'   => 'el el-th',
            'fields' => array(
                array(
                    'id'       => 'panel_logo',
                    'type'     => 'switch', 
                    'title'    => __('Logo Enable  / Disable', 'copygen'), 
                    'default'  => true,
                ),   
                array(
                    'id'       => 'company_logo_modals',
                    'type'     => 'media', 
                    'url'      => true, 
                    'default'  => array(
                        'url'=> get_template_directory_uri() . '/assets/images/theme-logo.png', 
                    ),
                    'title'    => __('Logo', 'copygen'),
                    'required' => array( 'panel_logo', '=', true ),
                 
                ), 
                array(
                    'id'       => 'about_company_modal',
                    'type'     => 'textarea',
                    'title'    => esc_html__( 'About Company', 'copygen' ), 
                    'default' => esc_html__('Denounce with righteous indignation and dislike men who are beguiled
                        and demoralized by the charms pleasure moment so blinded desire that
                        they cannot foresee the pain and trouble.', 'copygen') ,
                    'required' => array( 'panel_logo', '=', true ),
                ), 
                array(
                    'id'       => 'post_enable_modal',
                    'type'     => 'switch', 
                    'title'    => __('Post Enable', 'copygen'),
                    'default'  => true,
                ), 
                array(
                    'id'       => 'post_title_modal',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Title', 'copygen' ),
                    'desc'     => esc_html__( '', 'copygen' ),
                    'default' => esc_html__('Latest News', 'copygen') , 
                    'required' => array( 'post_enable_modal', '=', true ),
                ),
               
                array(
                    'id'       => 'form_enable',
                    'type'     => 'switch', 
                    'title'    => __('Form Enable  / Disable', 'copygen'), 
                    'default'  => true,
                ),  
                array(
                    'id'       => 'form_title',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Form Title', 'copygen' ),
                    'default' => esc_html__('Need Any Help? Or Looking For an Agent', 'copygen') , 
                    'required' => array( 'form_enable', '=', true ),
                ),
                array(
                    'id'       => 'modal_form_short_code',
                    'type'     => 'textarea',
                    'title'    => esc_html__( 'Modal Form Shortcode', 'copygen' ),
                    'desc' => esc_html__('Enter Contact Form 7 Short Code here', 'copygen') ,
                    'placeholder'     => esc_html__( '[contact-form-7 id="344" title="Contact Form"]', 'copygen' ),
                    'required' => array( 'form_enable', '=', true ),
                ),
                array(
                    'id'       => 'contact_panel_enable',
                    'type'     => 'switch', 
                    'title'    => __('Contact Enable  / Disable', 'copygen'), 
                    'default'  => true,
                ), 
                array(
                    'id'       => 'mobile_phone_number',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Phone Number', 'copygen' ),
                    'default' => esc_html__('9806071234', 'copygen') ,
                    'required' => array( 'contact_panel_enable', '=', true ),
                ),
                array(
                    'id'       => 'mobile_mail_number',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Mail Id', 'copygen' ),
                    'default' => esc_html__('sendmail@example.com', 'copygen') ,
                    'required' => array( 'contact_panel_enable', '=', true ),
                ),
                array(
                    'id'       => 'working_hours_panels',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Working Hours', 'copygen' ),
                    'default' => esc_html__('Working Hours : <span> Sun-monday, 09am-5pm </span>', 'copygen') ,
                    'required' => array( 'contact_panel_enable', '=', true ),
                ),
                array(
                    'id'       => 'copy_right_enable',
                    'type'     => 'switch', 
                    'title'    => __('Copy Right Enable  / Disable', 'copygen'), 
                    'default'  => true,
                ),  
                array(
                    'id'       => 'copy_right_modal',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Copy Right', 'copygen' ),
                    'desc'     => esc_html__( '', 'copygen' ),
                    'default' => esc_html__('© 2023 copygen. All Rights Reserved.', 'copygen') , 
                    'required' => array( 'copy_right_enable', '=', true ),
                ),
               
    )
));


 