<?php
/*
====================
Theme Color Settings
====================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Color Settings', 'copygen' ),
            'id'     => 'color_scheme',
            'desc'   => esc_html__( '', 'copygen' ),
            'icon'   => 'el el-brush',
            'fields' => array(
                array(         
                    'id'       => 'body_backgrounds',
                    'type'     => 'background',
                    'title'    => __('Backgrounds for Site', 'copygen'),  
                    'output'    => array('body'),
                ),
                array(
                    'id' => 'dark_color_enable',
                    'type' => 'switch',
                    'default'  => false,
                    'title' => __('Dark Colors Enable / Disable', 'copygen'),  
                ),
                array(
                    'id' => 'theme_color_enable',
                    'type' => 'switch',
                    'default'  => false,
                    'title' => __('Theme Colors Enable / Disable', 'copygen'),
                    'indent' => true ,
                ),
                array(
                    'id'       => 'theme_color_one',
                    'type'     => 'color',
                    'title'    => __('Primary Color 1', 'copygen'), 
                    'validate' => 'color', 
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
                array(
                    'id'       => 'theme_color_two',
                    'type'     => 'color',
                    'title'    => __('Primary Color 2', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
            
                array(
                    'id'       => 'theme_color_three',
                    'type'     => 'color',
                    'title'    => __('Primary Color 3', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
            
                array(
                    'id'       => 'theme_color_four',
                    'type'     => 'color',
                    'title'    => __('Primary Color 4', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
             
                array(
                    'id' => 'theme_bgcolor_section',
                    'type' => 'section',
                    'title' => __('Theme Background Colors', 'copygen'),
                    'indent' => true ,
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
            
                array(
                    'id'       => 'theme_bgcolor_one',
                    'type'     => 'color',
                    'title'    => __('Theme Background Color (1)', 'copygen'),
                    'description'    => __('Use Light Color', 'copygen'),  
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
                array(
                    'id'       => 'theme_bgcolor_two',
                    'type'     => 'color',
                    'title'    => __('Theme Background Color (2)', 'copygen'), 
                    'description'    => __('Use Light Color', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ), 
               
                array(
                    'id' => 'theme_border_color_sect',
                    'type' => 'section',
                    'title' => __('Border Colors', 'copygen'),
                    'indent' => true ,
                    'required' => [ 'theme_color_enable', '=', true ],
                ),

                array(
                    'id'       => 'border_color',
                    'type'     => 'color',
                    'title'    => __('Border Color', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
                array(
                    'id' => 'theme_heding_clor_section',
                    'type' => 'section',
                    'title' => __('Theme Heading Colors', 'copygen'),
                    'indent' => true ,
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
                array(
                    'id'       => 'heading_color',
                    'type'     => 'color',
                    'title'    => __('Heading Color', 'copygen'), 
                    'validate' => 'color',
                    'required' => [ 'theme_color_enable', '=', true ],
                ),
            
                array(
                    'id'       => 'description_color',
                    'type'     => 'color',
                    'title'    => __('Text  Color', 'copygen'), 
                    'validate' => 'color',
                          'required' => [ 'theme_color_enable', '=', true ],
                ), 
            )
        )   
    );

