<?php
/*
====================
Blog Settings
====================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Blog  Settings', 'copygen' ),
            'id'     => 'blog_settings_all',
            'desc'   => esc_html__( '', 'copygen' ),
            'icon'   => 'el el-bold',
            'fields' => array(
                array(
                    'id' => 'blog_page_section',
                    'type' => 'section',
                    'title' => __('Blog Settings', 'copygen'),
                    'indent' => true ,
                ),
                array(
                    'id'       => 'excerpt_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Excerpt Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Excerpt in Blog Card', 'copygen'),
                ),
                array(
                    'id'       => 'authour_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Authour Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Authour in Blog Card', 'copygen'),
                ),
                array(
                    'id'       => 'post_category_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Category Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Category in Blog Card', 'copygen'),
                ),
                array(
                    'id'       => 'post_meta_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Meta Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Meta in Blog Card', 'copygen'),
                ),
                array(
                    'id' => 'blog_singe_section',
                    'type' => 'section',
                    'title' => __('Blog Single Settings', 'copygen'),
                    'indent' => true ,
                ),
                array(
                    'id'    => 'blog_single_styles',
                    'type'  => 'select',
                    'title' => esc_html__( 'Blog Single Style', 'copygen' ),
                    'options'  => array(
                        'style_one' => esc_html__( 'Style One', 'copygen' ),
                        'style_two' => esc_html__( 'Style Two ', 'copygen' ), 
                    ),
                    'default'  => 'style_one',
                ),
                array(
                    'id'       => 'pg_headerimage_for_style_two',
                    'type'     => 'media', 
                    'url'      => true,
                    'title'    => __('Blog Header Pattern Background Image', 'copygen'),
                 
                ),  
                array(         
                    'id'       => 'blog_page_header_bg_image_other',
                    'type'     => 'background',
                    'title'    => __('Blog Header Pattern Background  Option for Blog', 'copygen'), 
                    'background-image' => false ,
                    'background-color' => false ,
                    'output'    => array('.pageheader_bg_for_single_style_two'),
                ),
                  
                array(
                    'id'        => 'pg_headercolor_for_style_two',
                    'type'      => 'color_rgba',
                    'title'     =>  __('Page header Background Colors', 'copygen'), 
                     
                    // See Notes below about these lines.
                    'output'    => array('background' => '.pageheader_bg_for_single_style_two'),
                    //'compiler'  => array('color' => '.site-header, .site-footer', 'background-color' => '.nav-bar'),
                    'default'   => array(
                        'color'     => '#fdfdfd',
                        'alpha'     => 1
                    ), 
                    // These options display a fully functional color palette.  Omit this argument
                    // for the minimal color picker, and change as desired.
                    'options'       => array(
                        'show_input'                => true,
                        'show_initial'              => true,
                        'show_alpha'                => true,
                        'show_palette'              => true,
                        'show_palette_only'         => false,
                        'show_selection_palette'    => true,
                        'max_palette_size'          => 10,
                        'allow_empty'               => true,
                        'clickout_fires_change'     => false,
                        'choose_text'               => 'Choose',
                        'cancel_text'               => 'Cancel',
                        'show_buttons'              => true,
                        'use_extended_classes'      => true,
                        'palette'                   => null,  // show default
                        'input_text'                => 'Select Color'
                    ),                        
                ),
                

                array(
                    'id'       => 'breadcrumb_s_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Breadcrumb Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Breadcrumb in Blog single', 'copygen'),
                    'required' => array( 'blog_single_style', '=', 'style_two' ),
                ), 
                array(
                    'id'       => 'category_enable',
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Category Enable / Disable', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Category in Blog single', 'copygen'),
                ),
                array(
                    'id'       => 'tag_disable', 
                    'type'     => 'switch', 
                    'default'  => true,
                    'title'    => __('Tag Enable / Disable', 'copygen'),
                    'desc'       => esc_html__('This is used to enable and disable Tags in Blog single', 'copygen'),
                ),
                array(
                    'id'       => 'share_disable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Share Enable / Disable ', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Share in Blog single', 'copygen'),
                ),
                array(
                    'id'       => 'authour_detail_disable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Authour Details Enable / Disable ', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Share in Blog single', 'copygen'),
                ),
                array(
                    'id'       => 'next_prev_enable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Post Navigation Enable / Disable ', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Share in Blog single', 'copygen'),
                ), 
                array(
                    'id'       => 'related_post_enable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Related Post  Enable / Disable ', 'copygen'),
                    'desc'       => esc_html__( 'This is used to enable and disable Related post in Blog single', 'copygen'),
                ), 
                array(
                    'id'       => 'related_post_title',
                    'type'     => 'text', 
                    'default'  =>  esc_html__( 'Related Post', 'copygen' ), 
                    'title'    => __('Related Post Title Text', 'copygen'),
                    'required' => array( 'related_post_enable', '=', true ),
                ),
            )
        )
    );