<?php
/*
====================
404 Settings
====================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( '404 Settings', 'copygen' ),
            'id'     => 'fournotfour_settings',
            'desc'   => esc_html__( '', 'copygen' ),
            'icon'   => 'el el-check-empty',
            'fields' => array(
                array(
                    'id'    => 'fnotf_styles',
                    'type'  => 'select',
                    'title' => esc_html__( '404 Style', 'copygen' ),
                    'options'  => array(
                        'style_one' => esc_html__( 'Style One', 'copygen' ),
                        'style_two' => esc_html__( 'Style Two ', 'copygen' ), 
                    ),
                    'default'  => 'style_one',
                ),
                array(
                    'id'       => '404_image',
                    'type'     => 'media', 
                    'url'      => true,
                    'title'    => __('404 Image', 'copygen'), 
                ),
                array(
                    'id'       => 'bg_error_images',
                    'type'     => 'media', 
                    'url'      => true,
                    'title'    => __('404 Background Image', 'copygen'), 
                ),
                array(         
                    'id'       => 'bg_error_color',
                    'type'     => 'background',
                    'title'    => __('404 Backgrounds', 'copygen'),
                    'background-image' => false ,
                    'subtitle' => __('404 background with color, etc.', 'copygen'),
                    'output'    => array('.error404'),
                ),
                array(
                    'id'       => 'fn_title_color',
                    'type'     => 'color',
                    'title'    => __('404 Title Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('.main.page-404 .page-content .title_no_a_24'),
                ),
                array(
                    'id'       => 'fn_des_color',
                    'type'     => 'color',
                    'title'    => __('404 Description Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('.main.page-404 .page-content p'),
                ),
                
                array(
                    'id'       => 'fn_search_text_color',
                    'type'     => 'color',
                    'title'    => __('404 Search Input Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    =>   array('color' => '.main.page-404 form input::placeholder , .main.page-404 form input , .main.page-404 form i'),
                ),
                array(
                    'id'       => 'fn_search_br_color',
                    'type'     => 'color',
                    'title'    => __('404 Search Border Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('border-color' => '.main.page-404 form input'),
                ),
                array(
                    'id'       => 'fn_search_tbgcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Background Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('background' => '.main.page-404 form input'),
                ),
                array(
                    'id'       => 'fn_search_bcolcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Btn  Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('.main.page-404 form .sch_btn'),
                ),
                array(
                    'id'       => 'fn_search_btngcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Btn Background Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('background' =>'.main.page-404 form .sch_btn'),
                ), 
                array(
                    'id'       => 'fn_search_brcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Btn Border Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('border-color' =>'.main.page-404 form .sch_btn'),
                ), 
                array(
                    'id'       => 'fn_backtohomecolor',
                    'type'     => 'color',
                    'title'    => __('404 Back to Home Button Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('.main.page-404 .theme_btn'),
                ),
                array(
                    'id'       => 'fn_backtohomebgcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Btn Background Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('background' =>'.main.page-404 .theme_btn'),
                ),
                array(
                    'id'       => 'fn_backtohomebrcolor',
                    'type'     => 'color',
                    'title'    => __('404 Search Btn Border Color', 'copygen'),  
                    'validate' => 'color', 
                    'output'    => array('border-color' =>'.main.page-404 .theme_btn'),
                ),
            )
        )
    );