<?php
/*
** ============================== 
** Copygen Admin Panel
** ==============================
*/
add_action( 'admin_menu', 'copygen_plugin_menu' );
function copygen_plugin_menu() {
	add_menu_page( 
        'Copygen',
        'Copygen',
        'manage_options',
        'copygen', 
        'copygen_settings_page',
        'dashicons-admin-settings', // Icon
        2 
    );
    
    add_submenu_page(
        'copygen', // Parent slug (replace with the slug of the parent menu item)
        'Copygen Settings', // Page title
        'About Copygen', // Menu title
        'manage_options', // Capability required to access the page
        'copygen-settings', // Menu slug
        'copygen_settings_page', // Callback function to display content
        0
    );
}

// Callback function for top-level menu item
function copygen_settings_page() {
// Add HTML for navigation tabs
global $wp_filesystem, $wpdb;
?>
<section class="copygen_tab_box">

    <div class="copygen_tab_wrapper">
        <div class="copygen_admin_tab">
            <div class="copygen_content_box">

                <div class="welcome_contnet c_bg_color">
                    <h2 class="main_t"><?php echo esc_html('Welcome to Copygen ---> ' , 'copygen'); ?> <?php $current_theme = wp_get_theme();
                    echo 'Current theme version: ' . $current_theme->get( 'Version' );
                ?></h2>
                    <p class="end">
                        <?php echo esc_html('Thank you for purchasing our Copygen theme. Here you are able to 
                        start creating your awesome web Application by importing our dummy content and theme by options.' , 'copygen'); ?>
                    </p>
                    <div class="clearfix d-flex">
                        <div class="copt_system_information  c_bg_teo_color">
                            <h2>
                                <?php echo esc_html('System Information' , 'copygen'); ?>
                            </h2>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('Your Php Version ' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $php_version = phpversion();
                                            if (version_compare($php_version, '5.6', '<')):
                                            ?>
                                        <?php echo esc_attr($php_version); echo esc_html__(' is too old. Please upgrade to version 5.6 or higher' , 'copygen'); ?>
                                        <label> <?php esc_html__('Please contact Host provider to fix it.','copygen') ?>
                                        </label>
                                        <?php else: ?>
                                        <?php  echo esc_attr($php_version); echo esc_html__(' is up to date.' , 'copygen'); ?>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('MySQL Version' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php  
                                             global $wpdb;
                                             $mysql_version = $wpdb->get_var("SELECT version() as version");
                                            ?>
                                        <span><?php echo esc_attr($mysql_version); ?></span>

                                    </li>
                                </ul>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Post Max Size' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php  
                                            $max_post_size_bytes = wp_convert_hr_to_bytes( ini_get( 'post_max_size' ) );
                                            $max_post_size_formatted = size_format( $max_post_size_bytes );
                                            $bytes = wp_convert_hr_to_bytes( '512MB' );
                                            ?>
                                        <span><?php echo esc_attr($max_post_size_formatted); ?></span>
                                        <small><?php if($max_post_size_bytes >  $bytes): ?>
                                            <?php echo esc_html('looks good' , 'copygen'); ?>
                                            <?php else: ?>
                                            <?php echo esc_html('Increase Your Post Max Size greaten than 512' , 'copygen'); ?>
                                            <?php endif; ?>
                                        </small>
                                    </li>
                                </ul>
                            </div>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('Max Upload Size' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $max_upload_size_low = 128;
                                            $max_upload_size = ini_get('upload_max_filesize'); ?>
                                        <span><?php echo esc_attr($max_upload_size); ?></span>
                                        <small>
                                            <?php echo esc_html('looks good' , 'copygen'); ?>
                                        </small>
                                    </li>
                                </ul>
                                <?php if($max_upload_size < $max_upload_size_low): ?>
                                <em> <?php echo esc_html('Increase Max Upload Size to 300 or 512 or maximum' , 'copygen'); ?>
                                </em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Time Limit' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $current_time_limit = ini_get('max_execution_time'); ?>
                                        <?php if ($current_time_limit < 600): ?>
                                        <span>
                                            <?php echo esc_attr($current_time_limit); echo esc_html__('sec' , 'copygen'); ?></span>
                                        <?php else: ?>
                                        <span>
                                            <?php echo esc_attr($current_time_limit); echo esc_html__(' sec' , 'copygen'); ?>
                                            <small>
                                                <?php echo esc_html('looks good' , 'copygen'); ?>
                                            </small>
                                        </span>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                                <?php if ($current_time_limit < 1300): ?>
                                <em><?php echo esc_html('Your PHP time limit is too low. Please set it to at least 600 seconds to import demo content' , 'copygen'); ?>
                                </em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Max Input Vars' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php
                                        $max_input_vars = ini_get('max_input_vars');
                                        $menu_items = get_nav_menu_locations();
                                        $menu_items_count = count($menu_items);
                                        $required_input_vars = ceil(($menu_items_count * 4) / 1024);
                                        $buffer = 500; // adjust this as needed
                                        $required_input_vars += $buffer;
                                        $required_input_vars_formatted = number_format($required_input_vars);
                                        $current_input_vars_formatted = number_format($max_input_vars);
                                        ?>
                                        <span><?php echo esc_attr($current_input_vars_formatted); ?> </span> <small>
                                            <?php echo esc_html('looks good' , 'copygen'); ?>
                                        </small>

                                    </li>
                                </ul>
                                <?php if ($max_input_vars < $required_input_vars): ?>
                                <em><strong><?php echo esc_html('Note:' , 'copygen'); ?></strong>
                                    <?php echo esc_html('Your current PHP Max Input Vars setting is too low. Please increase it to at least', 'copygen'); ?>
                                    <?php echo esc_attr($required_input_vars_formatted); ?><?php echo esc_html(' to avoid issues with your menu items.', 'copygen'); ?></em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('ZipArchive' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if(class_exists('ZipArchive')): ?>
                                        <span><?php echo esc_html('Yes' , 'copygen'); ?></span>
                                        <?php else: ?>
                                        <?php echo esc_html('No' , 'copygen'); ?>
                                        <?php endif; ?>

                                    </li>
                                </ul>
                                <?php  if (!class_exists('ZipArchive')): ?>
                                <em><?php echo esc_html('ZipArchive class is not available on your server.' , 'copygen'); ?></em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('GD Library' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if (extension_loaded('gd') && function_exists('gd_info')): ?>
                                        <span><?php $gdinfo = gd_info();
				                                echo esc_html($gdinfo['GD Version']); ?></span>
                                        <?php else: ?>
                                        <span><?php echo esc_html__('Not Installed', 'copygen'); ?></span>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('cURL' , 'copygen'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if (function_exists('curl_version')): ?>
                                        <span><?php    $curl_version = curl_version();
                                            echo esc_html($curl_version['version']); ?></span>

                                        <?php else: ?>
                                        <span><?php echo esc_html('Not Enabled' , 'copygen'); ?></span>
                                        <?php endif; ?>

                                    </li>
                                </ul>
                            </div>

                        </div>
                        <div class="right_box">
                            <div class="d-flex">
                                <div class="documentation common_box">
                                    <div class="inner_docsuppo">
                                        <h6><?php echo esc_html__('Our documentation is simple  , With details and covers all the essential features from the beginning to the most advanced.' , 'copygen') ?>
                                            <br>
                                            <a href="https://themepanthers.com/wp/copygen/demos/documentation/"
                                                target="_blank">
                                                <?php echo esc_html('Click  here to check Documentation' , 'copygen'); ?>
                                            </a></h6>
                                        <?php  $docsimg = get_template_directory_uri() . '/includes/admin/images/documentation.jpg'; ?>
                                        <?php if(!empty($docsimg)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($docsimg); ?>"
                                            alt="documentation" /><?php endif; ?>
                                    </div>

                                </div>
                                <div class="support common_box">
                                    <div class="inner_docsuppo">
                                        <h6> <?php echo esc_html__('Copygen theme comes with 6 months of free support for every license you purchase. Support can be extended through subscriptions via ThemeForest.' , 'copygen') ?>
                                            <br>
                                            <a href="https://steelthemes.ticksy.com/submit/#100021264" target="_blank">
                                                <?php echo esc_html('Click here to get Support' , 'copygen'); ?>
                                            </a>
                                        </h6>
                                        <?php  $support = get_template_directory_uri() . '/includes/admin/images/support.jpg'; ?>
                                        <?php if(!empty($support)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($support); ?>" alt="support" /><?php endif; ?>
                                    </div>
                                </div>

                            </div>

                            <div class="d-flex">


                                <div class="video common_box">
                                    <div class="inner_docsuppo">
                                        <h6> <?php echo esc_html__('Here is the Video Tutorials to install theme , pluign , import demo content and Get Start with it.' , 'copygen') ?>
                                            <br>
                                            <a href="https://www.youtube.com/watch?v=yQ3peIJK2eU&list=PL0r7c9VEks_slU5-oQyiiUT-vwtlsgy82" target="_blank">
                                                <?php echo esc_html('Click here to get Video Tutorials' , 'copygen'); ?>
                                            </a>
                                        </h6>
                                        <?php  $support = get_template_directory_uri() . '/includes/admin/images/support.jpg'; ?>
                                        <?php if(!empty($support)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($support); ?>" alt="support" /><?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="our_recent_themes">
                                <h2><?php echo esc_html('Our Recent Themes' , 'copygen'); ?> </h2>

                                <div class="d-flex">


                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_1 = get_template_directory_uri() . '/includes/admin/images/theme-1.jpg'; ?>
                                            <?php if(!empty($theme_1)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_1); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Vankine - Insurance & Consulting Business WordPress Theme' , 'copygen'); ?>
                                                <a href="https://themeforest.net/item/vankine-insurance-business-wordpress-theme/43132301" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'copygen'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>


                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_2 = get_template_directory_uri() . '/includes/admin/images/theme-2.jpg'; ?>
                                            <?php if(!empty($theme_2)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_2); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Creote - Corporate & Consulting Business WordPress Theme' , 'copygen'); ?>
                                                <a href="https://themeforest.net/item/creote-business-wordpress-theme/34450141" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'copygen'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_3 = get_template_directory_uri() . '/includes/admin/images/theme-3.jpg'; ?>
                                            <?php if(!empty($theme_3)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_3); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Lawnella - Gardening & Landscaping WordPress Theme' , 'copygen'); ?>
                                                <a href="https://themeforest.net/item/lawnella-landscaping-wordpress-theme/26526840" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'copygen'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_4 = get_template_directory_uri() . '/includes/admin/images/theme-4.jpg'; ?>
                                            <?php if(!empty($theme_4)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_4); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Nest - Grocery Store WooCommerce WordPress Theme' , 'copygen'); ?>
                                                <a href="https://themeforest.net/item/nest-multipurpose-woocommerce-wordpress-theme/37772027" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'copygen'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>
<?php
}

  
// Add JavaScript to show/hide tab content
add_action( 'admin_enqueue_scripts', 'copygen_admin_scripts' );
function copygen_admin_scripts() {
    wp_enqueue_style('copygen-admin-style', get_template_directory_uri() . '/includes/admin/css/style.css', array() , '1.0.0', 'all'); 
	wp_enqueue_script( 'copygen-admin',  get_template_directory_uri() . '/includes/admin/js/admin.js', array( 'jquery' ), '1.0', true );
}

// get admin files
require_once get_template_directory() . '/includes/admin/menu/menu-option.php';




function display_admin_notice() {
    global $copygen_theme_mod;
    $admin_notice_enable = isset( $copygen_theme_mod['admin_notice_enable'] ) ? $copygen_theme_mod['admin_notice_enable'] : ''; 
    $admin_dashboard_url = admin_url('admin.php?page=copygen-settings'); 
    ?>
   <div class="admin-notice admin-notice-copygens notice notice-info is-dismissible <?php if($admin_notice_enable == false): ?> disable_copt_notice <?php  endif; ?>">
    <ul>
        <li><?php echo esc_html('To Get auto updates install envato-market pluign and follow this steps to step up =>' , 'copygen'); ?><a href="https://themepanthers.com/wp/copygen/demos/documentation/getting-started.html#updatetheme" target="_blank"><?php echo esc_html('Documentation' , 'copygen'); ?></a> <?php echo esc_html(' Or ' , 'copygen'); ?> <a target="_blank" href="https://www.youtube.com/watch?v=lD_j9rbVle4&feature=youtu.be"><?php echo esc_html('Follow this Video' , 'copygen'); ?></a></li>
        <li><?php echo esc_html('Before Import Demo Content Check the server configuration here' , 'copygen'); ?> <a target="_blank" href="<?php echo esc_url($admin_dashboard_url);?>"><?php echo esc_html('Click here...' , 'copygen'); ?></a></li>
        <li><?php echo esc_html('We are here to help you.For any issues please submit your ticket here' , 'copygen'); ?> <a target="_blank" href="https://steelthemes.ticksy.com/submit/#100021264"><?php echo esc_html('Get Support' , 'copygen'); ?></a></li>
        <li><?php echo esc_html('Looking for Copygen Documentation' , 'copygen'); ?> <a target="_blank" href="https://themepanthers.com/wp/copygen/demos/documentation/"><?php echo esc_html('Click here' , 'copygen'); ?></a></li>
    </ul>
    <p><?php echo esc_html('Disable this notification totally go to copygen -> theme option ->  general settings ->  Disable Admin Notice => Switch Off' , 'copygen'); ?></p>
    </div> 
   <?php
}
add_action( 'admin_notices', 'display_admin_notice' );


 