<?php

function my_login_form_shortcode() {
    if ( is_user_logged_in() ) {
        return '';
    }
    $form = '';
    if ( isset( $_GET['login'] ) && preg_match('/failed/', $_GET['login'] ) ) {
        $form .= '<div class="wp_login_error"><p style="color:red;">The login is incorrect. Please try again.</p></div>';
    } elseif ( isset( $_GET['login'] ) && $_GET['login'] == 'empty' ) {
        $form .= '<div class="wp_login_error"><p style="color:red;">Please enter both username and password.</p></div>';
    }
    $form .= '<div id="loginform">';
    $form .= '<form method="post" action="'. home_url('wp-login.php') .'" class="wp-user-form">';
    $form .= '<h2>Login to access this formfsdfd</h2>';
    $form .= '<div><input type="text" placeholder="UserID" required="" id="user_login" name="log" /></div>';
    $form .= '<div><input type="password" placeholder="Password" required="" id="user_pass" name="pwd" /></div>';
    $form .= '<div><input id="wp-submit" type="submit" value="Login" name="submit" /></div>';
    $form .= '<input type="hidden" name="redirect_to" value="'. esc_attr( $_SERVER['REQUEST_URI'] ) .'" />';
    $form .= '</form>';
    $form .= '</div>';
    return $form;
}

//use shortcode [my-login-form] to show the login on any page or post
function my_add_shortcodes() {
    add_shortcode( 'my-login-form', 'my_login_form_shortcode' );
}
add_action( 'init', 'my_add_shortcodes' );

add_action( 'wp_login_failed', 'my_front_end_login_fail' );  // hook failed login

//control login failures
function my_front_end_login_fail( $username ) {
    $referrer = $_SERVER['HTTP_REFERER'];  // where did the post submission come from?
    // if there's a valid referrer, and it's not the default log-in screen
    if ( !empty($referrer) && !strstr($referrer,'wp-login') && !strstr($referrer,'wp-admin') ) {
        wp_redirect( add_query_arg( 'login', 'failed', $referrer ) );  // let's append some information (login=failed) to the URL for the theme to use
        exit;
    }
}
//control where logout goes
function my_logout_redirect() {
    wp_redirect( wp_get_referer() );
    exit;
}
add_action( 'wp_logout', 'my_logout_redirect', PHP_INT_MAX );

 

function copygen_registration_form() {
    if (isset($_POST['register'])) {
        $username = sanitize_user($_POST['user_login']);
        $email = sanitize_email($_POST['user_email']);
        $password = esc_attr($_POST['user_password']);
 
        $user_id = wp_create_user($username, $password, $email);
 
        if (!is_wp_error($user_id)) {
            wp_new_user_notification($user_id, null, 'admin');
            echo 'Registration complete. Please check your email for login details.';
        } else {
            echo $user_id->get_error_message();
        }
    }
    ?>
    <form method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
        <p>
            <label for="user_login"><?php _e('Username') ?><br />
            <input type="text" name="user_login" value="<?php if (isset($_POST['user_login'])) echo $_POST['user_login']; ?>" /></label>
        </p>
        <p>
            <label for="user_email"><?php _e('Email') ?><br />
            <input type="email" name="user_email" value="<?php if (isset($_POST['user_email'])) echo $_POST['user_email']; ?>" /></label>
        </p>
        <p>
            <label for="user_password"><?php _e('Password') ?><br />
            <input type="password" name="user_password" /></label>
        </p>
        <p>
            <input type="submit" name="register" value="<?php _e('Register'); ?>" />
        </p>
        <div id="copygen-google-signin-button">Sign in with Google</div>

    </form>
    <?php
}
add_shortcode('copygen-registration-form', 'copygen_registration_form');
 

function remember_me_checked() {
    add_filter( 'login_footer', function() {
  ?>
    <script>
     $(document).ready(function() {
  $('#rememberme').prop('checked', true);
});
    </script>
  <?php
    });
  }
add_action( 'login_enqueue_scripts', 'remember_me_checked' );
  

