<?php
namespace Copygenaddons;
if (! defined('ABSPATH' )){
	die('-1');
}
class Startcopygen{
      /**
      * Instance
      *
      * @var $instance
      */
      private static $instance;
      /**
      * Initiator
      *
      * @since 1.0.0
      * @return object
      */
      public static function instance() {
        if ( ! isset( self::$instance ) ) {
          self::$instance = new self();
        }

        return self::$instance;
      }


      /**
      * Instantiate the object.
      *
      * @since 1.0.0
      *
      * @return void
      */
      public function __construct() {
          add_action('wp_enqueue_scripts', array($this, 'copygen_enqueue_scripts'));  
        //  add_action('elementor/editor/before_enqueue_scripts', array($this, 'copygen_elementor_scripts'));
          add_action( 'elementor/elements/categories_registered', array($this, 'add_category' ) );

      } 
 	      /**
	      * Add  category
	      *
	      * @since 1.0.0
	      *
	      * @return void
	      */
	      public function add_category( $elements_manager ) {
            $elements_manager->add_category(
              '100',
              [
                  'title'  => 'Copygen Header',
                  'icon' => 'font',
              ],
              1
            );
            $elements_manager->add_category(
              '101',
              [
                'title'  => 'Copygen Content',
                'icon' => 'font',
              ],
              2
            );
            $elements_manager->add_category(
              '102',
              [
                  'title'  => 'Copygen Posts',
                  'icon' => 'font',
              ],
              3
            );
         // $elements_manager->add_category(
           // '103',
              //[
               // 'title'  => 'copygen Shop Content',
               // 'icon' => 'font',
            //  ],
           // 4
         // );
          $elements_manager->add_category(
              '104',
              [
                'title'  => 'Copygen Footer',
                'icon' => 'font',
              ],
            5
          );
	    }
      /**
      * Get All ths scriptis and styles
      *
      * @return void
      */
      public function copygen_enqueue_scripts(){
     
      global $copygen_theme_mod;
      $rtl_enable = isset( $copygen_theme_mod['rtl_enables'] ) ? $copygen_theme_mod['rtl_enables'] : ''; 
      if(is_rtl() || $rtl_enable == true || get_post_meta(get_the_ID() , 'rtl_enable_for_particular', true) == true):
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.rtl.min.css', array() , '5.2.3', 'all');
      elseif((is_page()  || is_singular(array('project' , 'service' , 'post' , 'product'))) && get_post_meta(get_the_ID() , 'rtl_enable_for_particular', true)):
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.rtl.min.css', array() , '5.2.3', 'all');
      else:
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.min.css', array() , '5.2.3', 'all');
      endif;
      // theme main files
      wp_enqueue_style('copygen-meta-box', get_template_directory_uri() . '/assets/css/metabox.css' );    
      wp_enqueue_style('copygen-style', get_template_directory_uri().'/style.css' , array() , time() , 'all');  
      wp_enqueue_style('carousel-style', COPYGEN_ADDONS_URL . 'assets/css/owl.css' , array() , time() , 'all');
      wp_enqueue_style('fancybox-style', COPYGEN_ADDONS_URL . 'assets/css/jquery.fancybox.min.css' , array() , time() , 'all');   
      wp_enqueue_style('copygen-main-style', get_template_directory_uri() . '/assets/css/theme.css' , array() , time(), 'all'); 
      if(is_rtl() || $rtl_enable == true):
        wp_enqueue_style('copygen-main-rtl', get_template_directory_uri() . '/assets/css/rtl.css', array() , '1.0.0', 'all');
      elseif((is_page()  || is_singular(array('project' , 'service' , 'post' , 'product'))) && get_post_meta(get_the_ID() , 'rtl_enable_for_particular', true)):
        wp_enqueue_style('copygen-main-rtl', get_template_directory_uri() . '/assets/css/rtl.css', array() , '1.0.0', 'all');
      endif;
      if(is_singular() && comments_open() && get_option('thread_comments')):
          wp_enqueue_script('comment-reply');
      endif;
      // ============================================================js start===================================================================================
      wp_enqueue_script('bootstrap-bundle', get_template_directory_uri() . '/assets/js/plugins/bootstrap.bundle.min.js', array('jquery') , '5.2.3', true);
      wp_enqueue_script('appear', COPYGEN_ADDONS_URL . 'assets/js/plugins/appear.js', array('jquery') , '10.0', true);
      wp_enqueue_script('waypoints',  COPYGEN_ADDONS_URL . 'assets/js/plugins/waypoints.js', array('jquery') , '4.0.1', true);
      wp_enqueue_script('fancybox',  COPYGEN_ADDONS_URL . 'assets/js/plugins/jquery.fancybox.js', array('jquery') , '3.2.10', true);
      wp_enqueue_script('carousel', COPYGEN_ADDONS_URL . 'assets/js/plugins/owl.js', array('jquery') , '9.2.0', true);
      wp_enqueue_script('isotope',  COPYGEN_ADDONS_URL . 'assets/js/plugins/isotope.min.js', array('jquery') , '3.0.6', true);
      wp_enqueue_script('share', COPYGEN_ADDONS_URL . 'assets/js/plugins/sharer.min.js', array('jquery') , '1.0.0', true); 
      wp_enqueue_script('counterup', COPYGEN_ADDONS_URL . 'assets/js/plugins/counterup.js', array('jquery') , '2.0.0', true); 
      wp_enqueue_script('copygen-main', COPYGEN_ADDONS_URL . 'assets/js/main.js', array('jquery' , 'imagesloaded') , '1.0.0', true);
  
      if(is_rtl() || $rtl_enable == true):
        wp_enqueue_script('copygen-carousel-rtl-active', COPYGEN_ADDONS_URL . 'assets/js/main-rtl-active.js', array('jquery') , '1.0.0', true);
      elseif((is_page()  || is_singular(array('project' , 'service' , 'post' , 'product'))) && get_post_meta(get_the_ID() , 'rtl_enable_for_particular', true)):
        wp_enqueue_script('copygen-carousel-rtl-active', COPYGEN_ADDONS_URL . 'assets/js/main-rtl-active.js', array('jquery') , '1.0.0', true);
      else:
        wp_enqueue_script('copygen-carousel-active', COPYGEN_ADDONS_URL . 'assets/js/main-ltr-active.js', array('jquery') , '1.0.0', true);
      endif;

    }
   
    /**
    * Get All ths Elementor Call back scripts
    *
    * @return void
    *  
   * public function copygen_elementor_scripts(){
       *  wp_enqueue_style('uicons', get_template_directory_uri() . '/assets/css/vendors/uicons-regular-straight.css', array() , '1.0.0', 'all');
       *  wp_enqueue_style('icomoon', get_template_directory_uri() . '/assets/fonts/icomoon/icomoon.css', array() , '1.0.0', 'all');
    * } 
    */
   
}