<?php
/*
** ===================
** copygen Service
** Post type : Service;
** version: 1.0;
** Authour : Steeltheme;
** ===================
*/
namespace copygenaddons\Plugins;
if (! defined('ABSPATH' )){
	die('-1');
}
class Service{
   
	public function __construct() {
		add_action('init', array($this, 'service_custom_post_type'));  
		add_action('init', array($this, 'service_custom_taxonomies')); 
 
	}
	public function service_custom_post_type() {
		register_post_type( 'service',
		array(
			'labels' => array(
				'name' => esc_html_x('Services', 'Post Type General Name', 'copygen-addons') ,
				'singular_name' => esc_html_x('Service', 'Post Type General Name', 'copygen-addons') , 
				'add_new' =>  esc_html__('Add New', 'copygen-addons'),
				'add_new_item' =>   esc_html__('Add New Service', 'copygen-addons'),
				'edit' => esc_html__('Edit', 'copygen-addons'),
				'edit_item' =>   esc_html__('Edit Service', 'copygen-addons'),
				'new_item' =>   esc_html__('New Service', 'copygen-addons'),
				'view' =>  esc_html__('View', 'copygen-addons'),
				'view_item' =>    esc_html__('View Service', 'copygen-addons'),
				'search_items' =>   esc_html__('Search Service', 'copygen-addons'),
				'not_found' =>   esc_html__('No Service found', 'copygen-addons'),
				'not_found_in_trash' =>  esc_html__('No Service found in Trash', 'copygen-addons'),
				'parent' =>  esc_html__('Parent Service', 'copygen-addons')
			),
		
			'public' => true,
			'show_in_rest' => true,
			'menu_position' => 15,
			'supports' => array( 'title', 'editor', 'comments', 'thumbnail', 'excerpt'  ),
			'taxonomies' => array( '' ),
			'show_in_nav_menus'   => true,
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-format-aside',
			'has_archive' => false,
			'capability_type'    => 'post',
			'hierarchical'          => true,
		)
		 
		);
	}
	public function service_custom_taxonomies() {

		//add new taxonomy hierarchical
		$labels = array(
			'name' =>   esc_html__('Service Categories', 'copygen-addons'),
			'singular_name' =>  esc_html__('Category', 'copygen-addons'),
			'search_items' =>  esc_html__('Search Category', 'copygen-addons'),
			'all_items' =>  esc_html__('All Category', 'copygen-addons'),
			'parent_item' =>  esc_html__('Parent Category', 'copygen-addons'),
			'parent_item_colon' =>   esc_html__('Parent Category:', 'copygen-addons'),
			'edit_item' =>   esc_html__('Edit Category', 'copygen-addons'),
			'update_item' =>   esc_html__('Update Category', 'copygen-addons'),
			'add_new_item' =>  esc_html__('Add New Service Category', 'copygen-addons'),
			'new_item_name' =>   esc_html__('New Category Name', 'copygen-addons'),
			'menu_name' => esc_html__('Categories', 'copygen-addons')
		);
		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'public'             => true,
			'publicly_queryable' => true,
			'show_in_rest' => true,
			'rewrite' => array( 'slug' => 'service_category' )
		);
		register_taxonomy('service_category', array('service'), $args);
		//add new taxonomy NOT hierarchical
	}
}

?>