<?php
/*
** ===================
** copygen Portfolio
** Post type : Portfolio;
** version: 1.0;
** Authour : Steeltheme;
** ===================
*/
namespace copygenaddons\Plugins;
if (! defined('ABSPATH' )){
	die('-1');
}
class Portfolio{
   
	public function __construct() {
		add_action('init', array($this, 'portfolio_custom_post_type'));  
		add_action('init', array($this, 'portfolio_custom_taxonomies')); 
 
	}
	public function portfolio_custom_post_type() {
		register_post_type( 'portfolio',
		array(
			'labels' => array(
				'name' => esc_html_x('Portfolios', 'Post Type General Name', 'copygen-addons') ,
				'singular_name' => esc_html_x('Portfolio', 'Post Type General Name', 'copygen-addons') , 
				'add_new' =>  esc_html__('Add New', 'copygen-addons'),
				'add_new_item' =>   esc_html__('Add New Portfolio', 'copygen-addons'),
				'edit' => esc_html__('Edit', 'copygen-addons'),
				'edit_item' =>   esc_html__('Edit Portfolio', 'copygen-addons'),
				'new_item' =>   esc_html__('New Portfolio', 'copygen-addons'),
				'view' =>  esc_html__('View', 'copygen-addons'),
				'view_item' =>    esc_html__('View Portfolio', 'copygen-addons'),
				'search_items' =>   esc_html__('Search Portfolio', 'copygen-addons'),
				'not_found' =>   esc_html__('No Portfolio found', 'copygen-addons'),
				'not_found_in_trash' =>  esc_html__('No Portfolio found in Trash', 'copygen-addons'),
				'parent' =>  esc_html__('Parent Portfolio', 'copygen-addons')
			),
			'public' => true,
			'show_in_rest' => true,
			'menu_position' => 15,
			'supports' => array( 'title', 'excerpt' , 'thumbnail' , 'editor' , 'page-attributes' ),
			'taxonomies' => array( '' ),
			'show_in_nav_menus'   => true,
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-tagcloud',
			'has_archive' => false,
			'capability_type'    => 'post',
			'hierarchical'          => true,
		)
	);
}
public function portfolio_custom_taxonomies() {
		//add new taxonomy hierarchical
		$labels = array(
			'name' =>   esc_html__('Portfolio Categories', 'copygen-addons'),
			'singular_name' =>  esc_html__('Category', 'copygen-addons'),
			'search_items' =>  esc_html__('Search Category', 'copygen-addons'),
			'all_items' =>  esc_html__('All Category', 'copygen-addons'),
			'parent_item' =>  esc_html__('Parent Category', 'copygen-addons'),
			'parent_item_colon' =>   esc_html__('Parent Category:', 'copygen-addons'),
			'edit_item' =>   esc_html__('Edit Category', 'copygen-addons'),
			'update_item' =>   esc_html__('Update Category', 'copygen-addons'),
			'add_new_item' =>  esc_html__('Add New Portfolio Category', 'copygen-addons'),
			'new_item_name' =>   esc_html__('New Category Name', 'copygen-addons'),
			'menu_name' => esc_html__('Categories', 'copygen-addons')
		);
		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'public'             => true,
			'publicly_queryable' => true,
			'show_in_rest' => true,
			'rewrite' => array( 'slug' => 'portfolio_category' )
		);
		register_taxonomy('portfolio_category', array('portfolio'), $args);
		//add new taxonomy NOT hierarchical
	}
}

?>