<?php

namespace  Copygenaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Service_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-service-v1';
    }

    public function get_title()
    {
        return __('Service Post  V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('service_settings',
        [ 
            'label' => __('Service Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'service_style',
            [
                'label' => __('Service style', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'copygen-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'copygen-addons' ),
                    'style_three'   => esc_html__( 'Style Three', 'copygen-addons' ), 
                    'style_four'   => esc_html__( 'Style Four', 'copygen-addons' ), 
                    'style_five' => esc_html__( 'Style Five', 'copygen-addons' ), 
                ],
                'default' => 'style_one',
              
            ]
        );


        $this->add_control(
            'service_column',
            [
                'label' => __('Service Column', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'copygen-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'copygen-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'copygen-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'copygen-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
                 
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Service Count', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'copygen-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'copygen-addons' ),
					'title'      => esc_html__( 'Title', 'copygen-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'copygen-addons' ),
					'rand'       => esc_html__( 'Random', 'copygen-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'copygen-addons' ),
					'ASC'  => esc_html__( 'ASC', 'copygen-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__('Category', 'copygen-addons'),
			'options' => copygen_get_service_categories(),
			]
        );

        $this->add_control(
            'excerpt_enable',
           [
              'label' => __('Excerpt Enable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'ajax_loadmore',
           [
              'label' => __('Ajax Load More Enable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'load_more',
            [
                'label' => __( 'Load More', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Load More', 'copygen-addons' ),
                'condition' => [
                    'ajax_loadmore' => 'yes'
               ],
            ]
        );
        $this->add_control(
            'pagination_enable',
           [
              'label' => __('Pagination Enable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
    
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('Pagination alignments', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'left' => [
                    'title' => __( 'Pagination Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Pagination Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                    'title' => __( 'Pagination Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes'
               ],
            ]
        );


        $this->add_control(
			'hrp',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'pagination_enable' => 'yes'
                ],
			]
		);

        $this->add_control(
            'pagcolor',
            [
                'label' => __('Pagination Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagacolor',
            [
                'label' => __('Pagination Active Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxticoncolor',
            [
                'label' => __('Pagination Next / Prev  Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtpreviconcolor',
            [
                'label' => __('Pagination Next / Prev Border Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtbgcolor',
            [
                'label' => __('Pagination Next / Prev Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

       

        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
			]
		);
           
        $this->add_control(
            'load_more_color',
            [
                'label' => __('Load More Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'load_morebg_color',
            [
                'label' => __('Load More Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );


        $this->add_control(
            'load_ho_more_color',
            [
                'label' => __('Load More Hover Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'loadho_morebg_color',
            [
                'label' => __('Load More Hover Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
     
    $this->end_controls_section();

    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .content_box .icon i , {{WRAPPER}} .service_box.type_one .content_box .content_inner .icon i ,
                {{WRAPPER}} .service_box.type_three .content_box .content_box_in .icon i , {{WRAPPER}} .service_box.type_four .icon i , {{WRAPPER}} .service_box.type_five .icon i
                ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'icon_bg_color',
         [
            'label' => __('Icon Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .content_box .icon , {{WRAPPER}} .service_box.type_one .content_box .content_inner .icon 
                {{WRAPPER}} .service_box.type_five  .icon , ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four'] ,
            ],
         ]
    );
    $this->add_control(
        'icon_ho_bg_color',
         [
            'label' => __('Icon Hover Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two:hover .content_box .icon , {{WRAPPER}} .service_box.type_two:hover .img_bx 
                , {{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .icon ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two'] ,
           ],
         ]
    );
    $this->add_control(
        'icon_ho_color',
         [
            'label' => __('Icon Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two:hover .content_box .icon i  , {{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .icon i , {{WRAPPER}} .service_box.type_four:hover .icon i  ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four'] ,
           ],
         ]
    );
    
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box .title_24 a , {{WRAPPER}}  .service_box .title_22 a ,  {{WRAPPER}} .service_box span:after ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'title_hover_color',
         [
            'label' => __('Title Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box:hover .title_24 a  , {{WRAPPER}}  .service_box:hover .title_22 a  , {{WRAPPER}}   .service_box:hover span:after' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_color',
         [
            'label' => __('Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box p , {{WRAPPER}} .service_box.type_four p ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_hover_color',
         [
            'label' => __('Content Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner p , {{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in p  
                , {{WRAPPER}} .service_box.type_four:hover p  ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_three' , 'style_four']
            ],
         ]
    );
    $this->add_control(
        'link_color',
         [
            'label' => __('Link Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .rd_more , {{WRAPPER}} .rd_more  i , {{WRAPPER}} .service_box.type_three .content_box .content_box_in a.rd_more ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .link svg path  , {{WRAPPER}} .service_box.type_five  .rd_more svg path ' => 'stroke: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_three .content_box .content_box_in a.rd_more  ' => ' text-decoration-color: {{VALUE}}!important;',
                '{{WRAPPER}}  a.rd_more svg path  ' => ' fill: {{VALUE}}!important;',            ],
         ]
    );
    $this->add_control(
        'link_border_color',
         [
            'label' => __('Link Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .link ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'] ,
           ],
         ]
    );
    $this->add_control(
        'link_hover_color',
         [
            'label' => __('Link Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .rd_more:hover , {{WRAPPER}} .rd_more:hover 1 ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .link svg path' => 'stroke: {{VALUE}}!important;', 
                 '{{WRAPPER}} .service_box.type_four:hover a.rd_more svg path  ' => ' fill: {{VALUE}}!important;',    
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four'] ,
           ],
         ]
    );
    $this->add_control(
        'link_two_hover_color',
         [
            'label' => __('Link Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in a.rd_more , {{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in a.rd_more i ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                
            ],
            'condition' => [
                'service_style' => ['style_three'] ,
           ],
         ]
    );
    $this->add_control(
        'link_hover_bor_color',
         [
            'label' => __('Link Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box.type_one:hover .content_box .content_inner .link' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'] ,
           ],
         ]
    );
    $this->add_control(
        'overlay_color',
         [
            'label' => __('Overlay Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .hover_1 .oh , {{WRAPPER}} .service_box.type_one .content_box .content_inner:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_three'] ,
           ],
         ]
    );
    $this->add_control(
        'box_bg_color',
         [
            'label' => __('Box Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two , {{WRAPPER}} .service_box.type_one .content_box .content_inner , {{WRAPPER}} .service_box.type_three .content_box .content_box_in
               , {{WRAPPER}} .service_box.type_four  , {{WRAPPER}} .icon_box_only.type_three .icon_inner
                ' => 'background: {{VALUE}}!important;',
            ],
            
         ]
    );

    $this->add_control(
        'hobox_bg_color',
         [
            'label' => __('Hover Box Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in , {{WRAPPER}} .service_box.type_four.hover_1 .oh' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_three' , 'style_four'] ,
           ],
         ]
    );
   
    $this->add_control(
        'other_content_color',
         [
            'label' => __('Other Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .img_bx ' => 'background: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_two .content_box .steps , {{WRAPPER}} .service_box.type_one .content_box .content_inner .steps , 
                {{WRAPPER}} .service_box.type_four .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four'] ,
           ],
         ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Line Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_four .line_box .line , {{WRAPPER}} .service_box.type_five:before ' => 'background: {{VALUE}}',
            ],
            'condition' => [
                'service_style' => ['style_four' , 'style_five'] ,
           ],
         ]
    );

    $this->add_control(
        'border_hover_color',
         [
            'label' => __('Border Hover Line Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_four:hover .line_box .line ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_four'] ,
           ],
         ]
    );
    $this->add_control(
        'border_thover_color',
         [
            'label' => __('Border Hover Line Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_five:hover:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_five'] ,
           ],
         ]
    );
    $this->add_control(
        'other_content_ho_color',
         [
            'label' => __('Other Content Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .steps , {{WRAPPER}} .service_box.type_three .content_box .content_box_in .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_three'],
            ],
         ]
    );

    
   
   
$this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="service_post position-relative <?php if($settings['ajax_loadmore'] == 'yes'): ?> ajax_service_enabled <?php endif; ?>"   data-scroll>
        <div class="row ajaxservicecontainer">
        <?php if(get_query_var( 'paged')){ 
                        $paged = get_query_var( 'paged' ); 
                        } elseif ( get_query_var( 'page' ) ) { 
                        $paged = get_query_var( 'page' ); 
                        } else { 
                        $paged = 1; 
                    }
                  $query_args = array(
                        'post_type' => 'service',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'paged'  => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['service_category'] = $settings['query_category'];
                     
                        $service_query = new \WP_Query( $query_args );
                    ?>
                    <?php if($service_query->have_posts()):
                        while($service_query->have_posts()) : $service_query->the_post();
                        global $post;
                        $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                        $service_icon_type = get_post_meta(get_the_ID() , 'service_icon_type', true);
                        $ser_icon = get_post_meta(get_the_ID() , 'ser_icon', true);
                        $ser_icon_img = get_post_meta(get_the_ID() , 'ser_icon_img', true);
                        $serv_steps = get_post_meta(get_the_ID() , 'serv_steps', true);
                        // while loop start ?>
                        <?php // servie style ?>
						<?php if($settings['service_style'] == 'style_one'): ?>
                        <?php // servie style ?>    
                            <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
                                <div class="service_box type_one">
                                    <?php if(has_post_thumbnail()): ?>
                                        <a href="<?php echo esc_url(get_permalink()); ?>">
                                            <div class="image"> 
                                                <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                    <div class="content_box"> 
                                        <div class="content_inner trans">
                                        <?php if($service_icon_type == 'image'): ?>
                                            <?php if(!empty($ser_icon_img['url'])): ?>
                                            <div class="icon trans">
                                                <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                            </div>
                                            <?php endif; ?>
                                        <?php elseif($service_icon_type == 'icon'): ?>
                                            <div class="icon trans">
                                                <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                        <h4 class="title_24 trans" data-splitting>
                                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                        </h4>
                                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                                                <p class="trans">
                                                    <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                                                </p> 
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <a class="link trans" href="<?php echo esc_url(get_permalink()); ?>">
                                            <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M1 12.25L12.25 1M12.25 1H3.8125M12.25 1V9.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_two'): ?>
                        <?php // servie style ?>    
                            <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
                                <div class="service_box type_two hover_1_get">
                                    <?php if(has_post_thumbnail()): ?>
                                        <a href="<?php echo esc_url(get_permalink()); ?>" class="img_bx">
                                            <div class="image trans hover_1"> 
                                                <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                                <div class="oh ho_1"></div>
                                                <div class="oh ho_2"></div>
                                                <div class="oh ho_3"></div>
                                                <div class="oh ho_4"></div>
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                    <div class="content_box trans"> 
                                       
                                        <?php if($service_icon_type == 'image'): ?>
                                            <?php if(!empty($ser_icon_img['url'])): ?>
                                            <div class="icon trans">
                                                <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                            </div>
                                            <?php endif; ?>
                                        <?php elseif($service_icon_type == 'icon'): ?>
                                            <div class="icon trans">
                                                <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                        <h4 class="title_24 trans" data-splitting>
                                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                        </h4>
                                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                                                <p class="trans">
                                                    <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                                                </p> 
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_html__('Read More' , 'copygen-addons'); ?><i class="fi-rr-arrow-small-right"></i></a>
                                
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_three'): ?>
                        <?php // servie style ?>    
                            <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
                                <div class="service_box type_three hover_1_get">
                                    <?php if(has_post_thumbnail()): ?>
                                        <a href="<?php echo esc_url(get_permalink()); ?>" class="img_bx">
                                            <div class="image trans hover_1"> 
                                                <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                                <div class="oh ho_1"></div>
                                                <div class="oh ho_2"></div>
                                                <div class="oh ho_3"></div>
                                                <div class="oh ho_4"></div>
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                    <div class="content_box trans">
                                        <div class="content_box_in trans"> 
                                            <?php if($service_icon_type == 'image'): ?>
                                                <?php if(!empty($ser_icon_img['url'])): ?>
                                                <div class="icon trans">
                                                    <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                                </div>
                                                <?php endif; ?>
                                            <?php elseif($service_icon_type == 'icon'): ?>
                                                <div class="icon trans">
                                                    <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                                </div>
                                            <?php endif; ?>
                                            <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                            <h4 class="title_24 trans" data-splitting>
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                                                <p class="trans">
                                                    <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                                                </p> 
                                            <?php endif; ?>
                                        <?php endif; ?>
                                            <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_html__('Read More' , 'copygen-addons'); ?><i class="fi-rr-arrow-small-right"></i></a>
                                        </div>
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_four'): ?>
                        <?php // servie style ?>    
                        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
                                <div class="service_box type_four  hover_1_get   hover_1">
                                <div class="oh ho_1"></div>
                                <div class="oh ho_2"></div>
                                <div class="oh ho_3"></div>
                                <div class="oh ho_4"></div>
                            <div class="content_box trans">
                                <div class="top">
                                <?php if($service_icon_type == 'image'): ?>
                                    <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                    <?php endif; ?>
                                <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                <?php endif; ?>
                                <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                <h4 class="title_24 trans" data-splitting>
                                    <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                </h4>
                                </div>
                                <div class="line_box">
                                    <div class="line"></div>
                                </div>
                                <div class="bottom">
                                <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                                                <p class="trans">
                                                    <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                                                </p> 
                                            <?php endif; ?>
                                        <?php endif; ?>
                                <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more">
                                    <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.60161 0H19.6641C19.9128 0 20.1512 0.0987719 20.327 0.274587C20.5028 0.450403 20.6016 0.68886 20.6016 0.9375V15C20.6016 15.2486 20.5028 15.4871 20.327 15.6629C20.1512 15.8387 19.9128 15.9375 19.6641 15.9375C19.4155 15.9375 19.177 15.8387 19.0012 15.6629C18.8254 15.4871 18.7266 15.2486 18.7266 15V3.2L1.57661 20.35C1.3989 20.5156 1.16384 20.6058 0.920961 20.6015C0.678085 20.5972 0.446354 20.4988 0.274588 20.327C0.102821 20.1553 0.00443133 19.9235 0.000146059 19.6807C-0.00413921 19.4378 0.0860148 19.2027 0.251615 19.025L17.4016 1.875H5.60161C5.35297 1.875 5.11452 1.77623 4.9387 1.60041C4.76289 1.4246 4.66411 1.18614 4.66411 0.9375C4.66411 0.68886 4.76289 0.450403 4.9387 0.274587C5.11452 0.0987719 5.35297 0 5.60161 0Z" fill="white"/>
                                    </svg>
                                </a>
                                </div>
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_five'): ?>
                        <?php // servie style ?>  
                        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
                        <div class="service_box type_five icon_box_only type_three trans" data-scroll>
                            <div class="icon_inner trans">
                            <div class="d-flex trans"> 
                            <?php if($service_icon_type == 'image'): ?>
                                    <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                    <?php endif; ?>
                                <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                <?php endif; ?>
                                <div class="content">
                     
                                    <div class="title_22" data-splitting>
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                    </div>
                   
                                <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                                                <p class="trans">
                                                    <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                                                </p> 
                                            <?php endif; ?>
                                        <?php endif; ?>
                                
                                        <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more">
                                        <?php echo esc_html__('Read More' , 'copygen-addons'); ?> 
                                        <svg width="14" height="12" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8 1L13 6M13 6L8 11M13 6H1" stroke="var(--color-white)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>

                                        </a>
                                </div>
                        </div>
                            </div>
                        </div>
                        </div>
                        <?php // servie style ?>              
                            <?php endif; ?>
                        <?php // servie style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
    <!--End tab-content-->
    <?php if($settings['pagination_enable'] == 'yes' || $settings['ajax_loadmore'] == 'yes'):?>
            <div class="row">
        <div class="col-lg-12">
        <div class="pagination-area pagination">
           
        <?php
            if($settings['ajax_loadmore'] == 'yes'):
                $prev = '';
                $next = '<span class="theme_btn">'.$settings['load_more'].'</span>';
                $type = 'plain';
            elseif($settings['pagination_enable'] == 'yes'):
                $prev = '<i class="fa fa-angle-left"></i>';
                $next = '<i class="fa fa-angle-right"></i>';
                $type = 'list';
            endif;
            $pagination = 999999999;
            echo paginate_links( array(
                    'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
                    'format' => '?paged=%#%',
                    'current' => max( 1, get_query_var('paged') ),
                    'total' => $service_query->max_num_pages,
                    'prev_text' => $prev,
                    'next_text' => $next,
                    'type'=> $type,
                    'add_args' => false
                ) );
            ?>          
            </div>
            </div>     
            </div> 
            <?php endif; ?>  
</section>
 
        <?php
    }
}

         