<?php

namespace  Copygenaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Blog_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-blog-v1';
    }

    public function get_title()
    {
        return __('Blog Post  V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('blog_settings',
        [ 
            'label' => __('Blog Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'blog_style',
            [
                'label' => __('Blog style', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'copygen-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'copygen-addons' ), 
                ],
                'default' => 'style_one',
            ]
        );
        $this->add_control(
            'enable_list',
           [
                'label' => __('List Type  Enable / Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'blog_style' => ['style_one' , 'style_two']
                ],
           ]
        );
        $this->add_control(
            'cut_list',
           [
                'label' => __('Cut Title in Two Line Enable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no', 
           ]
        );
        $this->add_control(
            'blog_column',
            [
                'label' => __('Blog Column', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'copygen-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'copygen-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'copygen-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'copygen-addons' ),
                ],
                'default' => 'col-xl-4 col-lg-4 col-md-6 col-sm-6',
            ]
        );
        $this->add_control(
            'post_count',
            [
                'label' => __('Blog Count', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'copygen-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'copygen-addons' ),
					'title'      => esc_html__( 'Title', 'copygen-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'copygen-addons' ),
					'rand'       => esc_html__( 'Random', 'copygen-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'copygen-addons' ),
					'ASC'  => esc_html__( 'ASC', 'copygen-addons' ),
				),
			]
        );
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__('Category', 'copygen-addons'),
			'options' => copygen_get_blog_categories(),
			]
        );
        $this->add_control(
            'excerpt_enable',
           [
              'label' => __('Excerpt  Enable / Disable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'ajax_loadmore',
           [
              'label' => __('Ajax Load More Enable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'load_more',
            [
                'label' => __( 'Load More', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Load More', 'copygen-addons' ),
                'condition' => [
                    'ajax_loadmore' => 'yes'
               ],
            ]
        );
        
        $this->add_control(
            'pagination_enable',
           [
              'label' => __('Pagination Enable', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'copygen-addons'),
               'label_off' => __('No', 'copygen-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
    
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('Pagination alignments', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'start' => [
                    'title' => __( 'Pagination Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Pagination Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'end' => [
                    'title' => __( 'Pagination Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important; justify-content: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes'
               ],
            ]
        );


        $this->add_control(
			'hrp',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'pagination_enable' => 'yes'
                ],
			]
		);

        $this->add_control(
            'pagcolor',
            [
                'label' => __('Pagination Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'pabr_color',
             [
                'label' => __('Pagination Border Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
             ]
        );
        $this->add_control(
            'pabg_color',
             [
                'label' => __('Pagination Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
             ]
        );
        $this->add_control(
            'pagacolor',
            [
                'label' => __('Pagination Active  / Hover Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'pagbracolor',
            [
                'label' => __('Pagination Active  / Hover Border Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ,
                    {{WRAPPER}}.pagination li a.page-link:hover , {{WRAPPER}}   .pagination li .page-numbers:hover , {{WRAPPER}}  .page-numbers li a.page-link:hover , {{WRAPPER}}  .page-numbers li .page-numbers:hover ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'pagbgdacolor',
            [
                'label' => __('Pagination Active  / Hover Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover  ,
                    {{WRAPPER}}.pagination li a.page-link:hover , {{WRAPPER}}   .pagination li .page-numbers:hover , {{WRAPPER}}  .page-numbers li a.page-link:hover , {{WRAPPER}}  .page-numbers li .page-numbers:hover' => 'background-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );
 
        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
			]
		);
           
        $this->add_control(
            'load_more_color',
            [
                'label' => __('Load More Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'load_morebg_color',
            [
                'label' => __('Load More Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );


        $this->add_control(
            'load_ho_more_color',
            [
                'label' => __('Load More Hover Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'loadho_morebg_color',
            [
                'label' => __('Load More Hover Bg Color', 'copygen-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
    
        $this->end_controls_section();
        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'blog_box',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .blog.style_one  ',
            ]
        );
        $this->add_control(
            'bhrz',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadowcolor',
                'selector' => '{{WRAPPER}} .blog.style_one ', 
            ]
        ); 
        $this->add_control(
            'bhr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Category Typography', 'copygen-addons' ),
				'name' => 'cat_typo',
				'selector' => '{{WRAPPER}}  .blog.style_one .cat_gry ',
			]
		); 
        $this->add_control(
            'cat_color',
             [
                'label' => __('Category Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog.style_one .cat_gry ' => 'color: {{VALUE}}!important;',
                ],
             ]
        ); 
        $this->add_control(
            'cbg_color',
             [
                'label' => __('Category Bg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .blog.style_one .cat_gry ' => 'background: {{VALUE}}!important;', 
                ],
             ]
        );
        $this->add_control(
            'bhr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Title Typography', 'copygen-addons' ),
				'name' => 'tit_typo',
				'selector' => '{{WRAPPER}} .blog .title_24 a ',
			]
		); 
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog .title_24 a ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'bhr4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Description Typography', 'copygen-addons' ),
				'name' => 'des_typo',
				'selector' => '{{WRAPPER}} .blog p',
			]
		); 
        $this->add_control(
            'expert_color',
             [
                'label' => __('Description Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog p ' => 'color: {{VALUE}}!important;', 
                ], 
             ]
        );
        $this->add_control(
            'bhr5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Authour Typography', 'copygen-addons' ),
				'name' => 'authour_typo',
				'selector' => '{{WRAPPER}}  .blog .media-group .media-text span.lead-text ',
			]
		); 
        $this->add_control(
            'authour_color',
             [
                'label' => __('Authour Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog .media-group .media-text span.lead-text ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'bhr6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Meta Typography', 'copygen-addons' ),
				'name' => 'mta_typo',
				'selector' => '{{WRAPPER}} .nk-list-meta li a , {{WRAPPER}} .nk-list-meta li time ',
			]
		); 
        $this->add_control(
            'meta_color',
             [
                'label' => __('Meta Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .nk-list-meta li a , {{WRAPPER}} .nk-list-meta li time' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'metado_color',
             [
                'label' => __('Dot Bg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .nk-list-meta li::after ' => 'background: {{VALUE}}!important;',
                ],
             ]
        );
       
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="blog_post position-relative<?php if($settings['cut_list'] == 'yes'): ?> cut_title <?php endif; ?><?php if($settings['ajax_loadmore'] == 'yes'): ?> ajax_posts_enabled <?php endif; ?>" data-scroll>
        <div class="row ajaxcontainer">
                <?php if(get_query_var( 'paged')){ 
                        $paged = get_query_var( 'paged' ); 
                        } elseif ( get_query_var( 'page' ) ) { 
                        $paged = get_query_var( 'page' ); 
                        } else { 
                        $paged = 1; 
                    }
                  $query_args = array(
                        'post_type' => 'post',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'paged'             => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['category_name'] = $settings['query_category'];
                     
                        $blog_query = new \WP_Query( $query_args );
                    ?>
                    <?php if($blog_query->have_posts()):
                            while($blog_query->have_posts()) : $blog_query->the_post();
                            global $post;
                              
                            $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                            $post_video_link_get = '';
                            $post_video_link = get_post_meta(get_the_ID() , 'post_video_link', true);
                            if(!empty($post_video_link)):
                                $post_video_link_get = $post_video_link;
                            endif;
                        // while loop start ?>
                        <?php // blog style ?>
                            <?php if($settings['blog_style'] == 'style_two'): ?>
                        <?php // blog style ?>    
                            <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog style_one style_two<?php if($settings['enable_list'] == 'yes'): ?> list_view<?php endif; ?><?php if(!empty($featured_img_url)): ?> yes_image<?php endif; ?>">
                                <?php if(!empty($featured_img_url)): ?>
                                <div class="card-image mb-4">
                                <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="lightbox-image blog_video">
                                    <i class="fa fa-play"></i>
                                </a>
                                <?php endif; ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <img class="card-img" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="card-content">
                                <?php do_action('copygen_theme_blog_category'); ?>
                                <?php the_title( '<h5 class="title_24"  data-splitting><a href="' .  esc_url(get_permalink()) . '" rel="bookmark">', '</a></h5>' ); ?>
                                <?php if($settings['excerpt_enable'] == 'yes'):
                                    $excerpt = '';
                                    if (has_excerpt()): ?>
                                        <p class="descs">
                                            <?php 
                                                $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                echo esc_attr($excerpt);
                                            ?>
                                        </p> 
                                     <?php endif; ?>
                                <?php endif; ?>
                                <div class="card-divider"></div>
                                    <ul class="nk-list-meta smaller">
                                        <li><?php do_action('copygen_theme_blog_time'); ?></li>
                                        <li><?php do_action('copygen_theme_blog_comments'); ?></li>
                                    </ul>
                                </div>
                            </div> 
                            </div>
                        <?php // blog style ?>              
                        <?php else: ?>
                        <?php // blog style ?>
                        <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog style_one <?php if($settings['enable_list'] == 'yes'): ?>list_view <?php endif; ?><?php if(!empty($featured_img_url)): ?>yes_image<?php endif; ?>">
                                <?php if(!empty($featured_img_url)): ?>
                                <div class="card-image mb-4">
                                <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="lightbox-image blog_video">
                                    <i class="fa fa-play"></i>
                                </a>
                                <?php endif; ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <img class="card-img" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="card-content">
                                <?php do_action('copygen_theme_blog_category'); ?>
                                <?php the_title( '<h5 class="title_24"  data-splitting><a href="' .  esc_url(get_permalink()) . '" rel="bookmark">', '</a></h5>' ); ?>
                                <?php if($settings['excerpt_enable'] == 'yes'):
                                    $excerpt = '';
                                    if (has_excerpt()): ?>
                                        <p class="descs">
                                            <?php 
                                                $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                echo esc_attr($excerpt);
                                            ?>
                                        </p> 
                                     <?php endif; ?>
                                <?php endif; ?>
                                <div class="media-group align-items-center pt-3">
                                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'copygen-authour', 100 )); ?> 
                                    <div class="media-text">
                                    <span class="lead-text"><?php the_author(); ?></span>
                                    <ul class="nk-list-meta smaller">
                                        <li><?php do_action('copygen_theme_blog_time'); ?></li>
                                        <li><?php do_action('copygen_theme_blog_comments'); ?></li>
                                    </ul>
                                    </div>
                                </div>
                                </div>
                            </div>           
                            </div>
                        <?php // blog style ?>              
                        <?php endif; ?>
                        <?php // blog style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
    <!--End tab-content-->
    <?php if($settings['pagination_enable'] == true):?>
        <div class="row">
            <div class="col-lg-12">
            <?php if($settings['ajax_loadmore'] == 'yes'):
                            $prev = '';
                            $next = '<span class="theme_btn">'.$settings['load_more'].'</span>';
                            $type = 'plain';
                        elseif($settings['pagination_enable'] == 'yes'):
                            $prev = '<i class="fa fa-angle-left"></i>';
                            $next = '<i class="fa fa-angle-right"></i>';
                            $type = 'list';
                        endif;?>
                <div class="pagination_blog pagination-area pagination <?php echo $type ?>">
                
                    <?php
                        $pagination = 999999999;
                        echo paginate_links( array(
                            'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
                            'format' => '?paged=%#%',
                            'current' => max( 1, get_query_var('paged') ),
                            'total' => $blog_query->max_num_pages,
                            'prev_text' => $prev,
                            'next_text' => $next,
                            'type'=> $type,
                            'add_args' => false
                        ) );
                    ?>          
                </div>
            </div>     
        </div> 
    <?php endif; ?>  
</section>
 
        <?php
    }
}

         