<?php

namespace  Copygenaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Header_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-header-v1';
    }

    public function get_title()
    {
        return __('Prebuilt Header V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('headers_settings',
        [ 
            'label' => __('Header Settings', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'logo_default',
        [
            'label' => __( 'Logo Default', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => COPYGEN_ADDONS_URL . '/assets/imgs/logo-dark.png',
            ],
        ] 
       );
    
        $this->add_control(
            'logo_bg',
            [
                'label' => __( 'Logo Bg Color', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_box svg path ' => 'fill: {{VALUE}}',
                ],
            ]
        );

    
       $this->add_control(
        'logo_width',
        [
            'label' => __( 'Logo Width', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( '170px', 'copygen-addons' ),
            'placeholder' => __( 'Enter logo width here in (px , rem and em )', 'copygen-addons' ),
            'selectors' => [
                '{{WRAPPER}} .header .header_logo_box img' => 'width: {{VALUE}}!important;',
            ],
        ]
        );
        $this->add_control(
            'margin_logo',
            [
                'label' => __( 'Margin', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header .header_logo_box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->add_control(
            'custom_link_enable',
            [
                'label' => __('Custom Link show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
    
    
        $this->add_control(
            'logo_link',
            [
                'label' => __( 'Link', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'copygen-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'custom_link_enable' => 'yes'
                ],
            ]
        );
    
        $this->add_control(
            'hr_sear',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'header_width',
            [
              'label' => __('Header Styles', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::SELECT,
              'options' => [
                'no-container' => __( 'No Container', 'copygen-addons' ),
                'full-container' => __( 'Full With Container', 'copygen-addons' ),
                'large-container' => __( 'large Container', 'copygen-addons' ),
                'medium-container' => __( 'medium Container', 'copygen-addons' ),
                'auto-container' => __( 'auto Container', 'copygen-addons' ),
            ],
              'default' => 'auto-container' , 
            ]
         );
    
        $this->add_control(
            'top_bar_enable',
            [
                'label' => __('Top Bar show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
 
        $this->add_control(
            'main_header_enable',
            [
                'label' => __('Main Header show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
    
        $this->end_controls_section();

        $this->start_controls_section('top_content',
        [ 
            'label' => __('Topbar Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
                'top_bar_enable' => 'yes'
            ]
        ]
        );
        
        $this->add_control(
            'working_enable',
            [
                'label' => __('Working Hours Show / Hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'working',
            [
                'label' => __( 'Working Hours', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Working Hours : <span> Sun-monday, 09am-5pm </span>', 'copygen-addons' ),
                'condition' => [
                    'working_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'text_content_enable',
            [
                'label' => __('Text Content show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'text_content',
            [
                'label' => __( 'Content', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Looking for Best Insurance Company?', 'copygen-addons' ),
                'condition' => [
                    'phone_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'phone_enable',
            [
                'label' => __('Phone show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'phone_title',
            [
                'label' => __( 'Phone Title', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Call : ', 'copygen-addons' ),
                'condition' => [
                    'phone_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'phone_number',
            [
                'label' => __( 'Phone Number', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '+000(123)456989', 'copygen-addons' ),
                'condition' => [
                    'phone_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
			'hr_three_mail',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
        $this->add_control(
            'mail_enable',
            [
                'label' => __('Mail Show / Hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'mail_title',
            [
                'label' => __( 'Mail Title', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Mail : ', 'copygen-addons' ),
                'condition' => [
                    'mail_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'mail_id',
            [
                'label' => __( 'Mail Id', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'example@gmail.com', 'copygen-addons' ),
                'condition' => [
                    'mail_enable' => 'yes'
                ],
            ]
        );

        $this->add_control(
			'hr_three',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
 
  
        $this->add_control(
            'language_enable',
            [
                'label' => __('Language List show / hide', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'language_type',
            [
                'label' => __('Language Type', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'custom_language'   => esc_html__( 'Custom Language', 'copygen-addons' ),
                    'using_short_code'   => esc_html__( 'Using Shortcode', 'copygen-addons' ), 
                ],
                'default' => 'custom_language',
                'condition' => [
                    'language_enable' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'defaut_language_texts',
            [
                'label' => __( 'Default Language Text', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'English', 'copygen-addons' ),
                'condition' => [
                    'language_type' => 'custom_language'
                ],
            ]
        );
        $repeater_three = new \Elementor\Repeater();
        $repeater_three->add_control(
        'language_icon_image',
        [
            'label' => __( 'Image', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ] 
       );
        $repeater_three->add_control(
            'language_text',
            [
                'label' => __( 'Language Text', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'English', 'copygen-addons' ),
            ]
        );
  
        $repeater_three->add_control(
            'language_link',
            [
                'label' => __( 'Link', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'copygen-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'language_repeater',
            [
                'label' => __('Language Content', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_three->get_controls(),
                'default' => [
                    [
                       'language_text' =>  __('Français', 'copygen-addons'),
                       'language_link' =>  __('#', 'copygen-addons'),
                    ],
                    [
                        'language_text' =>  __('Deutsch', 'copygen-addons'),
                        'language_link' =>  __('#', 'copygen-addons'),
                    ],
                    [
                        'language_text' =>  __('Pусский ', 'copygen-addons'),
                        'language_link' =>  __('#', 'copygen-addons'),
                    ], 
                ],
                'title_field' => '{{{ language_text }}}',
                'condition' => [
                    'language_type' => 'custom_language'
                ],
            ]
        );

        
    $this->add_control(
        'language_shortcode',
        [
            'label' => __( 'Language Shortcode', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( '[trp_language language="en_US"]', 'copygen-addons' ),
            'condition' => [
                'language_type' => 'using_short_code'
            ],
        ]
    );

    $this->add_control(
        'hr_three_med',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
    );

 
    $this->add_control(
        'media_enable',
        [
            'label' => __('Media show / hide', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );

    $repeater = new \Elementor\Repeater();
  
    $repeater->add_control(
        'social_media_icon',
        [
            'label' => __( 'Social Media Icon', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'fa fa-facebook', 'copygen-addons' ),
            'placeholder' => __( 'Type your Socail Media Icon Class Name', 'copygen-addons' ),
        ]
    );
    $repeater->add_control(
        'socail_media_link',
        [
            'label' => __( 'Link', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __( 'https://your-link.com', 'copygen-addons' ),
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
        ]
    );
    $this->add_control(
        'social_media_repeater',
        [
            'label' => __('Social Media Content', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                   'social_media_icon' =>  __('fa fa-facebook', 'copygen-addons'),
                   'socail_media_link' =>  __('#', 'copygen-addons'),
                ],
                [
                   'social_media_icon' =>  __('fa fa-twitter', 'copygen-addons'),
                   'socail_media_link' =>  __('#', 'copygen-addons'),
                 ],
                 [
                    'social_media_icon' =>  __('fa fa-skype', 'copygen-addons'),
                    'socail_media_link' =>  __('#', 'copygen-addons'),
                 ],
                 [
                    'social_media_icon' =>  __('fa fa-telegram', 'copygen-addons'),
                    'socail_media_link' =>  __('#', 'copygen-addons'),
                 ],
            ],
            'title_field' => '{{{ social_media_icon }}}',
            'condition' => [
                'media_enable' => 'yes'
            ],
        ]
    );

   $this->end_controls_section();

        // header content

    $this->start_controls_section('headers_content',
    [ 
        'label' => __('Header Content', 'copygen-addons'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
    );

    $this->add_control(
        'navigations',
        [
            'label' => __('Select Navigation', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => copygen_navmenu(),
        ]
    );
        
    $this->add_control(
        'hr_seven',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );

  
    $this->add_control(
        'search_enable',
        [
            'label' => __('Search show / hide', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );
    $this->add_control(
        'hr_five_f',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
    );
    $this->add_control(
        'button_enable',
        [
            'label' => __('Button show / hide', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );
    $this->add_control(
        'button_texts',
        [
            'label' => __( 'Button Text', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'Get A Quote', 'copygen-addons' ),
            'placeholder' => __( 'Type your title here', 'copygen-addons' ),
            'condition' => [
                'button_enable' => 'yes'
            ],
        ]
    );
    $this->add_control(
        'button_link',
        [
            'label' => __( 'Button Link', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __( 'https://your-link.com', 'copygen-addons' ),
            'show_external' => true,
            'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
            ],
            'condition' => [
                'button_enable' => 'yes'
            ],
        ]
    );

    $this->add_control(
        'hr_five',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
    );

    $this->add_control(
        'option_panel_enable',
        [
            'label' => __('Option Panel Show / Hide', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );

 
    $this->end_controls_section();

 

$this->start_controls_section('header_css',
[ 
    'label' => __('Topbar Css', 'copygen-addons'),
    'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control(
    'topbar_bg_color',
     [
        'label' => __('Topbar Bg Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .top_bar ' => 'background: {{VALUE}}!important;',
        ],
     ]
); 

$this->add_control(
    'css_h1_1',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);
$this->add_control(
    'text_color',
     [
        'label' => __('Text Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .top_bar .top_md .text  ' => 'color: {{VALUE}}!important;',
        ],
     ]
); 
$this->add_control(
    'css_h1_2',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'phone_mail_colro',
     [
        'label' => __('Phone / Mail Text Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .top_bar .top_md .call a, {{WRAPPER}}  .header-area.header-style-1 .top_bar .top_md .mail a  ' => 'color: {{VALUE}}!important;',
        ],
     ]
); 
$this->add_control(
    'phone_mail_bg_colro',
     [
        'label' => __('Phone / Mail Bg Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .top_bar .top_md .call a, {{WRAPPER}}  .header-area.header-style-1 .top_bar .top_md .mail a  ' => 'background: {{VALUE}}!important;',
        ],
     ]
); 

$this->add_control(
    'css_h1_3',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);
$this->add_control(
    'lan_color',
     [
        'label' => __('Language Text Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .language .language-dropdown-active  ' => 'color: {{VALUE}}!important;',
        ],
     ]
);

$this->add_control(
    'css_h1_4',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);
$this->add_control(
    'color_one',
    [
        'label' => __( 'Icon Color', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .social-icons ul li a ' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'color_two',
    [
        'label' => __( 'Icon Bg Color', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .social-icons ul li a ' => 'background: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'color_three',
    [
        'label' => __( 'Icon Hover Color', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .social-icons ul li a:hover ' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'color_four',
    [
        'label' => __( 'Icon Hover Bg Color', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .social-icons ul li a:hover ' => 'background: {{VALUE}}',
        ],
    ]
);


$this->add_control(
  'media_font_weights',
  [
      'label' => __('Icon Font Weight', 'copygen-addons'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'options' => [
          '400'   => esc_html__( '400', 'copygen-addons' ),
          '500'   => esc_html__( '500', 'copygen-addons' ),
          '600'   => esc_html__( '600', 'copygen-addons' ), 
          '700'   => esc_html__( '700', 'copygen-addons' ), 
          '800'   => esc_html__( '800', 'copygen-addons' ), 
          '900'   => esc_html__( '900', 'copygen-addons' ), 
      ],
      'default' => '400',
      'selectors' => [
          '{{WRAPPER}} .social-icons ul li a i' => 'font-weight: {{VALUE}}',
      ],
  ]
);

$this->add_control(
  'font_familyss',
  [
      'label' => __('Font Family', 'copygen-addons'),
      'type' => \Elementor\Controls_Manager::SELECT,
      'options' => [
          'Font Awesome 5 Brands'   => esc_html__( 'Font Awesome 5 Brands', 'copygen-addons' ),
          'Font Awesome 5 Free'   => esc_html__( 'Font Awesome 5 Free', 'copygen-addons' ),
          'FontAwesome'   => esc_html__( 'FontAwesome', 'copygen-addons' ),
          
      ],
      'default' => 'Font Awesome 5 Brands',
      'selectors' => [
          '{{WRAPPER}} .social-icons ul li a i' => 'font-family: {{VALUE}}',
      ],
  ]
);


$this->end_controls_section(); 
$this->start_controls_section('button_css',
    [ 
        'label' => __('Header Button Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
]);


$this->add_control(
    'button_color',
     [
        'label' => __('Button Text Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn  ' => 'color: {{VALUE}}!important;',
        ],
     ]
  );
  
  $this->add_control(
    'background_color',
     [
        'label' => __('Button Background Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn  ' => 'background: {{VALUE}}!important;',
        ],
     ]
  );

  $this->add_control(
    'border_color',
     [
        'label' => __('Button Border Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn  ' => 'border-color: {{VALUE}}!important;',
        ],
     ]
  );

  $this->add_responsive_control(
          'border_radius',
          [
              'label' => __( 'Border Radius', 'copygen-addons' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => ['px'],
              'selectors' => [
                  '{{WRAPPER}} .theme_btn    ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
              ],
          ]
  );

  $this->add_control(
    'button_color_hover',
     [
        'label' => __('Button Hover Text Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn:hover ' => 'color: {{VALUE}}!important;',
        ],
     ]
  );
  
  $this->add_control(
    'background_color_hover',
     [
        'label' => __('Button Hover Background Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn:hover ' => 'background: {{VALUE}}!important;',
        ],
     ]
  );

  $this->add_control(
    'border_color_hover',
     [
        'label' => __('Button Hover Border Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .theme_btn:hover ' => 'border-color: {{VALUE}}!important;',
        ],
     ]
  );


$this->end_controls_section();


$this->start_controls_section('header_bg_css',
[ 
    'label' => __('Header  Bg Css', 'copygen-addons'),
    'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control(
    'header_bg_color',
     [
        'label' => __('Header Bg Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .main_header_content ' => 'background: {{VALUE}}!important;',
        ],
     ]
); 


$this->end_controls_section();

$this->start_controls_section('menu_css',
    [ 
        'label' => __('Menu Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]);

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Menu Typography', 'copygen-addons' ),
            'name' => 'menu_typo',
            'selector' => '{{WRAPPER}} .main-menu > nav > ul > li > a ',
        ]
    );

    $this->add_control(
        'menu_item_padding',
        [
            'label' => esc_html__( 'Menu Item Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'menu_item_color',
        [
            'label' => __('Menu Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > a.nav_link  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_control(
        'menu_item_active_color',
        [
            'label' => __('Menu Active Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item.active > a.nav_link  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'menu_item_arrow_color',
        [
            'label' => __('Arrow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > li > .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->add_control(
        'drop_down_bg_color',
        [
            'label' => __('Drop Down Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu  ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->add_control(
        'drop_down_menu_color',
        [
            'label' => __('Drop Down Menu Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 

      $this->add_control(
        'navigation_btn_color',
        [
            'label' => __('Mobile Navigation Button  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area .navbar_togglers  .line' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    
    $this->end_controls_section(); 

    $this->start_controls_section('header_extra_css',
[ 
    'label' => __('Search / Option Panel Button Css', 'copygen-addons'),
    'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control(
    'icon_color',
     [
        'label' => __('Search Icon Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .main_header_content .search .fi-rs-search' => 'color: {{VALUE}}!important;',
        ],
        'condition' => [
            'search_enable' => 'yes'
        ],
     ]
); 

$this->add_control(
    'icon_color_two',
     [
        'label' => __('Option Panel Icon Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-1 .main_header_content .contact-toggler svg path' => 'stroke: {{VALUE}}!important;',
        ],
        'condition' => [
            'option_panel_enable' => 'yes'
        ],
     ]
); 

$this->add_control(
    'icon_bg_color',
     [
        'label' => __('Icon Background Color', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .header-area.header-style-1 .main_header_content .search , {{WRAPPER}}  .header-area.header-style-1 .main_header_content .contact-toggler ' => 'background: {{VALUE}}!important;',
        ],
     ]
); 
$this->add_control(
    'icon_padding',
    [
        'label' => esc_html__( 'Icon Padding', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
            '{{WRAPPER}}  .header-area.header-style-1 .main_header_content .search  , {{WRAPPER}}  .header-area.header-style-1 .main_header_content  .contact-toggler ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
        ],
    ]
);
$this->add_control(
    'icon_radius',
    [
        'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
            '{{WRAPPER}}  .header-area.header-style-1 .main_header_content .search  , {{WRAPPER}}  .header-area.header-style-1 .main_header_content .contact-toggler ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
        ],
    ]
);


          


$this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$url = '';
if($settings['custom_link_enable'] == 'yes'):
$logo_target = $settings['logo_link']['is_external'] ? ' target="_blank"' : '';
$logo_nofollow = $settings['logo_link']['nofollow'] ? ' rel="nofollow"' : ''; 
    $url = $settings['logo_link']['url'];
else:
    $url = home_url();
endif;
?>

<header class="header-area header-style-1">
    <?php if($settings['top_bar_enable'] == 'yes'): ?>
    <div class="top_bar">
        <div class="<?php echo esc_attr($settings['header_width']); ?>">
            <div class="row align-items-center">
                <div class="col-xl-2 col-lg-0 col-md-0 col-sm-0 col-xs-0">
                </div>
                <div class="col-xl-7 col-lg-9 col-md-12 col-sm-12 col-xs-12">
                    <div class="top_md d-flex align-items-center">
                        <?php if($settings['working_enable'] == 'yes'): ?>
                            <div class="text workings">
                                <i class="fi-rr-clock"></i> <?php echo wp_kses($settings['working'] , $allowed_tags); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($settings['text_content_enable'] == 'yes'): ?>
                        <div class="text">
                            <?php echo wp_kses($settings['text_content'] , $allowed_tags); ?>
                        </div>
                        <?php endif; ?>
                        <?php if($settings['phone_enable'] == 'yes'): ?>
                        <div class="call">
                            <a href="tel:<?php echo esc_attr($settings['phone_number']); ?>">
                                <small><?php echo esc_attr($settings['phone_title']); ?></small>
                                <?php echo esc_attr($settings['phone_number']); ?></a>
                        </div>
                        <?php endif; ?>
                        <?php if($settings['mail_enable'] == 'yes'): ?>
                        <div class="mail">
                            <a href="mailto:<?php echo esc_attr($settings['mail_id']); ?>">
                                <small><?php echo esc_attr($settings['mail_title']); ?></small>
                                <?php echo esc_attr($settings['mail_id']); ?></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-xs-12">
                    <div class="top_rt d-flex align-items-center">
                        <?php if($settings['language_enable'] == 'yes'): ?>
                        <?php if($settings['language_type'] == 'custom_language'): ?>
                            <div class="language">
                                <a class="language-dropdown-active">
                                    <?php echo esc_html($settings['defaut_language_texts']); ?>
                                    <i class="fi-rs-angle-small-down"></i>
                                </a>
                                <ul class="language-dropdown">
                                    <?php foreach($settings['language_repeater'] as  $language_repeater): 
                                        $target_three = $language_repeater['language_link']['is_external'] ? ' target="_blank"' : '';
                                        $nofollow_three= $language_repeater['language_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                                    <li>
                                        <a href="<?php echo esc_url($language_repeater['language_link']['url']); ?>"
                                            <?php echo esc_attr($target_three); ?>
                                            <?php echo esc_attr($nofollow_three); ?>>
                                            <?php if(!empty($language_repeater['language_icon_image']['url'])): ?>
                                            <img src="<?php echo esc_url($language_repeater['language_icon_image']['url']); ?>"
                                                alt="img" />
                                            <?php endif; ?>
                                            <?php echo esc_attr($language_repeater['language_text']); ?>
                                        </a>
                                    </li>
                                    <?php endforeach ;?>
                                </ul>
                            </div>
                        <?php elseif($settings['language_type'] == 'using_short_code'): ?>
                            <div class="language_shortcode">
                                <?php do_shortcode($settings['language_shortcode']); ?>
                            </div>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php if($settings['media_enable'] == 'yes'): ?>
                        <div class="social-icons">
                            <ul class="d-inline-block">
                            <?php foreach($settings['social_media_repeater'] as $media_repearter):?>
                                <?php $target = $media_repearter['socail_media_link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $media_repearter['socail_media_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                                <li>
                                    <a class="m_icon" href="<?php echo esc_url($media_repearter['socail_media_link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                                        <i class="<?php echo esc_attr($media_repearter['social_media_icon']); ?>"></i>
                                    </a>
                                </li>
                            <?php endforeach;?>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if($settings['main_header_enable'] == 'yes'): ?>
    <div class="main_header_content default_header">
        <div class="<?php echo esc_attr($settings['header_width']); ?>">
            <div class="row align-items-center">
                <div class="col-xl-2 col-lg-12 col-md-5 col-sm-5 col-xs-5">
                    <div class="logo_box">
                    <svg width="286" height="120" viewBox="0 0 286 120" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0 15.1694C0 10.2921 3.885 6.30231 8.76058 6.17256L234.506 0.165147C238.242 0.0657277 241.65 2.2855 243.07 5.74252L284.899 107.581C287.331 113.503 282.976 120 276.574 120H9C4.02943 120 0 115.971 0 111V15.1694Z" fill="var(--color-set-one-1)"/>
</svg>

                        <a href="<?php echo esc_url($url); ?>" class="logo navbar-brand"
                            <?php if($settings['custom_link_enable'] == 'yes'): echo esc_attr($logo_target);  echo esc_attr($logo_nofollow); endif; ?>>
                            <img src="<?php echo esc_url($settings['logo_default']['url']); ?>"
                                alt="<?php echo esc_html(get_bloginfo( 'name' )); ?>" class="logo_default">
                        </a>
                    </div>
                </div>
                <div class="col-xl-8 col-lg-9 col-md-0 col-sm-0 col-xs-0 column_menu">
                <div class="navbar_togglers hamburger_menu">
                        <span class="line"></span>
                        <span class="line"></span>
                        <span class="line"></span>
                    </div>
                    <div class="navbar_content d-flex align-items-center">
                        <?php if(!empty($settings['navigations'])):
                            wp_nav_menu(array(
                                'menu' => $settings['navigations'],
                                'container' => false,
                                'menu_class' => 'navbar_nav',
                                'fallback_cb'    => 'copygen_wp_bootstrap_navwalker::fallback',
                                'walker' => new \copygen_wp_bootstrap_navwalker()
                            )); 
                        endif; ?>
                        <?php if($settings['search_enable'] == 'yes'): ?>
                        <div class="search search-toggler">
                            <i class="fi-rs-search"></i>
                        </div>
                        <?php endif;?>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-3 col-md-7 col-sm-7 col-xs-7 nav_tog_column">
                
                    <div class="d-flex right_content align-items-center">
                    <div class="navbar_togglers hamburger_menu">
                        <span class="line"></span>
                        <span class="line"></span>
                        <span class="line"></span>
                    </div>
                        <?php if($settings['button_enable'] == 'yes'): ?>
                        <div class="button">
                            <?php $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
                           $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                            <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                                <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?> class="theme_btn">
                                <?php echo esc_attr($settings['button_texts']); ?>
                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>


                            </a>
                        </div>
                        <?php endif;?>
                        <?php if($settings['option_panel_enable'] == 'yes'): ?>
                      
                            <div class="contact-toggler">
                                <svg width="18" height="19" viewBox="0 0 18 19" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0.75 3.25C0.75 2.65326 0.987053 2.08097 1.40901 1.65901C1.83097 1.23705 2.40326 1 3 1H5.25C5.84674 1 6.41903 1.23705 6.84099 1.65901C7.26295 2.08097 7.5 2.65326 7.5 3.25V5.5C7.5 6.09674 7.26295 6.66903 6.84099 7.09099C6.41903 7.51295 5.84674 7.75 5.25 7.75H3C2.40326 7.75 1.83097 7.51295 1.40901 7.09099C0.987053 6.66903 0.75 6.09674 0.75 5.5V3.25ZM0.75 13C0.75 12.4033 0.987053 11.831 1.40901 11.409C1.83097 10.9871 2.40326 10.75 3 10.75H5.25C5.84674 10.75 6.41903 10.9871 6.84099 11.409C7.26295 11.831 7.5 12.4033 7.5 13V15.25C7.5 15.8467 7.26295 16.419 6.84099 16.841C6.41903 17.2629 5.84674 17.5 5.25 17.5H3C2.40326 17.5 1.83097 17.2629 1.40901 16.841C0.987053 16.419 0.75 15.8467 0.75 15.25V13ZM10.5 3.25C10.5 2.65326 10.7371 2.08097 11.159 1.65901C11.581 1.23705 12.1533 1 12.75 1H15C15.5967 1 16.169 1.23705 16.591 1.65901C17.0129 2.08097 17.25 2.65326 17.25 3.25V5.5C17.25 6.09674 17.0129 6.66903 16.591 7.09099C16.169 7.51295 15.5967 7.75 15 7.75H12.75C12.1533 7.75 11.581 7.51295 11.159 7.09099C10.7371 6.66903 10.5 6.09674 10.5 5.5V3.25ZM10.5 13C10.5 12.4033 10.7371 11.831 11.159 11.409C11.581 10.9871 12.1533 10.75 12.75 10.75H15C15.5967 10.75 16.169 10.9871 16.591 11.409C17.0129 11.831 17.25 12.4033 17.25 13V15.25C17.25 15.8467 17.0129 16.419 16.591 16.841C16.169 17.2629 15.5967 17.5 15 17.5H12.75C12.1533 17.5 11.581 17.2629 11.159 16.841C10.7371 16.419 10.5 15.8467 10.5 15.25V13Z"
                                        stroke="#0F3567" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>


                            </div>
                        
                        <?php endif;?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</header>


<?php
    }
}