<?php
namespace  Copygenaddons\Core\Widgets\Footer;
if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.
class Foo_contact_v1 extends \Elementor\Widget_Base{
    public function get_name()
    {
        return 'copygen-footer-contact';
    }
    public function get_title()
    {
        return __('Footer Contact  V1' , 'copygen-addons');
    }
    public function get_icon()
    {
        return 'icon-steel';
    }
    public function get_categories()
    {
        return ['104'];
    }
    protected function register_controls(){

        $this->start_controls_section('footer_contact_content',
        [ 
            'label' => __('Contact Content', 'copygen-addons')
        ]
        );
        $this->add_control(
            'contact_type',
            [
                'label' => __('Contact Type', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'address_type' => __('Address', 'copygen-addons'),
                    'phone_type' => __('Phone', 'copygen-addons'),
                    'mail_type' => __('Mail', 'copygen-addons'),
                    'timing_type' => __('Timing', 'copygen-addons'),
                ],
                'default' => 'timing_type',
            ]
        );
        $this->add_control(
            'heading_text',
            [
                'label' => __('Heading', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default text', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),
              
            ]
        );
        $this->add_control(
            'address',
            [
                'label' => __(' Address', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('United States 866 Wilshire, 2nd Street Los Angeles 90024.', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),
                'condition' => [
                    'contact_type' => 'address_type',
                ]
            ]
        );
        $this->add_control(
            'phone',
            [
                'label' => __('Phone', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('+555 5678 12340', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),
                'condition' => [
                    'contact_type' => 'phone_type',
                ]
            ]
        );
        $this->add_control(
            'mail',
            [
                'label' => __(' Mail Id', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('support@copygen.com', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),
                'condition' => [
                    'contact_type' => 'mail_type',
                ]
            ]
        );
        $this->add_control(
            'timing',
            [
                'label' => __(' Timing', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Mon - Sat: 09.00 to 06.00 (Sun:Closed)', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),
                'condition' => [
                    'contact_type' => 'timing_type',
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section('button_css',
        [ 
            'label' => __('Custom Css ', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_responsive_control(
            'icon_move_top',
            [
                'label' => __('Icon Move Top', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min'     => -150,
                'max'     => 150,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .footer_contact_widget i  ' => 'top: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_font_sizes',
            [
                'label' => __('Icon Font Size', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 20, 
                'min'     => 0,
                'max'     => 150,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .footer_contact_widget i  ' => 'font-size: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_control(
            'icon_olor',
             [
                'label' => __('Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget i  ' => 'color: {{VALUE}}!important', 
				], 
             ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typo', 'copygen-addons' ),
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .footer_contact_widget .title_no_a1_8 ',
			]
		); 
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget .title_no_a1_8 ' => 'color: {{VALUE}}!important',
                    'pathtwo'
				], 
             ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Content Typo', 'copygen-addons' ),
				'name' => 'content_typo',
				'selector' => '{{WRAPPER}} .footer_contact_widget .d-flex p , {{WRAPPER}} .footer_contact_widget .d-flex p a ',
			]
		);
        $this->add_control(
            'content_text_color',
             [
                'label' => __('Content Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget .d-flex p , {{WRAPPER}} .footer_contact_widget .d-flex p a ' => 'color: {{VALUE}}!important',
                    'pathtwo'
				], 
             ]
        );
        $this->end_controls_section();
    }
    protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');
    ?> 
    <div class="footer_contact_widget"> 
		<?php if($settings['contact_type'] == 'phone_type') : ?> 
			<div class="d-flex">
                <i class="copy-mail-fill"></i>
                <div>
                    <?php if(!empty($settings['heading_text'])) : ?> 
                        <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
                    <?php endif; ?>
                    <p><a href="tel:<?php echo wp_kses($settings['phone'] , $allowed_tags); ?>"><?php echo wp_kses($settings['phone'], $allowed_tags); ?></a></p>
                </div>
            </div>
            <?php elseif($settings['contact_type'] == 'mail_type'): ?> 
				<div class="d-flex">
                    <i class="copy-call-alt-fill"></i>
                <div>
                    <?php if(!empty($settings['heading_text'])) : ?> 
                        <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
                    <?php endif; ?>
                    <p><a href="mailto:<?php echo wp_kses($settings['mail'] , $allowed_tags); ?>"><?php echo wp_kses($settings['mail'], $allowed_tags); ?></a></p>
                </div>
            </div>
            <?php elseif($settings['contact_type'] == 'address_type') : ?> 
				<div class="d-flex">
                    <i class="copy-map-pin-fill"></i>
                    <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                        <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                        <p><?php echo wp_kses($settings['address'] , $allowed_tags); ?></p>
                    </div>
                </div>
            <?php else: ?> 
				<div class="d-flex">
                    <i class="copy-time1"></i>
                    <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                            <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                            <p><?php echo wp_kses($settings['timing'] , $allowed_tags); ?></p>
                    </div>
                </div>
			<?php endif; ?>
		</div>
            
        <?php
    }
}



