<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Title_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-title-v1';
    }

    public function get_title()
    {
        return __('Title V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('title_v1_settings',
        [ 
            'label' => __('Title Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        ); 
        $this->add_control(
            'title_tag',
            [
            'label' => __('Title Tag', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'div' => __( 'Div Tag', 'copygen-addons' ),
                'h1' => __( 'H1 Tag', 'copygen-addons' ),
                'h2' => __( 'H2 Tag', 'copygen-addons' ),
                'h3' => __( 'H3 Tag', 'copygen-addons' ),
                'h4' => __( 'H4 Tag', 'copygen-addons' ),
                'h5' => __( 'H5 Tag', 'copygen-addons' ),
                'h6' => __( 'H6 Tag', 'copygen-addons' ),
            ],
            'default' => 'h2' , 
            ]
        );
        $this->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        
        $this->add_control(
            'sm_title',
            [
               'label' => __('Sub Title', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Our performance', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
              
            ]
        );
        $this->add_control(
            'hr8',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
               
            ]
        );
        $this->add_control(
            'titles',
            [
                'label' => __('Title', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Unlock the power of Copywriting AI and Create Content Faster', 'copygen-addons'),
                'placeholder' => __('Type your text here', 'copygen-addons'),     
            ]
        ); 
        $this->add_control(
            'typing_text_enable',
            [
                'label' => esc_html__( 'Typing Text Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'no', 
            ]
        );
        $this->add_control(
            'typewrite',
            [
                'label' => __('Type Write Text', 'monst-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('"Web Agency", "Social Marketing"', 'monst-addons'),
                'placeholder' => __('"Web Agency", "Social Marketing"', 'monst-addons'),
                'condition' => [
                    'typing_text_enable' => 'yes' , 
                ],
            ]
        ); 
        $this->add_control(
            'hr9',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'pattern',
            [
                'label' => esc_html__( 'Pattern Text Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'no',
               
            ]
        );
        $this->add_control(
            'pattern_style',
            [
                'label' => __('Pattern Style', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one' => __( 'Pattern Style One', 'copygen-addons' ),
                    'style_two' => __( 'Pattern Style Two', 'copygen-addons' ), 
                ],
                'default' => 'style_one' , 
                'condition' => [
                    'pattern' => 'yes' , 
                ],
            ]
        ); 
        $this->add_control(
			'text_position',
			[
				'label' => esc_html__( 'Pattern Text Position', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'copygen-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'copygen-addons' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
                'condition' => [
                    'pattern' => 'yes' , 
                ],
			]
		); 
        $this->add_control(
            'hr10',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'pattern' => 'yes' , 
                ],
            ]
        );
        $this->add_control(
            'titlestext',
            [
               'label' => __('Pattern Text', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('analytics', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'), 
               'condition' => [
                    'pattern' => 'yes' , 
                ],   
            ]
        );
        $this->add_control(
            'hr11',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'pattern' => 'yes' , 
                ],
            ]
        );
        $this->add_control(
			'font_sizes',
			[
				'label' => esc_html__( 'Pattern Width', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .title_whole svg' => 'width: {{SIZE}}{{UNIT}}; height:unset!important;',
				],
                'condition' => [
                    'pattern' => 'yes' , 
                ],   
			]
		);
        $this->add_control(
			'top',
			[
				'label' => esc_html__( 'Move Top', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -10000,
						'max' => 10000,
						'step' => 5,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .title_whole svg' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'pattern' => 'yes' , 
                ],   
			]
		);

        $this->add_control(
			'left',
			[
				'label' => esc_html__( 'Move Left', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -10000,
						'max' => 10000,
						'step' => 5,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .title_whole svg' => 'left: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'pattern' => 'yes' , 
                ],  
			]
		);
        $this->add_control(
            'hr13',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'description',
            [
              'label' => __('Description', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::TEXTAREA,
              'default' => __('AI Copywriting is revolutionizing the way content is created. AI can create content for blogs, articles, websites, social media and more.', 'copygen-addons'),
              'placeholder' => __('Type your text here', 'copygen-addons'),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section('title_css',
        [ 
            'label' => __('Title Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Sub Title Typography', 'copygen-addons' ),
				'name' => 'sm_typos',
				'selector' => '{{WRAPPER}} .section_title .overline-title',
			]
		);
        $this->add_control(
            'sm_title_color',
             [
                'label' => __('Sub Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .overline-title ' => 'color: {{VALUE}}!important;',
                ], 
             ]
        );
        $this->add_control(
            'sm_titlebg_color',
             [
                'label' => __('Sub Title Bg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .overline-title ' => 'background: {{VALUE}}!important;',
                ], 
             ]
        );
        $this->add_control(
            'hr145sp',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'sm_titlespan_color',
             [
                'label' => __('Sub Title Span Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .overline-title span ' => 'color: {{VALUE}}!important;',
                ], 
             ]
        ); 
        $this->add_control(
            'hr145',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
			'sm_padding',
			[
				'label' => esc_html__( 'Sub Title Padding', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title .overline-title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				], 
			]
		); 
        $this->add_responsive_control(
			'sm_radius',
			[
				'label' => esc_html__( 'Sub Title Border Radius', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title .overline-title ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				], 
			]
		); 
        $this->add_responsive_control(
			'sm_margin',
			[
				'label' => esc_html__( 'Sub Title Margin', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title .overline-title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				], 
			]
		); 
        $this->add_control(
            'hr14',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
				'name' => 'title_typos',
				'selector' => '{{WRAPPER}} .section_title .title , {{WRAPPER}} .section_title .title small , {{WRAPPER}} .section_title .title span',
			]
		);
        $this->add_control(
            'hr141',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title  ' => 'color: {{VALUE}}!important;',
                ],
             ]
        ); 
        $this->add_control(
            'hr1sg',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'gradient_color_enable',
            [
                'label' => esc_html__( 'Gradient Color For Span Enable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_color',
                'types' => ['gradient' ],
                'selector' => '{{WRAPPER}} .section_title .title span , .section_title .title small ',
                'condition' => [
                    'gradient_color_enable' => 'yes' 
                 ]
            ]
        );
        $this->add_control(
            'hr1sgs',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'gradient_color_enable' => 'yes' 
                 ]
            ]
        );
        $this->add_control(
            'title_span_color',
             [
                'label' => __('Title Span Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title span ' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .section_title .title span:before ' => 'background: {{VALUE}}!important;',
                    '{{WRAPPER}} .typewrite ' => ' background: linear-gradient(90deg, {{VALUE}} 48.76%, {{VALUE}} 98.19%)!important;',
                ],
                 'condition' => [
                    'gradient_color' => 'no' 
                 ]
             ]
        );
        $this->add_control(
            'title_span_colortwo',
             [
                'label' => __('Title Small Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title small ' => 'color: {{VALUE}}!important;',
                ], 
                'condition' => [
                    'gradient_color' => 'no' 
                 ]
             ]
        );
        $this->add_control(
            'title_span_lnt',
             [
                'label' => __('Title Small Line Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title small svg stop.ons ' => 'stop-color: {{VALUE}}!important;',
                ], 
                'condition' => [
                    'pattern' => 'yes' , 
                    'gradient_color' => 'no' 
                ],  
             ]
        );
        $this->add_control(
            'title_span_lntwo',
             [
                'label' => __('Title Small Line Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title small svg stop ' => 'stop-color: {{VALUE}}!important;',
                ], 
                'condition' => [
                    'pattern' => 'yes' , 
                    'gradient_color' => 'no' 
                ],  
             ]
        );
        $this->add_control(
            'hr142',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title  .title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
        $this->add_control(
            'hr15',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Description Typography', 'copygen-addons' ),
				'name' => 'desc_typo',
				'selector' => '{{WRAPPER}} .section_title p',
			]
		);
        $this->add_control(
            'hr143',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'description_color',
             [
                'label' => __('Description Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title p ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'hr144',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
			'description_margin',
			[
				'label' => esc_html__( 'Description Padding', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title p ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
        $this->add_control(
            'hr16',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
                    'none' => [
                        'title' => __( 'None', 'copygen-addons' ),
                        'icon' => 'eicon-undo',
                    ],
					'left' => [
						'title' => esc_html__( 'Left', 'copygen-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'copygen-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'copygen-addons' ),
						'icon' => 'eicon-text-align-right',
					],
                    'justify' => [
						'title' => esc_html__( 'Justify', 'copygen-addons' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
                'default' => 'none',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .section_title ' => 'text-align: {{VALUE}}!important;',
                ],
			]
		);  
        $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
 
        <div class="section_title type_one<?php if($settings['gradient_color_enable'] = 'yes'): ?> g_enable<?php endif; ?>">
            <?php if(!empty($settings['sm_title'])): ?>
                <div class="overline-title"> <?php echo wp_kses($settings['sm_title'] , $allowed_tags);  ?></div>
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_whole position-relative">
                    <?php if($settings['title_tag'] == 'h1'): ?>
                        <h1 class="title">
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php // type write enable ?>   
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>    
                        </h1>
                    <?php elseif($settings['title_tag'] == 'h2'):?>
                        <h2 class="title">
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </h2>
                    <?php elseif($settings['title_tag'] == 'h3'):?>
                        <h3 class="title"> 
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </h3>
                    <?php elseif($settings['title_tag'] == 'h4'):?>
                        <h4 class="title"> 
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </h4>
                    <?php elseif($settings['title_tag'] == 'h5'):?>
                        <h5 class="title"> 
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </h5>
                    <?php elseif($settings['title_tag'] == 'h6'):?>
                        <h6 class="title">
                        <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </h6>
                    <?php else: ?>
                        <div class="title">
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'left'): // left Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // left Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                            <?php if($settings['pattern'] == 'yes'): // pattern enable ?>
                                <?php if($settings['text_position'] == 'right'): // Right Side ?>
                                <small>
                                <?php if(!empty($settings['titlestext'])): ?>
                                    <?php echo wp_kses($settings['titlestext'] , $allowed_tags); ?>
                                    <?php if($settings['pattern_style'] == 'style_two'): ?>
                                        <svg width="243" height="35" viewBox="0 0 243 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2 13.0328C32.4961 7.38981 122.991 -2.20328 241 4.56831" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M64.9152 15.5249C87.022 10.8533 152.77 2.09709 238.906 4.44526" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                            <path d="M65.012 16.4264C87.692 13.3239 154.306 10.8944 239.322 25.9959" stroke="#FDB52A" stroke-width="4" stroke-linecap="round"/>
                                        </svg>
                                    <?php else: ?>
                                        <svg width="200" height="23" viewBox="0 0 200 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3 19.004C33.1561 9.47909 114.175 -5.76732 197 9.44658" stroke="url(#paint0_linear_1_2801)" stroke-width="6" stroke-linecap="round"/>
                                            <defs>
                                            <linearGradient id="paint0_linear_1_2801" x1="3.00002" y1="11.002" x2="3.89873" y2="24.1755" gradientUnits="userSpaceOnUse">
                                            <stop class="ons" stop-color="#2B5CFD"/>
                                            <stop offset="1" stop-color="#1D3FAF"/>
                                            </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php endif; // pattern end ?>
                                <?php endif; // title empty ?>
                                </small>
                                <?php endif;  // Right Side ?>
                            <?php endif;  // pattern enable ?>
                            <?php if($settings['typing_text_enable'] == 'yes'): ?>
                                <span class="typewrite d-inline" data-period="3000" data-type='[<?php echo wp_kses($settings['typewrite'] , $allowed_tags); ?>]'>
                                </span>
                            <?php endif;  // type write enable ?>  
                        </div>
                    <?php endif; ?>
                 
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['description'])): ?>
                <p class="lead"> <?php echo wp_kses($settings['description'] , $allowed_tags);  ?></p>
            <?php endif; ?>
        </div>
        
    <?php
    }
}

 

