<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Theme_btn_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-themebtns-v1';
    }

    public function get_title()
    {
        return __('Theme Buttons V1' , 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
 
        $this->start_controls_section(
            'theme_btn_content',
            [
                'label' => __('theme Button Content', 'copygen-addons')
            ]
        );

        $this->add_control(
            'theme_btn_styles',
            [
                'label' => __('theme Button Styles', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one' => __( 'Style One', 'copygen-addons' ),
                    'style_two' => __( 'Style Two', 'copygen-addons' ),
                
				],
                'default' => 'style_one' , 
            ]
        ); 
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );

        $this->add_responsive_control(
          'btn_alignments',
          [
              'label' => __('Button alignments', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::CHOOSE,
              'options' => [
                'none' => [
                    'title' => __( 'None', 'copygen-addons' ),
                    'icon' => 'eicon-undo',
                ],
                'left' => [
                  'title' => __( 'Text Left', 'copygen-addons' ),
                  'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                  'title' => __( 'Text Center', 'copygen-addons' ),
                  'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                  'title' => __( 'Text Right', 'copygen-addons' ),
                  'icon' => 'eicon-text-align-right',
                ],
              ],
              'default' => 'none',
              'toggle' => true,
              'selectors' => [
                '{{WRAPPER}} .theme_btn_all' => 'text-align: {{VALUE}}!important;',
              ],
          ]
        );
        $this->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        // icon content start =======================================================================
        $this->start_controls_tabs(
            'group_one'
        );
        $this->start_controls_tab(
            'group_tab_one',
            [
                'label' => esc_html__( 'Icon Tab', 'copygen-addons' ),
            ]
        );
        // icon content start =======================================================================
        $this->add_control(
            'icon_enable',
            [
                'label' => __('Icon Enable /  Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_responsive_control(
            'icon_alignment',
            [
                'label' => __('Icon Position', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'ileft' => [
                    'title' => __( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'iright' => [
                    'title' => __( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'iright',
                'toggle' => true,
                'condition' => [ 
                    'icon_enable' => 'yes' 
                ],
            ]
        );
        $this->add_control(
            'hr3',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [ 
                    'icon_enable' => 'yes' 
                ],
            ]
        );
        $this->add_control(
        'icon_type',
            [
                'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'image' => esc_html__( 'Image', 'copygen-addons' ),
                    'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
                ], 
                'default' => 'icon' , 
                'condition' => [ 
                    'icon_enable' => 'yes' 
                ],
            ]
        );
        $this->add_control(
            'hr4',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [ 
                    'icon_enable' => 'yes' 
                ],
            ]
        );
      
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image' ,
                    'icon_enable' => 'yes' 
                ],
            ] 
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon',
                    'icon_enable' => 'yes' 
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon',
                    'icon_enable' => 'yes' 
                ]
            ]
        );
        // icon content start =======================================================================
        $this->end_controls_tab();
        // icon style start =======================================================================
        $this->start_controls_tab(
            'group_tab_two',
            [
                'label' => esc_html__( 'Icon Style', 'copygen-addons' ),
            ]
        );
        // icon style start =======================================================================
        $this->add_responsive_control(
            'iconnumber',
            [
                'label' => __('Icon  Size', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 500,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn .icon i  ' => 'font-size: {{VALUE}}px!important;', 
                    '{{WRAPPER}} .theme_btn .icon svg , {{WRAPPER}} .theme_btn .icon img  ' => 'width: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_control(
            'hr5',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'iconrotate',
            [
                'label' => __('Icon Rotate', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -360,
                'max'     => 360,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn .icon ' => 'transform: rotate({{VALUE}}deg)!important;', 
                ],
            ]
        );
        $this->add_control(
            'hr6',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'icon_left',
             [
                'label' => __('Icon Move Left', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn .icon ' => 'left: {{VALUE}}px!important;',
                ],
                'condition' => [
                    'icon_alignment' => 'ileft',
                ]
             ]
        );
        $this->add_control(
            'hr7',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'icon_alignment' => 'ileft',
                ]
            ]
        );
        $this->add_responsive_control(
            'icon_top',
             [
                'label' => __('Icon Move Top', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn .icon ' => 'top: {{VALUE}}px!important;',
                ],
             ]
        );
        $this->add_control(
            'hr8',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'icon_right',
             [
                'label' => __('Icon Move Left', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn .icon  ' => 'right: {{VALUE}}px!important;',
                ],
                'condition' => [
                    'icon_alignment' => 'iright',
                ]
             ]
        );
        $this->add_control(
            'hr9',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'icon_alignment' => 'iright',
                ]
            ]
        );
        $this->add_control(
            'icon_color',
             [
                'label' => __('Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn .icon i' => 'color: {{VALUE}}!important;',
                ],
             ]
          );
        // icon end =======================================================================
        $this->end_controls_tab();
        $this->end_controls_tabs();
        // icon end =======================================================================
        $this->add_control(
            'hr0',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        // Button content start =======================================================================
        $this->start_controls_tabs(
            'group_two'
        );
        // Button style start =======================================================================
        $this->start_controls_tab(
            'group_tab_three',
            [
                  'label' => esc_html__( 'Button Content', 'copygen-addons' ),
            ]
        );
        // Button style start =======================================================================
        $this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', 'copygen-addons' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Contact us' , 'copygen-addons'),
		]);
        $this->add_control(
            'hr10',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label' => __('Link', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'copygen-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );  

        // Button content start =======================================================================
        $this->end_controls_tab();
        // Button style start =======================================================================
        $this->start_controls_tab(
            'group_tab_four',
            [
                'label' => esc_html__( 'Button Style', 'copygen-addons' ),
            ]
        );
        // Button style start =======================================================================
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Button Typography', 'copygen-addons' ),
                'name' => 'button_typo',
                'selector' => '{{WRAPPER}} .theme_btn',
            ]
        );
        $this->add_control(
            'hr11',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'button_color',
             [
                'label' => __('Button Text Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'hr12',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_color',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .theme_btn ',
            ]
        );

        $this->add_control(
            'hr13',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
      
        $this->add_control(
            'border_color',
            [
                'label' => __('Button Border Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn ' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'hr14',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px' , 'rem' , 'em' , '%'],
                'selectors' => [
                    '{{WRAPPER}} .theme_btn   ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'hr15',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'number',
            [
                'label' => __('Button With', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 500,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn  ' => 'min-width: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_control(
            'hr16',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => __( 'Padding', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px' , 'rem' , 'em' , '%'],
                'selectors' => [
                    '{{WRAPPER}} .theme_btn   ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'hr17',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'icon_hover_color',
             [
                'label' => __('Icon Hover Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover i' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'hr18',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'button_color_hover',
            [
                'label' => __('Button Hover Text Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover ' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'hr19',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control( 
            \Elementor\Group_Control_Background::get_type(),
            [
    
                'name' => 'background_color_hover',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .theme_btn:hover ',
            ]
        );
        $this->add_control(
            'hr20',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'border_color_hover',
            [
                'label' => __('Button Hover Border Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover ' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );
         // button end =======================================================================
         $this->end_controls_tab();
         $this->end_controls_tabs();
         // button end =======================================================================
        $this->end_controls_section();
    }
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<?php $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
$nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : ''; ?> 
        <?php if($settings['theme_btn_styles'] == 'style_two'): ?>
        <div class="theme_btn_all">
            <a class="show-all" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                <?php // icon ?>
                <?php if($settings['icon_enable'] == 'yes'): ?>
                    <?php if($settings['icon_alignment'] == 'ileft'): ?>
                        <?php if($settings['icon_type'] == 'image'): ?>
                            <?php if(!empty($settings['image']['url'])): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                                </div>
                            <?php endif; ?>
                        <?php elseif($settings['icon_type'] == 'elicon'): ?>
                            <?php if(!empty($settings['icon_lib'])): ?>
                                <div class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                </div>
                            <?php endif; ?>		
                        <?php else: ?>
                            <?php if(!empty($settings['icon'])): ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                                </div> 
                            <?php endif; ?>		
                        <?php endif; ?>
                    <?php endif; ?>	
                <?php endif; ?>
                <?php // icon ?>
                <?php // button text ?>
                    <?php echo esc_html($settings['button_text']);?>
                <?php // button text ?>
                <?php // icon ?>
                <?php if($settings['icon_enable'] == 'yes'): ?>
                    <?php if($settings['icon_alignment'] == 'iright'): ?>
                        <?php if($settings['icon_type'] == 'image'): ?>
                            <?php if(!empty($settings['image']['url'])): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                                </div>
                            <?php endif; ?>
                        <?php elseif($settings['icon_type'] == 'elicon'): ?>
                            <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                            <?php endif; ?>		
                        <?php else: ?>
                            <?php if(!empty($settings['icon'])): ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div> 
                            <?php endif; ?>		
                        <?php endif; ?>
                    <?php endif; ?>	
                <?php endif; ?>
                <?php // icon ?>
            </a> 
        </div>
        <?php // style  two end ?>
        <?php else: ?>
        <?php // style  one ?>
        <div class="theme_btn_all">
            <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?> class="theme_btn">
                <?php // icon ?>
                <?php if($settings['icon_enable'] == 'yes'): ?>
                    <?php if($settings['icon_alignment'] == 'ileft'): ?>
                        <?php if($settings['icon_type'] == 'image'): ?>
                            <?php if(!empty($settings['image']['url'])): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                                </div>
                            <?php endif; ?>
                        <?php elseif($settings['icon_type'] == 'elicon'): ?>
                            <?php if(!empty($settings['icon_lib'])): ?>
                                <div class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                </div>
                            <?php endif; ?>		
                        <?php else: ?>
                            <?php if(!empty($settings['icon'])): ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                                </div> 
                            <?php endif; ?>		
                        <?php endif; ?>
                    <?php endif; ?>	
                <?php endif; ?>	
                <?php // icon ?>
                <?php // button text ?>
                    <?php echo esc_html($settings['button_text']);?>
                <?php // button text ?>
                <?php // icon ?>
                <?php if($settings['icon_enable'] == 'yes'): ?>
                    <?php if($settings['icon_alignment'] == 'iright'): ?>
                        <?php if($settings['icon_type'] == 'image'): ?>
                            <?php if(!empty($settings['image']['url'])): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                                </div>
                            <?php endif; ?>
                        <?php elseif($settings['icon_type'] == 'elicon'): ?>
                            <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                            <?php endif; ?>		
                        <?php else: ?>
                            <?php if(!empty($settings['icon'])): ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div> 
                            <?php endif; ?>		
                        <?php endif; ?>
                    <?php endif; ?>	
                <?php endif; ?>	
                <?php // icon ?>
            </a>
        </div>
    <?php endif; ?>
    <?php
    }
}

 