<?php
namespace  Copygenaddons\Core\Widgets\Content;
   if (!defined('ABSPATH')) {
       exit;
   } // If this file is called directly, abort.
   
   class Text_editor extends \Elementor\Widget_Base
   {
   
       public function get_name()
       {
           return 'copygen-text-editor-v1';
       }
   
       public function get_title()
       {
           return __('Text Editor V1' , 'copygen-addons');
       }
   
       public function get_icon()
       {
           return 'icon-steel';
       }
   
       public function get_categories()
       {
           return ['101'];
       }
   
       
   
       /**
 * Register text editor widget controls.
 *
 * Adds different input fields to allow the user to change and customize the widget settings.
 *
 * @since 3.1.0
 * @access protected
 */
protected function register_controls() {
    $this->start_controls_section(
        'section_editor',
        [
            'label' => esc_html__( 'Text Editor', 'copygen-addons' ),
        ]
    );

    $this->add_control(
        'editor_copygen',
        [
            'label' => esc_html__( 'Text Editor', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::WYSIWYG,
            'default' => '<p>' . esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'copygen-addons' ) . '</p>',
        ]
    );
 

    $text_columns = range( 1, 10 );
    $text_columns = array_combine( $text_columns, $text_columns );
    $text_columns[''] = esc_html__( 'Default', 'copygen-addons' );

    $this->add_responsive_control(
        'text_columns',
        [
            'label' => esc_html__( 'Columns', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'separator' => 'before',
            'options' => $text_columns,
            'selectors' => [
                '{{WRAPPER}}' => 'columns: {{VALUE}};',
            ],
        ]
    );

    $this->add_responsive_control(
        'column_gap',
        [
            'label' => esc_html__( 'Columns Gap', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%', 'em', 'vw' ],
            'range' => [
                'px' => [
                    'max' => 100,
                ],
                '%' => [
                    'max' => 10,
                    'step' => 0.1,
                ],
                'vw' => [
                    'max' => 10,
                    'step' => 0.1,
                ],
                'em' => [
                    'max' => 10,
                    'step' => 0.1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}' => 'column-gap: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
        'section_style',
        [
            'label' => esc_html__( 'Text Editor', 'copygen-addons' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_responsive_control(
        'align',
        [
            'label' => esc_html__( 'Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justified', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .position_p_relative ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );

    $this->add_control(
        'text_color',
        [
            'label' => esc_html__( 'Text Color', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .position_p_relative  , {{WRAPPER}} .position_p_relative  p , {{WRAPPER}} .position_p_relative h1 , {{WRAPPER}}
                .position_p_relative h2 , {{WRAPPER}} .position_p_relative h3 , {{WRAPPER}} .position_p_relative h4 , {{WRAPPER}} .position_p_relative h5 , {{WRAPPER}} .position_p_relative h6 , {{WRAPPER}} .position_p_relative a ,
                {{WRAPPER}} .position_p_relative ul li , {{WRAPPER}} .position_p_relative ul li a ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'typography_crs',
            'selector' =>  '{{WRAPPER}}  .position_p_relative  , {{WRAPPER}} .position_p_relative  p , {{WRAPPER}} .position_p_relative h1 , {{WRAPPER}}
                .position_p_relative h2 , {{WRAPPER}} .position_p_relative h3 , {{WRAPPER}} .position_p_relative h4 , {{WRAPPER}} .position_p_relative h5 , {{WRAPPER}} .position_p_relative h6 , {{WRAPPER}} .position_p_relative a ,
                {{WRAPPER}}  .position_p_relative ul li , {{WRAPPER}} .position_p_relative ul li a '
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
            'name' => 'text_shadow_crs',
            'selector' =>  '{{WRAPPER}}  .position_p_relative  , {{WRAPPER}} .position_p_relative  p , {{WRAPPER}} .position_p_relative h1 ,
            {{WRAPPER}} .position_p_relative h2 , {{WRAPPER}} .position_p_relative h3 , {{WRAPPER}} .position_p_relative h4 , {{WRAPPER}} .position_p_relative h5 , {{WRAPPER}} .position_p_relative h6 , {{WRAPPER}} .position_p_relative a ,
            {{WRAPPER}} .position_p_relative ul li , {{WRAPPER}} .position_p_relative ul li a ' 
        ]
    );

 

   
    $this->end_controls_section();
}

protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');
?>
   <div class="position-relative position_p_relative" data-scroll>
        <?php echo wp_kses($settings['editor_copygen'] , $allowed_tags); ?>
    </div>
<?php
}
}
