<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Testimonial_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-testimonil-v1';
    }

    public function get_title()
    {
        return __('Testimonial  Carousel  V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
    // style one start
    $this->start_controls_section('testc_settings',
    [ 
        'label' => __('Testimonial Content', 'copygen-addons'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
    );
        $this->add_control(
            'test_type',
            [
                'label' => __('Testimonial  Type', 'rakon-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'grid' => [
                        'title' => __( 'Grid Type', 'rakon-addons' ),
                        'icon' => 'eicon-gallery-grid',
                    ],
                    'carousel' => [
                        'title' => __( 'Carousel Type', 'rakon-addons' ),
                        'icon' => 'eicon-carousel-loop',
                    ],
                ],
                'default' => 'carousel',
            
            ]
        );
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'testi_style',
            [
            'label' => __('Testimonial Styles', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'copygen-addons' ),
                'style_two' => __( 'Style Two', 'copygen-addons' ),
                'style_three' => __( 'Style Three', 'copygen-addons' ),
                'style_four' => __( 'Style Four', 'copygen-addons' ),
            ],
            'default' => __('style_one' , 'copygen-addons'),
            ]
        );
        $this->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'column_type',
            [
            'label' => __('Testimonial Styles', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'one_column' => __( 'One Column', 'copygen-addons' ),
                'two_column' => __( 'Two Column', 'copygen-addons' ),
                'three_column' => __( 'Three Column', 'copygen-addons' ),
                'four_column' => __( 'Four Column', 'copygen-addons' ),
            ],
            'default' => __('one_column' , 'copygen-addons'),
            'condition' => [
                'test_type' => 'grid' , 
            ],
            ]
        );
        
        $this->add_control(
            'desktop',
            [
                'label' => __('Carousel Items to Display Desktop', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'hr4',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'tablet',
            [
                'label' => __('Carousel Items to Display Tablet', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'hr5',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'mobile',
            [
                'label' => __('Carousel Items to Display Mobile', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '1',
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'hr55',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'test_type' => 'carousel' , 
                    'testi_style' => 'style_three'
                ],
            ]
        );
        $this->add_control(
            'center_enable',
                [
                    'label' => __('Center Enable', 'copygen-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', 'copygen-addons'),
                    'label_off' => __('No', 'copygen-addons'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' => [
                        'test_type' => 'carousel' , 
                        'testi_style' => 'style_three'
                    ],
                ]
            );

        $this->add_control(
            'hr6',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'item_margin',
            [
                'label' => __('Carousel Items Space', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 100,
                'step'    => 1,
                'default' => 20,
                'condition' => [
                    'test_type' => 'carousel' , 
                ],
            ]
        );
        $this->add_control(
            'hr14',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'quote_enable',
        [
            'label' => __('Quote Icon Enable', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'no',
        ]
        );
        $repeater->add_control(
            'hr76',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'image_enable',
        [
            'label' => __('Image Enable', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'copygen-addons'),
            'label_off' => __('No', 'copygen-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
        );
        $repeater->add_control(
            'hr7',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_enable' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'hr8',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'image_enable' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
            'label'       => esc_html__( 'Name', 'copygen-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Wade Warren' , 'copygen-addons'),
        ]);
        $repeater->add_control(
            'hr9',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'designation',
            [
            'label'       => esc_html__( 'Designation', 'copygen-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Senior Manager of Excel Solution' , 'copygen-addons'),
        ]);
        $repeater->add_control(
            'hr10',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
        'title',
            [
                'label'       => esc_html__( 'Highlight Content', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'We’re building a better application now, thanks to copygen.' , 'copygen-addons'),
                'description' =>  esc_html__( 'Content For Style One' , 'copygen-addons'),
            ]
        );
        $repeater->add_control(
            'hr11',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
        'comments',
            [
                'label'       => esc_html__( 'Comment', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( '“At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti provident, similique sunt in culpa qui officia deserunt mollitia animi”' , 'copygen-addons'),
            ]
        );
        $repeater->add_control(
            'hr12',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
        'rating_enable',
            [
                'label' => __('Rating Enable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'rating_one',
            [
                'label' => __( 'Rating', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' =>  'two' , 
                'options' => [
                    'one' => __('1', 'copygen-addons'),
                    'two' => __('2', 'copygen-addons'),
                    'three' => __('3', 'copygen-addons'),
                    'four' => __('4', 'copygen-addons'),
                    'five' => __('5', 'copygen-addons'),
                ],
                'condition' => [
                    'rating_enable' => 'yes',
                ],
                'description' =>  esc_html__( 'Rating For Style 1 /  Style 2' , 'copygen-addons'),
            ]
        );
        $repeater->add_control(
            'hr13',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
       
        $this->add_control(
            'testi_repeater',
            [
                'label' => __('Testimonial Content', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Fleix Everard ', 'copygen-addons'),
                        'designation' =>  __('HR, Blue Soft Sol', 'copygen-addons'),
                        'comments'  =>  __('“At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti provident, similique sunt in culpa qui officia deserunt mollitia animi”', 'copygen-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three' ,
                    ],
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Boris Elbert ', 'copygen-addons'),
                        'designation' =>  __('Green Tech', 'copygen-addons'),
                        'comments'  =>  __('“At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti provident, similique sunt in culpa qui officia deserunt mollitia animi”', 'copygen-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ], 
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Ivor Herbert', 'copygen-addons'),
                        'designation' =>  __('Manager, Airlines', 'copygen-addons'),
                        'comments'  =>  __('“At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti provident, similique sunt in culpa qui officia deserunt mollitia animi”', 'copygen-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ]
                ],
                'title_field' => '{{{ name }}}',

            ]
        );
    $this->end_controls_section();
    $this->start_controls_section('csutomcss',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'testibg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .testimonial_box.type_one , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card ',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'boxshadows',
            'selector' => '{{WRAPPER}} .testimonial_box.type_one , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card  ', 
        ]
    );
    $this->add_control(
        'hr1p',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'bg_border_color',
         [
            'label' => __('Box  Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one ' => 'border:1px solid {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
         ]
    );
    $this->add_control(
        'shr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
        ]
    );
    $this->add_control(
        'ho_border_color',
         [
            'label' => __('Box Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one:hover ' => 'border-color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
         ]
    );
    $this->add_control(
        'hr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
        ]
    );
    
     $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'authour_image_bg_color',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .nk-testimonial-img',
                'condition' => [
                    'testi_style' => 'style_two',
                ],
            ]
        );
    $this->add_control(
        'shr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => 'style_two',
            ],
        ]
    );
    $this->add_control(
        'rating_color',
         [
            'label' => __('Rating Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .top_content p i , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .rating i   ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_one', 'style_four', 'style_three']
            ],
         ]
    ); 
    $this->add_control(
        'ratingbg_color',
         [
            'label' => __('Rating Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .rating i   ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_three',
            ],
         ]
    ); 
    $this->add_control(
        'shr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => ['style_three'],
            ],
        ]
    );
    $this->add_control(
        'quote_color',
         [
            'label' => __('Quote Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .nk-testimonial-content .copy-quote-left ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );
    $this->add_control(
        'shr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => 'style_two',
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 't_typos',
            'selector' => '{{WRAPPER}} .testimonial_box.type_one .title_no_a_20 ',
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
        ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Highlight Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .title_no_a_20 ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
         ]
    );
    $this->add_control(
        'hr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => ['style_one' , 'style_four'],
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Comment Typography', 'copygen-addons' ),
            'name' => 'd_typos',
            'selector' => '{{WRAPPER}} .testimonial_box.type_one .top_content p , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card  .title_no_a_20 , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card p ',
        ]
    );
    $this->add_control(
        'desc_color',
         [
            'label' => __('Comment Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .top_content p , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card  .title_no_a_20  , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card p ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
    $this->add_control(
        'hr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Authour Typography', 'copygen-addons' ),
            'name' => 'a_typos',
            'selector' => '{{WRAPPER}} .testimonial_box.type_one .l_content .cont .title_no_a_18 , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .title_no_a_18  , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .title_no_a_24 ',
        ]
    );
    $this->add_control(
        'auth_color',
         [
            'label' => __('Authour Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .l_content .cont .title_no_a_18 , {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .title_no_a_18 , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .title_no_a_24   ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
    $this->add_control(
        'hr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,  
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Job Typography', 'copygen-addons' ),
            'name' => 'j_typos',
            'selector' => '{{WRAPPER}} .testimonial_box.type_one .l_content .cont p  ,  {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .small , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .job ',
        ]
    );
    $this->add_control(
        'desg_color',
         [
            'label' => __('Job Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .l_content .cont p  ,  {{WRAPPER}} .testimonial_box.type_two .nk-testimonial-card .small , {{WRAPPER}} .testimonial_box.type_three .nk-testimonial-card .job ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
 
    $this->end_controls_section();

    $this->start_controls_section('owl_nav_style',
    [ 
        'label' => __('Naigation Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
   
    $this->add_control(
        'nav_display',
        [
        'label' => __('Naigation Enable / Disabel', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'nav_true' => __( 'Block', 'copygen-addons' ),
            'nav_false' => __( 'none', 'copygen-addons' ),
        ],
        'default' => 'nav_true' , 
       
        ]
    );
 
    $this->add_control(
        'nav_style_options',
        [
        'label' => __('Nav Move Position', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'position_one' => __( 'Position One', 'copygen-addons' ),
            'position_two' => __( 'Position Two', 'copygen-addons' ),
            'position_three' => __( 'Position Three', 'copygen-addons' ),
            'position_four' => __( 'Position Four', 'copygen-addons' ),
            'position_five' => __( 'Position Five', 'copygen-addons' ),
            'position_six' => __( 'Position Six', 'copygen-addons' ),
        ],
        'default' => 'position_one' , 
        ]
    );
    $this->add_responsive_control(
        'nav_move_count',
        [
            'label' => __('Nav Move Top', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_two' , 'position_three' , 'position_four'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav , {{WRAPPER}}  .position_four .owl-carousel .owl-nav 
                , {{WRAPPER}}  .position_five .owl-carousel .owl-nav , {{WRAPPER}}  .position_six .owl-carousel .owl-nav ' => 'top: {{VALUE}}px!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'nav_move_count_bottom',
        [
            'label' => __('Nav Move Bottom', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_five' , 'position_six'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav , {{WRAPPER}}  .position_four .owl-carousel .owl-nav ,
                 {{WRAPPER}}  .position_five .owl-carousel .owl-nav , {{WRAPPER}}  .position_six .owl-carousel .owl-nav ' => 'bottom: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'nav_move_prev_left',
        [
            'label' => __('Prev Move Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_four'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-prev   ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'nav_move_nest_right',
        [
            'label' => __('Prev Move Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_four'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-next   ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'snav_move_prev_left',
        [
            'label' => __('Move Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_four' , 'position_five' , 'position_three'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_five .owl-carousel .owl-nav , {{WRAPPER}}  .position_six .owl-carousel .owl-nav  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'snav_move_nest_right',
        [
            'label' => __('Move Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_four' ,  'position_six' , 'position_two'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_five .owl-carousel .owl-nav , {{WRAPPER}}  .position_six .owl-carousel .owl-nav  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );


    $this->add_control(
        'owl_nav_color',
         [
            'label' => __('Owl Nav Arrow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-nav i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_bg_color',
         [
            'label' => __('Owl Nav Arrow Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-prev , {{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-next ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'owl_nav_br_color',
         [
            'label' => __('Owl Nav Arrow Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-prev , {{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-next ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'owl_nav_hover_color',
         [
            'label' => __('Owl Nav Hover Arrow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-nav .owl-prev:hover i , {{WRAPPER}} .testimonial_carousel .owl-nav .owl-next:hover i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_hover_bg_color',
         [
            'label' => __('Owl Nav Hover Arrow Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-next:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'owl_nav_hover_br_color',
         [
            'label' => __('Owl Nav Hover Arrow Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .testimonial_carousel .owl-carousel .owl-nav .owl-next:hover ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_section();

    $this->start_controls_section('owl_dot_style',
    [ 
        'label' => __('Dots Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'copygen-addons' ),
            'dot_false' => __( 'none', 'copygen-addons' ),
        ],
        'default' => 'dot_true' , 
       
        ]
    ); 
    $this->add_responsive_control(
        'dotalignment',
        [
            'label' => esc_html__( 'Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dot_left',
        [
            'label' => __('Dot Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'left',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );

    $this->add_control(
        'dot_right',
        [
            'label' => __('Dot Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'right',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
    

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $center = '';
        if($settings['center_enable'] == 'yes' && $settings['test_type'] == 'carousel'){
            $center = 'true';
        }else{
            $center = 'false';
        }
    ?>
<?php if($settings['test_type'] == 'grid'): ?>
<?php // type grid ?>
<div class="testimonial_isotope <?php echo esc_attr($settings['column_type']); ?>">
    <?php if($settings['testi_style'] == 'style_two'): ?>
    <?php foreach($settings['testi_repeater'] as $test_block):?>
    <div class="test-wrapper">
        <div class="testimonial_box type_two">
            <div class="nk-testimonial-card">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="nk-testimonial-img">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="people-3">
                </div>
                <?php endif; ?>
                <div class="nk-testimonial-content">
                    <?php if($test_block['quote_enable'] == 'yes'): ?>
                    <div class="nk-testimonial-icon">
                        <em class="copy-quote-left"></em>
                    </div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['comments'])): ?>
                    <div class="title_no_a_20">
                        <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                    </div>
                    <?php endif; ?>
                    <div
                        class="d-flex flex-column flex-md-row justify-content-between align-items-center gap g-3 pt-3 pt-md-5">
                        <div class="media-text text-start">
                            <?php if(!empty($test_block['name'])): ?>
                            <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                            <?php endif; ?>
                            <?php if(!empty($test_block['designation'])): ?>
                            <span class="small"><?php echo esc_attr($test_block['designation']); ?></span>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php elseif($settings['testi_style'] == 'style_three'): ?>
    <?php foreach($settings['testi_repeater'] as $test_block):?>
    <div class="test-wrapper">
        <div class="testimonial_box type_three">
            <div class="nk-testimonial-card">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="nk-testimonial-img">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="people-3">
                </div>
                <?php endif; ?>
                <div class="nk-testimonial-content">
                    <?php if(!empty($test_block['name'])): ?>
                    <div class="title_no_a_24"><?php echo esc_attr($test_block['name']); ?></div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['designation'])): ?>
                    <span class="job"><?php echo esc_attr($test_block['designation']); ?></span>
                    <?php endif; ?>
                    <?php if(!empty($test_block['comments'])): ?>
                    <p>
                        <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                    </p>
                    <?php endif; ?>
                    <?php if($test_block['rating_enable'] == 'yes'): ?>
                    <p class="rating">
                        <?php if($test_block['rating_one'] == 'one'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'two'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'three'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'four'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'five'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star-fill"></i>
                        <?php else: ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star-fill"></i>
                        <?php endif; ?>
                    </p>
                    <?php endif; ?>
                    <?php if($test_block['quote_enable'] == 'yes'): ?>
                    <div class="nk-testimonial-icon">
                        <em class="copy-quote-left"></em>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php elseif($settings['testi_style'] == 'style_four'): ?>
        <?php foreach($settings['testi_repeater'] as $test_block):?>
            <div class="test-wrapper">
        <div class="testimonial_box type_one lit_chan trans">
            <div class="top_content">
                <div class="l_content d-flex align-items-center clearfix">
                    <?php if($test_block['image_enable'] == 'yes'): ?>
                    <div class="image_box">
                        <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                    </div>
                    <?php endif; ?>
                    <div class="cont">
                        <?php if(!empty($test_block['name'])): ?>
                        <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                        <?php endif; ?>
                        <?php if(!empty($test_block['designation'])): ?>
                        <p><?php echo esc_attr($test_block['designation']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if(!empty($test_block['title'])): ?>
                <div class="title_no_a_20">
                    <?php echo wp_kses($test_block['title'] , $allowed_tags); ?>
                </div>
                <?php endif; ?>
                <?php if(!empty($test_block['comments'])): ?>
                <p>
                    <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                </p>
                <?php endif; ?>
            </div>
            <?php if($test_block['rating_enable'] == 'yes'): ?>
            <p class="rating">
                <?php if($test_block['rating_one'] == 'one'): ?>
                <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'two'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'three'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'four'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'five'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star-fill"></i>
                <?php else: ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star-fill"></i>
                <?php endif; ?>
            </p>
            <?php endif; ?>

        </div>
        </div>
        <?php endforeach; ?>
    <?php else: ?>
    <?php foreach($settings['testi_repeater'] as $test_block):?>
    <div class="test-wrapper">
        <div class="testimonial_box type_one trans">
            <div class="top_content">
                <?php if($test_block['rating_enable'] == 'yes'): ?>
                <p class="rating">
                    <?php if($test_block['rating_one'] == 'one'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'two'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'three'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'four'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'five'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star-fill"></i>
                    <?php else: ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star-fill"></i>
                    <?php endif; ?>
                </p>
                <?php endif; ?>
                <?php if(!empty($test_block['title'])): ?>
                <div class="title_no_a_20">
                    <?php echo wp_kses($test_block['title'] , $allowed_tags); ?>
                </div>
                <?php endif; ?>
                <?php if(!empty($test_block['comments'])): ?>
                <p>
                    <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                </p>
                <?php endif; ?>
            </div>
            <div class="l_content d-flex align-items-center clearfix">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="image_box">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                </div>
                <?php endif; ?>
                <div class="cont">
                    <?php if(!empty($test_block['name'])): ?>
                    <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['designation'])): ?>
                    <p><?php echo esc_attr($test_block['designation']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php endif; ?>
</div>
<?php // type grid ?>
<?php else: ?>
<?php // type carousel ?>
<section
    class="testimonial_carousel  position-relative <?php echo esc_attr($settings['nav_style_options']); ?> <?php echo esc_attr($settings['nav_display']); ?> <?php echo esc_attr($settings['dots_display']); ?>"
    data-scroll>
    <div class="theme_carousel owl-theme owl-carousel"
        data-options='{"loop": true , "center":<?php echo esc_attr($center); ?> , "margin": <?php echo esc_attr($settings['item_margin']); ?>, "autoheight":true, "lazyload":true, "nav":true, "dots": true, "autoplay": false, "autoplayTimeout": 6000,  "smartSpeed": 300, "responsive":{ "0" :{ "items": "1" }, "320" :{ "items" : "1" }, "500" :{ "items" : "1" }, "768" :{ "items" : "<?php echo esc_attr($settings['mobile']); ?>" } , "992":{ "items" : "<?php echo esc_attr($settings['tablet']); ?>" }, "1200":{ "items" : "<?php echo esc_attr($settings['desktop']); ?>" }}}'>
        <?php if($settings['testi_style'] == 'style_two'): ?>
        <?php foreach($settings['testi_repeater'] as $test_block):?>
        <div class="testimonial_box type_two">
            <div class="nk-testimonial-card">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="nk-testimonial-img">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="people-3">
                </div>
                <?php endif; ?>
                <div class="nk-testimonial-content">
                    <?php if($test_block['quote_enable'] == 'yes'): ?>
                    <div class="nk-testimonial-icon">
                        <em class="copy-quote-left"></em>
                    </div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['comments'])): ?>
                    <div class="title_no_a_20">
                        <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                    </div>
                    <?php endif; ?>
                    <div
                        class="d-flex flex-column flex-md-row justify-content-between align-items-center gap g-3 pt-3 pt-md-5">
                        <div class="media-text text-start">
                            <?php if(!empty($test_block['name'])): ?>
                            <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                            <?php endif; ?>
                            <?php if(!empty($test_block['designation'])): ?>
                            <span class="small"><?php echo esc_attr($test_block['designation']); ?></span>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php elseif($settings['testi_style'] == 'style_three'): ?>
        <?php foreach($settings['testi_repeater'] as $test_block):?>

        <div class="testimonial_box type_three">
            <div class="nk-testimonial-card">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="nk-testimonial-img">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="people-3">
                </div>
                <?php endif; ?>
                <div class="nk-testimonial-content">
                    <?php if(!empty($test_block['name'])): ?>
                    <div class="title_no_a_24"><?php echo esc_attr($test_block['name']); ?></div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['designation'])): ?>
                    <span class="job"><?php echo esc_attr($test_block['designation']); ?></span>
                    <?php endif; ?>
                    <?php if(!empty($test_block['comments'])): ?>
                    <p>
                        <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                    </p>
                    <?php endif; ?>
                    <?php if($test_block['rating_enable'] == 'yes'): ?>
                    <p class="rating">
                        <?php if($test_block['rating_one'] == 'one'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'two'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'three'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star1"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'four'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star1"></i>
                        <?php elseif($test_block['rating_one'] == 'five'): ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star-fill"></i>
                        <?php else: ?>
                        <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                            class="copy-star-fill"></i><i class="copy-star-fill"></i>
                        <?php endif; ?>
                    </p>
                    <?php endif; ?>
                    <?php if($test_block['quote_enable'] == 'yes'): ?>
                    <div class="nk-testimonial-icon">
                        <em class="copy-quote-left"></em>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div> 
        <?php endforeach; ?>
        <?php elseif($settings['testi_style'] == 'style_four'): ?>
        <?php foreach($settings['testi_repeater'] as $test_block):?>
        <div class="testimonial_box type_one lit_chan trans">
            <div class="top_content">
                <div class="l_content d-flex align-items-center clearfix">
                    <?php if($test_block['image_enable'] == 'yes'): ?>
                    <div class="image_box">
                        <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                    </div>
                    <?php endif; ?>
                    <div class="cont">
                        <?php if(!empty($test_block['name'])): ?>
                        <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                        <?php endif; ?>
                        <?php if(!empty($test_block['designation'])): ?>
                        <p><?php echo esc_attr($test_block['designation']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if(!empty($test_block['title'])): ?>
                <div class="title_no_a_20">
                    <?php echo wp_kses($test_block['title'] , $allowed_tags); ?>
                </div>
                <?php endif; ?>
                <?php if(!empty($test_block['comments'])): ?>
                <p>
                    <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                </p>
                <?php endif; ?>
            </div>
            <?php if($test_block['rating_enable'] == 'yes'): ?>
            <p class="rating">
                <?php if($test_block['rating_one'] == 'one'): ?>
                <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'two'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'three'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star1"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'four'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star1"></i>
                <?php elseif($test_block['rating_one'] == 'five'): ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star-fill"></i>
                <?php else: ?>
                <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                    class="copy-star-fill"></i><i class="copy-star-fill"></i>
                <?php endif; ?>
            </p>
            <?php endif; ?>

        </div>
        <?php endforeach; ?>
        <?php else: ?>
        <?php foreach($settings['testi_repeater'] as $test_block):?>
        <div class="testimonial_box type_one trans">
            <div class="top_content">
                <?php if($test_block['rating_enable'] == 'yes'): ?>
                <p class="rating">
                    <?php if($test_block['rating_one'] == 'one'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star1"></i><i class="copy-star1"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'two'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star1"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'three'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star1"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'four'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star1"></i>
                    <?php elseif($test_block['rating_one'] == 'five'): ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star-fill"></i>
                    <?php else: ?>
                    <i class="copy-star-fill"></i><i class="copy-star-fill"></i><i class="copy-star-fill"></i><i
                        class="copy-star-fill"></i><i class="copy-star-fill"></i>
                    <?php endif; ?>
                </p>
                <?php endif; ?>
                <?php if(!empty($test_block['title'])): ?>
                <div class="title_no_a_20">
                    <?php echo wp_kses($test_block['title'] , $allowed_tags); ?>
                </div>
                <?php endif; ?>
                <?php if(!empty($test_block['comments'])): ?>
                <p>
                    <?php echo wp_kses($test_block['comments'] , $allowed_tags); ?>
                </p>
                <?php endif; ?>
            </div>
            <div class="l_content d-flex align-items-center clearfix">
                <?php if($test_block['image_enable'] == 'yes'): ?>
                <div class="image_box">
                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                </div>
                <?php endif; ?>
                <div class="cont">
                    <?php if(!empty($test_block['name'])): ?>
                    <div class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></div>
                    <?php endif; ?>
                    <?php if(!empty($test_block['designation'])): ?>
                    <p><?php echo esc_attr($test_block['designation']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endif; ?>
    </div>
</section>
<?php // type carousel ?>
<?php endif; ?>
<?php
    }
}

         