<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Tab_with_content_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-tab-with-content-v1';
    }

    public function get_title()
    {
        return __('Tab With Content V1' , 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
		$this->start_controls_section(
			'tab_content',
			[
				'label' => esc_html__( 'Tab Content', 'copygen-addons' ),
			]
        );
        $this->add_control(
            'tab_box_style',
            [
                'label' => __('Tab Style', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'type_one'  => __('Tab Style One', 'creote-addons'),
                    'type_two'  => __('Tab  Style Two', 'creote-addons'),
                    'type_three'  => __('Tab  Style Three', 'creote-addons'),
                ],
                'default' => 'type_one',
            ]
        );
        $this->add_control(
            'hr',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $this->add_control(
            'alignment_one',
            [
                'label' => esc_html__( 'Tab Button Type', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'inline' => [
                        'inline' => esc_html__( 'Inline', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'seperate' => [
                        'title' => esc_html__( 'Seperate', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-justify',
                    ], 
                ],
                'default' => 'inline',
                'toggle' => true,
                
            ]
        ); 
        $this->add_control(
            'alignment_two',
            [
                'label' => esc_html__( 'Tab Button Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'default' => [
                        'title' => esc_html__( 'Default Alignment', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ], 
                    'left' => [
                        'inline' => esc_html__( 'Alignment Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    
                    'right' => [
                        'title' => esc_html__( 'Alignment Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ], 
                ],
                'default' => 'default',
                'toggle' => true, 
            ]
        ); 
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab_id',
            [
                'label'       => esc_html__( 'Tab ID', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'tab_default' , 'copygen-addons'),
                'description' =>  esc_html__( 'Please Enter the tab id like this example : (tab_one , tab_two , tab_three)' , 'copygen-addons'),
            ]
        );
        $repeater->add_control(
            'h2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icons', 'copygen-addons' ), 
                    'elemetoricon'  => esc_html__( 'Elementor Icons', 'copygen-addons' ), 
                    'none'  => esc_html__( 'None', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Icon Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
         
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [
                    'icon_type' => 'icon'
                ]
            ]
        );
        $repeater->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elemetoricon'
                ]
            ]
        );
        $repeater->add_control(
            'h3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'title_enable',
            [
                'label' => esc_html__( 'Tab Title Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'tab_title',
            [
                'label'       => esc_html__( 'Tab Title', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Planting' , 'copygen-addons'),
                'condition' => [
                    'title_enable' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
            'h1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'img_enable',
            [
                'label' => esc_html__( 'Image Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'cimage',
            [
                'label' => __( 'Content Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ], 
                'condition' => [
                    'img_enable' => 'yes'
                ],
            ] 
        );
        $repeater->add_control(
            'hrl',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'content_t_enable',
            [
                'label' => esc_html__( 'Title Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'tab_t_content',
            [
                'label'       => esc_html__( 'Title', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Capture leads and make buying easy' , 'copygen-addons'),
                'condition' => [
                    'content_t_enable' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'content_enable',
            [
                'label' => esc_html__( 'Content Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'tab_content',
            [
                'label'       => esc_html__( 'Tab Content', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam aperiam, eaquecy epsa abillo inventore veritatis architecto beatae' , 'copygen-addons'),
                'condition' => [
                    'content_enable' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
            'hr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'list_enable',
            [
                'label' => esc_html__( 'List 1 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'tab_list_items',
            [
                'label'       => esc_html__( 'Tab List Items', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Best Insurance Agency
                Trusted & Experience Insurance
                Dedicated Support & Security' , 'copygen-addons'), 
                'condition' => [
                    'list_enable' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
            'hr4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'list2_enable',
            [
                'label' => esc_html__( 'List 2 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'no', 
            ]
        );
        $repeater->add_control(
            'tab_list_items_two',
            [
                'label'       => esc_html__( 'Tab List Items', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Best Insurance Agency
                Trusted & Experience Insurance
                Dedicated Support & Security' , 'copygen-addons'), 
                'condition' => [
                    'list2_enable' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
            'hr5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'btn_enable',
            [
                'label' => esc_html__( 'Button 1 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'btnone',
            [
                'label'       => esc_html__( 'Button One', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Get started' , 'copygen-addons'),
                'condition' => [
                    'btn_enable' => 'yes'
                ], 
            ]
        );
        
        $repeater->add_control(
            'btnonelink',
            [
                'label' => __('Button One Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'btn_enable' => 'yes'
                ],
            ]
        );  
        $repeater->add_control(
            'hr6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'btn2_enable',
            [
                'label' => esc_html__( 'Button 2 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater->add_control(
            'btntwo',
            [
                'label'       => esc_html__( 'Button Two', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__('Learn More' , 'copygen-addons'), 
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        );
        
        $repeater->add_control(
            'btntwolink',
            [
                'label' => __('Button Two Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'content_repeater',
            [
                'label' => __( 'Tab Content Repeater', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon_type' => 'icon' ,
                        'icon' => 'copy-flag' ,
                        'tab_title' => __( 'Social Media & Ads', 'copygen-addons' ),
                        'tab_id' => 'tab1' ,
                        'content_t_enable' => 'yes',
                        'tab_t_content' =>  __( 'Generate months of social media content in minutes
                        ', 'copygen-addons' ),
                        'tab_content' => __( 'Simply choose a template from available list to write content for blog posts, landing page, website content etc.', 'copygen-addons' ),
                        'tab_list_items' => __( 'Analyze your business cost easily with group transaction thorugh tagging feature. 
                        Arrange your business expenses by date, name, etc. 
                        Add more than one card for payment. Integrated with more than 50+ payment method and support bulk payment.', 'copygen-addons' ),
                      
                    ],
                    [
                        'icon_type' => 'icon' ,
                        'icon' => 'copy-globe' ,
                        'tab_title' => __( 'Website Copy & SEO', 'copygen-addons' ),
                        'tab_id' => 'tab2' ,
                        'content_t_enable' => 'yes',
                        'tab_t_content' =>  __('Improve Your Websites Visibility and User Experience' ),
                        'tab_content' => __( 'Your website copy is one of the most important factors in determining whether or not people stay on your website and take the actions you want them to take. It needs to be clear, concise, and engaging, while also providing valuable information that visitors will find useful.', 'copygen-addons' ),
                        'tab_list_items' => __( 'Establish trust: By providing helpful and informative content, you can establish yourself as an authority in your field and build trust with your audience. 
                        Build credibility: When your website appears at the top of search results, it can help to build credibility and trust with your audience.', 'copygen-addons' ),
                    ],
                    [
                        'icon_type' => 'icon' ,
                        'icon' => 'copy-edit' ,
                        'tab_title' => __( 'Blog Section Writing', 'copygen-addons' ),
                        'tab_id' => 'tab3' ,
                        'content_t_enable' => 'yes',
                        'tab_t_content' =>  __( 'Engage Your Audience and Build Your Brand', 'copygen-addons' ),
                        'tab_content' => __( 'In todays digital age, a blog is an essential tool for any business looking to build its brand and engage with its audience.', 'copygen-addons' ),
                        'tab_list_items' => __( 'Before you start writing, its important to identify who your target audience is. Who are you trying to reach with your blog? What are their interests and pain points?
                        Your blog topics should be relevant to your business and your audience. Think about the questions and concerns your customers', 'copygen-addons' ),
                    ] ,
                    [
                        'icon_type' => 'icon' ,
                        'icon' => 'copy-briefcase' , 
                        'tab_title' => __( 'eCommerce Copy', 'copygen-addons' ),
                        'tab_id' => 'tab4' ,
                        'content_t_enable' => 'yes',
                        'tab_t_content' =>  __( 'Introducing our new Wireless Bluetooth Earbuds!', 'copygen-addons' ),
                        'tab_content' => __( 'Experience music like never before with our cutting-edge Wireless Bluetooth Earbuds. With advanced noise-cancelling technology and crystal-clear sound, youll be able to fully immerse yourself in your favorite tunes.', 'copygen-addons' ),
                        'tab_list_items' => __( 'Our earbuds are ergonomically designed to fit comfortably in your ears, and they are so lightweight that you will hardly know youre wearing them. They are also sweat-proof and water-resistant, so you can take them with you wherever you go, whether you are running, hiking, or just lounging by the pool.', 'copygen-addons' ),
                    ],
                    [
                        'icon_type' => 'icon' ,
                        'icon' => 'copy-chat-msg' , 
                        'tab_title' => __( 'Magic Command', 'copygen-addons' ),
                        'tab_id' => 'tab5' ,
                        'content_t_enable' => 'yes',
                        'tab_t_content' =>  __( "I've been shopping with this company for years, and I can honestly say that their customer service is second to none. I highly recommend this company to anyone looking for a great shopping experience.", 'copygen-addons' ),
                        'tab_content' => __( 'Simply choose a template from available list to write content for blog posts, landing page, website content etc.', 'copygen-addons' ),
                        'tab_list_items' => __( 'Our earbuds are ergonomically designed to fit comfortably in your ears, and they are so lightweight that you will hardly know you are wearing them. They are also sweat-proof and water-resistant, so you can take them with you wherever you go, whether you are running, hiking, or just lounging by the pool.', 'copygen-addons' ),
                    ]
                ],
                'title_field' => '{{{tab_title}}}',
            ]
        );
 
     $this->end_controls_section(); 

     $this->start_controls_section('tab_title_css',
     [ 
         'label' => __('Tab Css', 'copygen-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     ); 
     $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Normal', 'copygen-addons' ),
        ]
    );

    $this->add_control(
        'tabbtn_bg',
         [
            'label' => __('Tab Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_two'
            ],
         ]
    );
    $this->add_control(
        'tabbtn_bpor',
         [
            'label' => __('Tab Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_two'
            ],
         ]
    );
    $this->add_control(
        'tthhr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'tab_box_style' => 'type_two'
            ],
        ]
    ); 
     $this->add_control(
        'tabicss',
         [
            'label' => __('Tab Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tabibrcss',
         [
            'label' => __('Tab Icon Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'tabibgcss',
         [
            'label' => __('Tab Icon Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'hhr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
     $this->add_responsive_control(
        'icon_font_size',
        [
            'label' => __('Icon Size', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon i ' => 'font-size: {{VALUE}}px!important;', 
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon img , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon svg  ' => 'width: {{VALUE}}px!important;', 
            ], 
        ]
    );
    $this->add_responsive_control(
        'icon_width',
        [
            'label' => __('Icon Width', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon ' => 'width: {{VALUE}}px!important;', 
            ], 
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
        ]
    );
    $this->add_responsive_control(
        'icon_height',
        [
            'label' => __('Icon Height', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon  ' => 'height: {{VALUE}}px!important;', 
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon i ' => 'line-height: {{VALUE}}px!important;', 
            ], 
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
        ]
    );
    $this->add_control(
        'iconbrr_css',
         [
            'label' => __('Icon Border Radius', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link .icon  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'hhrt4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Tab Title Typography', 'copygen-addons' ),
            'name' => 'tab_title_typo',
            'selector' => '{{WRAPPER}} .showcase_tabs_btns .nav-item a .title_no_a_20',
        ]
    );
    $this->add_control(
        'tabtcss',
         [
            'label' => __('Tab Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .showcase_tabs_btns .nav-item a .title_no_a_20 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'tabrcss',
         [
            'label' => __('Tab Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content.type_three .showcase_tabs_btns::before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_three'
            ],
         ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
        'style_hover_tab',
        [
            'label' => esc_html__( 'Hover / Active', 'copygen-addons' ),
        ]
    );
    $this->add_control(
        'htabicss',
         [
            'label' => __('Tab Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link.active .icon i , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link:hover .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'htabibrcss',
         [
            'label' => __('Tab Icon Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link.active .icon , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link:hover .icon ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'htabibgcss',
         [
            'label' => __('Tab Icon Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link.active .icon , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link:hover .icon ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'chro',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'tabthacss',
         [
            'label' => __('Tab Title  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link.active .title_no_a_20 , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link:hover .icon .title_no_a_20 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_title_active_bg',
         [
            'label' => __('Tab Title Bg  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link.active , {{WRAPPER}} .tabs_with_content .nav-pills .nav-item .nav-link:hover  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_two'
            ],
         ]
    ); 

    $this->add_control(
        'taabrcss',
         [
            'label' => __('Tab Active Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content.type_three .showcase_tabs_btns .nav-item a.active , {{WRAPPER}} .tabs_with_content.type_three .showcase_tabs_btns .nav-item a:hover ' => 'border-bottom-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'tab_box_style' => 'type_three'
            ],
         ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section(); 

    $this->start_controls_section('tabimagecss',
     [ 
         'label' => __('Tab Content Css', 'copygen-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
    ); 
    
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'tab_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .tabs_with_content.type_three .tab_content_box ',
        ]
    ); 
    $this->add_control(
        'thr1',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadowcolor',
            'selector' => '{{WRAPPER}}  .tabs_with_content.type_three .tab_content_box  ', 
        ]
    ); 
    $this->add_control(
        'thr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'tab_conten_padding',
        [
            'label' => esc_html__( 'Tab Content Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content.type_three .tab_content_box ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    ); 
    $this->add_control(
        'thr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );

     $this->add_responsive_control(
        'imgheight',
        [
            'label' => __('Image Height', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 5000,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .image_box img.base  ' => 'height: {{VALUE}}px!important;',  
            ], 
        ]
    );
     $this->add_control(
        'image_css',
         [
            'label' => __('Tab Image Border Radius', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}}  .tabs_with_content .s_tabs_content .s_tab .image_box img.base ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
         ]
    );

    $this->add_control(
        'objectfit',
        [
            'label' => esc_html__( 'Object Fit', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'contain' => [
                    'title' => esc_html__( 'Object Fit Contain', 'copygen-addons' ),
                    'icon' => 'fa fa-image',
                ], 
                'cover' => [
                    'inline' => esc_html__( 'Object Fit Cover', 'copygen-addons' ),
                    'icon' => 'eicon-image-bold',
                ], 
            ],
            'default' => 'default',
            'toggle' => true,  
            'selectors' => [
                '{{WRAPPER}}  .tabs_with_content .s_tabs_content .s_tab .image_box img.base ' => 'object-fit: {{VALUE}}!important;',
            ],
        ]
    ); 
 
    $this->add_control(
        'chr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 'c_title_typo',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .title_no_a_28 ',
        ]
    );
    $this->add_control(
        'tcolor',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .title_no_a_28 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'chr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Content Typography', 'copygen-addons' ),
            'name' => 'cdes_typo',
            'selector' => '{{WRAPPER}}  .tabs_with_content .s_tabs_content .s_tab .content ',
        ]
    );
    $this->add_control(
        'contentcolor',
         [
            'label' => __('Content Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .content ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'chr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'List Typography', 'copygen-addons' ),
            'name' => 'ldes_typo',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .d-flex ul li ',
        ]
    );
    $this->add_control(
        'listsvgcolor',
         [
            'label' => __('List Svg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .d-flex ul li svg circle ' => 'fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'listcolor',
         [
            'label' => __('List Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .d-flex ul li ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->end_controls_section();
    $this->start_controls_section('buttoncss',
    [ 
        'label' => __('ButtonCss', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    ); 
    $this->start_controls_tabs(
        'style_tabst'
    );
    $this->start_controls_tab(
        'style_normal_tabt',
        [
            'label' => esc_html__( 'Button One', 'copygen-addons' ),
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Btn Typography', 'copygen-addons' ),
            'name' => 'btntypo',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn ',
        ]
    );
    $this->add_control(
        'btncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'chr66',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
            'name' => 'border',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn  ',
        ]
    );
    $this->add_control(
        'chr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'button_border_radius',
         [
            'label' => __('Button Radius', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'button_padding_radius',
         [
            'label' => __('Button Padding', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'chr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'background',
            'types' => [ 'classic', 'gradient'],
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.one .theme_btn ',
        ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
        'style_hover_tabt',
        [
            'label' => esc_html__( 'Button Two', 'copygen-addons' ),
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Btn Typography', 'copygen-addons' ),
            'name' => 'btntwotypo',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn ',
        ]
    );
    $this->add_control(
        'tbtncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tchr66',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
            'name' => 'tborder',
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn  ',
        ]
    );
    $this->add_control(
        'tchr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'tbutton_border_radius',
         [
            'label' => __('Button Radius', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'tbutton_padding_radius',
         [
            'label' => __('Button Padding', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'tchr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'tbackground',
            'types' => [ 'classic', 'gradient'],
            'selector' => '{{WRAPPER}} .tabs_with_content .s_tabs_content .s_tab .list_buttons li.two .theme_btn ',
        ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section(); 
}
protected function render() {
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$content_repeaters = $settings['content_repeater'];
?>
<section class="tabs_with_content  copygen_tab <?php echo esc_attr($settings['tab_box_style']); ?>">
   <div class="tab_over_all_box">
    
      <div class="tabs_header clearfix">
         <ul class="showcase_tabs_btns nav-pills nav clearfix tab_<?php echo esc_attr($settings['alignment_one']); ?>">
            <?php if(!empty($content_repeaters)): ?>
                <?php foreach($content_repeaters as $key => $content_repeater): ?>
                <li class="nav-item">
                    <a class="s_tab_btn nav-link <?php if($key == 0) echo 'active';?>" data-tab="#tab_<?php echo esc_attr($content_repeater['tab_id']);?>"> 
                        <?php if($content_repeater['icon_type'] == 'image'): ?>
                            <?php if(!empty($content_repeater['image']['url'])): ?>
                            <div class="icon">
                                <img src="<?php echo esc_url($content_repeater['image']['url']); ?>" alt="img" />
                            </div>
                            <?php endif; ?>
                            <?php elseif($content_repeater['icon_type'] == 'elemetoricon'): ?>
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon($content_repeater['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                            <?php elseif($content_repeater['icon_type'] == 'none'): ?>
                            <?php //  none ?>
                            <?php else: ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr($content_repeater['icon']); ?>"></i>
                            </div>
                            <?php endif; ?>
                            <?php if($content_repeater['title_enable'] == 'yes'): ?>
                            <small class="title_no_a_20"><?php echo esc_attr($content_repeater['tab_title']);?></small>
                        <?php endif; ?>
                    </a>
                </li>
                <?php endforeach; ?>
            <?php endif; ?>
         </ul>
      </div>
      <div class="s_tab_wrapper align_<?php echo esc_attr($settings['alignment_two']); ?>">
         <div class="s_tabs_content">
         <?php if(!empty($content_repeaters)): ?>
                <?php foreach($content_repeaters as $key => $content_repeater): ?>
            <div class="s_tab fade <?php if($key == 0) echo 'active-tab show';?>" id="tab_<?php echo esc_attr($content_repeater['tab_id']); ?>">
            <div class="tab_content_box">
                <?php if($content_repeater['img_enable'] == 'yes'): // image enable ?>
                    <div class="image_box">
                        <?php if(!empty($content_repeater['cimage']['url'])): ?>
                            <img src="<?php echo esc_url($content_repeater['cimage']['url']); ?>" alt="cover-bg" class="base">
                        <?php endif; ?>
                    </div>
                <?php endif; // image enable end ?>
                <div class="content_box">
                <?php if($content_repeater['content_t_enable'] == 'yes'): // tab title enable ?>
                    <?php if(!empty($content_repeater['tab_t_content'])): ?>
                        <div class="title_no_a_28">
                            <?php echo wp_kses($content_repeater['tab_t_content'] , $allowed_tags); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; // tab title end ?>
                <?php if($content_repeater['content_enable'] == 'yes'): // tab title enable ?>
                    <?php if(!empty($content_repeater['tab_content'])): ?>
                        <div class="content">
                            <?php echo wp_kses($content_repeater['tab_content'] , $allowed_tags); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; // tab title end ?>
                <?php if($content_repeater['list_enable'] == 'yes' || $content_repeater['list2_enable'] == 'yes'): // list content ?>
                <div class="d-flex">
                    <?php if($content_repeater['list_enable'] == 'yes'): // list content ?>
                    <?php if(!empty($content_repeater['tab_list_items'])): ?>
                        <ul>
                            <?php $tab_list_items = explode("\n", ($content_repeater['tab_list_items']));?>
                            <?php foreach($tab_list_items as $tab_list_item):?>
                            <li>
                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="12.5" cy="12.5" r="12.5" fill="#36DB9F" />
                                    <g>
                                        <path
                                            d="M11.8363 18.7066C12.2244 19.0994 13.0886 18.9692 13.1817 18.3516C13.7607 14.5175 16.6577 11.2829 18.85 8.23494C19.4579 7.39031 18.0602 6.58795 17.4602 7.42252C15.4568 10.2075 12.9317 13.138 11.9439 16.5174C10.815 15.3637 9.68161 14.221 8.41548 13.2072C7.61364 12.5649 6.46665 13.6965 7.27713 14.3455C8.92674 15.6668 10.3523 17.2076 11.8363 18.7066Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath>
                                            <rect width="12" height="12" fill="white" transform="translate(7 7)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                                <span> <?php echo wp_kses($tab_list_item, true); ?></span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    <?php endif; // list content end ?>
                    <?php if($content_repeater['list2_enable'] == 'yes'): // list content ?>
                    <?php if(!empty($content_repeater['tab_list_items_two'])): ?>
                        <ul>
                            <?php $tab_list_items_two = explode("\n", ($content_repeater['tab_list_items_two']));?>
                            <?php foreach($tab_list_items_two as $tab_list_items_twos):?>
                            <li>
                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="12.5" cy="12.5" r="12.5" fill="#36DB9F" />
                                    <g>
                                        <path
                                            d="M11.8363 18.7066C12.2244 19.0994 13.0886 18.9692 13.1817 18.3516C13.7607 14.5175 16.6577 11.2829 18.85 8.23494C19.4579 7.39031 18.0602 6.58795 17.4602 7.42252C15.4568 10.2075 12.9317 13.138 11.9439 16.5174C10.815 15.3637 9.68161 14.221 8.41548 13.2072C7.61364 12.5649 6.46665 13.6965 7.27713 14.3455C8.92674 15.6668 10.3523 17.2076 11.8363 18.7066Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath>
                                            <rect width="12" height="12" fill="white" transform="translate(7 7)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                                <span> <?php echo wp_kses($tab_list_items_twos, true); ?></span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    <?php endif; // list content end ?>
                </div>
                <?php endif; //  list contnet end ?>
                <?php if($content_repeater['btn_enable'] == 'yes' || $content_repeater['btn2_enable'] == 'yes'): ?>
                <ul class="list_buttons">
                    <?php if($content_repeater['btn_enable'] == 'yes'): // list content
                        $target = $content_repeater['btnonelink']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $content_repeater['btnonelink']['nofollow'] ? ' rel="nofollow"' : ''; 
                        ?>
                        <li class="one">
                            <a class="theme_btn" href="<?php echo esc_url($content_repeater['btnonelink']['url']); ?>" <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                                <?php echo wp_kses($content_repeater['btnone'] , $allowed_tags); ?>
                            </a>
                        </li>
                    <?php endif; // list content end ?>
                    <?php if($content_repeater['btn2_enable'] == 'yes'): // list content 
                        $targettwo = $content_repeater['btntwolink']['is_external'] ? ' target="_blank"' : '';
                        $nofollowtwo = $content_repeater['btntwolink']['nofollow'] ? ' rel="nofollow"' : ''; 
                        ?>
                        <li class="two">
                            <a class="theme_btn" href="<?php echo esc_url($content_repeater['btntwolink']['url']); ?>"  <?php echo esc_attr($targettwo); ?> <?php echo esc_attr($nofollowtwo); ?>>
                                <?php echo wp_kses($content_repeater['btntwo'] , $allowed_tags); ?>
                            </a>
                        </li>
                    <?php endif; // list content end ?>
                </ul>
                <?php endif; // list content end ?>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endif; ?>
         </div>
      </div> 
 
   </div>
</section>


<?php 
	}
}

 