<?php
namespace  Copygenaddons\Core\Widgets\Content;
if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.
class Process_v1 extends \Elementor\Widget_Base{
    public function get_name(){
        return 'copygen-process-v1';
    }
    public function get_title(){
        return __('Process V1', 'copygen-addons');
    }
    public function get_icon(){
        return 'icon-steel';
    }
    public function get_categories(){
        return ['101'];
    }
    protected function register_controls(){
        // style one start
        $this->start_controls_section('process_settings',
        [ 
            'label' => __('Process Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
      
        $this->add_control(
            'process_column',
            [
                'label' => __('Blog Column', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'copygen-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'copygen-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'copygen-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'copygen-addons' ),
                ],
                'default' => 'col-xl-4 col-lg-4 col-md-6 col-sm-6', 
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section('process_one',
            [ 
                'label' => __('Process Content', 'copygen-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater(); 
        $repeater->add_control(
            'icon_enable',
            [
                'label' => __('Icon Enable /  Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
                'condition' => [ 
                    'icon_enable' => 'yes'
                ],
			]
		);
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image' ,
                    'icon_enable' => 'yes'
                ],
            ] 
        ); 
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon' ,
                    'icon_enable' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon' ,
                    'icon_enable' => 'yes'
                ]
            ]
        ); 
        $repeater->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
			'step_type',
			[
				'label' => esc_html__( 'Step Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'text' => esc_html__( 'Text', 'copygen-addons' ),
					'simage'  => esc_html__( 'Image', 'copygen-addons' ), 
                    'none'  => esc_html__( 'Display None', 'copygen-addons' ), 
				], 
                'default' => 'simage' ,  
			]
		);
        $repeater->add_control(
            'step_image',
            [
                'label' => __( 'Step Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => COPYGEN_ADDONS_URL . '/assets/imgs/step-1.png',
                ],
                'condition' => [
                    'step_type' => 'simage' , 
                ],
            ] 
        ); 
        $repeater->add_control(
            'step_count',
            [
               'label' => __('Steps', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('1', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),  
               'condition' => [
                    'step_type' => 'text' , 
                ],  
            ]
        );
        $repeater->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
          'titles',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Select writing template', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $repeater->add_control(
            'hr3',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater->add_control(
            'content',
            [
               'label' => __('Content', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Simply choose a template from available list to write content for blog posts, landing page, website content etc.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               
            ]
        );
        $repeater->add_control(
            'hr4',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        ); 
        $repeater->add_responsive_control(
            'button_link',
            [
                'label' => __('Link', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'copygen-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                
            ]
        ); 
        $this->add_control(
            'pro_repeater_one',
            [
                'label' => __('Process Repeater', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'step_count'  =>  __('1', 'copygen-addons'),
                        'titles' =>  __('Select writing template', 'copygen-addons'),
                        'content' =>  __('Simply choose a template from available list to write content for blog posts, landing page, website content etc.', 'copygen-addons'),
                    ],
                    [
                        'step_count'  =>  __('2', 'copygen-addons'),
                        'titles' =>  __('Describe your topic', 'copygen-addons'),
                        'content' =>  __('Provide our AI content writer with few sentences on what you want to write, and it will start writing for you.', 'copygen-addons'),
                    ],
                    [
                        'step_count'  =>  __('3', 'copygen-addons'),
                        'titles' =>  __('Generate quality content', 'copygen-addons'),
                        'content' =>  __('Our powerful AI tools will generate content in few second, then you can export it to wherever you need.', 'copygen-addons'),
                    ],
                ],
                'title_field' => '{{{ titles }}}',
            ]
        );
    $this->end_controls_section();
    $this->start_controls_section('process_css',
        [ 
            'label' => __('Process Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'price_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .process_card.style_one .nk-item  ',
        ]
    );
    $this->add_control(
        'hshr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'btn_padding',
        [
            'label' => esc_html__( 'Box Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .process_card.style_one .nk-item ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    ); 
    $this->add_responsive_control(
        'btnradius_padding',
        [
            'label' => esc_html__( 'Box Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}}  .process_card.style_one .nk-item ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    );
    $this->add_control(
        'hshr13',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
        $this->add_control(
            'icon_color',
             [
                'label' => __('Icon Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process_card.style_one .nk-item .icon i ' => 'color: {{VALUE}}!important;', 
                ], 
             ]
        );
        $this->add_control(
            'shr_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
				'name' => 'tit_typo',
				'selector' => '{{WRAPPER}} .process_card.style_one .nk-item .title_20 a',
			]
		);
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process_card.style_one .nk-item .title_20 a' => 'color: {{VALUE}}!important;', 
                ], 
             ]
        );
        $this->add_control(
            'shr_2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Content Typography', 'copygen-addons' ),
				'name' => 'con_typo',
				'selector' => '{{WRAPPER}} .process_card.style_one .nk-item p',
			]
		);
        $this->add_control(
            'content_color',
             [
                'label' => __('Content Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process_card.style_one .nk-item p' => 'color: {{VALUE}}!important;', 
                ], 
             ]
        );
        $this->add_control(
            'shr_3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Step Typography', 'copygen-addons' ),
				'name' => 'step_typo',
				'selector' => '{{WRAPPER}} .process_card.style_one .nk-item .step.text',
			]
		);
        $this->add_control(
            'stept_color',
             [
                'label' => __('Step Text Shadow Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process_card.style_one .nk-item .step.text' => 'text-shadow:
                    -1px -1px 0 {{VALUE}},
                    1px -1px 0 {{VALUE}},  
                    -1px 1px 0 {{VALUE}},
                    1px 1px 0 {{VALUE}}; ', 
                ], 
             ]
        );
        $this->add_control(
            'step_color',
             [
                'label' => __('Step Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process_card.style_one .nk-item .step.text' => 'color: {{VALUE}}!important;', 
                ], 
             ]
        );
    $this->end_controls_section();
}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');
?>

<div class="process_card style_one">
    <div class="row">
        <?php if(!empty($settings['pro_repeater_one'])):
        foreach($settings['pro_repeater_one'] as  $key => $pro_repeater_one): 
            $target = $pro_repeater_one['button_link']['is_external'] ? ' target="_blank"' : '';
            $nofollow = $pro_repeater_one['button_link']['nofollow'] ? ' rel="nofollow"' : '';
        ?>
        <div class="<?php echo esc_attr($settings['process_column']) ?> col">
            <div class="nk-item d-flex align-items-end"> 
            <div class="nk-schedule-content">
                <?php if($pro_repeater_one['icon_enable'] == 'yes'): ?>
                    <?php if($pro_repeater_one['icon_type'] == 'image'):
                        $alt_text = 'alt';
                        $image = isset($pro_repeater_one['image']['alt']) ? $pro_repeater_one['image']['alt'] : '';
                        if(!empty($image)) {
                        $alt_text = $image;
                        }
                        ?>
                        <?php if(!empty($pro_repeater_one['image']['url'])): ?>
                            <div class="icon">
                                <img src="<?php echo esc_url($pro_repeater_one['image']['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                            </div>
                        <?php endif; ?>
                    <?php elseif($pro_repeater_one['icon_type'] == 'elicon'): ?>
                        <?php if(!empty($pro_repeater_one['icon_lib'])): ?>
                        <div class="icon">
                            <?php \Elementor\Icons_Manager::render_icon($pro_repeater_one['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                        </div>
                        <?php endif; ?>		
                    <?php else: ?>
                        <?php if(!empty($pro_repeater_one['icon'])): ?>
                        <div class="icon">
                            <i class="<?php echo esc_attr($pro_repeater_one['icon']); ?>"></i>
                        </div> 
                        <?php endif; ?>		
                    <?php endif; ?>
                <?php endif; ?> 
                    <div class="content"> 
                        <?php if(!empty($pro_repeater_one['titles'])): ?>
                            <div class="title_20">
                                <a href="<?php echo esc_url($pro_repeater_one['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                                    <?php echo wp_kses($pro_repeater_one['titles'] , $allowed_tags); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($pro_repeater_one['content'])): ?>
                        <p><?php echo wp_kses($pro_repeater_one['content'] , $allowed_tags); ?></p>
                        <?php endif; ?>
                    </div>
                </div> 
            <?php if($pro_repeater_one['step_type'] == 'text'): ?>
                <?php if(!empty($pro_repeater_one['step_count'])): ?>
                    <div class="step text">
                        <?php echo wp_kses($pro_repeater_one['step_count'] , $allowed_tags); ?>
                    </div>
                <?php endif; ?>
            <?php elseif($pro_repeater_one['step_type'] == 'none'): ?>    
                <?php // empty ?>
            <?php else: ?>
                <?php if(!empty($pro_repeater_one['step_image']['url'])): 
                    $image_step = isset($pro_repeater_one['step_image']['alt']) ? $pro_repeater_one['step_image']['alt'] : '';
                    if(!empty($step_image)) {
                        $image_step = $step_image;
                    }else{ 
                        $image_step = 'alt';
                    }
                    ?>
                    <div class="step image">
                        <img src="<?php echo esc_url($pro_repeater_one['step_image']['url']); ?>" alt="<?php echo esc_attr($image_step); ?>"  />
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            </div>
        </div>
        <?php endforeach; endif; ?>
    </div>
</div>



<?php
    }
}

 