<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Price_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-price-v1';
    }

    public function get_title()
    {
        return __('Price V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('price_settins',
        [ 
            'label' => __('Price Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        /*--$this->add_control(
            'price_styles',
            [
                'label' => __('Price Style', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'type_one'  => __('Price Style One', 'creote-addons'),
                    'type_two'  => __('Price  Style Two', 'creote-addons'), 
                ],
                'default' => 'type_one',
            ]
        );
        $this->add_control(
            'phr',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );---*/
        $repeater_f_one = new \Elementor\Repeater();
        $this->add_control(
            'active',
            [
                'label' => __('Price Box Active', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        ); 
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $this->add_control(
            'tag',
            [
               'label' => __('Tag', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Popular', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
          'title',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Standard Plan', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $this->add_control(
            'hr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'description',
            [
               'label' => __('Description', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Basic features for up to 40 users.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'hr4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'price',
            [
               'label' => __('Price', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('$9', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'price_duration',
            [
               'label' => __('Price Duration', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Month', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $this->add_control(
            'hr5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater_f_one->add_control(
            'fone_yesno',
            [
                'label' => __('Features Type', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'yes'  => __('Yes', 'creote-addons'),
                    'no'  => __('No', 'creote-addons'), 
                ],
                'default' => 'yes',
            ]
        );
        $repeater_f_one->add_control(
            'features_text_one',
            [
                'label' => __('Enter The Text Here', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Cake & Milk', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        ); 
        $this->add_control(
            'features_this',
            [
                'label' => __( 'Features Repeater', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_f_one->get_controls(),
                'default' => [
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( '10,000 Monthly Word Limit', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( '10+ Templates', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( '30+ Languages', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( 'Advance Editor Tool', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( 'Regular Technical Support', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'no',
                        'features_text_one' => __( 'Unlimited Logins', 'copygen-addons' ),
                    ],
                    [
                        'fone_yesno' => 'no',
                        'features_text_one' => __( 'Newest Features', 'copygen-addons' ),
                    ],
                ],
                'title_field' => '{{{ features_text_one }}}',
                'condition' => [],
            ]
        ); 
        $this->add_control(
            'btnone',
            [
                'label'       => esc_html__( 'Button One', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Start free trial today' , 'copygen-addons'),
            ]
        );
        $this->add_control(
            'btnonelink',
            [
                'label' => __('Button One Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );  
        $this->add_control(
            'hr6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'btn2_enable',
            [
                'label' => esc_html__( 'List 2 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $this->add_control(
            'btntwo',
            [
                'label'       => esc_html__( 'Button Two', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__('Learn More' , 'copygen-addons'), 
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        ); 
        $this->add_control(
            'btntwolink',
            [
                'label' => __('Button Two Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        ); 
    $this->end_controls_section();

    $this->start_controls_section('price_css',
        [ 
            'label' => __('Price Box Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
    ); 
    $this->add_responsive_control(
        'alignment_price_top',
        [
            'label' => esc_html__( 'Top Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->add_control(
        'shr0',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    
    $this->add_responsive_control(
        'alignment_price_feat',
        [
            'label' => esc_html__( 'Features Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'left',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-list-link ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Normal', 'copygen-addons' ),
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'price_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box  ',
        ]
    );
    $this->add_control(
        'shr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadowcolor',
            'selector' => '{{WRAPPER}} .price_box.style_one  ', 
        ]
    ); 
    $this->add_control(
        'shr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_tagbg_color',
         [
            'label' => __('Tag Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .badge ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
   
    $this->add_control(
        'price_tag_color',
         [
            'label' => __('Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .badge  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hprice_tagbr_color',
         [
            'label' => __('Tag Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .badge  , {{WRAPPER}} .price_box.style_one .badge ' => 'border: 1px solid {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .nk-pricing-head .title_no_a_24   ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_des_color',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_color',
         [
            'label' => __('Price Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-year-amount .amount ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'month_color',
         [
            'label' => __('Month Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-year-amount .amount-text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'shr10',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'fi_colro',
         [
            'label' => __('Feature Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-list-link li em' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'f_colro',
         [
            'label' => __('Feature  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-list-link li ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'f_scolro',
         [
            'label' => __('Feature Strong Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .nk-list-link li strong  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'btncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.one ' => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnbgcolor',
         [
            'label' => __('Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.one ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnborcolor',
         [
            'label' => __('Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.one ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr12',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'btncolort',
         [
            'label' => __('2nd Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnbgcolorts',
         [
            'label' => __('2nd Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.two ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnborcolort',
         [
            'label' => __('2nd  Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one .gap a.two ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr13',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_responsive_control(
        'btn_padding',
        [
            'label' => esc_html__( 'Button Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one  .gap a.one , {{WRAPPER}} .price_box.style_one .gap a.two ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    ); 
    $this->add_responsive_control(
        'btnradius_padding',
        [
            'label' => esc_html__( 'Button Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}}  .price_box.style_one  .gap a.one , {{WRAPPER}} .price_box.style_one .gap a.two  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    ); 
    $this->end_controls_tab();

    $this->start_controls_tab(
        'style_normal_mid',
        [
            'label' => esc_html__( 'Typography', 'copygen-addons' ),
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title / Price Typography', 'copygen-addons' ),
            'name' => 'tone',
            'selector' => '{{WRAPPER}} .nk-pricing-head .title_no_a_24 , {{WRAPPER}} .price_box .nk-year-amount .amount ',
        ]
    );
    $this->add_control(
        'thr1',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Desctiption  Typography', 'copygen-addons' ),
            'name' => 'ttwo',
            'selector' => '{{WRAPPER}} .nk-pricing-head .text , {{WRAPPER}} .price_box .nk-year-amount .amount-text  ',
        ]
    );
    $this->add_control(
        'thr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Badge Typography', 'copygen-addons' ),
            'name' => 'tthree',
            'selector' => '{{WRAPPER}} .nk-pricing-head .badge   ',
        ]
    );
    $this->add_control(
        'thr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Button Typography', 'copygen-addons' ),
            'name' => 'tfour',
            'selector' => '{{WRAPPER}} .price_box .gap a  ',
        ]
    );
    $this->add_control(
        'thr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Features  Typography', 'copygen-addons' ),
            'name' => 'tfive',
            'selector' => '{{WRAPPER}} .price_box .nk-list-link li  ',
        ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
        'style_hover_tab',
        [
            'label' => esc_html__( 'Hover / Active', 'copygen-addons' ),
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'hoprice_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box.style_one.active   , {{WRAPPER}} .price_box.style_one:hover   ',
        ]
    );
    $this->add_control(
        'hshr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_control(
        'hoverbox_shadow',
         [
            'label' => __('Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active , {{WRAPPER}}  .price_box.style_one:hover  ' => 'box-shadow: 0px 0px 0 3px {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_tagbg_color',
         [
            'label' => __('Tag Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .badge  , {{WRAPPER}} .price_box.style_one:hover .badge ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );  
    $this->add_control(
        'hprice_tag_color',
         [
            'label' => __('Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .badge  , {{WRAPPER}} .price_box.style_one:hover .badge ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hprice_tagbrh_color',
         [
            'label' => __('Tag Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .badge  , {{WRAPPER}} .price_box.style_one:hover .badge ' => 'border: 1px solid {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .price_box.style_one.active .title_no_a_24  , {{WRAPPER}} .price_box.style_one:hover .title_no_a_24  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_des_color',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .text  , {{WRAPPER}} .price_box.style_one:hover .text  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_color',
         [
            'label' => __('Price Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .price_box.style_one.active  .amount , {{WRAPPER}} .price_box.style_one:hover  .amount  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hmonth_color',
         [
            'label' => __('Month Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .nk-year-amount .amount-text , {{WRAPPER}} .price_box.style_one:hover .nk-year-amount .amount-text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hshr10',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hfi_colro',
         [
            'label' => __('Feature Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .nk-list-link li em , {{WRAPPER}} .price_box.style_one:hover .nk-list-link li em ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hf_colro',
         [
            'label' => __('Feature  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .nk-list-link li , {{WRAPPER}} .price_box.style_one:hover .nk-list-link li ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hf_scolro',
         [
            'label' => __('Feature Strong Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active .nk-list-link li strong , {{WRAPPER}} .price_box.style_one:hover .nk-list-link li strong  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hbtncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.one , {{WRAPPER}} .price_box.style_one:hover .gap a.one ' => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnbgcolor',
         [
            'label' => __('Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.one , {{WRAPPER}} .price_box.style_one:hover .gap a.one ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnborcolor',
         [
            'label' => __('Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.one , {{WRAPPER}} .price_box.style_one:hover .gap a.one ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr12',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hbtncolort',
         [
            'label' => __('2nd Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.two , {{WRAPPER}} .price_box.style_one:hover .gap a.two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnbgcolorts',
         [
            'label' => __('2nd Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.two , {{WRAPPER}} .price_box.style_one:hover .gap a.two ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnborcolort',
         [
            'label' => __('2nd  Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.style_one.active  .gap a.two , {{WRAPPER}} .price_box.style_one:hover .gap a.two ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
   

    $this->end_controls_tab();
    $this->end_controls_tabs();
   
    $this->end_controls_section();

}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');   
?>
<div class="price_box style_one trans<?php if($settings['active'] == 'yes'):?> active<?php endif; ?>">
    <div class="nk-pricing-head">
        <div class="nk-pricing-title-group mb-2">
            <?php if(!empty($settings['title'])): ?>
            <div class="title_no_a_24">
                <?php echo wp_kses($settings['title'] , $allowed_tags);  ?></div>
            <?php endif; ?>
            <?php if(!empty($settings['tag'])): ?>
            <span
                class="badge rounded-pill text-bg-warning text-white text-uppercase"><em class="icon ni-star-fill me-1"></em> <?php echo wp_kses($settings['tag'] , $allowed_tags);  ?></span>
            <?php endif; ?>
        </div> 

        <?php if(!empty($settings['description'])): ?>
        <p class="text mt-2">
            <?php echo wp_kses($settings['description'] , $allowed_tags);  ?></p>
        <?php endif; ?>

        <?php if(!empty($settings['price'])): ?>
        <div class="nk-year-amount amount-wrap">
            <span class="amount h1 mb-0">
                <?php echo wp_kses($settings['price'] , $allowed_tags);  ?>
            </span>
            <?php if(!empty($settings['price_duration'])): ?>
            <span class="amount-text"> /
                <?php echo wp_kses($settings['price_duration'] , $allowed_tags);  ?></span>
            <?php endif; ?>
        </div>
        <?php endif; ?> 
        <div class="gap g-3">
            <?php if(!empty($settings['btnone'])):
            $target_one = $settings['btnonelink']['is_external'] ? ' target="_blank"' : '';
            $nofollow_one = $settings['btnonelink']['nofollow'] ? ' rel="nofollow"' : ''; 
            ?>
            <a href="<?php echo esc_attr($settings['btnonelink']['url']); ?>" class="theme_btn one"
                <?php echo esc_attr($target_one); ?> <?php echo esc_attr($nofollow_one); ?>>
                <?php echo wp_kses($settings['btnone'] , $allowed_tags);  ?>
            </a>
            <?php endif; ?>
            <?php if($settings['btn2_enable'] == 'yes'): ?>
            <?php if(!empty($settings['btntwo'])):
            $target_two = $settings['btntwolink']['is_external'] ? ' target="_blank"' : '';
            $nofollow_two = $settings['btntwolink']['nofollow'] ? ' rel="nofollow"' : ''; 
            ?>
            <a href="<?php echo esc_attr($settings['btntwolink']['url']); ?>" class="theme_btn two"
                <?php echo esc_attr($target_two); ?> <?php echo esc_attr($nofollow_two); ?>>
                <?php echo wp_kses($settings['btntwo'] , $allowed_tags);  ?>
            </a>
            <?php endif; ?>
            <?php endif; ?>
        </div> 
        <ul class="nk-list-link">
            <?php if(!empty($settings['features_this'])): ?>
            <?php foreach($settings['features_this'] as $features_text_one):?>
            <li>
                <?php if($features_text_one['fone_yesno'] == 'no'): ?>
                <em class="icon ni copy-cross1"></em>
                <?php else: ?>
                <em class="icon ni copy-check"></em>
                <?php endif; ?>
                <span><?php echo wp_kses($features_text_one['features_text_one'] , $allowed_tags); ?></span>
            </li>
            <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
   
</div>

 
<?php

    }
}

 