<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Price_tab_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-price-tab-v1';
    }

    public function get_title()
    {
        return __('Price Tab' , 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
		$this->start_controls_section(
			'tab_content',
			[
				'label' => esc_html__( 'Price Settings', 'copygen-addons' ),
			]
        );
        $this->add_control(
            'price_styles',
            [
                'label' => __('Price Style', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'type_one'  => __('Price Style One', 'creote-addons'),
                    'type_two'  => __('Price  Style Two', 'creote-addons'), 
                ],
                'default' => 'type_one',
            ]
        );
       
        $this->add_control(
            'price_column',
            [
                'label' => __('Column', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'copygen-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'copygen-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'copygen-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'copygen-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
            ]
        );
        $this->add_control(
            'hr',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );  
        $this->add_control(
            'tabbtn_alignment',
            [
                'label' => esc_html__( 'Price Tab Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ], 
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
					'{{WRAPPER}} .tabs_header ' => 'text-align: {{VALUE}}!important;',
				], 
            ]
        );
        $this->start_controls_tabs(
            'group_one'
        );
        $this->start_controls_tab(
            'group_tab_one',
            [
                'label' => esc_html__( 'Tab One', 'copygen-addons' ),
            ]
        );
        $this->add_control(
            'tab_title',
            [
                'label'       => esc_html__( 'Tab Title', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Monthly' , 'copygen-addons'),
            ]
        );
        $this->add_control(
            'h2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater_one = new \Elementor\Repeater();
        $repeater_f_one = new \Elementor\Repeater();
        $repeater_one->add_control(
            'active',
            [
                'label' => __('Price Box Active', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater_one->add_control(
            'hract',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $repeater_one->add_control(
            'tag',
            [
               'label' => __('Tag', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Popular', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_one->add_control(
          'title',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Standard Plan', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $repeater_one->add_control(
            'description',
            [
               'label' => __('Description', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Basic features for up to 40 users.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_one->add_control(
            'high',
            [
               'label' => __('Highligh Text', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Try out all features to determine what works best for you', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        ); 
        $repeater_one->add_control(
            'icon_or_price',
            [
                'label' => __('Price or Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        // ================ icon =================================
        $repeater_one->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
                'condition' => [ 
                    'icon_or_price' => 'no'
                ],
			]
		);
        $repeater_one->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image' ,
                    'icon_or_price' => 'no'
                ],
            ] 
        );
       
        $repeater_one->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon' ,
                    'icon_or_price' => 'no'
                ]
            ]
        );
        $repeater_one->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon' ,
                    'icon_or_price' => 'no'
                ]
            ]
        );
        $repeater_one->add_control(
            'hr01',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [ 
                    'icon_or_price' => 'no'
                ]
            ]
        );
        // ================ icon =================================
        // ================ price =================================
        $repeater_one->add_control(
            'price',
            [
               'label' => __('Price', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('39.83', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
               'condition' => [ 
                    'icon_or_price' => 'yes'
                ]
            ]
        );
        $repeater_one->add_control(
            'price_duration',
            [
               'label' => __('Price Duration', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Monthly', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [ 
                    'icon_or_price' => 'yes'
                ] 
            ]
        );
        // ================ price =================================
        $repeater_one->add_control(
            'features_title',
            [
               'label' => __('Features Title', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Give a try for free', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_f_one->add_control(
            'fone_yesno',
            [
                'label' => __('Features Type', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'yes'  => __('Yes', 'creote-addons'),
                    'no'  => __('No', 'creote-addons'), 
                ],
                'default' => 'yes',
            ]
        );
        $repeater_f_one->add_control(
            'features_text_one',
            [
                'label' => __('Enter The Text Here', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Cake & Milk', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        ); 
        $repeater_one->add_control(
            'features_repeater_one',
            [
                'label' => __( 'Features Repeater', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_f_one->get_controls(),
                'default' => [
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( 'Complete documentation', 'text-domain' ),
                    ],
                    [
                        'fone_yesno' => 'no',
                        'features_text_one' => __( 'Working materials in Figma', 'text-domain' ),
                    ],
                    [
                        'fone_yesno' => 'no',
                        'features_text_one' => __( '100GB cloud storage', 'text-domain' ),
                    ],
                    [
                        'fone_yesno' => 'yes',
                        'features_text_one' => __( '500 team members', 'text-domain' ),
                    ],
                ],
                'title_field' => '{{{ features_text_one }}}',
                'condition' => [],
            ]
        ); 
        $repeater_one->add_control(
            'btnone',
            [
                'label'       => esc_html__( 'Button One', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Get started' , 'copygen-addons'),
            ]
        );
        $repeater_one->add_control(
            'btnonelink',
            [
                'label' => __('Button One Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );  
        $repeater_one->add_control(
            'hr6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater_one->add_control(
            'btn2_enable',
            [
                'label' => esc_html__( 'Button 2 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater_one->add_control(
            'btntwo',
            [
                'label'       => esc_html__( 'Button Two', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__('Learn More' , 'copygen-addons'), 
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        );
        
        $repeater_one->add_control(
            'btntwolink',
            [
                'label' => __('Button Two Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'btn2_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'price_repeater',
            [
                'label' => __( 'Price Content Repeater', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_one->get_controls(),
                'default' => [
                    [
                        'active' => 'no' ,
                        'tag' => __( '', 'copygen-addons' ),
                        'title' => __( 'Regular Plan', 'copygen-addons' ),
                        'description' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
                     
                        'price' => __( '$29', 'copygen-addons' ),
                        'price_duration' => __( 'Per year', 'copygen-addons' ),
                        'features_text' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_no' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                    [
                        'active' => 'yes' ,
                        'tag' => __( 'Popular', 'copygen-addons' ),
                        'title' => __( 'Standard Plan', 'copygen-addons' ),
                        'description' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
                    
                        'price' => __( '$199', 'copygen-addons' ),
                        'price_duration' => __( 'Per year', 'copygen-addons' ),
                        'features_text' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_no' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                    [
                        'active' => 'no' ,
                        'tag' => __( '', 'copygen-addons' ),
                        'title' => __( 'Golden Plan', 'copygen-addons' ),
                        'description' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
              
                        'price' => __( '$1099', 'copygen-addons' ),
                        'price_duration' => __( 'Per year', 'copygen-addons' ),
                        'features_text' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_no' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                ],
                'title_field' => '{{{title}}}',
            ]
        );
        $this->end_controls_tab();


        $this->start_controls_tab(
            'group_tab_two',
            [
                'label' => esc_html__( 'Tab two', 'copygen-addons' ),
            ]
        );
        $this->add_control(
            'tab_title_two',
            [
                'label'       => esc_html__( 'Tab Title', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Yearly' , 'copygen-addons'),
            ]
        );

        $this->add_control(
            'percentage',
            [
                'label'       => esc_html__( 'Percentage', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'SAVE 12%' , 'copygen-addons'),
            ]
        );

        $this->add_control(
            'two_h2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater_two = new \Elementor\Repeater();
        $repeater_f_two = new \Elementor\Repeater();
        $repeater_two->add_control(
            'active_two',
            [
                'label' => __('Price Box Active', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater_two->add_control(
            'hractwo',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER,  
            ]
        );
        $repeater_two->add_control(
            'tag_two',
            [
               'label' => __('Tag', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Popular', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_two->add_control(
          'title_two',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Standard Plan', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $repeater_two->add_control(
            'description_two',
            [
               'label' => __('Description', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Basic features for up to 40 users.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_two->add_control(
            'high_two',
            [
               'label' => __('Highligh Text', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Try out all features to determine what works best for you', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_two->add_control(
            'icon_or_price_two',
            [
                'label' => __('Price or Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        // ================ icon =================================
        $repeater_two->add_control(
			'icon_type_two',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
                'condition' => [ 
                    'icon_or_price_two' => 'no'
                ],
			]
		);
        $repeater_two->add_control(
            'image_two',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image' ,
                    'icon_or_price_two' => 'no'
                ],
            ] 
        );
       
        $repeater_two->add_control(
            'icon_two',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon' ,
                    'icon_or_price_two' => 'no'
                ]
            ]
        );
        $repeater_two->add_control(
            'icon_lib_two',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon' ,
                    'icon_or_price_two' => 'no'
                ]
            ]
        );
        $repeater_two->add_control(
            'hr012twp',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [ 
                    'icon_or_price_two' => 'no'
                ]
            ]
        );
        // ================ icon =================================
        $repeater_two->add_control(
            'price_two',
            [
               'label' => __('Price', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('39.83', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),  
               'condition' => [ 
                    'icon_or_price_two' => 'yes'
                ]  
            ]
        );
        $repeater_two->add_control(
            'price_duration_two',
            [
               'label' => __('Price Duration', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Monthly', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
               'condition' => [ 
                    'icon_or_price_two' => 'yes'
                ] 
            ]
        );
        $repeater_two->add_control(
            'features_title_two',
            [
               'label' => __('Features Title', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Give a try for free', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_f_two->add_control(
            'ftwo_yesno',
            [
                'label' => __('Features Type', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'yes'  => __('Yes', 'creote-addons'),
                    'no'  => __('No', 'creote-addons'), 
                ],
                'default' => 'yes',
            ]
        );
        $repeater_f_two->add_control(
            'features_text_two',
            [
                'label' => __('Enter The Text Here', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Cake & Milk', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
            ]
        );
        $repeater_two->add_control(
            'features_repeater_two',
            [
                'label' => __( 'Second Repeater Sub List', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_f_two->get_controls(),
                'default' => [
                    [
                        'ftwo_yesno' => 'yes',
                        'features_text_two' => __( 'Complete documentation', 'text-domain' ),
                    ],
                    [
                        'ftwo_yesno' => 'no',
                        'features_text_two' => __( 'Working materials in Figma', 'text-domain' ),
                    ],
                    [
                        'ftwo_yesno' => 'no',
                        'features_text_two' => __( '100GB cloud storage', 'text-domain' ),
                    ],
                    [
                        'ftwo_yesno' => 'yes',
                        'features_text_two' => __( '500 team members', 'text-domain' ),
                    ],
                ],
                'title_field' => '{{{ features_text_two }}}',
                'condition' => [],
            ]
        );
        $repeater_two->add_control(
            'btnone_two',
            [
                'label'       => esc_html__( 'Button One', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Get started' , 'copygen-addons'),
            ]
        );
        $repeater_two->add_control(
            'btnonelink_two',
            [
                'label' => __('Button One Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );  
        $repeater_two->add_control(
            'hr6_two',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $repeater_two->add_control(
            'btn2_enable_two',
            [
                'label' => esc_html__( 'Button 2 Enable / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => 'yes', 
            ]
        );
        $repeater_two->add_control(
            'btntwo_two',
            [
                'label'       => esc_html__( 'Button Two', 'copygen-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__('Learn More' , 'copygen-addons'), 
                'condition' => [
                    'btn2_enable_two' => 'yes'
                ],
            ]
        );
        
        $repeater_two->add_control(
            'btntwolink_two',
            [
                'label' => __('Button Two Link', 'creote-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'creote-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'btn2_enable_two' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'price_repeater_two',
            [
                'label' => __( 'Price Content Repeater', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_two->get_controls(),
                'default' => [
                    [
                        'active_two' => 'no' ,
                        'tag_two' => __( '', 'copygen-addons' ),
                        'title_two' => __( 'Golden Plan', 'copygen-addons' ),
                        'description_two' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
                       
                        'price_two' => __( '$1099', 'copygen-addons' ),
                        'price_duration_two' => __( 'Per year', 'copygen-addons' ),
                        'features_text_two' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_notwo' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone_two' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo_two'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                    [
                        'active_two' => 'yes' ,
                        'tag_two' => __( 'Popular', 'copygen-addons' ),
                        'title_two' => __( 'Standard Plan', 'copygen-addons' ),
                        'description_two' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
                     
                        'price_two' => __( '$199', 'copygen-addons' ),
                        'price_duration_two' => __( 'Per year', 'copygen-addons' ),
                        'features_text_two' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_notwo' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone_two' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo_two'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                    [
                        'active_two' => 'no' ,
                        'tag_two' => __( '', 'copygen-addons' ),
                        'title_two' => __( 'Regular Plan', 'copygen-addons' ),
                        'description_two' => __( 'Basic features for up to 40 users.', 'copygen-addons' ),
            
                        'price_two' => __( '$29', 'copygen-addons' ),
                        'price_duration_two' => __( 'Per year', 'copygen-addons' ),
                        'features_text_two' => __( 'Complete documentation', 'copygen-addons' ),
                        'features_text_notwo' => __( 'Working materials in Figma', 'copygen-addons' ),
                        'btnone_two' => __( 'Get Started', 'copygen-addons' ),
                        'btntwo_two'  => __( 'Learn More', 'copygen-addons' ),
                    ],
                ],
                'title_field' => '{{{title_two}}}',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();
     
     $this->end_controls_section(); 

     $this->start_controls_section('price_Tab_css',
     [ 
         'label' => __('Tab Css', 'copygen-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     ); 
     $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Tab Typography', 'copygen-addons' ),
            'name' => 'tab_typos',
            'selector' => '{{WRAPPER}} .price_tab .nav-item .nav-link .title_no_a_18',
        ]
    );
    $this->add_control(
        'tabthr',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    
    $this->add_control(
        'tab_color',
         [
            'label' => __('Tab  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab .nav-item .nav-link .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'tab_hr_2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'tab_toggle_color',
         [
            'label' => __('Tab Toggle Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab .nav-item:first-child .nav-link:before ' => 'background: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'tabb_toggle_color',
         [
            'label' => __('Tab Toggle Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab .nav-item:first-child .nav-link:before ' => 'border-color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'taba_toggle_color',
         [
            'label' => __('Tab Toggle Active Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab .nav-item:first-child .nav-link.active::after ,  {{WRAPPER}} .price_tab .nav-item.last .nav-link.active::after ' => 'background: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'taatexcss',
         [
            'label' => __('Tab Active Text Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab .nav-item .nav-link.active .title_no_a_18  ' => 'color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'tab_hr_3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Offer Typography', 'copygen-addons' ),
            'name' => 'off_typos',
            'selector' => '{{WRAPPER}} .price_tab span',
        ]
    );
    $this->add_control(
        'ofhr',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'save_color',
         [
            'label' => __('Offer Text Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab span ' => 'color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'savebg_color',
         [
            'label' => __('Offer Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_tab span ' => 'background: {{VALUE}}!important;',
            ], 
         ]
    );
$this->end_controls_section(); 
   $this->start_controls_section('price_css',
        [ 
            'label' => __('Price  Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
    ); 
    
    $this->add_responsive_control(
        'alignment_price_header',
        [
            'label' => esc_html__( 'Top Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'left',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-pricing-head' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'alignment_price_feat',
        [
            'label' => esc_html__( 'Features Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'left',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-list-link , {{WRAPPER}} .price_box .features_title_two   ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Normal', 'copygen-addons' ),
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'price_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box  ',
        ]
    );
    $this->add_control(
        'shr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadowcolor',
            'selector' => '{{WRAPPER}} .price_box ', 
        ]
    ); 
    $this->add_control(
        'shr22',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'price_styles' => 'type_two'
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'twprice_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box  .whole ',
            'condition' => [ 
                'price_styles' => 'type_two'
            ],
        ]
    );
    $this->add_control(
        'shr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_tagbg_color',
         [
            'label' => __('Tag Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .badge_two , {{WRAPPER}} .price_box.style_three .badge  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'shr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_tag_color',
         [
            'label' => __('Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .badge_two , {{WRAPPER}} .price_box.style_three .badge   ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .nk-pricing-head .title_no_a_20   ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_des_color',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr81',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_destw_color',
         [
            'label' => __('Description Two Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .high_two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'price_destwbg_color',
         [
            'label' => __('Description Two Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .high_two ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'price_color',
         [
            'label' => __('Price Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-year-amount .amount ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'month_color',
         [
            'label' => __('Month Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-year-amount .amount-text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'shr10',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'ft_colro',
         [
            'label' => __('Feature Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .features_title_two' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    
    $this->add_control(
        'fi_colro',
         [
            'label' => __('Feature Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-list-link li em' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'f_colro',
         [
            'label' => __('Feature  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .nk-list-link li ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'btncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.one ' => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnbgcolor',
         [
            'label' => __('Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.one ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnborcolor',
         [
            'label' => __('Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.one ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'shr12',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'btncolort',
         [
            'label' => __('2nd Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnbgcolorts',
         [
            'label' => __('2nd Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.two ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnborcolort',
         [
            'label' => __('2nd  Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box .gap a.two ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
        'style_normal_mid',
        [
            'label' => esc_html__( 'Typography', 'copygen-addons' ),
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title / Price Typography', 'copygen-addons' ), 
            'name' => 'tone',
            'selector' => '{{WRAPPER}} .nk-pricing-head .title_no_a_20 , {{WRAPPER}} .price_box .nk-year-amount .amount ',
        ]
    );
    $this->add_control(
        'thr1',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Desctiption One Typography', 'copygen-addons' ),
            'name' => 'tttwo',
            'selector' => '{{WRAPPER}} .price_box.style_two p.text  ',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Desctiption Two Typography', 'copygen-addons' ),
            'name' => 'ttwo',
            'selector' => '{{WRAPPER}} .price_box .high_two , {{WRAPPER}} .price_box .nk-year-amount .amount-text  ',
        ]
    );
    $this->add_control(
        'thr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Badge Typography', 'copygen-addons' ),
            'name' => 'tthree',
            'selector' => '{{WRAPPER}} .nk-pricing-head .badge , {{WRAPPER}} .nk-pricing-head .badge_two   ',
        ] ,
    );
    $this->add_control(
        'thr3',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Button Typography', 'copygen-addons' ),
            'name' => 'tfour',
            'selector' => '{{WRAPPER}} .price_box .gap a  ',
        ]
    );
    $this->add_control(
        'thr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Features Title  Typography', 'copygen-addons' ),
            'name' => 'ttfive',
            'selector' => '{{WRAPPER}} .price_box .features_title_two  ',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Features  Typography', 'copygen-addons' ),
            'name' => 'tfive',
            'selector' => '{{WRAPPER}} .price_box .nk-list-link li  ',
        ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
        'style_hover_tab',
        [
            'label' => esc_html__( 'Hover / Active', 'copygen-addons' ),
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'hoprice_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box.active   , {{WRAPPER}} .price_box:hover   ',
        ]
    );
    $this->add_control(
        'hshr2',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'price_styles' => 'type_one'
            ],
        ]
    ); 
    $this->add_control(
        'hoverbox_shadow',
         [
            'label' => __('Hover Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box:not(.style_two).active , {{WRAPPER}}  .price_box:not(.style_two):hover  ' => 'box-shadow: 0px 0px 0 3px {{VALUE}}!important;',
            ],
            'condition' => [ 
                'price_styles' => 'type_one'
            ],
         ]
    );
    $this->add_control(
        'hshr22',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [ 
                'price_styles' => 'type_two'
            ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'htwprice_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .price_box.active .whole , {{WRAPPER}}  .price_box:hover .whole ',
            'condition' => [ 
                'price_styles' => 'type_two'
            ],
        ]
    );
    $this->add_control(
        'hshr4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_tagbg_color',
         [
            'label' => __('Tag Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .badge_two  , {{WRAPPER}} .price_box:hover .badge_two  , {{WRAPPER}} .price_box.style_three.active .badge  , {{WRAPPER}} .price_box.style_three:hover .badge ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hshr5',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_tag_color',
         [
            'label' => __('Tag Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .badge_two  , {{WRAPPER}} .price_box:hover .badge_two , {{WRAPPER}} .price_box.style_three.active .badge  , {{WRAPPER}} .price_box.style_three:hover .badge ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr6',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .price_box.active .title_no_a_20  , {{WRAPPER}} .price_box:hover .title_no_a_20  ' => 'color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'hshr7',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_des_color',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .text  , {{WRAPPER}} .price_box:hover .text     ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr81',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_destw_color',
         [
            'label' => __('Description Two Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .high_two , {{WRAPPER}} .price_box:hover .high_two  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hprice_destwbg_color',
         [
            'label' => __('Description Two Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .high_two , {{WRAPPER}} .price_box:hover .high_two  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr8',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hprice_color',
         [
            'label' => __('Price Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .price_box.active .nk-year-amount .amount  , {{WRAPPER}} .price_box:hover .nk-year-amount .amount  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr9',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hmonth_color',
         [
            'label' => __('Month Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active .nk-year-amount .amount-text , {{WRAPPER}} .price_box:hover .nk-year-amount .amount-text ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hshr10',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hft_colro',
         [
            'label' => __('Feature Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .features_title_two , {{WRAPPER}} .price_box:hover .features_title_two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hfi_colro',
         [
            'label' => __('Feature Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .nk-list-link li em , {{WRAPPER}} .price_box:hover .nk-list-link li em ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hf_colro',
         [
            'label' => __('Feature  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .nk-list-link li , {{WRAPPER}} .price_box:hover .nk-list-link li ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr11',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hbtncolor',
         [
            'label' => __('Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.one , {{WRAPPER}} .price_box:hover .gap a.one ' => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnbgcolor',
         [
            'label' => __('Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.one , {{WRAPPER}} .price_box:hover .gap a.one ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnborcolor',
         [
            'label' => __('Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.one , {{WRAPPER}} .price_box:hover .gap a.one ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hshr12',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'hbtncolort',
         [
            'label' => __('2nd Button Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.two , {{WRAPPER}} .price_box:hover .gap a.two ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnbgcolorts',
         [
            'label' => __('2nd Button Background  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.two , {{WRAPPER}} .price_box:hover .gap a.two ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hbtnborcolort',
         [
            'label' => __('2nd  Button Border  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.active  .gap a.two , {{WRAPPER}} .price_box:hover .gap a.two ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();
   
    $this->end_controls_section();
    
}
protected function render() {
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$price_repeater = $settings['price_repeater'];
$price_repeater_two = $settings['price_repeater_two'];
?>
<section class="price_tab_box  copygen_tab p_<?php echo esc_attr($settings['price_styles']); ?>">
    <div class="tab_over_all_box">

        <div class="tabs_header clearfix">
            <ul class="showcase_tabs_btns price_tab nav-pills nav clearfix">
                <?php if(!empty($settings['tab_title'])): ?>
                <li class="nav-item">
                    <a class="s_tab_btn nav-link active" data-tab="#copygen_price_one">
                            <em class="dot left"></em>
                        <small class="title_no_a_18"><?php echo esc_attr($settings['tab_title']); ?></small>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(!empty($settings['tab_title_two'])): ?>
                <li class="nav-item last">
                    <a class="s_tab_btn nav-link" data-tab="#copygen_price_two">
                        <em class="dot right"></em>
                        <small class="title_no_a_18"><?php echo esc_attr($settings['tab_title_two']); ?></small> 
                    </a>
                </li>
                <?php endif; ?>
                <span><?php echo esc_attr($settings['percentage']); ?></span>
            </ul>
        </div>
        <div class="s_tab_wrapper">
            <div class="s_tabs_content">
                <?php //  tab ?>
                <div class="s_tab fade active-tab show" id="copygen_price_one">
                    <div class="row">
                        <?php if(!empty($price_repeater)): ?>
                        <?php foreach($price_repeater as $key => $price_repeater): ?>
                        <div class="<?php echo esc_attr($settings['price_column']); ?> col   trans  <?php if($price_repeater['active'] == 'yes'):?> active<?php endif; ?>">
                           
                            <div class="price_box style_two <?php if($settings['price_styles'] == 'type_two'): ?>style_three<?php endif; ?> trans<?php if($price_repeater['active'] == 'yes'):?> active<?php endif; ?>">
                                <div class="whole">
                                     <div class="nk-pricing-head">
                                        <?php if($settings['price_styles'] == 'type_two'): ?>
                                            <?php if(!empty($price_repeater['tag'])): ?>
                                                <span class="badge rounded-pill text-bg-warning text-white text-uppercase"><?php echo wp_kses($price_repeater['tag'] , $allowed_tags);  ?></span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if(!empty($price_repeater['tag'])): ?>
                                                <span class="badge_two"><?php echo wp_kses($price_repeater['tag'] , $allowed_tags);  ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <div class="nk-pricing-title-group mb-2">
                                        <?php if(!empty($price_repeater['title'])): ?>
                                        <div class="title_no_a_20">
                                            <?php echo wp_kses($price_repeater['title'] , $allowed_tags);  ?></div>
                                        <?php endif; ?>
                                       
                                    </div>
 
                                     
                                    <?php if($price_repeater['icon_or_price'] == 'yes'): ?>
                                        <div class="nk-year-amount amount-wrap">
                                        <?php if(!empty($price_repeater['price'])): ?>
                                        <span class="amount h1 mb-0">
                                  
                                            <?php echo wp_kses($price_repeater['price'] , $allowed_tags);  ?>
                                        </span>
                                        <?php if(!empty($price_repeater['price_duration'])): ?>
                                        <span class="amount-text"> /
                                            <?php echo wp_kses($price_repeater['price_duration'] , $allowed_tags);  ?></span>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        </div>
                                    <?php else: ?>     
                                        <?php if($price_repeater['icon_type'] == 'image'): ?>
                                            <?php if(!empty($price_repeater['image']['url'])):
                                                $alt_text = 'alt';
                                                $image = isset($price_repeater['image']['alt']) ? $price_repeater['image']['alt'] : '';
                                                if(!empty($image)) {
                                                $alt_text = $image;
                                                }
                                                ?>
                                                <div class="icon">
                                                    <img src="<?php echo esc_url($price_repeater['image']['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                                                </div>
                                            <?php endif; ?>
                                            <?php elseif($price_repeater['icon_type'] == 'elicon'): ?>
                                                <?php if(!empty($price_repeater['icon_lib'])): ?>
                                                <div class="icon">
                                                    <?php \Elementor\Icons_Manager::render_icon($price_repeater['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                                </div>
                                                <?php endif; ?>		
                                            <?php else: ?>
                                                <?php if(!empty($price_repeater['icon'])): ?>
                                                <div class="icon">
                                                    <i class="<?php echo esc_attr($price_repeater['icon']); ?>"></i>
                                                </div> 
                                            <?php endif; ?>		
                                        <?php endif; ?>
                                    <?php endif; ?>


                                    <?php if(!empty($price_repeater['description'])): ?>
                                        <p class="text mt-2">
                                            <?php echo wp_kses($price_repeater['description'] , $allowed_tags);  ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if(!empty($price_repeater['high'])): ?>
                                        <div class="high_two">
                                            <?php echo wp_kses($price_repeater['high'] , $allowed_tags);  ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="nk-pricing-body">
                                    <div class="gap g-3">
                                        <?php if(!empty($price_repeater['btnone'])):
                                        $target_one = $price_repeater['btnonelink']['is_external'] ? ' target="_blank"' : '';
                                        $nofollow_one = $price_repeater['btnonelink']['nofollow'] ? ' rel="nofollow"' : ''; 
                                        ?>
                                      
                                            <a href="<?php echo esc_attr($price_repeater['btnonelink']['url']); ?>"
                                                class="theme_btn one" <?php echo esc_attr($target_one); ?>
                                                <?php echo esc_attr($nofollow_one); ?>>
                                                <?php echo wp_kses($price_repeater['btnone'] , $allowed_tags);  ?>
                                            </a>
                                       
                                        <?php endif; ?>
                                        <?php if($price_repeater['btn2_enable'] == 'yes'): ?>
                                        <?php if(!empty($price_repeater['btntwo'])):
                                        $target_two = $price_repeater['btntwolink']['is_external'] ? ' target="_blank"' : '';
                                        $nofollow_two = $price_repeater['btntwolink']['nofollow'] ? ' rel="nofollow"' : ''; 
                                        ?>
                                    
                                            <a href="<?php echo esc_attr($price_repeater['btntwolink']['url']); ?>"
                                                class="theme_btn two" <?php echo esc_attr($target_two); ?>
                                                <?php echo esc_attr($nofollow_two); ?>>
                                                <?php echo wp_kses($price_repeater['btntwo'] , $allowed_tags);  ?>
                                            </a>
                                        
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        </div>
                                    <?php if(!empty($price_repeater['features_title'])): ?>
                                        <div class="features_title_two title_no_a_16">
                                        <?php echo wp_kses($price_repeater['features_title'] , $allowed_tags);  ?>
                                        </div>
                                    <?php endif; ?>
                                    <ul class="nk-list-link">
                                        <?php if(!empty($price_repeater['features_repeater_one'])): ?>
                                        <?php foreach($price_repeater['features_repeater_one'] as $features_text_one):?>
                                        <li>
                                            <?php if($features_text_one['fone_yesno'] == 'no'): ?>
                                            <em class="icon copy-cross-circle-fill"></em>
                                            <?php else: ?>
                                            <em class="icon copy-check-circle-fill"></em>
                                            <?php endif; ?>
                                            <span><?php echo wp_kses($features_text_one['features_text_one'] , $allowed_tags); ?></span>
                                        </li>
                                        <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                            </div>
                          
                        </div>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <?php //  tab end ?>
                <?php //  tab  ?>
                <div class="s_tab fade" id="copygen_price_two">
                    <div class="row">
                        <?php if(!empty($price_repeater_two)): ?>
                        <?php foreach($price_repeater_two as $key => $price_repeater_two): 
                        ?>
                        <div class="<?php echo esc_attr($settings['price_column']); ?> col   trans  <?php if($price_repeater_two['active_two'] == 'yes'):?> active<?php endif; ?>"> 
                            <div class="price_box style_two <?php if($settings['price_styles'] == 'type_two'): ?>style_three<?php endif; ?> trans<?php if($price_repeater_two['active_two'] == 'yes'):?> active<?php endif; ?>">
                                <div class="whole">
                                <div class="nk-pricing-head">
                           
                                        <?php if($settings['price_styles'] == 'type_two'): ?>
                                            <?php if(!empty($price_repeater_two['tag_two'])): ?>
                                                <span class="badge rounded-pill text-bg-warning text-white text-uppercase"><?php echo wp_kses($price_repeater_two['tag_two'] , $allowed_tags);  ?></span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if(!empty($price_repeater_two['tag_two'])): ?>
                                                <span class="badge_two"><?php echo wp_kses($price_repeater_two['tag_two'] , $allowed_tags);  ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        
                                    <div class="nk-pricing-title-group mb-2">
                                        <?php if(!empty($price_repeater_two['title_two'])): ?>
                                        <div class="title_no_a_20">
                                            <?php echo wp_kses($price_repeater_two['title_two'] , $allowed_tags);  ?>
                                        </div>
                                        <?php endif; ?>
                                     
                                    </div>
 
                                    <?php if($price_repeater_two['icon_or_price_two'] == 'yes'): ?>
                                        <div class="nk-year-amount amount-wrap">
                                        <?php if(!empty($price_repeater_two['price_two'])): ?>
                                        <span class="amount h1 mb-0">
                                  
                                            <?php echo wp_kses($price_repeater_two['price_two'] , $allowed_tags);  ?>
                                        </span>
                                        <?php if(!empty($price_repeater_two['price_duration_two'])): ?>
                                        <span class="amount-text"> /
                                            <?php echo wp_kses($price_repeater_two['price_duration_two'] , $allowed_tags);  ?></span>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        </div>
                                    <?php else: ?>     
                                        <?php if($price_repeater_two['icon_type_two'] == 'image'): ?>
                                            <?php if(!empty($price_repeater_two['image_two']['url'])):
                                                $alt_text_two = 'alt';
                                                $image_two = isset($price_repeater_two['image_two']['alt']) ? $price_repeater_two['image_two']['alt'] : '';
                                                if(!empty($image_two)) {
                                                $alt_text_two = $image_two;
                                                }
                                                ?>
                                                <div class="icon">
                                                    <img src="<?php echo esc_url($price_repeater_two['image_two']['url']); ?>" alt="<?php echo esc_attr($image_two); ?>" />
                                                </div>
                                            <?php endif; ?>
                                            <?php elseif($price_repeater_two['icon_type_two'] == 'elicon'): ?>
                                                <?php if(!empty($price_repeater_two['icon_lib_two'])): ?>
                                                <div class="icon">
                                                    <?php \Elementor\Icons_Manager::render_icon($price_repeater_two['icon_lib_two'], [ 'aria-hidden' => 'false' ]); ?>
                                                </div>
                                                <?php endif; ?>		
                                            <?php else: ?>
                                                <?php if(!empty($price_repeater_two['icon_two'])): ?>
                                                <div class="icon">
                                                    <i class="<?php echo esc_attr($price_repeater_two['icon_two']); ?>"></i>
                                                </div> 
                                            <?php endif; ?>		
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if(!empty($price_repeater_two['description_two'])): ?>
                                    <p class="text mt-2">
                                        <?php echo wp_kses($price_repeater_two['description_two'] , $allowed_tags);  ?>
                                    </p>
                                    <?php endif; ?> 

                                    <?php if(!empty($price_repeater_two['high_two'])): ?>
                                        <div class="high_two">
                                        <?php echo wp_kses($price_repeater_two['high_two'] , $allowed_tags);  ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="nk-pricing-body">
                                    <div class="gap g-3">
                                        <?php if(!empty($price_repeater_two['btnone_two'])):
                                        $pttarget_one = $price_repeater_two['btnonelink_two']['is_external'] ? ' target="_blank"' : '';
                                        $ptnofollow_one = $price_repeater_two['btnonelink_two']['nofollow'] ? ' rel="nofollow"' : ''; 
                                        ?>
                                   
                                            <a href="<?php echo esc_attr($price_repeater_two['btnonelink_two']['url']); ?>"
                                                class="theme_btn one" <?php echo esc_attr($pttarget_one); ?>
                                                <?php echo esc_attr($ptnofollow_one); ?>>
                                                <?php echo wp_kses($price_repeater_two['btnone_two'] , $allowed_tags);  ?>
                                            </a>
                                      
                                        <?php endif; ?>
                                        <?php if($price_repeater_two['btn2_enable_two'] == 'yes'): ?>
                                        <?php if(!empty($price_repeater_two['btntwo_two'])):
                                        $pttarget_two = $price_repeater_two['btntwolink_two']['is_external'] ? ' target="_blank"' : '';
                                        $ptnofollow_two = $price_repeater_two['btntwolink_two']['nofollow'] ? ' rel="nofollow"' : ''; 
                                        ?>
                                  
                                            <a href="<?php echo esc_attr($price_repeater_two['btntwolink_two']['url']); ?>"
                                                class="theme_btn two" <?php echo esc_attr($pttarget_two); ?>
                                                <?php echo esc_attr($ptnofollow_two); ?>>
                                                <?php echo wp_kses($price_repeater_two['btntwo_two'] , $allowed_tags);  ?>
                                            </a>
                                     
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        </div> 
                                    <?php if(!empty($price_repeater_two['features_title_two'])): ?>
                                        <div class="features_title_two title_no_a_16">
                                        <?php echo wp_kses($price_repeater_two['features_title_two'] , $allowed_tags);  ?>
                                        </div>
                                    <?php endif; ?>
                                    <ul class="nk-list-link">
                                        <?php if(!empty($price_repeater_two['features_repeater_two'])): ?>
                                        <?php foreach($price_repeater_two['features_repeater_two'] as $features_text):?>
                                        <li>
                                            <?php if($features_text['ftwo_yesno'] == 'no'): ?>
                                            <em class="icon copy-cross-circle-fill"></em>
                                            <?php else: ?>
                                            <em class="icon copy-check-circle-fill"></em>
                                            <?php endif; ?>
                                            <span><?php echo wp_kses($features_text['features_text_two'] , $allowed_tags); ?></span>
                                        </li>
                                        <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <?php //  tab end ?>
            </div>
        </div>
    </div>
</section>


<?php 
	}
}

 