<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Infinite_scroll_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-image-infinite-v1';
    }

    public function get_title()
    {
        return __('Image Infinite Scroll V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('image_box_settings',
        [ 
            'label' => __('Image Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $repeater = new \Elementor\Repeater(); 
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
               
            ] 
        );
        $this->add_control(
            'image_repeator_one',
            [
                'label' => __('Image Repeater Left', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                    'image' =>  '',
                    ],
                    [
                    'image' =>  '',
                    ],
                    [
                    'image' =>  '',
                    ],
                ],
                'title_field' => __('Image', 'copygen-addons'),
            ]
        );

        $repeater_two = new \Elementor\Repeater(); 
        $repeater_two->add_control(
            'image_two',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
               
            ] 
        );
        $this->add_control(
            'image_repeator_two',
            [
                'label' => __('Image Repeater Mid', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_two->get_controls(),
                'default' => [
                    [
                    'image_two' =>  '',
                    ],
                    [
                    'image_two' =>  '',
                    ],
                    [
                    'image_two' =>  '',
                    ],
                ],
                'title_field' => __('Image', 'copygen-addons'),
            ]
        );

        $repeater_three = new \Elementor\Repeater(); 
        $repeater_three->add_control(
            'image_three',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
               
            ] 
        );
        $this->add_control(
            'image_repeator_three',
            [
                'label' => __('Image Repeater Right', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_three->get_controls(),
                'default' => [
                    [
                    'image_three' =>  '',
                    ],
                    [
                    'image_three' =>  '',
                    ],
                    [
                    'image_three' =>  '',
                    ],
                ],
                'title_field' => __('Image', 'copygen-addons'),
            ]
        );

        $this->add_responsive_control(
            'scrollerheight',
            [
                'label' => __('Set Height For Scroll', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 400,
                'min'     => 1,
                'max'     => 50000,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .infinite-scroll ' => 'height: {{VALUE}}px!important;',  
                ], 
            ]
        );

    $this->end_controls_section();
}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');  
    ?>
    <div class="infinite-scroll">
        <?php if(!empty($settings['image_repeator_one'])): ?>
            <div class="infinite-scroll-col infinite-scroll-init infinite-scroll-lg-vertical infinite-scroll-horizontal infinite-scroll-duration-12">
                <?php foreach($settings['image_repeator_one'] as  $key => $image_repeator_one): ?>
                    <?php if(!empty($image_repeator_one['image']['url'])): ?>
                        <div class="infinite-scroll-card">
                            <img src="<?php echo esc_url($image_repeator_one['image']['url']); ?>" alt="tool">
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['image_repeator_two'])): ?>
        <div class="infinite-scroll-col infinite-scroll-init infinite-scroll-lg-verticalAlternate infinite-scroll-horizontalAlternate infinite-scroll-duration-12">
            <?php foreach($settings['image_repeator_two'] as  $key => $image_repeator_two): ?>
                <?php if(!empty($image_repeator_two['image_two']['url'])): ?>
                    <div class="infinite-scroll-card">
                        <img src="<?php echo esc_url($image_repeator_two['image_two']['url']); ?>" alt="tool">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <?php if(!empty($settings['image_repeator_three'])): ?>
        <div class="infinite-scroll-col infinite-scroll-init infinite-scroll-lg-vertical infinite-scroll-horizontal infinite-scroll-duration-12">
            <?php foreach($settings['image_repeator_three'] as  $key => $image_repeator_three): ?>
                <?php if(!empty($image_repeator_three['image_three']['url'])): ?>
                    <div class="infinite-scroll-card">
                        <img src="<?php echo esc_url($image_repeator_three['image_three']['url']); ?>" alt="tool">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
<?php
    }
}

 