<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Icon_box extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-icon-v1';
    }

    public function get_title()
    {
        return __('Icon Box With Content V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('icon_content_v1_settings',
        [ 
            'label' => __('Icon Box Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'icon_box_style',
            [
            'label' => __('Icon Box Styles', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'copygen-addons' ),
                'style_two' => __( 'Style Two', 'copygen-addons' ),  
            ],
            'default' => 'style_one' , 
            ]
        );
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
                    'number'  => esc_html__( 'Number', 'copygen-addons' ), 
                    'none'  => esc_html__( 'None', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon'
                ]
            ]
        );
        $this->add_responsive_control(
            'get_number',
            [
               'label' => __('Number', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('01', 'copygen-addons'),
               'placeholder' => __('Type your Number here', 'copygen-addons'),    
               'condition' => [ 
                    'icon_type' => 'number'
                ]
            ]
          );
        $this->add_control(
            'hr1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
          'titles',
          [
             'label' => __('Title', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Advance Analytics', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
        $this->add_control(
            'hr2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'content_enable',
            [
                'label' => __('Content Enable / Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'icon_box_style' => ['style_one' , 'style_two' ]
                ],
            ]
        );
        $this->add_responsive_control(
            'content',
            [
               'label' => __('Content', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Adipis cing nisi sem gravida enim eu adipi scing sagittis scele risque aug ue nulla massa ali quet fring illa null am eget.', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
                'condition' => [
                    'content_enable' => 'yes' ,
                    'icon_box_style' => ['style_one' , 'style_two' ]
                ],
            ]
        );
        $this->add_control(
            'hr3',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'link_enable',
            [
                'label' => __('Link Enable / Disable', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'copygen-addons'),
                'label_off' => __('No', 'copygen-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
               
            ]
        );
        $this->add_responsive_control(
            'button_text',
            [
              'label' => __('Button Label', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('Read More', 'copygen-addons'),
              'placeholder' => __('Type your Symbols here', 'copygen-addons'),
               'condition' => [
                    'link_enable' => 'yes' ,
                    'icon_box_style' => ['style_one' , 'style_two']
               ],
            ]
        );
        $this->add_responsive_control(
            'button_link',
            [
                'label' => __('Link', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'copygen-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                
            ]
        );
    $this->end_controls_section();
    $this->start_controls_section('icon_css',
    [ 
        'label' => __('Icon Box Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->start_controls_tabs(
        'style_tabs'
    );
    $this->start_controls_tab(
        'style_normal_tab',
        [
            'label' => esc_html__( 'Content Style', 'copygen-addons' ),
        ]
    );

    $this->add_control(
        'cssone',
         [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon , {{WRAPPER}} .icon_box_only .icon em  ' => 'color: {{VALUE}}!important;',
            ],
             
         ]
    );
    $this->add_control(
        'csstwo',
         [
            'label' => __('Icon Box Background Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon ' => 'background: {{VALUE}}!important;',
            ],
             
         ]
    );
    $this->add_control(
        'cssthree',
         [
            'label' => __('Icon Box Border Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon ' => 'border-color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_responsive_control(
        'borwid',
        [
            'label' => esc_html__( 'Icon Border Width', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ], 
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    ); 
    $this->add_control(
        'hr4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    ); 
     $this->add_responsive_control(
        'icon_font_size',
        [
            'label' => __('Icon  Size', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon i , {{WRAPPER}} .icon_box_only .icon em  ' => 'font-size: {{VALUE}}px!important;', 
                '{{WRAPPER}} .icon_box_only .icon img , {{WRAPPER}} .icon_box_only .icon svg  ' => 'width: {{VALUE}}px!important;', 
            ], 
        ]
    );
    $this->add_responsive_control(
        'icon_width',
        [
            'label' => __('Icon Width', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon ' => 'width: {{VALUE}}px!important;', 
            ], 
        ]
    );
    $this->add_responsive_control(
        'icon_height',
        [
            'label' => __('Icon Height', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 500,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon  ' => 'height: {{VALUE}}px!important;', 
                '{{WRAPPER}} .icon_box_only .icon i , {{WRAPPER}} .icon_box_only .icon em ' => 'line-height: {{VALUE}}px!important;', 
            ], 
        ]
    );

    $this->add_responsive_control(
        'icon_border_radius',
        [
            'label' => esc_html__( 'Icon Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ], 
        ]
    );

    $this->add_control(
        'hr5',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 'title_typos',
            'selector' => '{{WRAPPER}} .title_20 a ',
        ]
    );
    $this->add_control(
        'hr14',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'titlecolor',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .title_20 a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'titlehover',
         [
            'label' => __('Title Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .title_20 a:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hr15',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Description Typography', 'copygen-addons' ),
            'name' => 'des_typos',
            'selector' => '{{WRAPPER}} .icon_box_only  p ',
        ]
    );
    $this->add_control(
        'hr16',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_control(
        'descriptioncolor',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only  p ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hr17',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
     $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Read More Typography', 'copygen-addons' ),
            'name' => 'rd_typos',
            'selector' => '{{WRAPPER}} .icon_box_only  .rd_more  ',
        ]
    );
    $this->add_control(
        'css_seven',
         [
            'label' => __('Read More Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only  .rd_more , {{WRAPPER}} .icon_box_only  .rd_more i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
  
    $this->add_control(
        'hover_bor',
         [
            'label' => __('Hover Read More  Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .icon_box_only  .rd_more:hover , {{WRAPPER}} .icon_box_only  .rd_more:hover  i ' => 'color: {{VALUE}}!important;',
            ], 
         ]
    );
    $this->add_control(
        'hr18',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );

    $this->add_responsive_control(
        'text_align',
        [
            'label' => esc_html__( 'Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'start' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'end' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'left',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only ' => 'text-align: {{VALUE}}!important;',
                '{{WRAPPER}} .icon_box_only .rd_more ' => 'justify-content: {{VALUE}}!important;',
            ],
            'condition' => [ 
                'icon_box_style' => ['style_two']
           ],
        ]
    ); 

    $this->end_controls_tab();
    $this->start_controls_tab(
        'style_box_css',
        [
            'label' => esc_html__( 'Box Style', 'copygen-addons' ),
        ]
    );
    $this->add_responsive_control(
        'box_padding',
        [
            'label' => __( 'Box Padding', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px' , 'rem' , 'em' , '%'],
            'selectors' => [
                '{{WRAPPER}} .icon_box_only   ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'box_margin',
        [
            'label' => __( 'Box Margin', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px' , 'rem' , 'em' , '%'],
            'selectors' => [
                '{{WRAPPER}} .icon_box_only   ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'box_radius',
        [
            'label' => __( 'Box Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px' , 'rem' , 'em' , '%'],
            'selectors' => [
                '{{WRAPPER}} .icon_box_only   ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'bs_h1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'background_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .icon_box_only  ',
        ]
    );
    $this->add_control(
        'bs_h2',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'boxshadows',
            'selector' => '{{WRAPPER}} .icon_box_only   ', 
        ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->end_controls_section();
}
protected function render(){
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
        $alt_text = 'alt';
        $image = isset($settings['image']['alt']) ? $settings['image']['alt'] : '';
        if(!empty($image)) {
          $alt_text = $image;
        }
     ?>
        
    <?php // style ?>
    <?php if($settings['icon_box_style'] == 'style_two'):  ?>
    <?php // style ?>
    <div class="icon_box_only type_one">
    <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'elicon'): ?>
                <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                </div>
                <?php endif; ?>		
            <?php elseif($settings['icon_type'] == 'none'): ?>
                <?php // none ?>
            <?php elseif($settings['icon_type'] == 'number'): ?>
                <?php // number ?>
                <div class="icon">
                    <em><?php echo esc_attr($settings['get_number']); ?></em>
                </div>
            <?php else: ?>
                <?php if(!empty($settings['icon'])): ?>
                <div class="icon">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                </div> 
                <?php endif; ?>		
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_20">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <div class="text_center">
                    <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                        <?php echo esc_html($settings['button_text']);?> <i class=" copy-arrow-long-right"></i>
                    </a> 
                </div>
            <?php endif; endif; ?>
 
    </div>
    <?php // style ?>
    <?php else:  ?>
    <?php // style ?>
    <div class="icon_box_only type_one inline flex-sm-row">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'elicon'): ?>
                <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                </div>
                <?php endif; ?>		
            <?php elseif($settings['icon_type'] == 'none'): ?>
                <?php // none ?>
            <?php elseif($settings['icon_type'] == 'number'): ?>
                <?php // number ?>
                <div class="icon">
                    <em><?php echo esc_attr($settings['get_number']); ?></em>
                </div>
            <?php else: ?>
                <?php if(!empty($settings['icon'])): ?>
                <div class="icon">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                </div> 
                <?php endif; ?>		
            <?php endif; ?>
            <div class="contnet">
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_20">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <div class="text_center">
                    <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                        <?php echo esc_html($settings['button_text']);?> <i class=" copy-arrow-long-right"></i>
                    </a> 
                </div>
            <?php endif; endif; ?>
            </div>
    </div>  
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

