<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Fun_facts_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-fun-facts-v1';
    }

    public function get_title()
    {
        return __('Funfacts V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('funfacts_content_v1_settings',
        [ 
            'label' => __('Funfacts Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        ); 
        $this->add_control(
            'icon_enable',
            [
                'label' => esc_html__( 'Icon Enable  / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icons'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ),  
				], 
                'default' => 'dot' , 
                'condition' => [
                    'icon_enable' => 'yes'
                ],
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image' ,
                    'icon_enable' => 'yes'
                ],
            ] 
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'fi-rs-user' , 
                'condition' => [ 
                    'icon_type' => 'icons' ,
                    'icon_enable' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon' ,
                    'icon_enable' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'number',
            [
              'label' => __('Count', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('545', 'copygen-addons'),
              'placeholder' => __('Type your text here', 'copygen-addons'),
            ]
        );

        $this->add_control(
            'symbol',
            [
              'label' => __('Symbol', 'copygen-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('+', 'copygen-addons'),
              'placeholder' => __('Type your Symbols here', 'copygen-addons'),
            ]
        );
        $this->add_control(
            'title_enable',
            [
                'label' => esc_html__( 'Title Enable  / Disable', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'copygen-addons' ),
                'label_off' => esc_html__( 'No', 'copygen-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'title',
            [
               'label' => __('Title', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Projects completed', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),    
               'condition' => [  
                    'title_enable' => 'yes' ,
               ],
            ]
          );
        $this->add_control(
          'contnet',
          [
             'label' => __('Content', 'copygen-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('No need to hire specialists for each channel.', 'copygen-addons'),
             'placeholder' => __('Type your text here', 'copygen-addons'),    
          ]
        );
    $this->end_controls_section();

    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
 
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Count Typography', 'copygen-addons' ),
            'name' => 'desc_typo',
            'selector' => '{{WRAPPER}} .fun_facts h4 span ',
        ]
    );
    $this->add_control(
        'count_color',
         [
            'label' => __('Count Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts h4 span  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'count_sym_color',
         [
            'label' => __('Count Symbol Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts h4 small , {{WRAPPER}} .fun_facts h4 small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' Title Typography', 'copygen-addons' ),
            'name' => 'tit_typo',
            'selector' => '{{WRAPPER}} .fun_facts .title_no_a_18  ',
        ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts .title_no_a_18   ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 

    
    $this->add_responsive_control(
        'text_align',
        [
            'label' => esc_html__( 'Alignment', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
                'justify' => [
                    'title' => esc_html__( 'Justify', 'copygen-addons' ),
                    'icon' => 'eicon-text-align-justify',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .fun_facts ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    ); 


    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
     ?>  
    <div class="fun_facts type_one">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'elicon'): ?>
                <?php if(!empty($settings['icon_lib'])): ?>
                    <div class="icon trans">
                        <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                    </div>
                <?php endif; ?>	
            <?php else: ?>
                <?php if(!empty($settings['icon'])): ?>
                    <div class="icon trans">
                        <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                    </div>
                <?php endif; ?>	
            <?php endif; ?>	
        <?php endif; ?>
           
            <div class="title_no_a_32">
                <span class="count">
                    <?php echo esc_attr($settings['number']) ?>
                </span>
                <small>
                    <?php echo esc_attr($settings['symbol']) ?>
                </small>
            </div>
            <?php if($settings['title_enable'] == 'yes'): ?>
                <?php if(!empty($settings['title'])): ?>
                    <div class="title_no_a_20"> 
                        <?php echo wp_kses($settings['title'] , $allowed_tags); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <?php if(!empty($settings['contnet'])): ?>
                <p><?php echo wp_kses($settings['contnet'] , $allowed_tags); ?></p>
            <?php endif; ?>
    </div>
  


    <?php
    }
}

 

