<?php

namespace  Copygenaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-contact-box-v1';
    }

    public function get_title()
    {
        return __('Contact Box V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('widget_contact_box_v1_settings',
        [ 
            'label' => __('Widget  Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'contact_type',
            [
                'label' => __('Contact Type', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'address_type' => __('Address', 'copygen-addons'),
                    'phone_type' => __('Phone', 'copygen-addons'),
                    'mail_type' => __('Mail', 'copygen-addons'),
                    'timing_type' => __('Timing', 'copygen-addons'),
                ],
                'default' => 'address_type',
            ]
        );
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'copygen-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'copygen-addons' ),
					'icon'  => esc_html__( 'copygen Icon', 'copygen-addons' ), 
                    'elicon'  => esc_html__( 'Elementor Icon', 'copygen-addons' ), 
                    'none'  => esc_html__( 'None', 'copygen-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_get_icons(),
                'default' => 'copy-user' , 
                'condition' => [ 
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [ 
                    'icon_type' => 'elicon'
                ]
            ]
        );
        
        $this->add_control(
            'title',
            [
               'label' => __('Title', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('Call Us', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),     
            ]
          );
        $this->add_control(
            'address',
            [
               'label' => __('Address', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('5171 W Campbell Ave undefined Kent, Utah 53127 United States', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'address_type'
              ], 
            ]
        );
  
        $this->add_control(
            'phone',
            [
               'label' => __('Phone', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('(+91)-540-025-124553', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'phone_type'
              ], 
            ]
        );
        $this->add_control(
            'phone_two',
            [
               'label' => __('Phone', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('(+91)-540-025-124553', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'phone_type'
              ], 
            ]
        ); 
        $this->add_control(
            'email',
            [
               'label' => __('Mail', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('sale@copygen.com', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'mail_type'
              ], 
            ]
        );
        $this->add_control(
            'email_two',
            [
               'label' => __('Mail', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('sale@copygen.com', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'mail_type'
              ], 
            ]
        );
 
        $this->add_control(
            'timing',
            [
               'label' => __('Timing', 'copygen-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('10:00 - 18:00, Mon - Sat', 'copygen-addons'),
               'placeholder' => __('Type your text here', 'copygen-addons'),   
               'condition' => [
                  'contact_type' => 'timing_type'
              ], 
            ]
        );
 
    $this->end_controls_section(); 
    $this->start_controls_section('contact_css',
        [ 
            'label' => __('Custom Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
    ); 
    $this->add_control(
        'box_bg',
         [
            'label' => __('Box Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'iconbg_color',
         [
            'label' => __('Icon Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .icon ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Title Typography', 'copygen-addons' ),
            'name' => 'tone',
            'selector' => '{{WRAPPER}} .contact_box_content .title_no_a_20 ',
        ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .title_no_a_20 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Description Typography', 'copygen-addons' ),
            'name' => 'done',
            'selector' => '{{WRAPPER}} .contact_box_content .contact-infor span , {{WRAPPER}} .contact_box_content .contact-infor  a ',
        ]
    );
    $this->add_control(
        'description_color',
         [
            'label' => __('Description Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .contact-infor span , {{WRAPPER}} .contact_box_content .contact-infor  a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'border_radius',
        [
            'label' => esc_html__( 'Border Radius', 'copygen-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .newsletter .newsletter-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    ); 
    $this->end_controls_section();

}
protected function render() {
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post'); 
?>
<div class="contact_box_content">
    <div class="contact-infor">
            <?php if(!empty($settings['title'])): ?> 
                <h6 class="title_no_a_20">   <?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
            <div class="d-flex">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'elicon'): ?>
                <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                </div>
                <?php endif; ?>		
            <?php elseif($settings['icon_type'] == 'none'): ?>
                <?php // none ?>
            <?php else: ?>
                <?php if(!empty($settings['icon'])): ?>
                <div class="icon">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                </div> 
                <?php endif; ?>		
            <?php endif; ?>
            <?php // contact_type ?>
            <?php if($settings['contact_type'] == 'phone_type'): // phone ?>
                <?php if(!empty($settings['phone'])): ?>
                    <a href="tel:<?php echo esc_attr($settings['phone']); ?>"><?php echo esc_attr($settings['phone']); ?></a>
                <?php endif; ?>
                <?php if(!empty($settings['phone_two'])): ?>
                    <a href="tel:<?php echo esc_attr($settings['phone_two']); ?>"><?php echo esc_attr($settings['phone_two']); ?></a>
                <?php endif; ?>
            <?php elseif($settings['contact_type'] == 'mail_type'): // mail ?>
                <?php if(!empty($settings['email'])): ?>
                <a href="mailto:<?php echo esc_attr($settings['email']); ?>"><?php echo esc_attr($settings['email']); ?></a>
                <?php endif; ?>
                <?php if(!empty($settings['email_two'])): ?>
                    <a href="mailto:<?php echo esc_attr($settings['email_two']); ?>"><?php echo esc_attr($settings['email_two']); ?></a>
                <?php endif; ?>
            <?php elseif($settings['contact_type'] == 'timing_type'): // timing ?>
                <?php if(!empty($settings['timing'])): ?>
                    <span><?php echo wp_kses($settings['timing'] , $allowed_tags); ?></span>
                <?php endif; ?>
            <?php else: ?>
                <?php if(!empty($settings['address'])): ?>
                    <span><?php echo wp_kses($settings['address'] , $allowed_tags); ?></span>
                <?php endif; ?>
            <?php endif; ?>
            </div>
        </div>
    </div>
    <?php
    }
}
 

